#
# dsw sw stack makefile
#
ifeq ($(MAKELEVEL),1)
# Base flags and variables for all modules
include platform.inc
endif

export TOPDIR = $(shell cd ../../ ; /bin/pwd)
ifndef TOPDIR
TOPDIR = $(shell cd ../../ ; /bin/pwd)
DHL_DIR = $(TOPDIR)/dst/dhl
DLIB_DIR = $(TOPDIR)/dst/dlib
DMW_DIR = $(TOPDIR)/dst/dmw
DAPP_DIR = $(TOPDIR)/dst/app
LIBDIR = $(TOPDIR)/dta/lib
$(warning *** Warning:  TOPDIR is not defined ($(TOPDIR)))
#$(warning *** Warning:  DHL_DIR is  ($(DHL_DIR)))
else
LIBDIR := $(TOPDIR)/dta/lib
DHL_DIR := $(TOP_DIR)/dst/dhl
DLIB_DIR := $(TOP_DIR)/dst/dlib
DMW_DIR := $(TOP_DIR)/dst/dmw
DAPP_DIR := $(TOP_DIR)/dst/app
$(warning *** Warning:  TOPDIR is defined ($(TOPDIR)))
#$(warning *** Warning:  DHL_DIR is  ($(DHL_DIR)))
endif

DSTAPPBASE = $(TOPDIR)/../zasc
DSTIMG_DIR = $(DSTAPPBASE)/image
include $(DSTAPPBASE)/files_c.mk
CFLAGS  += $(addprefix -D, $(DEFINES))

DSTLIBNAME = dst
DSTMODPATH = $(TOP_DIR)/dst

DHL_SRC += $(DHL_DIR)/src/DHL_OSAL_Impl.c
DHL_SRC += $(DHL_DIR)/src/DHL_OSAL.c
DHL_SRC += $(DHL_DIR)/src/DHL_OSAL_Print.c
DHL_SRC += $(DHL_DIR)/src/DHL_DBG.c
DHL_SRC += $(DHL_DIR)/src/DHL_DBG_Print.c
DHL_SRC += $(DHL_DIR)/src/DHL_UTL.c
DHL_SRC += $(DHL_DIR)/src/DHL_Timer.c
DHL_SRC += $(DHL_DIR)/src/DHL_DBG_Symbols.c
DHL_SRC += $(DHL_DIR)/src/DHL_DBG_Shell.c
DHL_SRC += $(DHL_DIR)/src/DHL_SYS_Impl.c
DHL_SRC += $(DHL_DIR)/src/DHL_SYS.c
DHL_SRC += $(DHL_DIR)/src/DHL_Main.c
DHL_SRC += $(DHL_DIR)/src/DHL_DEV_Platform.c
DHL_SRC += $(DHL_DIR)/src/DHL_FE.c
DHL_SRC += $(DHL_DIR)/src/DHL_FE_Platform.c
DHL_SRC += $(DHL_DIR)/src/DHL_AVCAP.c
DHL_SRC += $(DHL_DIR)/src/DHL_AVCAP_Impl.c
DHL_SRC += $(DHL_DIR)/src/DHL_Graphic.c
DHL_SRC += $(DHL_DIR)/src/DHL_Graphic_Platform.c
DHL_SRC += $(DHL_DIR)/src/DHL_Demux.c
DHL_SRC += $(DHL_DIR)/src/DHL_PSI.c
DHL_SRC += $(DHL_DIR)/src/DHL_PSI_Impl.c
DHL_SRC += $(DHL_DIR)/src/DHL_PSI_Rx.c
#DHL_SRC += $(DHL_DIR)/src/DHL_UIO_Platform.c
DHL_SRC += $(DHL_DIR)/src/DHL_NVM.c
#DHL_SRC += $(DHL_DIR)/src/DHL_UIO.c
DHL_SRC += $(DHL_DIR)/src/DHL_COM.c
	
DSTMOD_SRC += $(DHL_SRC)


SRC_DIR += \
	$(DHL_DIR)/src
DST_INC_DIRS +=	\
	SRC_DIR	\
	$(DHL_DIR)/api/include	\
	$(DHL_DIR)/src/include	\

SRC_DIR += \
	$(DSTAPPBASE)/app_1 \
	$(DSTAPPBASE)/sqlite \
	$(DSTAPPBASE)/freetype-2.3.9/include \

DST_INCLUDE	= $(patsubst %,-I%,$(subst :, ,$(DST_INC_DIRS)))
DST_INCLUDE +=  $(patsubst %,-I%,$(subst :, ,$(SRC_DIR)))

CFLAGS += $(DST_INCLUDE) -I./
CFLAGS += -DSUBMODEL_ID=2
CFLAGS += -D_FE_BCM3520_NXP


#DSTLIB_SRCS := $(addprefix $(DSTMODPATH)/, $(DSTMOD_SRC))
DSTLIB_SRCS :=  $(DSTMOD_SRC)

DSTLIB_OBJECTS := $(patsubst %.c,%.o,$(filter %.c,$(DSTLIB_SRCS))) $(patsubst %.S,%.o,$(filter %.S,$(DSTLIB_SRCS)))

DSTLIB_OBJECTS += $(patsubst %.png,%.o,$(filter %.png,$(PNGFILES)))
DSTLIB_OBJECTS += $(patsubst %.ttf,%.o,$(filter %.ttf,$(TTFFILES)))
#DSTLIB_OBJECTS += $(patsubst %.cpp,%.o,$(filter %.cpp,$(SOURCEFILES)))
DSTLIB_OBJECTS += $(patsubst %.c,%.o,$(filter %.c,$(SOURCEFILES)))

DSTLIB_DEPENDS := $(DSTLIB_OBJECTS:%.o=%.d)

%.c : %.png
	 make -C ../../../zas_dstar/build/bmpbin2src/
	./../../../zas_dstar/build/png2src $< > $@

%.c : %.ttf
	make -C ../../../zas_dstar/build/bmpbin2src/
	./../../../zas_dstar/build/bin2src $< > $@

#$(warning *** Warning:  DSTMODPATH is  ($(DSTMODPATH)))
#$(warning *** Warning:  DST_INCLUDE is  ($(DST_INCLUDE)))

all : $(LIBDIR)/lib$(DSTLIBNAME).a


$(LIBDIR)/lib$(DSTLIBNAME).a : $(DSTLIB_OBJECTS) 
	$(AR) $(ARFLAGS) $@ $?


# clean : clean_dst

clean_dst:
	$(RM) -f $(LIBDIR)/lib$(DSTLIBNAME).a $(DSTLIB_OBJECTS) $(DSTLIB_DEPENDS)

-include $(DSTLIB_DEPENDS)

