################################################################
#
# Broadcom Corp. Confidential
# Copyright 2003 Broadcom Corp. All Rights Reserved.
#
# THIS SOFTWARE MAY ONLY BE USED SUBJECT TO AN EXECUTED
# SOFTWARE LICENSE AGREEMENT BETWEEN THE USER AND BROADCOM.
# YOU HAVE NO RIGHT TO USE OR EXPLOIT THIS MATERIAL EXCEPT
# SUBJECT TO THE TERMS OF SUCH AN AGREEMENT.
#
# $brcm_Workfile:  $
# $brcm_Revision:  $
# $brcm_Date: $
#
# Module Description:  ram makefile
#
# Revision History:
#
# Created: Wed Sep 13 11:49:24 PDT 2006 by Jeffrey Fisher
#
# $brcm_Log: $
#
################################################################/

# Tools definitions
LANG=en_US

ARCH            ?=      mipsel-linux-uclibc
CROSS_COMPILE   ?=      $(TOPDIR)/toolchain/bin/$(ARCH)-

CCACHE	= ccache
CP		=	/bin/cp
CAT		=	/bin/cat
RM		=	/bin/rm
CP		=	/bin/cp
RM		=	/bin/rm
MV		=	/bin/mv
CC		=	$(CCACHE) $(CROSS_COMPILE)gcc
CXX		=	$(CCACHE) $(CROSS_COMPILE)g++
GXX		=	$(CCACHE) $(CROSS_COMPILE)g++
LD		=	$(CROSS_COMPILE)ld
AR		=	$(CROSS_COMPILE)ar
NM		=	$(CROSS_COMPILE)nm
AS      	=	$(CROSS_COMPILE)as
RANLIB  	=	$(CROSS_COMPILE)ranlib
OBJCOPY 	=	$(CROSS_COMPILE)objcopy
OBJDUMP 	=	$(CROSS_COMPILE)objdump
STRIP   	=	$(CROSS_COMPILE)strip
AS      	=  	$(CROSS_COMPILE)gcc
ECHO		=	$(QUIET)echo

# base flags which should be inherited by all modules

# compiler flags

ifeq ($(findstring mips, $(CROSS_COMPILE)),mips)
CFLAGS = -MMD -G 0 -mips32 -march=4kc -Wa,--trap -Wall \
		-fno-strict-aliasing \
		-mno-abicalls -fno-pic -msoft-float
		
#
# Avoid including errno in zutil
#
CFLAGS += -DNO_ERRNO_H
#
# CFLAGS and LDFLAGS for ministd or NEWLIB libc build 
#
ifeq ($(OS),linuxuser) 
CFLAGS = -D__NEWLIB__ -DLINUX
else
ifeq ($(findstring mips-elf-ucos, $(CROSS_COMPILE)),)
CFLAGS += -G 0 -fomit-frame-pointer -nostdlib -nostdinc -ffreestanding
else
NEWLIB_DIR ?= $(subst bin/mips-elf-ucos-,mips-elf-ucos/lib, $(CROSS_COMPILE))
NEWLIB=y
CFLAGS += -EL -D__NEWLIB__ -D__ucos__
LDFLAGS += -G 0 -EL
endif
endif
else
CFLAGS = -D__NEWLIB__ -DLINUX
NTV_SIMULATOR = y
endif

#
# SDE toolchain CFLAGS and LDFLAGS
#

ifeq ($(findstring mips-sde-elf-,$(CROSS_COMPILE)),mips-sde-elf-)
CFLAGS          += -EL -DSDE_MIPS
LFLAGS		+= -EL
LDFLAGS		+= -EL
endif


#
# Debug CFLAGS
#

ifeq ($(DEBUG),y)
CFLAGS          += -ggdb -DBCM_DEBUG -DBDBG_DEBUG_BUILD=1
else
CFLAGS          += -Os
endif

# assembler flags

ASFLAGS = -x assembler-with-cpp -DLANGUAGE_ASSEMBLY -D_ASMLANGUAGE  -D__ASSEMBLY__ -DMIPS_SDE $(CFLAGS)

# ar flags

ARFLAGS = rcus

# Chip definitions

BCHP_CHIP = 7552
BCHP_VER ?= B0
BCHP_ENDIAN = le
B_REFSW_OS = $(OS)
BTNR_7552_SUPPORT=y
ifeq ($(HAS_ISDBT),y)
BTHD_ISDBT_SUPPORT=y
else
BADS_7552_SUPPORT=y
endif

BCHP_VER_LOWER := $(shell echo $(BCHP_VER) | tr '[:upper:]' '[:lower:]')

#
# Audio codecs supported 
#

RAP_AC3_SUPPORT = y
RAP_MPEG_SUPPORT = y
RAP_DDP_SUPPORT = y

