#include "DST_WinManager.h"
#include "DST_DataStrings.h"
#include "DST_OSDImage.h"
#include "DST_EEPROM.h"
#include "DST_ChannelTune.h"
#include "DST_UserInterface.h"
#include "DST_DB.h"


#if 0
____CMessageWin___()
#endif


//class CFactoryResetWin : public CWindow
//{
//private:
	static DS_U8 CFactoryResetWin_winParentID;
	static DS_U8 CFactoryResetWin_msg;
//public:
//	CFactoryResetWin(SWinEventMsg event):CWindow(event)
	void CFactoryResetWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "FactoryReset");
		this->rect.w = DST_GetImageWidth(pin_change_back);
		this->rect.h = DST_GetImageHeight(pin_change_back);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight()- this->rect.h) / 2;
		this->RegisterAllKey(this);
		this->SetTimeOut(this, 0);

		CFactoryResetWin_winParentID = event.data[1];
		CFactoryResetWin_msg = event.data[2];
		DST_Printf("winParentID : %d , msg : %d\n",CFactoryResetWin_winParentID,CFactoryResetWin_msg);
		DST_EEPROM_SetNeedReset(1);
		DST_DB_Sync();

	}
	
	void CFactoryResetWin_Destructor(CWindow *this)
	{
		DST_Reset(__func__); // â 鼭 
	}
	
//	virtual void OnTimer(char)
	void CFactoryResetWin_OnTimer(CWindow *this, char nID)
	{
		this->Show(this);
	}

//	virtual void OnMessage(SWinEventMsg event)
	void CFactoryResetWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				this->Close(this);
				break;
			default: break;
		}
	}
	
//	virtual void Show(void)
	void CFactoryResetWin_Show(CWindow *this)
	{
		this->DrawImage(this, 0, 0, pin_change_back, false);
		this->setFontStyle(this, 22,0xFFFFFFFF,ALIGN_MIDDLE,ALIGN_CENTER);

		if (DST_DB_IsSync())
		{
			this->KillTimer(this, 1);
			this->SetTimeOut(this, 1); // ũ  ŸӾƿ 1ʷ 
			this->DrawTextUni(this, 0, 0, this->rect.w, this->rect.h, pz_sysreset[OSD_Lang], &(this->font));
		}
		else
		{
			this->DrawTextUni(this, 0, 0, this->rect.w, this->rect.h, pz_OTC_Download2[OSD_Lang], &(this->font));
			this->SetTimer(this, 1, 1000);
		}
		this->UpdateScreen(this);
	}
//};


//class CFactoryResetAskWin : public CWindow
//{
//private:

	static DS_U16 CFactoryResetAskWin_g_nPos;
	static DS_U16 CFactoryResetAskWin_g_nTop;
	static DS_U16 CFactoryResetAskWin_select;
	static DS_U16 CFactoryResetAskWin_itemNum;
	static bool CFactoryResetAskWin_bExitKeyPressed;
	static bool CFactoryResetAskWin_bVolumeKeyPressed;
	static DS_U8 CFactoryResetAskWin_winParentID;
	static DS_U8 CFactoryResetAskWin_msg;
//public:
void CFactoryResetAskWin_setSize(CWindow *this);

//	CFactoryResetAskWin(SWinEventMsg event):CWindow(event)
	void CFactoryResetAskWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "FacResetAsk");
		CFactoryResetAskWin_setSize(this);
		CFactoryResetAskWin_bExitKeyPressed = false;
		CFactoryResetAskWin_bVolumeKeyPressed = false;
		CFactoryResetAskWin_g_nTop = 0;
		CFactoryResetAskWin_g_nPos = 0;
		CFactoryResetAskWin_select = 1;
		CFactoryResetAskWin_itemNum = 2;

		CFactoryResetAskWin_winParentID = event.data[1];
		CFactoryResetAskWin_msg = event.data[2];
		this->SetTimeOut(this, 100);
	}

	void CFactoryResetAskWin_Destructor(CWindow *this)
	{
	
	}
	
	void CFactoryResetAskWin_setSize(CWindow *this)
	{
		this->rect.w = DST_GetImageWidth(pin_change_back);
		this->rect.h = DST_GetImageHeight(pin_change_back);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w)/2;
		this->rect.y = (DST_GetScreenHeight() - this->rect.h)/2;
	}

//	virtual void Focus(bool bVal)
	void CFactoryResetAskWin_Focus(CWindow *this, bool bVal)
	{
		this->RegisterKey(this, VK_CANCEL, bVal, 0, 0);
		this->RegisterKey(this, VK_MENU, bVal, 0, 0);
		this->RegisterKey(this, VK_OK, bVal, 0, 0);
		this->RegisterKey(this, VK_RIGHT, bVal, 0, 0);
		this->RegisterKey(this, VK_LEFT, bVal, 0, 0);
		this->RegisterKey(this, VK_UP, bVal, 0, 0);
		this->RegisterKey(this, VK_DN, bVal, 0, 0);
		this->RegisterKey(this, VK_PREV, bVal, 0, 0);
		this->RegisterKey(this, VK_PREV_CH, bVal, 0, 0);
		this->RegisterKey(this, VK_PREV_MENU, true, 0, 0);
	}

//	virtual void Show(WinID id)
	void CFactoryResetAskWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_ENGINEER_MODE:
			case WIN_FREQUENCY_SETTING:		
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
				CFactoryResetAskWin_bVolumeKeyPressed = true;
				this->Close(this);
				break;
			default:
				break;
		}
	}

	DS_U16* CFactoryResetAskWin_GetString(int index)
	{
		switch(index)
		{
			case 0: return pz_ZAS_Confirm[OSD_Lang];
			case 1: return pz_ZAS_Cancel[OSD_Lang];
			default: break;
		}
		return 0;
	}
	
	void CFactoryResetAskWin_Draw(CWindow *this)
	{
		int center_pos =  0;
		int line_spacing = 0;
		int i = 0;
		
		this->DrawImage(this, 0,0,pin_change_back,true);
		this->setFontStyle(this, 22,0xFFFFFFFF,ALIGN_MIDDLE,ALIGN_CENTER);
		
		center_pos =  DST_GetImageHeight(pin_change_back) / 2; 
		line_spacing = DST_GetFontHeight(this->FontGetSize(this)) * 125 / 100;

		this->DrawTextUni(this, 0,	center_pos-line_spacing/2-line_spacing-line_spacing/2, this->rect.w, line_spacing, pz_Sub_FactoryResetAsk_E1[OSD_Lang],  &(this->font));
		this->DrawTextUni(this, 0,	center_pos-line_spacing/2-line_spacing/2, this->rect.w, line_spacing, pz_Sub_FactoryResetAsk_E2[OSD_Lang],  &(this->font));
		
		this->DrawImage(this, 65, 151, Button_d, true);
		this->DrawImage(this, 207, 151, Button_d, true);
		if(CFactoryResetAskWin_select == 0)
			this->DrawImage(this, 65, 151, Button_h, true);
		else
			this->DrawImage(this, 207, 151, Button_h, true);
		
		for( i=0;i<CFactoryResetAskWin_itemNum;i++)
		{
			if(CFactoryResetAskWin_select==i)
				this->setFontStyle(this,20,0xFFFFFFFF,ALIGN_MIDDLE,ALIGN_CENTER);
			else
				this->setFontStyle(this,20,0xFF494949,ALIGN_MIDDLE,ALIGN_CENTER);
			this->DrawTextUni(this, 65+i*142, 151, DST_GetImageWidth(Button_d),  DST_GetImageHeight(Button_d), CFactoryResetAskWin_GetString(i),	&(this->font));
		}
	}

//	virtual void Show(void)
	void CFactoryResetAskWin_Show(CWindow *this)
	{
		CFactoryResetAskWin_Draw(this);
		this->DoFocus(this, true);
	}

//	virtual void OnMessage(SWinEventMsg event)
	void CFactoryResetAskWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				this->Close(this);
				break;
			default: break;
		}
	}
	

//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CFactoryResetAskWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_RIGHT:
			case VK_LEFT:
				if(key == VK_RIGHT)
					ItemIncrease(CFactoryResetAskWin_itemNum, 2, &CFactoryResetAskWin_g_nTop, &CFactoryResetAskWin_select, &CFactoryResetAskWin_g_nPos, 1);
				else
					ItemDecrease(CFactoryResetAskWin_itemNum, 2, &CFactoryResetAskWin_g_nTop, &CFactoryResetAskWin_select, &CFactoryResetAskWin_g_nPos, 1);
				CFactoryResetAskWin_Draw(this);
				break;
			case VK_OK: 
				if(CFactoryResetAskWin_select == 0)
				{
//					DST_RemoveAllWindowExceptBasicWin();
					DST_CreateWin(WIN_FACTORY_RESET, (WinID)CFactoryResetAskWin_winParentID, CFactoryResetAskWin_msg, 0, 0, 0);
				}
				else
				{
					DST_CreateWin((WinID)CFactoryResetAskWin_winParentID, 0, 0, 0, 0, 0);
				}
				this->Close(this);
				break;
			case VK_MENU:
			case VK_CANCEL:
			case VK_PREV_MENU:
				this->Close(this);
				break;
			case VK_PREV:
			case VK_PREV_CH:
				DST_CreateWin((WinID)CFactoryResetAskWin_winParentID, 0, 0, 0, 0, 0);
				this->Close(this);
				break;
			default:
				break;
		}
	}

//};

void DST_CreateFactoryResetWin(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor	= CFactoryResetWin_Destructor;
	pWin->OnTimer		= CFactoryResetWin_OnTimer;
	pWin->OnMessage 	= CFactoryResetWin_OnMessage;
	pWin->Show			= CFactoryResetWin_Show;
	//  ȣ
	CFactoryResetWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}

void DST_CreateFactoryResetAskWin(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor	= CFactoryResetAskWin_Destructor;
	pWin->KeyInput		= CFactoryResetAskWin_KeyInput;
	pWin->OnMessage 	= CFactoryResetAskWin_OnMessage;
	pWin->ShowWindow	= CFactoryResetAskWin_ShowWindow;
	pWin->Show			= CFactoryResetAskWin_Show;
	pWin->Focus 		= CFactoryResetAskWin_Focus;
	//  ȣ
	CFactoryResetAskWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}
