#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"

#if 0
____CAudioWin___()
#endif

//class CAudioWin : public CWindow
//{
//private:
	static int CAudioWin_nMTSCount;
//public:
//	CAudioWin(SWinEventMsg event):CWindow(event)
	void CAudioWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "Audio");
		this->rect.w = DST_GetImageWidth(newcon2_gui_banner_mute_back);
		this->rect.h = DST_GetImageHeight(newcon2_gui_banner_mute_back);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = DST_GetScreenHeight()*9/10 - this->rect.h;

		this->SetTimeOut(this, 3);
	}

	void CAudioWin_Destructor(CWindow *this)
	{
	}
	
//	virtual void OnMessage(SWinEventMsg event)
	void CAudioWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				this->Close(this);
				break;
			default: break;
		}
	}

//	virtual void Show(WinID id)
	void CAudioWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_ENGINEER_MODE:
			case WIN_FREQUENCY_SETTING: 		
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
				this->Close(this);
				break;
			default:
				break;
		}
	}
	
	DS_U16* CAudioWin_GetString(int nPos)
	{
		switch (nPos)
		{
			case  0: return pz_MTS_Main[OSD_Lang];
			case  1: return pz_MTS_Sub[OSD_Lang];
		}
		return 0;
	}		
	
//	virtual void Show()
	void CAudioWin_Show(CWindow *this)
	{
		CAudioWin_nMTSCount = 2;
		this->DrawImage(this, 0, 0, newcon2_gui_banner_mute_back, false);
		this->setFontStyle(this, 25, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);
		this->DrawTextUni(this, 0, 0, this->rect.w, this->rect.h, CAudioWin_GetString(DST_UI_GetMTS()), &(this->font));
		
		this->RegisterKey(this, VK_AUDIO, true, 0, 0);
		this->RegisterKey(this, VK_CANCEL, true, 0, 0);
	}

//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CAudioWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_AUDIO:
				DST_UI_SetMTS((DST_UI_GetMTS() == CAudioWin_nMTSCount - 1) ? 0 : DST_UI_GetMTS()+1);
				this->Show(this);

				break;
			case VK_CANCEL:
				this->Close(this);
				break;
			default: break;
		}
	}
//};

void DST_CreateAudioWindow(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor 	= CAudioWin_Destructor;
	pWin->KeyInput 		= CAudioWin_KeyInput;
	pWin->OnMessage		= CAudioWin_OnMessage;
	pWin->ShowWindow 	= CAudioWin_ShowWindow;
	pWin->Show 			= CAudioWin_Show;
	//  ȣ
	CAudioWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}


//class CClosedCaptionWin : public CWindow
//{
//private:
	static int CClosedCaptionWin_nCCPos;
//public:
//	CClosedCaptionWin(SWinEventMsg event):CWindow(event)
	void CClosedCaptionWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "ClosedCaption");
		this->rect.w = DST_GetImageWidth(newcon2_gui_banner_mute_back);
		this->rect.h = DST_GetImageHeight(newcon2_gui_banner_mute_back);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = DST_GetScreenHeight()*9/10 - this->rect.h;

		this->SetTimeOut(this, 3);
		CClosedCaptionWin_nCCPos = 0;

	}

	void CClosedCaptionWin_Destructor(CWindow *this)
	{
	}
	
//	virtual void Show(WinID id)
	void CClosedCaptionWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_ENGINEER_MODE:
			case WIN_FREQUENCY_SETTING:		
			case WIN_EWS:
//			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
//			case WIN_VOLUME:
//			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
				this->Close(this);
				break;
			default:
				break;
		}
	}

	DS_U16* CClosedCaptionWin_GetString(int nPos)
	{
		switch (nPos)
		{
			case  0: return pz_Off[OSD_Lang];
			case  1: return pz_On[OSD_Lang];
			default : return 0;
		}
	}
	
//	virtual void Show()
	void CClosedCaptionWin_Show(CWindow *this)
	{
		CClosedCaptionWin_nCCPos = DST_EEPROM_GetCC();

		this->DrawImage(this, 0, 0, newcon2_gui_banner_mute_back, false);
		this->setFontStyle(this, 25, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);
		this->DrawTextUni(this, 0, 0, this->rect.w, this->rect.h, CClosedCaptionWin_GetString(CClosedCaptionWin_nCCPos), &(this->font));
		
		this->RegisterKey(this, VK_CC, true, 0, 0);
		this->RegisterKey(this, VK_CANCEL, true, 0, 0);
	}

//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CClosedCaptionWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_CC:
				CClosedCaptionWin_nCCPos = (CClosedCaptionWin_nCCPos == 2 - 1) ? 0 : CClosedCaptionWin_nCCPos+1;
				DST_UI_SetCloseCaption(CClosedCaptionWin_nCCPos);
				this->Show(this);
				break;
			case VK_CANCEL:
				this->Close(this);
				break;
			default: break;
		}
	}
//};

void DST_CreateClosedCaptionHotWindow(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor 	= CClosedCaptionWin_Destructor;
	pWin->KeyInput 		= CClosedCaptionWin_KeyInput;
	pWin->ShowWindow 	= CClosedCaptionWin_ShowWindow;
	pWin->Show 			= CClosedCaptionWin_Show;
	//  ȣ
	CClosedCaptionWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}


//class CDisplayModeWin : public CWindow
//{
//private:
	static int CDisplayModeWin_nDMPos;
//public:
//	CDisplayModeWin(SWinEventMsg event):CWindow(event)
	void CDisplayModeWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "DispMode");
		this->rect.w = DST_GetImageWidth(newcon2_gui_banner_mute_back);
		this->rect.h = DST_GetImageHeight(newcon2_gui_banner_mute_back);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = DST_GetScreenHeight()*9/10 - this->rect.h;

		this->SetTimeOut(this, 3);
		CDisplayModeWin_nDMPos = 0;

	}

	void CDisplayModeWin_Destructor(CWindow *this)
	{
	}
	
//	virtual void Show(WinID id)
	void CDisplayModeWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_ENGINEER_MODE:
			case WIN_FREQUENCY_SETTING:		
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
				this->Close(this);
				break;
			default:
				break;
		}
	}

	DS_U16* CDisplayModeWin_GetString(int nPos)
	{
		switch (nPos)
		{
			case DISPLAY_MODE_WIDE: return pz_Wide[OSD_Lang]; break;
			case DISPLAY_MODE_NORMAL: return pz_Normal[OSD_Lang]; break;
			case DISPLAY_MODE_ZOOM: return pz_Zoom[OSD_Lang]; break;
			default : return 0;
		}
	}
	
//	virtual void Show()
	void CDisplayModeWin_Show(CWindow *this)
	{
		CDisplayModeWin_nDMPos = DST_UI_GetAspect();

		this->DrawImage(this, 0, 0, newcon2_gui_banner_mute_back, false);
		this->setFontStyle(this, 25, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);
		this->DrawTextUni(this, 0, 0, this->rect.w, this->rect.h, CDisplayModeWin_GetString(CDisplayModeWin_nDMPos), &(this->font));
		
		this->RegisterKey(this, VK_ZOOM, true, 0, 0);
		this->RegisterKey(this, VK_CANCEL, true, 0, 0);
	}

//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CDisplayModeWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_ZOOM:
				DST_UI_SetAspect(DST_UI_GetAspect() < 2 ? DST_UI_GetAspect()+1 : 0);
				this->Show(this);
				break;
			case VK_CANCEL:
				this->Close(this);
				break;
		}
	}
//};

void DST_CreateDisplayModeWindow(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor 	= CDisplayModeWin_Destructor;
	pWin->KeyInput 		= CDisplayModeWin_KeyInput;
	pWin->ShowWindow 	= CDisplayModeWin_ShowWindow;
	pWin->Show 			= CDisplayModeWin_Show;
	//  ȣ
	CDisplayModeWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}


