#include "DST_Window.h"
#include "DST_WinManager.h"
#include "DST_CommonAPI.h"
#include "DST_DataStrings.h"
#include "DST_UserInterface.h"
#include "DST_CCTask.h"
#include "DST_ChannelTune.h"
#include "DST_DB.h"
#include "DST_OSDImage.h"
#include "DST_SignalMonitor.h"
#include "DST_EEPROM.h"


typedef struct 
{
	MainMenuLists menu;
	bool bEnable;
}MAIN_MENU;

static MAIN_MENU CMainMenu_tv_menu[] = {
	{	MN_AUTO_SCAN,	true	},
	{	MN_MANUAL_SCAN, true	},
	{	MN_SIGNAL_METER,	false	},
	{	MN_AV_DISPLAY_MODE,	true	},
	{	MN_AV_AUDIO_PREF,	true	},
	{	MN_AV_VI,	true	},
	{	MN_CC_DISPLAY,	true	},
	{	MN_SLEEP_TIMER,	true	},
	{	MN_AV_PREFERRED_CONN,	true	},
	{	MN_FACTORY_RESET,	true	},
	{	MN_STB_INFO,	true	},
	{ MN_MAX_NUM, false}
};


//class CZASMainMenu: public CWindow
//{
//private:

	static DS_U16 CMainMenu_g_nPos;
	static DS_U16 CMainMenu_g_nTop;
	static DS_U16 CMainMenu_mainSelect;
	static DS_U16 CMainMenu_mainListNum;
	static DS_U16 CMainMenu_mainItemNum;
	

	static DS_U16 CMainMenu_cursor[20];
	static DS_U16 CMainMenu_select[20];
	static DS_U16 CMainMenu_userSavedValue[20];

	static DS_U16 CMainMenu_listNum[20];
	static DS_U16 CMainMenu_itemNum[20];
	static DS_U16 CMainMenu_SubTop[20];

	static int  CMainMenu_MenuIdx;
	
	void CMainMenu_InitValues();
	void CMainMenu_SetSize(CWindow *this);
	int CMainMenu_GetCount();
	void CMainMenu_GetValuse(DS_U16 menu, DS_U16 *value);

//public:
//	CZASMainMenu(SWinEventMsg event):CWindow(event)
	void CMainMenu_Constructor(CWindow *this, SWinEventMsg event)
	{
		CMainMenu_InitValues();
		CMainMenu_SetSize(this);
		this->SetTimeOut(this, 100);
		
	}

//	virtual ~CZASMainMenu()
	void CMainMenu_Desnstructor(CWindow *this)
	{
		if(DST_GetWin(WIN_FACTORY_RESET)) DST_CreateWin(WIN_MAIN_MENU, 0, 0, 0, 0, 0);
		if(DST_GetWin(WIN_FACTORY_RESET_ASK)) DST_CreateWin(WIN_MAIN_MENU, 0, 0, 0, 0, 0);
		if(DST_g_SignalState == SM_AUDIO_ONLY) DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL ,0, 0, 0);
	}

	bool CMainMenu_getTR_AspectRatio()
	{
		DS_U16 w = 0, h = 0, fps = 0;
		bool bWide = false, bInterlace = false;
		DST_GetVideoSize(&w, &h, &fps, &bInterlace, &bWide);
		
		return (!bWide);
	}

	DS_U8 CMainMenu_getAspectRatioIndex()
	{
		if(CMainMenu_getTR_AspectRatio()) return 1;
		else return 3;
	}

	MainMenuLists CMainMenu_Index2MenuLists(int index)
	{
		int nPos = -1;
		int i = 0;
		MainMenuLists menu = MN_AUTO_SCAN;
		if (index < CMainMenu_mainItemNum)
		{
			for (i = 0; i < 20; i++)
			{
				
				if (CMainMenu_tv_menu[i].bEnable) nPos++;
				if (nPos != index) continue;
				menu = CMainMenu_tv_menu[i].menu;
				break;
			}
		}
		return menu;
	}
	
	DS_U16 CMainMenu_GetSubCount(DS_U16 menu)
	{
		switch(CMainMenu_Index2MenuLists(menu))
		{
			case MN_AUTO_SCAN: return 1;
			case MN_MANUAL_SCAN: return 1;
			case MN_SIGNAL_METER: return 1;
			case MN_AV_DISPLAY_MODE: return CMainMenu_getAspectRatioIndex();
			case MN_AV_AUDIO_PREF: return 2;
			case MN_AV_VI: return 2;
			case MN_CC_DISPLAY: return 2;
			case MN_SLEEP_TIMER: return SLEEP_TIMER_MAX_NUM;
			case MN_AV_PREFERRED_CONN: return PREFERRED_CONN_MAX_NUM;
			case MN_FACTORY_RESET: return 1;
			case MN_STB_INFO: return 1;
			default: break;
		}
		return 0;
	}

	void CMainMenu_InitSubValues()
	{
		int i = 0;
		for(i = 0 ; i < CMainMenu_mainItemNum ; i++)
		{
			CMainMenu_cursor[i]		=0;
			CMainMenu_select[i]		=0;
			CMainMenu_userSavedValue[i] =0;

			CMainMenu_listNum[i] = 0;
			CMainMenu_itemNum[i] = 0;
			CMainMenu_SubTop[i] = 0;
		
			CMainMenu_listNum[i] = 6;
			CMainMenu_itemNum[i]  = CMainMenu_GetSubCount(i);
			if (CMainMenu_itemNum[i] < CMainMenu_listNum[i]) CMainMenu_listNum[i] = CMainMenu_itemNum[i];
			CMainMenu_GetValuse(i, &CMainMenu_select[i]);
			CMainMenu_userSavedValue[i] = CMainMenu_select[i];
			InitItemValues(CMainMenu_listNum[i], CMainMenu_select[i], &CMainMenu_SubTop[i], &CMainMenu_cursor[i]);
		}
	}
	
	void CMainMenu_InitValues()
	{
		CMainMenu_MenuIdx = 0;/*DST_UI_GetSource();*/
		
		CMainMenu_mainItemNum = CMainMenu_GetCount();
		CMainMenu_g_nTop = MenuTop[CMainMenu_MenuIdx];
		CMainMenu_g_nPos = MenuPos[CMainMenu_MenuIdx];
		CMainMenu_mainSelect = MenuSelect[CMainMenu_MenuIdx];
		CMainMenu_mainListNum = 6;
		if (CMainMenu_mainItemNum < CMainMenu_mainListNum) CMainMenu_mainListNum = CMainMenu_mainItemNum;
		CMainMenu_InitSubValues();
		
	}

	int CMainMenu_GetCount()
	{
		int MenuCount = 0;
		int i = 0;
		for (i = 0; i < 20; i++)
		{
			if (CMainMenu_tv_menu[i].menu == MN_MAX_NUM) break;
			if (CMainMenu_tv_menu[i].bEnable) MenuCount++;
		}
		return MenuCount;
	}
	
	void CMainMenu_GetValuse(DS_U16 menu, DS_U16 *value)
	{
		switch(CMainMenu_Index2MenuLists(menu))
		{
			case MN_AUTO_SCAN: *value = 0; break;
			case MN_MANUAL_SCAN: *value = 0; break;
			case MN_SIGNAL_METER: *value = 0; break;
			case MN_AV_DISPLAY_MODE: *value = DST_UI_GetAspect(); break;
			case MN_AV_AUDIO_PREF: *value = DST_UI_GetMTS(); break;
			case MN_AV_VI: *value = DST_UI_GetVI(); break;
			case MN_CC_DISPLAY: *value = DST_EEPROM_GetCC(); break;
			case MN_SLEEP_TIMER: *value = DST_GetSleepTimer(); break;
			case MN_AV_PREFERRED_CONN: *value = DST_UI_GetCh34(); break;
			case MN_FACTORY_RESET: *value = 0; break;
			case MN_STB_INFO: *value = 0; break;
			default: break;
		}
	}

	void CMainMenu_SetValuse(DS_U16 menu, DS_U16 value)
	{
		switch(CMainMenu_Index2MenuLists(menu))
		{
 			case MN_AUTO_SCAN:break;
			case MN_MANUAL_SCAN: break;
			case MN_SIGNAL_METER: break;
			case MN_AV_DISPLAY_MODE: DST_UI_SetAspect(value); break;
			case MN_AV_AUDIO_PREF: DST_UI_SetMTS(value); break;
			case MN_AV_VI: DST_UI_SetVI(value); break;
			case MN_CC_DISPLAY: DST_UI_SetCloseCaption(value); break;
			case MN_SLEEP_TIMER: 
				if(0 < value && value < 5 )DST_g_sleepTimercheckTime = DST_OS_GetTickCount(); 
				DST_SetSleepTimer(value); 
				break;	
			case MN_AV_PREFERRED_CONN: DST_UI_SetCh34(value); break;
			case MN_FACTORY_RESET: break;
			case MN_STB_INFO: break;
			default: break;
		}
	}
	

	
	DS_U16* CMainMenu_GetString(int nPos)
	{
		switch (CMainMenu_Index2MenuLists(nPos))
		{
			case MN_AUTO_SCAN: return pz_Sub_AutoScan[OSD_Lang]; break;
			case MN_MANUAL_SCAN: return pz_ManualSearch[OSD_Lang]; break;
			case MN_SIGNAL_METER: return pz_Sub_SignalMeter[OSD_Lang]; break;
			case MN_AV_DISPLAY_MODE: return pz_Sub_DisplayMode[OSD_Lang]; break;
			case MN_AV_AUDIO_PREF: return pz_Sub_AudioPref[OSD_Lang]; break;
			case MN_AV_VI: return pz_Sub_DVS[OSD_Lang]; break;
			case MN_CC_DISPLAY: return pz_Sub_CC[OSD_Lang]; break;
			case MN_SLEEP_TIMER: return pz_Sub_SleepTime[OSD_Lang]; break;
			case MN_AV_PREFERRED_CONN: return pz_Sub_PrefConn[OSD_Lang]; break;
			case MN_FACTORY_RESET: return pz_Sub_Factory[OSD_Lang]; break;
			case MN_STB_INFO: return pz_Sub_STB_Info[OSD_Lang];
			default: break;
		}
		return 0;
	}

	DS_U16* CMainMenu_GetSubString(int itemIdx, int nPos)
	{
		static DS_U16 strText[32];
		unsigned i = 0;
		// ⺻..̰ ٸ 
		for (i = 0; i < 40; i++)
		{
			strText[i] = pz_Unknown[OSD_Lang][i];
			if (strText[i] == 0) break;
		}

		switch (CMainMenu_Index2MenuLists(itemIdx))
		{

			case MN_AV_DISPLAY_MODE:
				switch(nPos)
				{
					case DISPLAY_MODE_WIDE: return pz_Wide[OSD_Lang]; break;
					case DISPLAY_MODE_NORMAL: return pz_Normal[OSD_Lang]; break;
					case DISPLAY_MODE_ZOOM: return pz_Zoom[OSD_Lang]; break;
					default: break;
				}
				break;

			case MN_AV_AUDIO_PREF:
				switch (nPos)
				{
					case  0: return pz_MTS_Main[OSD_Lang];
					case  1: return pz_MTS_Sub[OSD_Lang];
					default: break;
				}
				break;
				
			case MN_AV_VI:
				switch (nPos)
				{
					case  0: return pz_VI_Off[OSD_Lang];
					case  1: return pz_VI_On[OSD_Lang];
					default: break;

				}
				break;
				
			case MN_CC_DISPLAY:
				switch (nPos)
				{
					case  0: return pz_Off[OSD_Lang]; break;
					case  1: return pz_On[OSD_Lang]; break;
					default: break;
				}
				break;
				
			case MN_SLEEP_TIMER:
				switch(nPos)
				{
					case SLEEP_TIMER_OFF: return pz_Off[OSD_Lang]; break;
					case SLEEP_TIMER_15M: return pz_Sub_SleepTime_15[OSD_Lang]; break;
					case SLEEP_TIMER_30M: return pz_Sub_SleepTime_30[OSD_Lang]; break;
					case SLEEP_TIMER_60M: return pz_Sub_SleepTime_60[OSD_Lang]; break;
					case SLEEP_TIMER_120M: return pz_Sub_SleepTime_120[OSD_Lang]; break;
					default: break;
				}
				break;
				
			case MN_AV_PREFERRED_CONN:
				switch(nPos)
				{
					case PREFERRED_CONN_LINE_OUT: return pz_Sub_LineOut[OSD_Lang]; break;
					case PREFERRED_CONN_CH34: return pz_Sub_CH34[OSD_Lang]; break;
					default: break;
				}
				break;
				
			case MN_AUTO_SCAN:
			case MN_MANUAL_SCAN:
			case MN_SIGNAL_METER:
			case MN_FACTORY_RESET:
			case MN_STB_INFO:
				switch (nPos)
				{
					case  0: return pz_Empty[OSD_Lang];
				}
				break;
			default:
				break;
		}
		return 0;
	}

	void CMainMenu_SetSize(CWindow *this)
	{
		this->rect.w = DST_GetImageWidth(back);
		this->rect.h = DST_GetImageHeight(back);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w)/2;
		this->rect.y = ((DST_GetScreenHeight() - this->rect.h)/2)+10;
	}

//	virtual void Focus(bool bVal)
	void CMainMenu_Focus(CWindow *this, bool bVal)
	{
		this->RegisterKey(this, VK_MENU, bVal, 0, 0);
		this->RegisterKey(this, VK_CANCEL, bVal, 0, 0);
		this->RegisterKey(this, VK_LEFT, bVal, 0, 0);
		this->RegisterKey(this, VK_RIGHT, bVal, 0, 0);
		this->RegisterKey(this, VK_UP, bVal, 0, 0);
		this->RegisterKey(this, VK_DN, bVal, 0, 0);
		this->RegisterKey(this, VK_OK, bVal, 0, 0);
		this->RegisterKey(this, VK_CH_UP, bVal, 0, 0);
		this->RegisterKey(this, VK_CH_DN, bVal, 0, 0);
		this->RegisterKey(this, VK_PREV, bVal, 0, 0);
		this->RegisterKey(this, VK_PREV_CH, bVal, 0, 0);
		this->RegisterKey(this, VK_PREV_MENU, bVal, 0, 0);
	}
	
//	virtual void Show(WinID id)
	void CMainMenu_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_ENGINEER_MODE:
			case WIN_FREQUENCY_SETTING:	
			case WIN_EWS:
			case WIN_DIRECT_TUNE:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
			case WIN_AGE_RATING:
				this->Close(this);
				break;
			default:
				break;		
		}
	}
	
	 void CMainMenu_DrawScrollBar(CWindow *this, int x, int y, int h, int total_count, int page_count, int page_start)
	 {
		 if (total_count <= page_count) return;
		 //  ׸
		 int nTop = DST_GetImageHeight(scroll_p_1);
		 int nBot = DST_GetImageHeight(scroll_p_3);
		 int nMinHeight = nTop + nBot + 1; // ּ 
		 int nHeight = (h * page_count) / total_count; // 
		 if (nHeight < nMinHeight) nHeight = nMinHeight; 
		 int nStart = (h * page_start) / total_count;
		 if (nStart + nHeight > h) nStart = h - nHeight; // Ʒ ° 
		 if (total_count == page_start + page_count) nStart = h - nHeight; // Ʒ ȼ  
		 int nMid = nHeight - nTop - nBot;	 
		 this->DrawImage(this, x, y+nStart, scroll_p_1, true);
		 int yy = 0;
		 for (yy = 0; yy < nMid; yy++)
		 {
			 this->DrawImage(this, x,y+yy+nStart+nTop,scroll_p_2,false);
		 }
		 this->DrawImage(this, x,y+nStart+nTop+nMid,scroll_p_3,true);
	 }

	 //ȯ漳 ޴ ŸƲ ׸
	void CMainMenu_DrawTitle(CWindow *this)
	{
		this->setFontStyle(this, 22,0xFFE1E1E1,ALIGN_MIDDLE,ALIGN_CENTER);
		this->DrawTextUni(this, 323-313, 82-78, 312, 42, pz_Empty[OSD_Lang], &(this->font));
	}

	 //׺̼ ׸
	void CMainMenu_DrawNavigation(CWindow *this)
	{
		this->setFontStyle(this, 20,0xFF7B7B7B,this->FontGetVerAlign(this),ALIGN_LEFT);

		DS_U16	final[20];

		this->DrawImage(this, 433-313,426-78, arrow_ud, false);
		str2uni(final, (char *)": ");
		strcpy16(&final[strlen16(final)], pz_Move[OSD_Lang]);
		this->DrawTextUni(this, 454-313, 428-78, 79, 22, final, &(this->font));

		this->DrawImage(this, 545-313,426-77,arrow_lr, false);
		str2uni(final, (char *)": ");
		strcpy16(&final[strlen16(final)], pz_Select[OSD_Lang]);
		this->DrawTextUni(this,569-313, 428-78, 79, 22, final, &(this->font));
	}

	 //ȭ鿡 Ÿ ׸ ׸
	void CMainMenu_DrawCategory(CWindow *this, int index)
	{
		int y_Constant=157;
		int y_Multiplier=42;
		int width=163;
		if(MenuPos[CMainMenu_MenuIdx] == index)
			this->setFontStyle(this, 21,0xFFFFFFFF,this->FontGetVerAlign(this),ALIGN_LEFT);
		else 
			this->setFontStyle(this, 21,0xFFC8C8C8,this->FontGetVerAlign(this),ALIGN_LEFT);

		this->DrawTextUni(this, 344-313, (y_Constant-78)+index*y_Multiplier, width, 20, CMainMenu_GetString(index+CMainMenu_g_nTop), &(this->font));

		if(MenuPos[CMainMenu_MenuIdx] == index)
		{
			int i = 0;
			this->DrawImage(this, 333-313, (145-76)+index*y_Multiplier, hl_orange_l,true);
			for( i=0;i<255;i++)
			{
				this->DrawImage(this, (333-313)+15+i, (145-76)+index*y_Multiplier, hl_orange_mid, false);
			}
			this->DrawImage(this, (333-313)+270, (145-76)+index*y_Multiplier, hl_orange_r,true);

			this->DrawTextUni(this, 344-313, (y_Constant-78)+index*y_Multiplier, width, 20, CMainMenu_GetString(index+CMainMenu_g_nTop), &(this->font));	

			//Aspect Ratio ϳۿ øҰ, Ȥ  ÷  ʴ   ׸ 
			if(CMainMenu_Index2MenuLists(MenuSelect[CMainMenu_MenuIdx]) == MN_AV_DISPLAY_MODE)
			{
				if(CMainMenu_getAspectRatioIndex() == 1 || DST_IsVideoPlay() == false) return;
					
			}
			
			this->DrawImage(this, 601-313,(160-76)+index*y_Multiplier,arrow_right,true);
			switch(CMainMenu_Index2MenuLists(MenuSelect[CMainMenu_MenuIdx]))
			{
				case MN_AUTO_SCAN:
				case MN_MANUAL_SCAN:
				case MN_SIGNAL_METER:
				case MN_FACTORY_RESET:
				case MN_STB_INFO:
					break;
				default:
					this->DrawImage(this, 514-313,(160-76)+index*y_Multiplier,arrow_left,true);
					break;
						
			}
			
		}
	}
	 //ȭ鿡 Ÿ ׸ ׸
	void CMainMenu_DrawItems(CWindow *this, int mainIndex,int subIndex)
	{
		int y_Constant=157;
		int y_Multiplier=42;
		int width=80;
		int nFontSize=20;
		if(MenuPos[CMainMenu_MenuIdx] == mainIndex)
			this->setFontStyle(this, 21,0xFFFFFFFF,this->FontGetVerAlign(this),ALIGN_CENTER);
		else 
			this->setFontStyle(this, 21,0xFFF06E03,this->FontGetVerAlign(this),ALIGN_LEFT);
		DS_U16* strText16 = CMainMenu_GetSubString(mainIndex+CMainMenu_g_nTop,subIndex);
		int k = 0;
		for (k = nFontSize; k > 10; k--)
		{
			int nWidth = DST_GetTextWidthUni(strText16, k);
			if (nWidth > width) continue;
			nFontSize = k;
			break;
		}
		this->FontSetSize(this, nFontSize); 
		
		this->DrawTextUni(this, 522-313, (y_Constant-78)+mainIndex*y_Multiplier,	width, 20, strText16, &(this->font));
		
	}

	void CMainMenu_DrawMenu(CWindow *this, int categoryIndex)
	{
		this->setFontStyle(this, 21,this->FontGetColor(this),ALIGN_MIDDLE,this->FontGetHorAlign(this));
		
		CMainMenu_DrawCategory(this, categoryIndex);
		CMainMenu_DrawItems(this, categoryIndex,CMainMenu_userSavedValue[categoryIndex+CMainMenu_g_nTop]);
	}

	void CMainMenu_Draw(CWindow *this)
	{
		this->DrawImage(this,0,0, (DS_U8*)back,false);
		
		CMainMenu_DrawScrollBar(this, 622-313, 145-77, 42*CMainMenu_mainListNum-1, CMainMenu_mainItemNum, CMainMenu_mainListNum, CMainMenu_g_nTop);

		int i = 0;
		for(i=0;i<CMainMenu_mainListNum;i++)
			CMainMenu_DrawMenu(this, i);
		CMainMenu_DrawNavigation(this);
		
	}

	void CMainMenu_DrawSubMenu(CWindow *this, DS_U8 key)
	{
		switch(key)
		{
			case VK_RIGHT:
			case VK_OK:
				switch(CMainMenu_Index2MenuLists(CMainMenu_mainSelect))
				{
					case MN_AUTO_SCAN:
						DST_CreateWin(WIN_AUTO_SEARCH, WIN_MAIN_MENU, 0, 0, 0, 0); 
						this->Close(this);
						break;
					case MN_MANUAL_SCAN:
						DST_CreateWin(WIN_MANUAL_SEARCH, WIN_MAIN_MENU,0 ,0 ,0 ,0);
						this->Close(this);
						break;
					case MN_SIGNAL_METER:
						DST_CreateWin(WIN_SIGNAL_METER, WIN_NULL,0,0,0,0);
						this->Close(this);
						break;
					case MN_FACTORY_RESET:
						DST_CreateWin(WIN_FACTORY_RESET_ASK, WIN_MAIN_MENU, 0, 0, 0, 0);
						this->Close(this);
						break;
					case MN_STB_INFO:
						DST_CreateWin(WIN_STB_INFO, WIN_NULL, 0, 0, 0, 0);
						break;
					default:
						break;
				}
				break;
			default:
				break;
		}
		
	}

//	virtual void Show(void)
	void CMainMenu_Show(CWindow *this)
	{
		CMainMenu_Draw(this);
		this->DoFocus(this, true);
	}

//	virtual void OnMessage(SWinEventMsg event)
	void CMainMenu_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			 //޴ ִ ¿  ȭ ҽ  Ǹ ش Ʈ
			case WM_SOURCE_FORMAT_DONE:
				CMainMenu_InitSubValues(); //忡 ° UI 
				DST_UI_SetAspect( DST_UI_GetAspect());//ٲ ȭ 
				CMainMenu_Draw(this);
				break;
		}
	}	
//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CMainMenu_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			 //  ٷ 
			case VK_RIGHT:
			case VK_LEFT:
				
				if(key == VK_LEFT)
					ItemDecrease(CMainMenu_itemNum[MenuSelect[CMainMenu_MenuIdx]], CMainMenu_itemNum[MenuSelect[CMainMenu_MenuIdx]], &CMainMenu_SubTop[MenuSelect[CMainMenu_MenuIdx]], &CMainMenu_select[MenuSelect[CMainMenu_MenuIdx]], &CMainMenu_cursor[MenuSelect[CMainMenu_MenuIdx]],1);
				else
					ItemIncrease(CMainMenu_itemNum[MenuSelect[CMainMenu_MenuIdx]], CMainMenu_itemNum[MenuSelect[CMainMenu_MenuIdx]], &CMainMenu_SubTop[MenuSelect[CMainMenu_MenuIdx]], &CMainMenu_select[MenuSelect[CMainMenu_MenuIdx]], &CMainMenu_cursor[MenuSelect[CMainMenu_MenuIdx]],1);
				
				CMainMenu_userSavedValue[MenuSelect[CMainMenu_MenuIdx]] = CMainMenu_select[MenuSelect[CMainMenu_MenuIdx]];
				CMainMenu_SetValuse(MenuSelect[CMainMenu_MenuIdx], CMainMenu_select[MenuSelect[CMainMenu_MenuIdx]]);
				CMainMenu_InitSubValues();
				
				CMainMenu_Draw(this);
				CMainMenu_DrawSubMenu(this, key);
				break;

			case VK_UP:
			case VK_DN:
				if(key == VK_DN)
					ItemIncrease(CMainMenu_mainItemNum, CMainMenu_mainListNum, &CMainMenu_g_nTop, &CMainMenu_mainSelect, &CMainMenu_g_nPos, 1);
				else
					ItemDecrease(CMainMenu_mainItemNum, CMainMenu_mainListNum, &CMainMenu_g_nTop, &CMainMenu_mainSelect, &CMainMenu_g_nPos, 1);
				MenuTop[CMainMenu_MenuIdx] = CMainMenu_g_nTop;
				MenuPos[CMainMenu_MenuIdx] = CMainMenu_g_nPos;
				MenuSelect[CMainMenu_MenuIdx] = CMainMenu_mainSelect;
				CMainMenu_InitSubValues();
				CMainMenu_Draw(this);
				break;
				
			case VK_OK:
				CMainMenu_DrawSubMenu(this, key);
				break;
			case VK_CANCEL:
			case VK_MENU:
			case VK_PREV:
			case VK_PREV_CH:
			case VK_PREV_MENU:
				if(DST_UI_GetMute() && DST_GetWin(WIN_VOLUME_MUTE)==0) DST_CreateWin(WIN_VOLUME_MUTE, 0, 0, 0, 0, 0);
				this->Close(this);
				if(DST_g_SignalState == SM_AUDIO_ONLY) DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL ,0, 0, 0);
				break;

			default:
				break;
		}
	}
//};

void DST_CreateMainMenu(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor = CMainMenu_Desnstructor;
	pWin->OnMessage = CMainMenu_OnMessage;	
	pWin->KeyInput = CMainMenu_KeyInput;
	pWin->Focus = CMainMenu_Focus;
	pWin->ShowWindow = CMainMenu_ShowWindow;
	pWin->Show = CMainMenu_Show;
	//  ȣ
	CMainMenu_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}

