#include "DST_Window.h"
#include "DST_WinManager.h"
#include "DST_CommonAPI.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"
#include "DST_ISDBT_ChannelTask.h"
#include "DST_DB.h"
#include "DST_ChannelTune.h"
#include "DST_OSDImage.h"


char* DST_GetAppShortVersion();
void CSTBInfo_SetSize(CWindow *this);

//class CSTBInfo: public CWindow
//{
//private:
//public:
//	CSTBInfo(SWinEventMsg event):CWindow(event)
	void CSTBInfo_Constructor(CWindow *this, SWinEventMsg event)
	{
		CSTBInfo_SetSize(this);
		this->SetTimeOut(this, 100);
	}

	void CSTBInfo_Destructor(CWindow *this)
	{
	}	
	
	
	void CSTBInfo_SetSize(CWindow *this)
	{
		this->rect.w = DST_GetImageWidth(pin_back);
		this->rect.h = DST_GetImageHeight(pin_back);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w)/2;
		this->rect.y = (DST_GetScreenHeight() - this->rect.h)/2;
	}

	void CSTBInfo_DrawGuide(CWindow *this)
	{
		this->setFontStyle(this, 22,0xFFE1E1E1,ALIGN_MIDDLE,ALIGN_CENTER);
		
		this->DrawTextUni(this, 0, 77/3, this->rect.w, DST_GetFontHeight(this->FontGetSize(this)), pz_Sub_STB_Info[OSD_Lang], &(this->font));
				
	}

	void CSTBInfo_DrawItems(CWindow *this, int xPos, int yPos)
	{
		char strHW[5] = {0,0,0,0,0};
		sprintf(strHW, "0.%d", 1);	
		
		this->setFontStyle(this,19,0xFFFF4B1E,ALIGN_MIDDLE,ALIGN_CENTER);
		int w1 = DST_GetTextWidth((char*)"S/W :", this->FontGetSize(this));
		int w2 = DST_GetTextWidth(DST_GetAppShortVersion(), this->FontGetSize(this));
		int w3 = DST_GetTextWidth((char*)"H/W :", this->FontGetSize(this));
		int w4 = DST_GetTextWidth(strHW, this->FontGetSize(this));
		
		int x1 = (this->rect.w - (w1 + w2))/2;
		int x2 = x1 + w1;
		int x3 = x2 - w3;
		int x4 = x2;

		int y1 = 75;
		int h1 = 30;
		int y3 = y1 + h1;
		
		this->setFontStyle(this,19,0xFFFF4B1E,ALIGN_MIDDLE,ALIGN_CENTER);
		this->DrawText(this,x1, y1, w1, h1, (char*)"S/W :", &(this->font));
		this->DrawText(this,x2, y1, w2, h1, DST_GetAppShortVersion(), &(this->font));
		this->DrawText(this,x3, y3, w3, h1, (char*)"H/W :", &(this->font));
		this->DrawText(this,x4, y3, w4, h1, strHW, &(this->font));
			
		
	}

	void CSTBInfo_Draw(CWindow *this)
	{
		this->DrawImage(this,0,0,pin_back,false);
		CSTBInfo_DrawGuide(this);
		CSTBInfo_DrawItems(this, 20, 77/3 + DST_GetFontHeight(20) + 77/3 );
	}

	

//	virtual void Focus(bool bVal)
	void CSTBInfo_Focus(CWindow *this, bool bVal)
	{
		this->RegisterKey(this, VK_CANCEL, bVal, 0, 0);
		this->RegisterKey(this, VK_MENU, bVal, 0, 0);
		this->RegisterKey(this, VK_OK, bVal, 0, 0);
		this->RegisterKey(this, VK_UP, bVal, 0, 0);
		this->RegisterKey(this, VK_DN, bVal, 0, 0);
		this->RegisterKey(this, VK_RIGHT, bVal, 0, 0);
		this->RegisterKey(this, VK_LEFT, bVal, 0, 0);
		this->RegisterKey(this, VK_PREV, bVal, 0, 0);
		this->RegisterKey(this, VK_PREV_CH, bVal, 0, 0);
		this->RegisterKey(this, VK_PREV_MENU, bVal, 0, 0);
	}
	
//	virtual void Show(WinID id)
	void CSTBInfo_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_ENGINEER_MODE: 
			case WIN_FREQUENCY_SETTING: 
			case WIN_EWS:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
				this->Close(this);
				break;
			default:
				break;		
		}

	}
	
//	virtual void Show(void)
	void CSTBInfo_Show(CWindow *this)
	{
		CSTBInfo_Draw(this);
		this->DoFocus(this, true);
	}


//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CSTBInfo_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_MENU:
			case VK_CANCEL:
			case VK_PREV_MENU:
				this->Close(this);
				if(DST_UI_GetMute() && DST_GetWin(WIN_VOLUME_MUTE)==0) DST_CreateWin(WIN_VOLUME_MUTE, 0, 0, 0, 0, 0);
				if(DST_GetWin(WIN_MAIN_MENU)) DST_CloseWin(WIN_MAIN_MENU);
				break;
			
			case VK_OK:
			case VK_PREV:
			case VK_PREV_CH:
				this->Close(this);
				break;

			default:
				break;
		}
	}

//};

void DST_CreateSTBInfo(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor = CSTBInfo_Destructor;
	pWin->KeyInput = CSTBInfo_KeyInput;
	pWin->Focus = CSTBInfo_Focus;
	pWin->ShowWindow = CSTBInfo_ShowWindow;
	pWin->Show = CSTBInfo_Show;
	//  ȣ
	CSTBInfo_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);

}



