#include "DST_Common.h"
#include "DST_GlobalVariables.h"
#include "DST_HostInterface.h"
#include "DST_CommonAPI.h"
#include "DST_ChannelTune.h"
#include "DST_WindowType.h"
#include "DST_WindowEvent.h"
#include "DST_SignalMonitor.h"
#include "DST_DataStrings.h"
#include "DST_WinManagerTask.h" //ui
#include "DST_FontEngine.h"
#include "DST_UserInterface.h"
#include "DST_WinManager.h"
#include "DST_DB.h"
#include "DST_ChannelTune.h"
#include "DST_CC_Setup.h"

bool DST_CC_Available();
bool DST_FlashSync();

#if 0
____Channel_APIs___()
#endif


//   ļ ȣ
DS_U8 DST_MinRF()
{
	//return 0;
	return DST_EEPROM_GetMinRF();
}

//   ļ ȣ
DS_U8 DST_MaxRF()
{
	//return RF_COUNT - DST_MinRF() - 1; // RF 85 Index 83
	return DST_EEPROM_GetMaxRF();
}

#if 0
____Image_APIs___()
#endif

// ̹  ´.
int DST_GetImageWidth(DS_U8 *Image)
{
	return Image[1]*256+Image[2];
}

// ̹ ̸ ´.
int DST_GetImageHeight(DS_U8 *Image)
{
	return Image[3]*256+Image[4];
}

#if 0
____EPG_APIs___()
#endif

// ð  Ÿ ڿ ´.
int DST_GetTimeDurationString(int date, int start, DS_U32 duration, DS_U16* strText)
{
	// Ÿ+Ÿ 
	start += (DST_GetTimeOffset()*60*60);
	if (start < 0) start += (24*60*60);

	//int year = 0;
	int month = 0;
	int day = 0;
	//int wday = 0;
	int y = /*int*/((date-15078.2f)/365.25f);
	int m = /*int*/((date-14956.1f - /*int*/(y*365.25f)) / 30.6001f);
	int k = (m==14 || m==15) ? 1 : 0;
	day = date-14956-/*int*/(y*365.25f)-/*int*/(m*30.6001f);
	//year = 1900 + y + k;
	month = m - 1 - k * 12;
	//wday = ((date+3) % 7); // Ͽ 0  1

	char str[10] = {0,};
	sprintf(str, "%02d/%02d ",day,month);
	str2uni(strText, str);
	
	DST_UI_GetTimeString(((start)/3600)%24, (start/60)%60,  &strText[strlen16(strText)]);
	str2uni(&strText[strlen16(strText)], (char*)"-");
	DST_UI_GetTimeString(((start+duration)/3600)%24, ((start+duration)/60)%60,  &strText[strlen16(strText)]);
	return strlen16(strText);
}

// ð ³ ڿ ´.
//int DST_GetTimeString(DS_U32 bcd, DS_U32 duration, DS_U16* strText)
//{
//	STime_t st = DST_GetTime(bcd, duration);
//	return DST_UI_GetTimeString(st.hour, st.min, strText);
//}

////   α׷ ̸ Ÿӵ෹̼ ڿ ´.
//void DST_GetProgramInfoString(DS_U8 *cur_info, DS_U16 *duration)
//{
//	int nCount = 0;
//	EPG_DB* db = DST_EPG_DB_Get(&nCount);
//	if (nCount == 0) return;
//	DST_GetTimeDurationString(db[0].start_time, db[0].duration, duration); // ̺Ʈ ۽ð ð ǥ
//	int nLen = db[0].name_length[0];
//	memset(cur_info, 0, nLen+1);
//	if (nLen > 0) memcpy(cur_info, db[0].p_name[0], nLen);
//	DST_EPG_DB_Free(db, nCount);
//}

#if 0
____Aspect_APIs___()
#endif

//  ػ  ´.
// ȯ 0̸ ػ  
int DST_GetResolutionInfo()
{
	DS_U16 w = 0, h = 0, fps = 0;
	bool bWide = false, bInterlace = false;
	DST_GetVideoSize(&w, &h, &fps, &bInterlace, &bWide);
	if (h == 0) return 0;
	if (h < 180) return 1;// SQVGA	160x120 160x90
	if (h < 264) return 2;// QVGA	320x240 320x180
	if (h < 384) return 3;// CIF	352x288
	if (h < 528) return bWide ? 4 : 5;// 480p/i	720x480
	if (h < 648) return bWide ? 6 : 7;// 576p/i	720x576
	if (h < 900) return 8;// 720p	1280x720
	return 9;
}

//   ÷  ȯѴ.
bool DST_IsVideoPlay()
{
		if (DST_IsWeakSignal()) return false;
		if (DST_IsNoProgram()) return false;
		if (DST_IsAudioOnly()) return false;
		return true;
}

//    HD ΰ?
bool DST_GetHDInfo()
{
	return (DST_GetResolutionInfo() >= 8); // 720p ̸̻ HD
}


#if 0
____CC_APIs___()
#endif

//  CC ֱⰡ Ѱ?
bool DST_GetCCInfo()
{
	if (DST_IsWeakSignal()) return false;
	if (DST_IsNoProgram()) return false;
	return DST_CC_Available();
}

#if 0
____Date_Time_APIs___()
#endif

//  ڿ ´.
// 0(Ͽ)-6()
DS_U16 *DST_GetDayOfWeakString(int nDayOfWeak)
{
	switch (nDayOfWeak)
	{
		case 1:	return pz_Mon[OSD_Lang];
		case 2:	return pz_Tue[OSD_Lang];
		case 3:	return pz_Wed[OSD_Lang];
		case 4:	return pz_Thu[OSD_Lang];
		case 5:	return pz_Fri[OSD_Lang];
		case 6:	return pz_Sat[OSD_Lang];
	}
	return pz_Sun[OSD_Lang];
}

//   ̸ ´.
// 1-12
DS_U16 *DST_GetMonthOfYearString(int nMonthOfYear)
{
	switch (nMonthOfYear)
	{
		case 2:	return pz_Feb[OSD_Lang];
		case 3:	return pz_Mar[OSD_Lang];
		case 4:	return pz_Apr[OSD_Lang];
		case 5:	return pz_May[OSD_Lang];
		case 6:	return pz_Jun[OSD_Lang];
		case 7:	return pz_Jul[OSD_Lang];
		case 8:	return pz_Aug[OSD_Lang];
		case 9:	return pz_Sep[OSD_Lang];
		case 10:	return pz_Oct[OSD_Lang];
		case 11:	return pz_Nov[OSD_Lang];
		case 12:	return pz_Dec[OSD_Lang];
	}
	return pz_Jan[OSD_Lang];
}

#if 0
____Brightness_APIs___()
#endif

//   Ѵ.
void DST_SetBrightness(DS_U8 value)
{
//	DHL_DISP_SetLCDBacklight(value);
//	DST_Printf("DHL_DISP_SetLCDBacklight %d\n", value);
}

#if 0
____Power_APIs___()
#endif

/*extern "C" */void DHL_SYS_Terminate();
void DST_PowerDown(void)
{
	DST_g_PowerOn = false;
	DST_RemoveAllWindowExceptBasicWin();
	// AV  Ʈ
//	DST_PowerOnMute(true);
	//DHL_DISP_MuteMain(1);
	DHL_VID_Mute(1);
	DST_DB_Sync();
	int i;
	for ( i = 0; i < 500; i++)
	{
		DST_OS_Delay(50);
		T();
		if (DST_DB_IsSync() == false) continue;
		break;
	}
	
	DHL_SYS_Off();
}

#if 0
____Country_APIs___()
#endif

DS_U16* DST_GetISOLanguageName(DS_U8 nNumber)
{
	static DS_U16 strText16[20];
	strcpy16(strText16, pz_Unknown[OSD_Lang]);
	// Ƽ   ڵ
	switch (nNumber)
	{
		case 0x01: str2uni(strText16, (char*)"Albanian"); break;
		case 0x02: str2uni(strText16, (char*)"Breton"); break;
		case 0x03: str2uni(strText16, (char*)"Catalan"); break;
		case 0x04: str2uni(strText16, (char*)"Croatian"); break;
		case 0x05: str2uni(strText16, (char*)"Welsh"); break;
		case 0x06: str2uni(strText16, (char*)"Czech"); break;
		case 0x07: str2uni(strText16, (char*)"Danish"); break;
		//case 0x08: str2uni(strText16, (char*)"German"); break;
		//case 0x09: str2uni(strText16, (char*)"English"); break;
		//case 0x0A: str2uni(strText16, (char*)"Spanish"); break;
		case 0x0B: str2uni(strText16, (char*)"Esperanto"); break;
		case 0x0C: str2uni(strText16, (char*)"Estonian"); break;
		case 0x0D: str2uni(strText16, (char*)"Basque"); break;
		case 0x0E: str2uni(strText16, (char*)"Faroese"); break;
		//case 0x0F: str2uni(strText16, "French"); break;
		case 0x10: str2uni(strText16, (char*)"Frisian"); break;
		case 0x11: str2uni(strText16, (char*)"Irish"); break;
		case 0x12: str2uni(strText16, (char*)"Gaelic"); break;
		case 0x13: str2uni(strText16, (char*)"Galician"); break;
		case 0x14: str2uni(strText16, (char*)"Icelandic"); break;
		case 0x15: str2uni(strText16, (char*)"Italian"); break;
		case 0x16: str2uni(strText16, (char*)"Lappish"); break;
		case 0x17: str2uni(strText16, (char*)"Latin"); break;
		case 0x18: str2uni(strText16, (char*)"Latvian"); break;
		case 0x19: str2uni(strText16, (char*)"Luxembourgian"); break;
		case 0x1A: str2uni(strText16, (char*)"Lithuanian"); break;
		case 0x1B: str2uni(strText16, (char*)"Hungarian"); break;
		case 0x1C: str2uni(strText16, (char*)"Maltese"); break;
		case 0x1D: str2uni(strText16, (char*)"Dutch"); break;
		case 0x1E: str2uni(strText16, (char*)"Norwegian"); break;
		case 0x1F: str2uni(strText16, (char*)"Occitan"); break;
		case 0x20: str2uni(strText16, (char*)"Polish"); break;
		//case 0x21: str2uni(strText16, (char*)"Portuguese"); break;
		case 0x22: str2uni(strText16, (char*)"Romanian"); break;
		case 0x23: str2uni(strText16, (char*)"Romansh"); break;
		case 0x24: str2uni(strText16, (char*)"Serbian"); break;
		case 0x25: str2uni(strText16, (char*)"Slovak"); break;
		case 0x26: str2uni(strText16, (char*)"Slovene"); break;
		case 0x27: str2uni(strText16, (char*)"Finnish"); break;
		case 0x28: str2uni(strText16, (char*)"Swedish"); break;
		case 0x29: str2uni(strText16, (char*)"Turkish"); break;
		case 0x2A: str2uni(strText16, (char*)"Flemish"); break;
		case 0x2B: str2uni(strText16, (char*)"Wallon"); break;
		case 0x45: str2uni(strText16, (char*)"Zulu"); break;
		case 0x46: str2uni(strText16, (char*)"Vietnamese"); break;
		case 0x47: str2uni(strText16, (char*)"Uzbek"); break;
		case 0x48: str2uni(strText16, (char*)"Urdu"); break;
		case 0x49: str2uni(strText16, (char*)"Ukrainian"); break;
		case 0x4A: str2uni(strText16, (char*)"Thai"); break;
		case 0x4B: str2uni(strText16, (char*)"Telugu"); break;
		case 0x4C: str2uni(strText16, (char*)"Tarar"); break;
		case 0x4D: str2uni(strText16, (char*)"Tamil"); break;
		case 0x4E: str2uni(strText16, (char*)"Tadzhik"); break;
		case 0x4F: str2uni(strText16, (char*)"Swahili"); break;
		case 0x50: str2uni(strText16, (char*)"Sranan Tongo"); break;
		case 0x51: str2uni(strText16, (char*)"Somali"); break;
		case 0x52: str2uni(strText16, (char*)"Sinhalese"); break;
		case 0x53: str2uni(strText16, (char*)"Shona"); break;
		case 0x54: str2uni(strText16, (char*)"Serbo-Croat"); break;
		case 0x55: str2uni(strText16, (char*)"Ruthenian"); break;
		case 0x56: str2uni(strText16, (char*)"Russian"); break;
		case 0x57: str2uni(strText16, (char*)"Quechua"); break;
		case 0x58: str2uni(strText16, (char*)"Pustu"); break;
		case 0x59: str2uni(strText16, (char*)"Punjabi"); break;
		case 0x5A: str2uni(strText16, (char*)"Persian"); break;
		case 0x5B: str2uni(strText16, (char*)"Papamiento"); break;
		case 0x5C: str2uni(strText16, (char*)"Oriya"); break;
		case 0x5D: str2uni(strText16, (char*)"Nepali"); break;
		case 0x5E: str2uni(strText16, (char*)"Ndebele"); break;
		case 0x5F: str2uni(strText16, (char*)"Marathi"); break;
		case 0x60: str2uni(strText16, (char*)"Moldavian"); break;
		case 0x61: str2uni(strText16, (char*)"Malaysian"); break;
		case 0x62: str2uni(strText16, (char*)"Malagasay"); break;
		case 0x63: str2uni(strText16, (char*)"Macedonian"); break;
		case 0x64: str2uni(strText16, (char*)"Laotian"); break;
		//case 0x65: str2uni(strText16, (char*)"Korean"); break;
		case 0x66: str2uni(strText16, (char*)"Khmer"); break;
		case 0x67: str2uni(strText16, (char*)"Kazakh"); break;
		case 0x68: str2uni(strText16, (char*)"Kannada"); break;
		//case 0x69: str2uni(strText16, (char*)"Japanese"); break;
		case 0x6A: str2uni(strText16, (char*)"Indonesian"); break;
		case 0x6B: str2uni(strText16, (char*)"Hindi"); break;
		case 0x6C: str2uni(strText16, (char*)"Hebrew"); break;
		case 0x6D: str2uni(strText16, (char*)"Hausa"); break;
		case 0x6E: str2uni(strText16, (char*)"Gurani"); break;
		case 0x6F: str2uni(strText16, (char*)"Gujurati"); break;
		case 0x70: str2uni(strText16, (char*)"Greek"); break;
		case 0x71: str2uni(strText16, (char*)"Georigian"); break;
		case 0x72: str2uni(strText16, (char*)"Fulani"); break;
		case 0x73: str2uni(strText16, (char*)"Dari"); break;
		case 0x74: str2uni(strText16, (char*)"Churash"); break;
		//case 0x75: str2uni(strText16, (char*)"Chinese"); break;
		case 0x76: str2uni(strText16, (char*)"Burmese"); break;
		case 0x77: str2uni(strText16, (char*)"Bulgarian"); break;
		case 0x78: str2uni(strText16, (char*)"Bengali"); break;
		case 0x79: str2uni(strText16, (char*)"Belorussian"); break;
		case 0x7A: str2uni(strText16, (char*)"Bambora"); break;
		case 0x7B: str2uni(strText16, (char*)"Azerbijani"); break;
		case 0x7C: str2uni(strText16, (char*)"Assamese"); break;
		case 0x7D: str2uni(strText16, (char*)"Armenian"); break;
		case 0x7E: str2uni(strText16, (char*)"Arabic"); break;
		case 0x7F: str2uni(strText16, (char*)"Amharic"); break;
	}
	// Ƽ  
	switch (nNumber)
	{
		case 0x65: strcpy16(strText16, pz_Korean[OSD_Lang]); break;// pz_Korean
		case 0x75: strcpy16(strText16, pz_Chinese[OSD_Lang]); break;// pz_Chinese
		case 0x08: strcpy16(strText16, pz_German[OSD_Lang]); break;// pz_German
		case 0x09: strcpy16(strText16, pz_English[OSD_Lang]); break;// pz_English
		case 0x0A: strcpy16(strText16, pz_Spanish[OSD_Lang]); break;// pz_Spanish
		case 0x0F: strcpy16(strText16, pz_French[OSD_Lang]); break;// pz_French
		case 0x21: strcpy16(strText16, pz_Portuguese[OSD_Lang]); break;// pz_Portuguese
		case 0x69: strcpy16(strText16, pz_Japanese[OSD_Lang]); break;// pz_Japanese
	}
	return strText16;
}

static bool DST_IsAlphabetCharacter(char c)
{
	if ('A' <= c && c <= 'Z') return true;
	if ('a' <= c && c <= 'z') return true;
	return false;
}

static char DST_ToLowerCharacter(char c)
{
	if ('A' <= c && c <= 'Z') return c+0x20;
	return c;
}

DS_U8 DST_GetLangCodeFromISO639String(char* code)
{
	if (code == 0) return 0;
	// ڿ Ͽ  ڵ带 ȯѴ.
	if (strcmp(code, "alb")==0) return 0x01;
	if (strcmp(code, "bre")==0) return 0x02;
	if (strcmp(code, "cat")==0) return 0x03;
	if (strcmp(code, "scr")==0) return 0x04;
	if (strcmp(code, "wel")==0) return 0x05;
	if (strcmp(code, "cze")==0) return 0x06;
	if (strcmp(code, "dan")==0) return 0x07;

	if (strcmp(code, "ger")==0) return 0x08;
	if (strcmp(code, "eng")==0) return 0x09;
	if (strcmp(code, "spa")==0 || strcmp(code, "esl")==0) return 0x0A;
	if (strcmp(code, "epo")==0) return 0x0B;
	if (strcmp(code, "est")==0) return 0x0C;
	if (strcmp(code, "baq")==0) return 0x0D;
	if (strcmp(code, "fao")==0) return 0x0E;
	if (strcmp(code, "fre")==0 || strcmp(code, "fra")==0) return 0x0F;

	if (strcmp(code, "fry")==0) return 0x10;
	if (strcmp(code, "gle")==0) return 0x11;
	if (strcmp(code, "gla")==0) return 0x12;
	if (strcmp(code, "glg")==0) return 0x13;
	if (strcmp(code, "ice")==0) return 0x14;
	if (strcmp(code, "ita")==0) return 0x15;
	if (strcmp(code, "lat")==0) return 0x17;

	if (strcmp(code, "lav")==0) return 0x18;
	if (strcmp(code, "lit")==0) return 0x1A;
	if (strcmp(code, "hun")==0) return 0x1B;
	if (strcmp(code, "mlt")==0) return 0x1C;
	if (strcmp(code, "dut")==0) return 0x1D;
	if (strcmp(code, "nor")==0) return 0x1E;
	if (strcmp(code, "oci")==0) return 0x1F;

	if (strcmp(code, "pol")==0) return 0x20;
	if (strcmp(code, "por")==0) return 0x21;
	if (strcmp(code, "rum")==0) return 0x22;
	if (strcmp(code, "scc")==0) return 0x24;
	if (strcmp(code, "slo")==0) return 0x25;
	if (strcmp(code, "fin")==0) return 0x27;

	if (strcmp(code, "swe")==0) return 0x28;
	if (strcmp(code, "tur")==0) return 0x29;

	if (strcmp(code, "zul")==0) return 0x45;
	if (strcmp(code, "vie")==0) return 0x46;
	if (strcmp(code, "uzb")==0) return 0x47;

	if (strcmp(code, "urd")==0) return 0x48;
	if (strcmp(code, "ukr")==0) return 0x49;
	if (strcmp(code, "tha")==0) return 0x4A;
	if (strcmp(code, "tel")==0) return 0x4B;
	if (strcmp(code, "tat")==0) return 0x4C;
	if (strcmp(code, "tam")==0) return 0x4D;
	if (strcmp(code, "swa")==0) return 0x4F;

	if (strcmp(code, "som")==0) return 0x51;
	if (strcmp(code, "sin")==0) return 0x52;
	if (strcmp(code, "sna")==0) return 0x53;
	if (strcmp(code, "rus")==0) return 0x56;
	if (strcmp(code, "que")==0) return 0x57;

	if (strcmp(code, "pus")==0) return 0x58;
	if (strcmp(code, "per")==0) return 0x5A;
	if (strcmp(code, "pap")==0) return 0x5B;
	if (strcmp(code, "ori")==0) return 0x5C;
	if (strcmp(code, "nep")==0) return 0x5D;
	if (strcmp(code, "nde")==0) return 0x5E;
	if (strcmp(code, "mar")==0) return 0x5F;

	if (strcmp(code, "mol")==0) return 0x60;
	if (strcmp(code, "may")==0) return 0x61;
	if (strcmp(code, "mlg")==0) return 0x62;
	if (strcmp(code, "mac")==0) return 0x63;
	if (strcmp(code, "kor")==0) return 0x65;
	if (strcmp(code, "khm")==0) return 0x66;
	if (strcmp(code, "kaz")==0) return 0x67;

	if (strcmp(code, "kan")==0) return 0x68;
	if (strcmp(code, "jpn")==0) return 0x69;
	if (strcmp(code, "ind")==0) return 0x6A;
	if (strcmp(code, "hin")==0) return 0x6B;
	if (strcmp(code, "heb")==0) return 0x6C;
	if (strcmp(code, "hau")==0) return 0x6D;
	if (strcmp(code, "grn")==0) return 0x6E;
	if (strcmp(code, "guj")==0) return 0x6F;

	if (strcmp(code, "gre")==0) return 0x70;
	if (strcmp(code, "geo")==0) return 0x71;
	if (strcmp(code, "chv")==0) return 0x74;
	if (strcmp(code, "chi")==0 || strcmp(code, "zho")==0) return 0x75;
	if (strcmp(code, "bur")==0) return 0x76;
	if (strcmp(code, "bul")==0) return 0x77;

	if (strcmp(code, "ben")==0) return 0x78;
	if (strcmp(code, "bel")==0) return 0x79;
	if (strcmp(code, "bam")==0) return 0x7A;
	if (strcmp(code, "aze")==0) return 0x7B;
	if (strcmp(code, "asm")==0) return 0x7C;
	if (strcmp(code, "arm")==0) return 0x7D;
	if (strcmp(code, "ara")==0) return 0x7E;
	if (strcmp(code, "amh")==0) return 0x7F;

	return 0; // Unknown
}

DS_U8 DST_GetLangCodeFromISO639(DS_U32 iso639)
{
	char code[4] = {0,0,0,0};
	code[0] = (iso639 >> 16) & 0xFF;
	code[1] = (iso639 >> 8) & 0xFF;
	code[2] = (iso639 >> 0) & 0xFF;
	//   ĺ Ȯ
	if (DST_IsAlphabetCharacter(code[0]) == false) return 0;
	if (DST_IsAlphabetCharacter(code[1]) == false) return 0;
	if (DST_IsAlphabetCharacter(code[2]) == false) return 0;
	// ҹڷ ȭ
	code[0] = DST_ToLowerCharacter(code[0]);
	code[1] = DST_ToLowerCharacter(code[1]);
	code[2] = DST_ToLowerCharacter(code[2]);
	
	return DST_GetLangCodeFromISO639String(code);
}

#if 0
____String_APIs___()
#endif

void strcpy16(DS_U16* des, DS_U16* src)
{
	unsigned i;
	for ( i = 0; i < 4096; i++)
	{
		des[i] = src[i];
		if (des[i] == 0) break;
	}
}

int strcmp16(DS_U16* des, DS_U16* src)
{
	int len_des = strlen16(des);
	int len_src = strlen16(src);
	if (len_des !=  len_src) return -1;
	return memcmp(des, src, len_des);
}

void strcpy32(DS_U32* des, DS_U32* src)
{
	unsigned i;
	for ( i = 0; i < 4096; i++)
	{
		des[i] = src[i];
		if (des[i] == 0) break;
	}
}

unsigned strlen16(DS_U16 *str)
{
	if (str == 0) return 0;
	unsigned i;
	for ( i = 0; i < 4096; i++) if (str[i] == 0) return i;
	return 0;
}

unsigned strlen32(DS_U32 *str)
{
	if (str == 0) return 0;
	unsigned i;
	for ( i = 0; i < 4096; i++) if (str[i] == 0) return i;
	return 0;
}

void str2uni(DS_U16* des, char* src)
{
	unsigned nLen = strlen(src);
	unsigned i;
	for ( i = 0; i < nLen; i++) des[i] = (DS_U16)(DS_U8)src[i];
	des[nLen] = 0;
}

void str232(DS_U32* des, char* src)
{
	unsigned nLen = strlen(src);
	unsigned i;
	for ( i = 0; i < nLen; i++) des[i] = (DS_U32)(DS_U8)src[i];
	des[nLen] = 0;
}

void uni232(DS_U32* des, DS_U16* src)
{
	unsigned nLen = strlen16(src);
	unsigned i;
	for ( i = 0; i < nLen; i++) des[i] = (DS_U32)src[i];
	des[nLen] = 0;
}

void strcat16(DS_U16* des, DS_U16* src)
{
	unsigned desLen = strlen16(des);
	unsigned srcLen = strlen16(src);
	
	unsigned i;
	for ( i = 0 ; i < srcLen ; i++)
	{
		des[desLen + i] = src[i];
		if (des[desLen + i] == 0) break;
	}
	des[desLen + srcLen] = 0;
}

void strcat16_8(DS_U16* des, char* src)
{
	unsigned desLen = strlen16(des);
	unsigned srcLen = strlen(src);

	unsigned i;
	for ( i = 0 ; i < srcLen ; i++)
	{
		des[desLen + i] = (DS_U16)(DS_U8)src[i];
		if (des[desLen + i] == 0) break;
	}
	des[desLen + srcLen] = 0;
}

#if 0
____Reset_APIs___()
#endif

/*extern "C" */void DHL_SYS_Reset();
void DST_Reset(const char * function)
{
	DST_Printf("%s|%d by %s \n",__func__, __LINE__,function);
//	DST_FlashSyncStart();
	DST_DB_Sync();
	int i;
	for ( i = 0; i < 500; i++)
	{
		DST_OS_Delay(50);
		T();
		if (DST_DB_IsSync() == false) continue;
		break;
	}
 	DHL_SYS_Reboot();
}

#if 0
____Item_Scroll_APIs____()
#endif
DS_U8 DST_IncreaseValue(DS_U16 min, DS_U16 max, DS_U16 *value, DS_U16 step/*=1*/)
{
    if ((max-min+1) <= step)        return *value;

    if((*value+step)>max)
    {
             *value = *value+step-(max-min+1);
    }
    else
    {
            *value = *value + step;
    }
    return *value;
}
	
DS_U8 DST_DecreaseValue(DS_U16 min, DS_U16 max, DS_U16 *value, DS_U16 step/*=1*/)
{
    if ((max-min+1) <= step)        return *value;

    if((*value-step)<min)
    {
             *value = *value-step+(max-min+1);
    }
    else
    {
            *value = *value - step;
    }
    return *value;
}


void InitItemValues(DS_U16 listNum, DS_U16 select, DS_U16 *start, DS_U16 *cursor)
{
    *start = 0;
    if (select >= listNum)  *start  = select-listNum+1;
    *cursor = select-*start;
}

void ItemDecrease(DS_U16 itemNum, DS_U16 listNum, DS_U16 *start, DS_U16 *select, DS_U16 *cursor, DS_U16 step)
{
	int i;
	for( i=0;i<step;i++)
	{
	    if (*cursor == 0)
			DST_DecreaseValue(0, itemNum-listNum, start, 1);
	    DST_DecreaseValue(0, itemNum-1, select, 1);
	    *cursor = *select - *start;		
	}
}

void ItemIncrease(DS_U16 itemNum, DS_U16 listNum, DS_U16 *start, DS_U16 *select, DS_U16 *cursor, DS_U16 step)
{
	int i;
	for( i=0;i<step;i++)
	{
	    if (*cursor >= listNum-1)
			DST_IncreaseValue(0, itemNum-listNum, start, 1);
	    DST_IncreaseValue(0, itemNum-1, select, 1);
	    *cursor = *select - *start;		
	}
}

//static DS_U32 l_pdwCrc32Table[256] = 
//{
//	0x00000000, 0x77073096, 0xEE0E612C, 0x990951BA,
//	0x076DC419, 0x706AF48F, 0xE963A535, 0x9E6495A3,
//	0x0EDB8832, 0x79DCB8A4, 0xE0D5E91E, 0x97D2D988,
//	0x09B64C2B, 0x7EB17CBD, 0xE7B82D07, 0x90BF1D91,
//	0x1DB71064, 0x6AB020F2, 0xF3B97148, 0x84BE41DE,
//	0x1ADAD47D, 0x6DDDE4EB, 0xF4D4B551, 0x83D385C7,
//	0x136C9856, 0x646BA8C0, 0xFD62F97A, 0x8A65C9EC,
//	0x14015C4F, 0x63066CD9, 0xFA0F3D63, 0x8D080DF5,
//	0x3B6E20C8, 0x4C69105E, 0xD56041E4, 0xA2677172,
//	0x3C03E4D1, 0x4B04D447, 0xD20D85FD, 0xA50AB56B,
//	0x35B5A8FA, 0x42B2986C, 0xDBBBC9D6, 0xACBCF940,
//	0x32D86CE3, 0x45DF5C75, 0xDCD60DCF, 0xABD13D59,
//	0x26D930AC, 0x51DE003A, 0xC8D75180, 0xBFD06116,
//	0x21B4F4B5, 0x56B3C423, 0xCFBA9599, 0xB8BDA50F,
//	0x2802B89E, 0x5F058808, 0xC60CD9B2, 0xB10BE924,
//	0x2F6F7C87, 0x58684C11, 0xC1611DAB, 0xB6662D3D,
//
//	0x76DC4190, 0x01DB7106, 0x98D220BC, 0xEFD5102A,
//	0x71B18589, 0x06B6B51F, 0x9FBFE4A5, 0xE8B8D433,
//	0x7807C9A2, 0x0F00F934, 0x9609A88E, 0xE10E9818,
//	0x7F6A0DBB, 0x086D3D2D, 0x91646C97, 0xE6635C01,
//	0x6B6B51F4, 0x1C6C6162, 0x856530D8, 0xF262004E,
//	0x6C0695ED, 0x1B01A57B, 0x8208F4C1, 0xF50FC457,
//	0x65B0D9C6, 0x12B7E950, 0x8BBEB8EA, 0xFCB9887C,
//	0x62DD1DDF, 0x15DA2D49, 0x8CD37CF3, 0xFBD44C65,
//	0x4DB26158, 0x3AB551CE, 0xA3BC0074, 0xD4BB30E2,
//	0x4ADFA541, 0x3DD895D7, 0xA4D1C46D, 0xD3D6F4FB,
//	0x4369E96A, 0x346ED9FC, 0xAD678846, 0xDA60B8D0,
//	0x44042D73, 0x33031DE5, 0xAA0A4C5F, 0xDD0D7CC9,
//	0x5005713C, 0x270241AA, 0xBE0B1010, 0xC90C2086,
//	0x5768B525, 0x206F85B3, 0xB966D409, 0xCE61E49F,
//	0x5EDEF90E, 0x29D9C998, 0xB0D09822, 0xC7D7A8B4,
//	0x59B33D17, 0x2EB40D81, 0xB7BD5C3B, 0xC0BA6CAD,
//
//	0xEDB88320, 0x9ABFB3B6, 0x03B6E20C, 0x74B1D29A,
//	0xEAD54739, 0x9DD277AF, 0x04DB2615, 0x73DC1683,
//	0xE3630B12, 0x94643B84, 0x0D6D6A3E, 0x7A6A5AA8,
//	0xE40ECF0B, 0x9309FF9D, 0x0A00AE27, 0x7D079EB1,
//	0xF00F9344, 0x8708A3D2, 0x1E01F268, 0x6906C2FE,
//	0xF762575D, 0x806567CB, 0x196C3671, 0x6E6B06E7,
//	0xFED41B76, 0x89D32BE0, 0x10DA7A5A, 0x67DD4ACC,
//	0xF9B9DF6F, 0x8EBEEFF9, 0x17B7BE43, 0x60B08ED5,
//	0xD6D6A3E8, 0xA1D1937E, 0x38D8C2C4, 0x4FDFF252,
//	0xD1BB67F1, 0xA6BC5767, 0x3FB506DD, 0x48B2364B,
//	0xD80D2BDA, 0xAF0A1B4C, 0x36034AF6, 0x41047A60,
//	0xDF60EFC3, 0xA867DF55, 0x316E8EEF, 0x4669BE79,
//	0xCB61B38C, 0xBC66831A, 0x256FD2A0, 0x5268E236,
//	0xCC0C7795, 0xBB0B4703, 0x220216B9, 0x5505262F,
//	0xC5BA3BBE, 0xB2BD0B28, 0x2BB45A92, 0x5CB36A04,
//	0xC2D7FFA7, 0xB5D0CF31, 0x2CD99E8B, 0x5BDEAE1D,
//
//	0x9B64C2B0, 0xEC63F226, 0x756AA39C, 0x026D930A,
//	0x9C0906A9, 0xEB0E363F, 0x72076785, 0x05005713,
//	0x95BF4A82, 0xE2B87A14, 0x7BB12BAE, 0x0CB61B38,
//	0x92D28E9B, 0xE5D5BE0D, 0x7CDCEFB7, 0x0BDBDF21,
//	0x86D3D2D4, 0xF1D4E242, 0x68DDB3F8, 0x1FDA836E,
//	0x81BE16CD, 0xF6B9265B, 0x6FB077E1, 0x18B74777,
//	0x88085AE6, 0xFF0F6A70, 0x66063BCA, 0x11010B5C,
//	0x8F659EFF, 0xF862AE69, 0x616BFFD3, 0x166CCF45,
//	0xA00AE278, 0xD70DD2EE, 0x4E048354, 0x3903B3C2,
//	0xA7672661, 0xD06016F7, 0x4969474D, 0x3E6E77DB,
//	0xAED16A4A, 0xD9D65ADC, 0x40DF0B66, 0x37D83BF0,
//	0xA9BCAE53, 0xDEBB9EC5, 0x47B2CF7F, 0x30B5FFE9,
//	0xBDBDF21C, 0xCABAC28A, 0x53B39330, 0x24B4A3A6,
//	0xBAD03605, 0xCDD70693, 0x54DE5729, 0x23D967BF,
//	0xB3667A2E, 0xC4614AB8, 0x5D681B02, 0x2A6F2B94,
//	0xB40BBE37, 0xC30C8EA1, 0x5A05DF1B, 0x2D02EF8D,
//};
//
//DS_U32 DST_crc32 (DS_U8 *data, int len)
//{
//	int i;
//	DS_U32 crc = 0xffffffff;
//
//	for (i=0; i<len; i++)
//		crc  = ((crc) >> 8) ^ l_pdwCrc32Table[(*data++) ^ ((crc) & 0x000000FF)];
//
//	crc = ~crc;
//
//	return crc;
//}
