#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_SignalMonitor.h"
#include "DST_ChannelTune.h"
#include "DST_GlobalVariables.h"
#include "DST_DataStrings.h"
#include "DST_DB.h"
#include "DST_ISDBT_ChannelTask.h"
#include "DST_DB_Engine.h"
#include "DST_MemoryDB.h"

OSD_PIXEL_T DST_GetAribColor(DS_U8 n);
DS_U32* DST_UTF82Uni(DS_U8 *utf);

#if 0
____CInfobannerWin___()
#endif

//class CInfobannerWin : public CWindow
//{
// public:
//	CInfobannerWin(SWinEventMsg event):CWindow(event)
	void CInfobannerWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "Infobanner");
		this->rect.w = DST_GetImageWidth(newcon2_gui_infobanner_back);
		this->rect.h = DST_GetImageHeight(newcon2_gui_infobanner_back);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = DST_GetScreenHeight() / 20;
		this->SetTimeOut(this, 100);
	}

	void CInfobannerWin_Destructor(CWindow *tis)
	{
		
	}

//	virtual void Show(WinID id)
	void CInfobannerWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_ENGINEER_MODE:
			case WIN_FREQUENCY_SETTING:		
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
//			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
				this->Close(this);
				break;
			default:
				break;
		}
	}

	void CInfobannerWin_DrawProgram(CWindow *this, int RF, DS_U16 source_id)
	{
#if EPG_SUPPORT
		DS_U16 time[110] = {0,};
		
		if (source_id == 0) return;
		
//		CDB db; NewCDB(&db);
		//   α׷ ã´. ̹   ϰ  ۽ð ɷ ϳ 
//		db.GetTable(&db, "select start_time, length_in_seconds, title from eit_sub "
//				"where rf = %d and source_id = %d "
//				"and start_time+length_in_seconds >  %d "
//				"order by start_time limit 1", RF, source_id, DST_GetCurrentUTCTime());
		int i;
		int nPos = -1;
		DS_U32 min_start_time = 0xFFFFFFFF;		
		for (i=0; i < DB_EIT_SUB_MAX; i++)
		{
			if (db_eit_sub[i].source_id == 0) continue;
			if (db_eit_sub[i].rf != RF) continue;
			if (db_eit_sub[i].source_id != source_id) continue;
			//DST_Printf("db_eit_sub[%d].rf = %d source_id = %d\n", i, db_eit_sub[i].rf, db_eit_sub[i].source_id);
			if (db_eit_sub[i].start_time + db_eit_sub[i].length_in_seconds <= DST_GetCurrentUTCTime()) continue;
			if (db_eit_sub[i].start_time < min_start_time)
			{
				min_start_time = db_eit_sub[i].start_time;
				nPos = i;
			}
		}		
		if(nPos < 0) 
		{
			return;
		}
			
		this->setFontStyle(this, 20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);
		this->DrawTextUTF8(this, 12, 35, 540, 20, db_eit_sub[nPos].title, &(this->font));

		strcpy16(time, DST_GetTimeString(db_eit_sub[nPos].start_time, DATE_NO_YEAR_TIME_NO_SEC_DETAIL,true,DST_g_TimeOffset[RF]));
		strcat16_8(time, (char *)" - ");
		strcat16(time, DST_GetTimeString(db_eit_sub[nPos].start_time+ db_eit_sub[nPos].length_in_seconds,TIME_NO_SEC,true,DST_g_TimeOffset[RF]));
		this->DrawTextUni(this, 12, 65, 540, 20 , time, &(this->font)); 	
//		DeleteCDB(&db);
#endif
  	}

	void CInfobannerWin_DrawTime(CWindow *this, int RF)
	{
		DS_U32 curTime = DST_GetCurrentUTCTime();
		// ð ǥ
		this->setFontStyle(this, 20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_RIGHT);
		// DST_Printf("curTime = %d\n", curTime);
		if (curTime > 0)
		{
			DS_U16 time[50] = {0,};
			strcpy16(time, DST_GetTimeString(curTime,DATE_NO_YEAR_TIME_NO_SEC_DETAIL,true,DST_g_TimeOffset[RF]));
			this->DrawTextUni(this, 12, 5, 540, 20, time, &(this->font));
		}
	}
	
	void CInfobannerWin_DrawChannel(CWindow *this)
	{
		// ä ̸ ǥ			
		DS_U32 ChInfo[100]={0};
		DST_UI_GetCurrentChannelInfo(ChInfo);
		this->setFontStyle(this, 20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);
		this->DrawText32(this, 12, 5, 298, 20, ChInfo,  &(this->font));
	}

	void CInfobannerWin_DrawResolution(CWindow *this)
	{
		DS_U8 *image = newcon2_gui_infobanner_hdtv_disable;
		switch (DST_GetResolutionInfo())
		{
			case  1: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_disable : newcon2_gui_infobanner_hdtv_disable; break;
			case  2: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_disable : newcon2_gui_infobanner_hdtv_disable; break;
			case  3: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_disable : newcon2_gui_infobanner_hdtv_disable; break;
			case  4: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_disable : newcon2_gui_infobanner_hdtv_disable; break;
			case  5: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_disable : newcon2_gui_infobanner_hdtv_disable; break;
			case  6: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_disable : newcon2_gui_infobanner_hdtv_disable; break;
			case  7: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_disable : newcon2_gui_infobanner_hdtv_disable; break;
			case  8: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_enable : newcon2_gui_infobanner_hdtv_disable; break;
			case  9: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_enable : newcon2_gui_infobanner_hdtv_disable; break;
			case 10: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_enable : newcon2_gui_infobanner_hdtv_disable; break;
		}
		this->DrawImage(this, 12, 128, image, false);
	}
	
	void CInfobannerWin_DrawIcon(CWindow *this, DS_U8 RF, DS_U16 program_number)
	{
		DS_U8* image  = newcon2_gui_infobanner_stereo_disable;
		
		CInfobannerWin_DrawResolution(this);
		this->DrawImage(this, 163, 128, DST_UI_GetCCInfo() ? newcon2_gui_infobanner_cc_enable:newcon2_gui_infobanner_cc_disable, false);

		this->DrawImage(this, 118, 128, (CT_GetAudioCount(RF, program_number) > 1) ? newcon2_gui_infobanner_multi_enable : newcon2_gui_infobanner_multi_disable, false);
		switch (DST_AUD_GetMode())
		{
			case DHL_AUDIO_MONO: image = newcon2_gui_infobanner_stereo_disable; break;// Mono
			case DHL_AUDIO_DUAL_MONO: image = newcon2_gui_infobanner_stereo_enable; break; // Dual Mono
			case DHL_AUDIO_STEREO:	image = newcon2_gui_infobanner_stereo_enable; break;// Stereo
			case DHL_AUDIO_5_1: image = newcon2_gui_infobanner_stereo_disable; break;// 5.1
			default: break;
		}
		this->DrawImage(this, 73, 128, image, false);
	}
	
	void CInfobannerWin_DrawSignalBar(CWindow *this)
	{
		int xPos 	= 358;
		int yPos 	= 133;
		int width   = 183;
		int range	= 100;
		int signal	= DST_GetSignalStrength();

		int division =	width/3;
		int position = (width*signal)/(range);

		int i = 0;
		//signal meter
		for ( i=xPos; i < xPos+position; i++)
		{
			if ((i-xPos) <= division)
				this->DrawImage(this, i, yPos, newcon2_gui_progress_red, false);
			else if ((i-xPos) <= (division*2))
				this->DrawImage(this, i, yPos, newcon2_gui_progress_yellow, false);
			else
				this->DrawImage(this, i, yPos, newcon2_gui_progress_green, false);
		}
	}


//  virtual void Show(void)
	void CInfobannerWin_Show(CWindow *this)
	{	
		DS_U8 RF = 0;
		DS_U16 source_id = 0;
		
		this->DrawImage(this, 0, 0, newcon2_gui_infobanner_back, false);
		DST_GetAVState(&RF, 0, &source_id);
		
		CInfobannerWin_DrawChannel(this);
		CInfobannerWin_DrawTime(this, RF);
		CInfobannerWin_DrawProgram(this, RF, source_id);
		CInfobannerWin_DrawSignalBar(this);
		CInfobannerWin_DrawIcon(this, RF, source_id);
		
		this->SetTimer(this, 1, 500); // 500ms  
		this->RegisterKey(this, VK_OK, true, 0, 0);
		this->RegisterKey(this, VK_CANCEL, true, 0, 0);
	}

//	virtual void OnMessage(SWinEventMsg event)
	void CInfobannerWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				this->Close(this);
				break;
			case WM_CT_MSG: // Ʃ  ޽  
				if (event.data32[0] == CT_TUNE_START) this->Show(this);
				this->SetTimeOut(this, 100);
				break;
		}
	}
	
//	virtual void OnTimer(char /*nID*/)
	void CInfobannerWin_OnTimer(CWindow *this, char nID)
	{
		this->Show(this);
	}


//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CInfobannerWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_OK:
			case VK_CANCEL:
			  this->Close(this);
			  break;
		}
	}
//};

void DST_CreateInforbannerWindow(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor	= CInfobannerWin_Destructor;
	pWin->KeyInput		= CInfobannerWin_KeyInput;
	pWin->OnMessage 	= CInfobannerWin_OnMessage;
	pWin->OnTimer		= CInfobannerWin_OnTimer;
	pWin->ShowWindow	= CInfobannerWin_ShowWindow;
	pWin->Show			= CInfobannerWin_Show;
	//  ȣ
	CInfobannerWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}
