#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_CommonAPI.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"
#include "DST_SignalMonitor.h"

#if 0
____CVolumeWin___()
#endif


//class CSignalMeterWin : public CWindow
//{
//public:
//	CSignalMeterWin(SWinEventMsg event):CWindow(event)
	void CSignalMeterWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "SignalMeter");
		this->rect.w = DST_GetImageWidth(pin_change_back);
		this->rect.h = DST_GetImageHeight(pin_change_back);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight() - this->rect.h) / 2;

		this->SetTimeOut(this, 0);
	}

	void CSignalMeterWin_Destructor(CWindow *this)
	{
	}
	
//	virtual void Show(WinID id)
	void CSignalMeterWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_ENGINEER_MODE:
			case WIN_FREQUENCY_SETTING:		
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
				this->Close(this);
				break;
			default:
				break;
		}
	}

//	virtual void OnMessage(SWinEventMsg event)
	void CSignalMeterWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				this->Close(this);
				break;
			default: break;
		}
	}

	void CSignalMeterWin_DrawSignalBar(CWindow *this)
	{
		int xPos 	= 53;
		int yPos 	= 168;
		int width   = 273;
		int range	= 100;
		int division =	width/3;
		int signal	= DST_GetSignalStrength();
		int position = (width*signal)/(range);
		int i = 0;
		
		this->DrawImage(this, xPos-1, yPos-1, Strength_prog_back, false);
		//signal meter
		for ( i=xPos; i < xPos+position; i++)
		{
			if ((i-xPos) <= division)
				this->DrawImage(this, i, yPos, signal_prog_r, false);
			else if ((i-xPos) <= (division*2))
				this->DrawImage(this, i, yPos, signal_prog_y, false);
			else
				this->DrawImage(this, i, yPos, signal_prog_g, false);
		}
		if(signal == 100)
			this->DrawImage(this, xPos+position, yPos, signal_prog_g, false);

	}
	
	void CSignalMeterWin_Draw(CWindow *this)
	{
		this->RegisterKey(this, VK_CANCEL, true, 0, 0);
		this->RegisterKey(this, VK_OK, true, 0, 0);
		this->RegisterKey(this, VK_MENU, true, 0, 0);
		this->RegisterKey(this, VK_PREV, true, 0, 0);
		this->RegisterKey(this, VK_PREV_CH, true, 0, 0);
		this->RegisterKey(this, VK_PREV_MENU, true, 0, 0);
		this->DrawImage(this, 0, 0, pin_change_back, false);

		
		this->DrawImage(this, 44, 39, icon_signal, false);
		this->setFontStyle(this, 20, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_LEFT);
		this->DrawTextUni(this, 133 , 49, 212, 24, pz_Sub_SignalMeter_E1[OSD_Lang], &(this->font));
		this->DrawTextUni(this, 133 , 49+38, 212, 24, pz_Sub_SignalMeter_E2[OSD_Lang], &(this->font));

		this->setFontStyle(this, 20, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_CENTER);

		//signal text
		char tmp[5]={0};
		int signal	= DST_GetSignalStrength();
		sprintf(tmp, "%d", signal);
		this->DrawText(this,0, 129, this->rect.w, 24, tmp, &(this->font));


		this->DrawTextUni(this, 52 , 189, 67, 24, pz_Weak[OSD_Lang], &(this->font));
		this->DrawTextUni(this, 262 , 189, 67, 24, pz_Good[OSD_Lang], &(this->font));
		
		CSignalMeterWin_DrawSignalBar(this);
		this->SetTimer(this,1,500);
	}	

//	virtual void Show()
	void CSignalMeterWin_Show(CWindow *this)
	{
		CSignalMeterWin_Draw(this);
	}

//	virtual void OnTimer(char nID)
	void CSignalMeterWin_OnTimer(CWindow *this, char nID)
	{
		switch(nID)
		{
			case 1:
				this->KillTimer(this, 1);
				CSignalMeterWin_Draw(this);
				break;
			default:
				break;
		}
	}

//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CSignalMeterWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_MENU:
			case VK_CANCEL:
			case VK_PREV_MENU:
			case VK_OK:
			case VK_PREV:
			case VK_PREV_CH:				
				this->Close(this);
				if(DST_UI_GetMute() && DST_GetWin(WIN_VOLUME_MUTE)==0) DST_CreateWin(WIN_VOLUME_MUTE, 0, 0, 0, 0, 0);
				break;

			default:
				break;

		}
	}


//};

void DST_CreateSignalMeterWindow(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor 	= CSignalMeterWin_Destructor;
	pWin->KeyInput 		= CSignalMeterWin_KeyInput;
	pWin->OnTimer		= CSignalMeterWin_OnTimer;
	pWin->OnMessage		= CSignalMeterWin_OnMessage;
	pWin->ShowWindow 	= CSignalMeterWin_ShowWindow;
	pWin->Show 			= CSignalMeterWin_Show;
	//  ȣ
	CSignalMeterWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}



