#ifndef __DST_EEPROM_H__
#define __DST_EEPROM_H__

#include "DST_GlobalVariables.h"
//#include "DST_WinMenu.h"

#if 0
____ReadWrite_EEPROM___()
#endif

void DST_EEPROM_FactoryInit(void);

void DST_EEPROM_SetConfig(const char * name, int value);
int DST_EEPROM_GetConfig(const char *name);

#define DST_EEPROM_SetNeedReset(value) DST_EEPROM_SetConfig("NeedReset", value)
#define DST_EEPROM_GetNeedReset() DST_EEPROM_GetConfig("NeedReset")

#define DST_EEPROM_SetFirst(value) DST_EEPROM_SetConfig("First", value)
#define DST_EEPROM_GetFirst() DST_EEPROM_GetConfig("First")

#define DST_EEPROM_SetTuneMode(value) DST_EEPROM_SetConfig("TuneMode", value)
#define DST_EEPROM_GetTuneMode() DST_EEPROM_GetConfig("TuneMode")

#define DST_EEPROM_SetVolume(value) DST_EEPROM_SetConfig("Volume", value)
#define DST_EEPROM_GetVolume() DST_EEPROM_GetConfig("Volume")

#define DST_EEPROM_SetCC(value) DST_EEPROM_SetConfig("CC", value)
#define DST_EEPROM_GetCC() DST_EEPROM_GetConfig("CC")

#define DST_EEPROM_SetRF(value) DST_EEPROM_SetConfig("RF", value)
#define DST_EEPROM_GetRF() DST_EEPROM_GetConfig("RF")

#define DST_EEPROM_SetProgramNumber(value) DST_EEPROM_SetConfig("program_number", value)
#define DST_EEPROM_GetProgramNumber() DST_EEPROM_GetConfig("program_number")

void DST_EEPROM_SetAspect(bool bSource4x3,  int nVal) ;
int DST_EEPROM_GetAspect(bool bSource4x3);


#define DST_EEPROM_SetAudioPref(value) DST_EEPROM_SetConfig("AudioPref",value) 
#define DST_EEPROM_GetAudioPref() DST_EEPROM_GetConfig("AudioPref")

#define DST_EEPROM_SetVI(value) DST_EEPROM_SetConfig("VI",value) 
#define DST_EEPROM_GetVI() DST_EEPROM_GetConfig("VI")

#define DST_EEPROM_SetPreferredConn(value) DST_EEPROM_SetConfig("PreferredConn",value) 
#define DST_EEPROM_GetPreferredConn() DST_EEPROM_GetConfig("PreferredConn")

void DST_EEPROM_SetPassword(DS_U8* nVal);

void DST_SetSleepTimer(DS_U8 value);

DS_U8 DST_GetSleepTimer();

#define DST_EEPROM_SetFrequncySetting(value) DST_EEPROM_SetConfig("FrequencySetting",value) 
#define DST_EEPROM_GetFrequencySetting() DST_EEPROM_GetConfig("FrequencySetting")
#define DST_EEPROM_SetMinRF(value) DST_EEPROM_SetConfig("MinRF",value) 
#define DST_EEPROM_GetMinRF() DST_EEPROM_GetConfig("MinRF")
#define DST_EEPROM_SetMaxRF(value) DST_EEPROM_SetConfig("MaxRF",value) 
#define DST_EEPROM_GetMaxRF() DST_EEPROM_GetConfig("MaxRF")

#endif// __DST_EEPROM_H__

	
