#include "DST_Window.h"
#include "DST_WinManager.h"
#include "DST_CommonAPI.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"
#include "DST_ISDBT_ChannelTask.h"
#include "DST_DB.h"
#include "DST_ChannelTune.h"
#include "DST_SignalMonitor.h"

#ifndef DSTAR
#include "DHL_OSAL.h"
#include "DHL_OSAL_Priv.h"
#include "bcmmemmgr.h"
#endif

extern DS_U8 newcon2_gui_banner_4line_back[];

#if 0
____CFrequncySettingWin___()
#endif

static int nPos = 0;

//class CFrequncySettingWin : public CWindow
//{
//private:
//	
//public:
//	CFrequncySettingWin(SWinEventMsg event):CWindow(event)
	void CFrequncySettingWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "FrequencySetting");
		this->setFontStyle(this, 22, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_LEFT);
		this->rect.w = DST_GetImageWidth(newcon2_gui_banner_4line_back);
		this->rect.h = DST_GetImageHeight(newcon2_gui_banner_4line_back);;
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight() - this->rect.h) / 2;

		this->SetTimeOut(this, 0);
	}

	void CFrequncySettingWin_Destructor(CWindow *this)
	{
	}
	
//	virtual void OnTimer(char nID)
	void CFrequncySettingWin_OnTimer(CWindow *this, char nID)
	{
	}

//	virtual void Show(WinID id)
	void CFrequncySettingWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			case WIN_ENGINEER_MODE:
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_MAIN_MENU:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
			case WIN_PASSWD_CHANGE:
			case WIN_PASSWD_CHECK:
			case WIN_PASSWD_CONFIRM:
			case WIN_AGE_RATING:
				this->Close(this);
				break;
			default:
				break;
		}
	}

//	virtual void Show()
	void CFrequncySettingWin_Show(CWindow *this)
	{
		this->RegisterAllKey(this);
				this->RegisterKey(this, VK_PWR, false, 0, 0);
		// background
		this->DrawImage(this, 0, 0, newcon2_gui_banner_4line_back, false);
	
		char strText[256];
		
		int nLineHeight = (this->rect.h) / 7;
		// title
		this->setFontStyle(this, 18, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_CENTER);
		this->DrawText(this, 0, 0, this->rect.w, nLineHeight*2, (char*)"Frequency Setting", &(this->font));
		int isOn = DST_EEPROM_GetFrequencySetting();
		sprintf(strText, "< %s >", isOn == 1?(char*)"ON":(char*)"OFF");
		switch(nPos)
		{
			case 0:
				this->setFontStyle(this, 17, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_CENTER);
				break;
			case 1:
				this->setFontStyle(this, 15, 0xFFAAAAAA, ALIGN_MIDDLE, ALIGN_CENTER);
				break;
			case 2:
				this->setFontStyle(this, 15, 0xFFAAAAAA, ALIGN_MIDDLE, ALIGN_CENTER);
				break;
			default:break;
		}
		this->DrawText(this, 0, nLineHeight * 2, this->rect.w, nLineHeight, (char*)strText, &(this->font));
		// display max
		switch(nPos)
		{
			case 0:
				this->setFontStyle(this, 15, 0xFFAAAAAA, ALIGN_MIDDLE, ALIGN_CENTER);
				if(isOn == 0) this->setFontStyle(this, 15, 0xFF666666, ALIGN_MIDDLE, ALIGN_CENTER);
				break;
			case 1:
				this->setFontStyle(this, 17, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_CENTER);
				if(isOn == 0) this->setFontStyle(this, 15, 0xFF666666, ALIGN_MIDDLE, ALIGN_CENTER);
				break;
			case 2:
				this->setFontStyle(this, 15, 0xFFAAAAAA, ALIGN_MIDDLE, ALIGN_CENTER);
				if(isOn == 0) this->setFontStyle(this, 15, 0xFF666666, ALIGN_MIDDLE, ALIGN_CENTER);
				break;
			default:break;
		}

		int num = DST_EEPROM_GetMinRF();
		
			int rf = DST_GetFrequencyNumberbyIndex(num);
			int freq = DST_GetMHzFrequencybyIndex(num);
			sprintf(strText, "< Min : %d ( %dMHz ) >", rf, freq);

		this->DrawText(this, 0, nLineHeight * 3, this->rect.w, nLineHeight, (char*)strText, &(this->font));
		// display min
		switch(nPos)
		{
			case 0:
				this->setFontStyle(this, 15, 0xFFAAAAAA, ALIGN_MIDDLE, ALIGN_CENTER);
				if(isOn == 0) this->setFontStyle(this, 15, 0xFF666666, ALIGN_MIDDLE, ALIGN_CENTER);
				break;
			case 1:
				this->setFontStyle(this, 15, 0xFFAAAAAA, ALIGN_MIDDLE, ALIGN_CENTER);
				if(isOn == 0) this->setFontStyle(this, 15, 0xFF666666, ALIGN_MIDDLE, ALIGN_CENTER);
				break;
			case 2:
				this->setFontStyle(this, 17, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_CENTER);
				if(isOn == 0) this->setFontStyle(this, 15, 0xFF666666, ALIGN_MIDDLE, ALIGN_CENTER);
				break;
			default:break;
		}

		num = DST_EEPROM_GetMaxRF();

		rf = DST_GetFrequencyNumberbyIndex(num);
		freq = DST_GetMHzFrequencybyIndex(num);
		sprintf(strText, "< Max : %d ( %dMHz ) >", rf, freq);


		this->DrawText(this, 0, nLineHeight * 4, this->rect.w, nLineHeight, (char*)strText, &(this->font));
		// descriptor
		this->setFontStyle(this, 15, 0xFF666666, ALIGN_MIDDLE, ALIGN_CENTER);
		this->DrawText(this, 0, nLineHeight * 6, this->rect.w, nLineHeight, (char*)"Channel/Volume : Next", &(this->font));
	}


//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void IncreaseMaxRF()
	{
		if (DST_EEPROM_GetMaxRF() >= DST_MaxRF()) 
		{
			DST_EEPROM_SetMaxRF(DST_MaxRF());
			return;
		}
		else if (DST_EEPROM_GetMinRF() > DST_EEPROM_GetMaxRF())
		{
			DST_EEPROM_SetMaxRF(DST_EEPROM_GetMinRF());
			return;
		}
		DST_EEPROM_SetMaxRF(DST_EEPROM_GetMaxRF() + 1);
	}
	void DecreaseMinRF()
	{
		if (DST_EEPROM_GetMinRF() <= DST_MinRF()) 
		{
			DST_EEPROM_SetMinRF(DST_MinRF());
			return;
		}
		else if (DST_EEPROM_GetMinRF() > DST_EEPROM_GetMaxRF())
		{
			DST_EEPROM_SetMinRF(DST_EEPROM_GetMaxRF());
			return;
		}
		DST_EEPROM_SetMinRF(DST_EEPROM_GetMinRF() - 1);
	}
	void IncreaseMinRF()
	{
		if (DST_EEPROM_GetMinRF() >= DST_MaxRF()) 
		{
			DST_EEPROM_SetMinRF(DST_MaxRF());
			return;
		}
		else if (DST_EEPROM_GetMinRF() >= DST_EEPROM_GetMaxRF())
		{
			DST_EEPROM_SetMinRF(DST_EEPROM_GetMaxRF());
			return;
		}

		DST_EEPROM_SetMinRF(DST_EEPROM_GetMinRF() + 1);
	}
	void DecreaseMaxRF()
	{
		if (DST_EEPROM_GetMaxRF() <= DST_MinRF()) 
		{
			DST_EEPROM_SetMaxRF(DST_MinRF());
			return;
		}
		else if (DST_EEPROM_GetMinRF() >= DST_EEPROM_GetMaxRF())
		{
			DST_EEPROM_SetMaxRF(DST_EEPROM_GetMinRF());
			return;
		}

		DST_EEPROM_SetMaxRF(DST_EEPROM_GetMaxRF() - 1);
	}
	void CFrequncySettingWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		int i = 0;
		int isOn = DST_EEPROM_GetFrequencySetting();
		switch(key)
		{
			case VK_UP:
				switch(nPos)
				{
					case 0:
						isOn = isOn ? 0 : 1;
						DST_EEPROM_SetFrequncySetting(isOn);
						break;
					case 1:
						if(isOn == 1)
						{
							for (i=0; i < 10; i++) IncreaseMinRF();
						}
						break;
					case 2:
						if(isOn == 1)
						{
							for (i=0; i < 10; i++) IncreaseMaxRF();
						}
						break;
						default:break;
				}

				this->Show(this);
				break;
				
			case VK_DN:
				switch(nPos)
				{
					case 0:
						isOn = isOn ? 0 : 1;
						DST_EEPROM_SetFrequncySetting(isOn);
						break;
					case 1:
						if(isOn == 1)
						{
							for (i=0; i < 10; i++) DecreaseMinRF();
						}
						break;
					case 2:
						if(isOn == 1)
						{
							for (i=0; i < 10; i++) DecreaseMaxRF();
						}
						break;
						default:break;
				}

				this->Show(this);
				break;
				
			case VK_VOL_UP:
			case VK_CH_UP:
				if(isOn == 1) nPos = (nPos+1)>2?0:(nPos+1);
				this->Show(this);	
				break;
			case VK_VOL_DN:
			case VK_CH_DN:
				if(isOn == 1) nPos = (nPos-1)<0?2:(nPos-1);
				this->Show(this);			
				break;
				
			case VK_LEFT:
				switch(nPos)
				{
					case 0:
						isOn = isOn ? 0 : 1;
						DST_EEPROM_SetFrequncySetting(isOn);
						break;
					case 1:
						if(isOn == 1) DecreaseMinRF();
						break;
					case 2:
						if(isOn == 1) DecreaseMaxRF();
						break;
						default:break;
				}

				this->Show(this);
				break;
			
			case VK_RIGHT:
				switch(nPos)
				{
					case 0:
						isOn = isOn ? 0 : 1;
						DST_EEPROM_SetFrequncySetting(isOn);
						break;
					case 1:
						if(isOn == 1) IncreaseMinRF();
						break;
					case 2:
						if(isOn == 1) IncreaseMaxRF();
						break;
						default:break;
				}

				this->Show(this);
				break;
				
			default:
				this->Close(this);
				break;
		}
	}

//};

void DST_CreateFrequencySettingWin(SWinEventMsg event)
{
	DST_RemoveAllWindowExceptBasicWin();
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor	= CFrequncySettingWin_Destructor;
	pWin->KeyInput		= CFrequncySettingWin_KeyInput;
	pWin->OnTimer		= CFrequncySettingWin_OnTimer;
	pWin->ShowWindow	= CFrequncySettingWin_ShowWindow;
	pWin->Show			= CFrequncySettingWin_Show;
	//  ȣ
	CFrequncySettingWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}


