#include "DST_DB.h"
//#include "sqlite3.h"
#include "DST_CommonAPI.h"
#include "DST_ChannelTune.h"
#include "DST_HostInterface.h"
#include "DST_DB_Engine.h"
#include "DST_MemoryDB.h"

//int CT_DB_GetTSID(DS_U8 RF);
DS_U32* DST_UTF82Uni(DS_U8 *utf);
void CT_DB_GetVideoPid(DS_U8 RF, DS_U16 sID,DS_U16* pcr, DS_U16* pid, DS_U8* type);
void CT_ChMapUpdate();
int CT_ChMapCount();
//char* CDBStringAdd(char*strText, const char* strSQL, ...);
//
//#ifdef SQLITE_ZERO_MALLOC
//static void sqlite3MemSetDefault(void);
//#endif

#if CHANNEL_EDIT_SUPPORT
void DST_DB_SetSkipChannel(int rf, int program_number, bool bAdd)
{
//	CDB db; NewCDB(&db);
//	db.Query(&db, "delete from skip_list where rf=%d and program_number=%d",rf, program_number);
//	if(bAdd) db.Query(&db, "INSERT INTO skip_list  VALUES (%d, %d)",rf, program_number);
	int i;
	for (i=0; i < DB_SKIP_LIST_MAX; i++)
	{
		if (db_skip_list[i].program_number == 0) continue;
		if (db_skip_list[i].rf != rf) continue;
		if (db_skip_list[i].program_number != program_number) continue;
		memset(&db_skip_list[i], 0, sizeof(_DB_SKIP_LIST_));
	}
	if(bAdd)
	{
		for (i=0; i < DB_SKIP_LIST_MAX; i++)
		{
			if (db_skip_list[i].program_number != 0) continue;
			db_skip_list[i].rf = rf;
			db_skip_list[i].program_number = program_number;
			break;
		}
	}
	CT_ChMapUpdate(); // Skip Ʈ  ä ٿ  Ѵ.
//	DeleteCDB(&db);
}
#endif // CHANNEL_EDIT_SUPPORT

bool DST_DB_PresentChMap()
{
	return (CT_ChMapCount() > 0);
}

int DST_DB_GetMajor(DS_U8 RF, DS_U16 program_number)
{
//	CDB db; NewCDB(&db);
//	db.GetTable(&db, "select major from channel_db where rf=%d and program_number=%d", RF, program_number);
//	int result = (db.GetRow(&db) < 1) ? 0 : dst_atoi(db.GetResult(&db, 1));
//	DeleteCDB(&db);
//	return result;
	int i;
	DBLock(true);
	for (i=0; i < DB_CHANNEL_DB_MAX; i++)
	{
		if (db_channel_db[i].program_number == 0) continue;
		if (db_channel_db[i].rf != RF) continue;
		if (db_channel_db[i].program_number != program_number) continue;
		int ret = db_channel_db[i].major;
		DBLock(false);
		return ret;
	}
	DBLock(false);
	return 0;
}

int DST_DB_GetMinor(DS_U8 RF, DS_U16 program_number)
{
//	CDB db; NewCDB(&db);
//	db.GetTable(&db, "select minor from channel_db where rf=%d and program_number=%d", RF, program_number);
//	int result = (db.GetRow(&db) < 1) ? 0 : dst_atoi(db.GetResult(&db, 1));
//	DeleteCDB(&db);
//	return result;
	int i;
	DBLock(true);
	for (i=0; i < DB_CHANNEL_DB_MAX; i++)
	{
		if (db_channel_db[i].program_number == 0) continue;
		if (db_channel_db[i].rf != RF) continue;
		if (db_channel_db[i].program_number != program_number) continue;
		int ret = db_channel_db[i].minor;
		DBLock(false);
		return ret;
	}
	DBLock(false);
	return 0;
}

void DST_DB_ChannelUpDn(bool bUp)
{
	T();
	int rf = DST_EEPROM_GetRF();
	int program_number = DST_EEPROM_GetProgramNumber();
	int nCount = 0;
	int nPos = -1;
	int i;
	DBLock(true);
	for (i =0; i < DB_CHANNEL_UPDN_MAX; i++)
	{
		if (db_channel_updn[i].program_number == 0) continue; 
		nCount++;
		if (db_channel_updn[i].rf != rf) continue;
		if (db_channel_updn[i].program_number != program_number) continue;
		nPos = i;
	}
	if (nCount == 0) 
	{
		DBLock(false);
		return;
	}
	if (nCount == 1) 
	{
		DST_UI_ChannelTune(db_channel_updn[0].rf, db_channel_updn[0].program_number);
		DBLock(false);
		return;
	}
	if (nPos < 0) // ä äθʿ  ä 
	{
		if (bUp)
		{
			DST_UI_ChannelTune(db_channel_updn[0].rf, db_channel_updn[0].program_number);
		}
		else
		{
			DST_UI_ChannelTune(db_channel_updn[nCount-1].rf, db_channel_updn[nCount-1].program_number);
		}
		DBLock(false);
		return; 
	}
	if (bUp)
	{
		nPos = (nPos >= nCount-1) ? 0 : nPos+1;
	}
	else
	{
		nPos = (nPos == 0) ? nCount-1 : nPos-1;
	}
	rf = db_channel_updn[nPos].rf;
	program_number = db_channel_updn[nPos].program_number;
	DBLock(false);
	DST_UI_ChannelTune(rf, program_number);
}

ChannelMap* DST_DB_GetChannelMapForChEdit(int *nChannels)
{
	DBLock(true);
	*nChannels = CT_ChMapCount();
	if (*nChannels == 0) 
	{
		DBLock(false);
		return 0;
	}
	ChannelMap* chMap = (ChannelMap *)DST_OS_Calloc(sizeof(ChannelMap), *nChannels);
	int i;
	int nPos = 0;
	for (i=0; i < DB_CHANNEL_DB_MAX; i++)
	{
		if (db_channel_db[i].program_number == 0) continue;
		chMap[nPos].rf = db_channel_db[i].rf;
		chMap[nPos].major = db_channel_db[i].major;
		chMap[nPos].minor = db_channel_db[i].minor;
		strcpy((char*)chMap[nPos].name, db_channel_db[i].name);
		chMap[nPos].number = db_channel_db[i].program_number;
		sprintf(chMap[nPos].num, "%d-%d", chMap[nPos].major, chMap[nPos].minor);
		if (chMap[nPos].minor == 0) sprintf(chMap[nPos].num, "%d", chMap[nPos].major);
		nPos++;
		if (nPos >= *nChannels) break;
	}
	if (*nChannels > 1)
	{
		// major, minor, rf  
		for (i=0; i < *nChannels-1; i++)
		{
			int j;
			for (j = i+1; j < *nChannels; j++)
			{
				if (chMap[i].major < chMap[j].major) continue;
				if (chMap[i].minor < chMap[j].minor) continue;
				if (chMap[i].rf < chMap[j].rf) continue;
				ChannelMap tmp = chMap[i];
				chMap[i] = chMap[j];
				chMap[j] = tmp;
			}
		}
	}
	DBLock(false);
	return chMap;
}

int DST_DB_GetChannelCount()
{
	return CT_ChMapCount();
}

bool DST_DB_GetCurrentChannelInfo(char* chNum, DS_U32* chName, int *num)
{
	if (chNum) chNum[0] = 0;
	if (chName) chName[0] = 0;

#if 0		
	DS_U8 RF= DST_EEPROM_GetRF();
	DS_U16 program_number = DST_EEPROM_GetProgramNumber();
#else
	DS_U8  RF= 0;
	DS_U16 program_number = 0;
	DST_GetAVState(&RF, &program_number, 0);
#endif
	
	if (program_number == 0)
	{
		if (num) *num = DST_GetFrequencyNumberbyIndex(RF);
		if (chNum) sprintf(chNum,"%d", DST_GetFrequencyNumberbyIndex(RF));
		return false;
	}
//	CDB db; NewCDB(&db);
//	db.GetTable(&db, "select major, minor, name from channel_db where rf =%d and program_number=%d", RF, program_number);
	int major = 0;
	int minor = 0;
	int i;
	int nPos = -1;
	DBLock(true);
	for (i=0; i < DB_CHANNEL_DB_MAX;i++)
	{
		if (db_channel_db[i].program_number == 0) continue;
		if (db_channel_db[i].rf != RF) continue;
		if (db_channel_db[i].program_number != program_number) continue;
		major = db_channel_db[i].major;
		minor = db_channel_db[i].minor;
		nPos = i;
		break;
	}
	
	if (nPos < 0)
	{
		if (num) *num = DST_GetFrequencyNumberbyIndex(RF);
		if (chNum) sprintf(chNum,"%d", DST_GetFrequencyNumberbyIndex(RF));
//		DeleteCDB(&db);
		DBLock(false);
		return false;
	}
	
//	int major = dst_atoi(db.GetResult(&db, 3));
//	int minor = dst_atoi(db.GetResult(&db, 4));
	if (chName)
	{
		DS_U32 *strText32 = DST_UTF82Uni((DS_U8*)db_channel_db[nPos].name);
		if (strText32) strcpy32(chName, strText32);
	}
	if (minor == 0)
	{
		sprintf(chNum,"%d (%d) ", major, DST_GetFrequencyNumberbyIndex(RF));
	}
	else
	{
		sprintf(chNum,"%d-%d(%d) ", major, minor, DST_GetFrequencyNumberbyIndex(RF));
	}
//	DeleteCDB(&db);
	DBLock(false);
	return true;
}

//   Ȥ  ĵ  ȣ ȴ.
void DST_DB_TuneFirstChannel()
{
	DBLock(true);
	if (DST_DB_PresentChMap() == false)
	{
		DST_UI_ChannelTune(DST_DB_GetUnexceptedFirstRF(), 0);
		DBLock(false);
		return;
	}
	// RF ȣ α׷ѹ ġϴ ä ã´.
	int rf = DST_EEPROM_GetRF();
	int program_number = DST_EEPROM_GetProgramNumber();
	int i;
	for (i=0; i < DB_CHANNEL_DB_MAX;i++)
	{
		if (db_channel_db[i].program_number == 0) continue;
		if (db_channel_db[i].rf != rf) continue;
		if (db_channel_db[i].program_number != program_number) continue;
		DST_UI_ChannelTune(rf, program_number);
		DBLock(false);
		return;
	}
	// RF ȣ ġϴ ä ã´.
	for (i=0; i < DB_CHANNEL_DB_MAX;i++)
	{
		if (db_channel_db[i].program_number == 0) continue;
		if (db_channel_db[i].rf != rf) continue;
		DST_UI_ChannelTune(rf, db_channel_db[i].program_number);
		DBLock(false);
		return;
	}
	// ù° ä
	if (db_channel_updn[0].program_number)
	{
		DST_UI_ChannelTune(db_channel_updn[0].rf, db_channel_updn[0].program_number);
		DBLock(false);
		return;
	}
	DST_UI_ChannelTune(DST_MinRF(), 0);
	DBLock(false); 
}

int DST_DB_GetProgramNumber(int major, int minor)
{
	int i;
	DBLock(true); 
	for (i=0; i < DB_CHANNEL_DB_MAX;i++)
	{
		if (db_channel_db[i].program_number == 0) continue;
		if (db_channel_db[i].major != major) continue;
		if (db_channel_db[i].minor != minor) continue;
		int ret = db_channel_db[i].program_number;
		DBLock(false); 
		return ret;
	}
	if (minor != 0) 
	{
		DBLock(false); 
		return 0;
	}
	for (i=0; i < DB_CHANNEL_DB_MAX;i++)
	{
		if (db_channel_db[i].program_number == 0) continue;
		if (db_channel_db[i].major != major) continue;
		//if (db_channel_db[i].minor != minor) continue;
		int ret = db_channel_db[i].program_number;
		DBLock(false); 
		return ret;
	}
	DBLock(false); 
	return 0;
}

int DST_DB_GetProgramNumberbyRFNumber(int rf)
{
	int i;
	int program_number = 0;
	int min_minor = 10000;
	DBLock(true); 
	for (i=0; i < DB_CHANNEL_DB_MAX;i++)
	{
		if (db_channel_db[i].program_number == 0) continue;
		if (db_channel_db[i].rf != rf) continue;
		if (db_channel_db[i].minor < min_minor)
		{
			program_number = db_channel_db[i].program_number;
			min_minor = db_channel_db[i].minor;
		}
	}
	DBLock(false); 
	return program_number;
}

void DST_DB_Del()
{
	DBLock(true); 
#if EPG_SUPPORT
	int i;
	for (i =0 ; i < DB_EIT_SUB_MAX; i++)
	{
		if (db_eit_sub[i].title) DST_OS_Free(&db_eit_sub[i].title);
		memset(&db_eit_sub[i], 0, sizeof(_DB_EIT_SUB_));
	}
	for (i =0 ; i < DB_ETT_MAX; i++)
	{
		if (db_ett[i].title) DST_OS_Free(&db_ett[i].title);
		memset(&db_ett[i], 0, sizeof(_DB_ETT_));
	}
	memset(&db_eit, 0, sizeof(_DB_EIT_)*DB_EIT_MAX);
#endif
	memset(&db_pat, 0, sizeof(_DB_PAT_)*DB_PAT_MAX);
	memset(&db_pmt, 0, sizeof(_DB_PMT_)*DB_PMT_MAX);
	memset(&db_tvct, 0, sizeof(_DB_TVCT_)*DB_TVCT_MAX);
	memset(&db_tvct_sub, 0, sizeof(_DB_TVCT_SUB_)*DB_TVCT_SUB_MAX);
#if CVCT_SUPPORT
	memset(&db_cvct, 0, sizeof(_DB_CVCT_)*DB_CVCT_MAX);
	memset(&db_cvct_sub, 0, sizeof(_DB_CVCT_SUB_)*DB_CVCT_SUB_MAX);
#endif
#if CHANNEL_EDIT_SUPPORT
	memset(&db_skip_list, 0, sizeof(_DB_SKIP_LIST_)*DB_SKIP_LIST_MAX);
#endif // CHANNEL_EDIT_SUPPORT
	CT_ChMapUpdate();
	DBLock(false); 
}

// FLASH ޸ 

DS_U32 DST_CRC32(DS_U8 *data, int len)
{
	static DS_U32 crcTable[256];
	static bool bFirst=true;
	if (bFirst)
	{
		bFirst = false;
		int i;
		for ( i=0; i<256; i++) {
			DS_U32 crc = 0;
			int j;
			for ( j=7; j>=0; j--) {
				if (((i >> j) ^ (crc >> 31)) & 1) crc=(crc<<1)^0x04C11DB7;
				else crc<<=1;
			}
			crcTable[i] = crc;
		}
	}
	DS_U32 crc = 0xFFFFFFFF;
	int i;
	for ( i = 0; i < len; ++i) crc = (crc << 8) ^ crcTable[(crc >> 24) ^ (*data++)];
	return crc;
}

// FLASH MEMORY LOW LEVEL ACCESS FUNCTION
static DS_U8 *strFlash = 0;
static DS_U32 g_nFlashDBSize = 0;
static DS_U32 g_nFlashDBAddress[2] = {0, 0};

static DS_U32 g_sync_request_time = 0;
static DS_U32 g_Sync_finish_time = 0;

void DST_DB_Sync()
{
	g_sync_request_time = DST_OS_GetTickCount();
}

bool DST_DB_IsSync()
{
	return (g_Sync_finish_time < g_sync_request_time) ? false : true;
}

static void tDB_Sync()
{
	while (1)
	{
		//T();
		DST_OS_Delay(1000);
		if (DST_g_KeyPressTime > DST_OS_GetTickCount()) DST_g_KeyPressTime = DST_OS_GetTickCount();
		if (DST_OS_GetTickCount() - DST_g_KeyPressTime < DST_OS_GetTicksPerSecond()/2) continue;
		if (DST_DB_IsSync()) continue;
		//T();
		DS_U32 *version = (DS_U32 *)&strFlash[0];
		DS_U32 *crc = (DS_U32 *)&strFlash[4];
		int nPos = 8;
		memcpy(&strFlash[nPos], &db_config, sizeof(_DB_CONFIG_) * DB_CONFIG_MAX);
		nPos += sizeof(_DB_CONFIG_) * DB_CONFIG_MAX;
		memcpy(&strFlash[nPos], &db_pat, sizeof(_DB_PAT_) * DB_PAT_MAX);
		nPos += sizeof(_DB_PAT_) * DB_PAT_MAX;
		memcpy(&strFlash[nPos], &db_pmt, sizeof(_DB_PMT_) * DB_PMT_MAX);
		nPos += sizeof(_DB_PMT_) * DB_PMT_MAX;
#if CHANNEL_EDIT_SUPPORT
		memcpy(&strFlash[nPos], &db_skip_list, sizeof(_DB_SKIP_LIST_) * DB_SKIP_LIST_MAX);
		nPos += sizeof(_DB_SKIP_LIST_) * DB_SKIP_LIST_MAX;
#endif // CHANNEL_EDIT_SUPPORT
		memcpy(&strFlash[nPos], &db_tvct, sizeof(_DB_TVCT_) * DB_TVCT_MAX);
		nPos += sizeof(_DB_TVCT_) * DB_TVCT_MAX;
		memcpy(&strFlash[nPos], &db_tvct_sub, sizeof(_DB_TVCT_SUB_) * DB_TVCT_SUB_MAX);
		nPos += sizeof(_DB_TVCT_SUB_) * DB_TVCT_SUB_MAX;
		*version = FLASH_VERSION;
		*crc =  DST_CRC32(&strFlash[8], g_nFlashDBSize-8);
		int i;
		for (i=0; i <g_nFlashDBSize; i++) strFlash[i] ^= 0xFF;
		DHL_Flash_Write(g_nFlashDBAddress[0], g_nFlashDBSize, strFlash);
		DHL_Flash_Write(g_nFlashDBAddress[1], g_nFlashDBSize, strFlash);
		g_Sync_finish_time = DST_OS_GetTickCount();
	}
}

void DST_DB_Open()
{
	if (strFlash) DST_OS_Free(&strFlash);
	g_nFlashDBSize = 8; //version, crc
	g_nFlashDBSize += sizeof(_DB_CONFIG_) * DB_CONFIG_MAX;
	g_nFlashDBSize += sizeof(_DB_PAT_) * DB_PAT_MAX;
	g_nFlashDBSize += sizeof(_DB_PMT_) * DB_PMT_MAX;
#if CHANNEL_EDIT_SUPPORT
	g_nFlashDBSize += sizeof(_DB_SKIP_LIST_) * DB_SKIP_LIST_MAX;
#endif
	g_nFlashDBSize += sizeof(_DB_TVCT_) * DB_TVCT_MAX;
	g_nFlashDBSize += sizeof(_DB_TVCT_SUB_) * DB_TVCT_SUB_MAX;
//	DST_Printf("nFlashDBSize4K = %d nFlashDBSize = %d\n", nFlashDBSize4K, (int)g_nFlashDBSize);
	DS_U32 nFlashDBSize4K = ((g_nFlashDBSize+4096-1)/4096)*4096;
	g_nFlashDBAddress[0] = FLASH_CH_MAP_POS;
	g_nFlashDBAddress[1] = g_nFlashDBAddress[0] + nFlashDBSize4K;
	
	strFlash = DHL_Flash_Read(g_nFlashDBAddress[0], g_nFlashDBSize);
	int i;
	for (i=0; i <g_nFlashDBSize; i++) strFlash[i] ^= 0xFF;
	DS_U32 version = *(DS_U32 *)&strFlash[0];
	DS_U32 crc = *(DS_U32 *)&strFlash[4];
	bool bValidDB = true;
	if ((version != FLASH_VERSION) || (crc !=  DST_CRC32(&strFlash[8], g_nFlashDBSize-8))) //DB0 is broken
	{
		if (strFlash) DST_OS_Free(&strFlash);
		strFlash = DHL_Flash_Read(g_nFlashDBAddress[1], g_nFlashDBSize);
		for (i=0; i <g_nFlashDBSize; i++) strFlash[i] ^= 0xFF;
		DS_U32* buff32 = (DS_U32*)strFlash;
		version = buff32[0];
		crc = buff32[1];
		if ((version != FLASH_VERSION) || (crc !=  DST_CRC32(&strFlash[8], g_nFlashDBSize-8))) // DB1 is broken
		{
			bValidDB = false;
			DST_Factory_Reset();
		}	
	}
	if (bValidDB == true)
	{
		int nPos = 8;
		memcpy(&db_config, &strFlash[nPos], sizeof(_DB_CONFIG_) * DB_CONFIG_MAX);
		nPos += sizeof(_DB_CONFIG_) * DB_CONFIG_MAX;
		memcpy(&db_pat, &strFlash[nPos],  sizeof(_DB_PAT_) * DB_PAT_MAX);
		nPos += sizeof(_DB_PAT_) * DB_PAT_MAX;
		memcpy(&db_pmt, &strFlash[nPos], sizeof(_DB_PMT_) * DB_PMT_MAX);
		nPos += sizeof(_DB_PMT_) * DB_PMT_MAX;
#if CHANNEL_EDIT_SUPPORT
		memcpy(&db_skip_list, &strFlash[nPos], sizeof(_DB_SKIP_LIST_) * DB_SKIP_LIST_MAX);
		nPos += sizeof(_DB_SKIP_LIST_) * DB_SKIP_LIST_MAX;
#endif
		memcpy( &db_tvct, &strFlash[nPos], sizeof(_DB_TVCT_) * DB_TVCT_MAX);
		nPos += sizeof(_DB_TVCT_) * DB_TVCT_MAX;
		memcpy(&db_tvct_sub, &strFlash[nPos], sizeof(_DB_TVCT_SUB_) * DB_TVCT_SUB_MAX);
		nPos += sizeof(_DB_TVCT_SUB_) * DB_TVCT_SUB_MAX;
		int i;
		for (i = 0; i < DB_CONFIG_MAX; i++)
		{
			if (strlen(db_config[i].name) == 0) continue;
			DST_Printf("%s | %d\n", db_config[i].name, db_config[i].value);
		}
	}
	DST_OS_SpawnTask( (void(*) (void *))tDB_Sync, (char*)"tDB_Sync", APP_TASK_PRIO_EEPROM_SYNC, WIN_MGR_TASK_STACKSIZE,  0);
}

int DST_DB_GetRF(int major, int *minor, bool* bFound)
{
	*bFound = true;
	int i;
	int min_rf = 10000;
	int min_minor = 10000;
	int nPos = -1;
	DBLock(true); 
	for (i = 0; i < DB_CHANNEL_DB_MAX; i++)
	{
		if (db_channel_db[i].program_number == 0) continue;
		if (db_channel_db[i].major != major) continue;
		if (db_channel_db[i].minor != *minor) continue;
		if (db_channel_db[i].rf <  min_rf)
		{
			min_rf = db_channel_db[i].rf;
			nPos = i;
		}
	}
	if (nPos >=0) 
	{
		*minor = db_channel_db[nPos].minor;
		int ret = db_channel_db[nPos].rf;
		DBLock(false); 
		return ret;
	}

	min_rf = 10000;
	min_minor = 10000;
	nPos = -1;

	for (i = 0; i < DB_CHANNEL_DB_MAX; i++)
	{
		if (db_channel_db[i].program_number == 0) continue;
		if (db_channel_db[i].major != major) continue;
//		if (db_channel_db[i].minor != minor) continue;
		if (db_channel_db[i].minor < min_minor)
		{
			min_minor = db_channel_db[i].minor;
			nPos = i;
		}
	}
	if (nPos >= 0)
	{
		nPos = -1;
		for (i = 0; i < DB_CHANNEL_DB_MAX; i++)
		{
			if (db_channel_db[i].program_number == 0) continue;
			if (db_channel_db[i].major != major) continue;
			if (db_channel_db[i].minor != min_minor) continue;
			if (db_channel_db[i].rf <  min_rf)
			{
				min_rf = db_channel_db[i].rf;
				nPos = i;
			}
		}	
	}
	if (nPos >=0) 
	{
		*minor = db_channel_db[nPos].minor;
		int ret = db_channel_db[nPos].rf;
		DBLock(false); 
		return ret;
	}
	*bFound = false;
	DBLock(false); 
	return 0;
}

int DST_DB_AvailableChannelCount(int major)
{
	if (major == 0) return 0;
	int i;
	int nCount = 0;
	DBLock(true); 
	for (i = 0; i < DB_CHANNEL_DB_MAX; i++)
	{
		if (db_channel_db[i].program_number == 0) continue;
		if ((db_channel_db[i].major == major) || 
			(db_channel_db[i].major/10 == major) ||
			(db_channel_db[i].major/100 == major) ||
			(db_channel_db[i].major/1000 == major) ||
			(db_channel_db[i].major/10000 == major))
		{
			nCount++;
		}	
	}
	DBLock(false); 
	return nCount;
}

bool DST_DB_PresentMatchChannel(int rf, int major, int minor)
{
	int i;
	DBLock(true); 
	for (i = 0; i < DB_CHANNEL_DB_MAX; i++)
	{
		if (db_channel_db[i].program_number == 0) continue;
		if (db_channel_db[i].rf != rf) continue;
		if (db_channel_db[i].major != major) continue;
		if (minor != 0) if (db_channel_db[i].minor != minor) continue;
		DBLock(false); 
		return true;
	}
	DBLock(false); 
	return false;
}

// ļ  ܵ ä?
// Է° rf index ̴
int DST_DB_IsExceptRF(int rf)
{
	if (DST_EEPROM_GetFrequencySetting() == 0) return 0;
	if (rf < DST_EEPROM_GetMinRF()) return 0;
	if (rf > DST_EEPROM_GetMaxRF()) return 0;
	return 1;
}

//  ä ܵǾ?
int DST_DB_GetExceptRFCount()
{
	if (DST_EEPROM_GetFrequencySetting() == 0) return 0;
	return DST_EEPROM_GetMaxRF() - DST_EEPROM_GetMinRF() + 1;
}

static int GetNextRF(int rf)
{
	if (rf >= DST_MaxRF()) return 0;
	return rf+1;
}
// ܵ   RF index ´
// Էµ   indexed rf 
int DST_DB_GetNextUnexceptRF(int rf)
{
	int i=0;
	if (DST_EEPROM_GetFrequencySetting() == 0)
	{
		return GetNextRF(rf);
	}
	int curRF = rf;
	for (i = DST_MinRF(); i <= DST_MaxRF(); i++)
	{
		curRF = GetNextRF(curRF); 
		if (DST_DB_IsExceptRF(curRF) == 0) return curRF;
	} 	
	return 0;
}

static int GetPrevRF(int rf)
{
	if (rf <= DST_MinRF()) return DST_MaxRF();
	return rf-1;
}
// ܵ   RF index ´
// Էµ   indexed rf 
int DST_DB_GetPrevUnexceptRF(int rf)
{
	int i=0;
	if (DST_EEPROM_GetFrequencySetting() == 0)
	{
		return GetPrevRF(rf);
	}
	int curRF = rf;
	for (i = DST_MinRF(); i <= DST_MaxRF(); i++)
	{
		curRF = GetPrevRF(curRF); 
		if (DST_DB_IsExceptRF(curRF) == 0) return curRF;
	} 	
	return 0;
}

int DST_DB_GetUnexceptedFirstRF()
{
	int i=0;
	for (i = DST_MinRF(); i <= DST_MaxRF(); i++)
	{
		if (DST_DB_IsExceptRF(i) == 0) return i;
	}
	return DST_MinRF();  	
}

int DST_DB_GetUnexceptedLastRF()
{
	int i=0;
	for (i = DST_MaxRF(); i >= DST_MinRF(); i--)
	{
		if (DST_DB_IsExceptRF(i) == 0) return i;
	}
	return DST_MaxRF();  	
}
