#include "DST_Common.h"
#include "DST_EEPROM.h"
#include "DST_HostInterface.h"
#include "DST_GlobalVariables.h"
#include "DST_CommonAPI.h"
#include "DST_ChannelTune.h"
#include "DST_WinManagerTask.h" //ui

#include "DST_DB_Engine.h"
#include "DST_DB.h"
#include "DST_MemoryDB.h"

typedef struct 
{
	const char* name;
	int min;
	int max;
	int default_value;
} CONFIG;

static CONFIG config[] =
{
	{"NeedReset", 0, 1, 0},
	{"First", 0, 1, 1},
	{"TuneMode", 0, 2, 1},
	{"Volume", 0, 50, 25},
	{"CC", 0, 1, 0},
	{"RF", 0, 154, 0}, // RF index Ѵ.
	{"program_number", 0, 0xFFFF, 0},
	{"aspect_4x3o_4x3i", 0, 2, 1},
	{"aspect_4x3o_16x9i", 0, 2, 1},
	{"AudioPref", 0, 1, 0},
	{"VI", 0, 1, 0},
	{"PreferredConn", 0, 1, 0},
	{"MinRF", 0, RF_COUNT-1, 0}, 
	{"MaxRF", 0, RF_COUNT-1, RF_COUNT-1}
};
// unsigned aspect_4x3o_4x3i:2; // 0~2
// unsigned aspect_4x3o_16x9i:2; // 0~2
// unsigned aspect_16x9o_4x3i:2; // 0~2
// unsigned aspect_16x9o_16x9i:2; // 0~2
void DST_EEPROM_SetAspect(bool bSource4x3,  int nVal) 
{
	if (bSource4x3)
	{
		DST_EEPROM_SetConfig("aspect_4x3o_4x3i", 1);
	}	
	else
	{
		DST_EEPROM_SetConfig("aspect_4x3o_16x9i", nVal);
	}
}

int DST_EEPROM_GetAspect(bool bSource4x3)
{
	 //Ʈ 4:3϶ 븻
	if (bSource4x3) return DST_EEPROM_GetConfig("aspect_4x3o_4x3i");
	return DST_EEPROM_GetConfig("aspect_4x3o_16x9i");
}

void DST_EEPROM_SetConfig(const char * name, int value)
{
	int i;
	for (i = 0; i < DB_CONFIG_MAX; i++) //   
	{
		if (strcmp(db_config[i].name, name) != 0) continue;
		memset(&db_config[i], 0, sizeof(_DB_CONFIG_));
	}
	for (i = 0; i < DB_CONFIG_MAX; i++) //  ߰
	{
		if (strlen(db_config[i].name) != 0) continue; 
		strcpy(db_config[i].name, name);
		db_config[i].value = value;
		break;
	}
	DST_DB_Sync();
}

int DST_EEPROM_GetConfig(const char *name) 
{
	int i;
	int nCount = sizeof(config)/sizeof(CONFIG);
	int nPos = -1;
	for (i = 0; i < nCount; i++)
	{
		if (strcmp(config[i].name, name) != 0) continue;
		nPos = i;
		break;
	} 
	if (nPos < 0)
	{
		DST_Printf("%s|%d|Invalid name %s", __func__, __LINE__, name);
		return 0;
	}
	for (i = 0; i < DB_CONFIG_MAX; i++)
	{
		if (strcmp(db_config[i].name, name) != 0) continue;
		if (db_config[i].value < config[nPos].min) db_config[i].value = config[nPos].default_value;
		if (db_config[i].value > config[nPos].max) db_config[i].value = config[nPos].default_value;
		return db_config[i].value;
	} 
	return 	config[nPos].default_value;
}

void DST_EEPROM_FactoryInit()
{
	int MinRF = DST_EEPROM_GetMinRF(); //    ʱȭص   ȴ.
	int MaxRF = DST_EEPROM_GetMaxRF(); //    ʱȭص   ȴ.
	memset(&db_config, 0, sizeof(_DB_CONFIG_) * DB_CONFIG_MAX);
	DST_EEPROM_SetMinRF(MinRF);
	DST_EEPROM_SetMaxRF(MaxRF);
}

void DST_SetSleepTimer(DS_U8 value)
{
	DST_g_SleepTimer = (value < 5) ? value : 0;
}

DS_U8 DST_GetSleepTimer()
{
	return (DST_g_SleepTimer < 5) ? DST_g_SleepTimer : 0;
}

