#include "DST_Window.h"
#include "DST_WinManager.h"
#include "DST_DataStrings.h"
#include "DST_CommonAPI.h"
#include "DST_EEPROM.h"
#include "DST_ChannelTune.h"
#include "DST_UserInterface.h"
#include "DST_Updates.h"
#include "DST_ISDBT_ChannelTask.h"
//#include "DST_OTC_Main.h"
#include "DST_OSDImage.h"

#if 0
____CMessageWin___()
#endif


char* DST_GetAppShortVersion();


//class COTCDownLoadingWin : public CWindow
//{
//private:
	static bool COTCDownLoadingWin_bDone;
	static bool COTCDownLoadingWin_bNeedLine;
	static int COTCDownLoadingWin_progress;
	static int COTCDownLoadingWin_center_pos;
	static int COTCDownLoadingWin_line_spacing;	

	static int COTCDownLoadingWin_nErr;
	static int COTCDownLoadingWin_ErrCategory;
	static int COTCDownLoadingWin_category;
//public:
//	COTCDownLoadingWin(SWinEventMsg event):CWindow(event)
	void COTCDownLoadingWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "OTCDownload");
		DST_g_RFUpdateState = 0;
		this->rect.w = 382; 
		this->rect.h = 241; 
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight()- this->rect.h) / 2;

		DST_Printf("\n\n--------------------------WIN_OTC_DOWNLOADING----------------------------------\n\n");
		

		COTCDownLoadingWin_center_pos =  this->rect.h / 2; 
		COTCDownLoadingWin_line_spacing = DST_GetFontHeight(fontItemSize) * 125 / 100;

		COTCDownLoadingWin_nErr = 0;
		COTCDownLoadingWin_ErrCategory = 0;
		COTCDownLoadingWin_category = 0;
		COTCDownLoadingWin_bNeedLine = false;
		COTCDownLoadingWin_bDone = false;
		COTCDownLoadingWin_progress = 0;
		
		this->SetTimeOut(this, 0);
		this->SetTimer(this, 1, 5*60*1000);

//		DHL_POWER_SetMode(nSleepState ? 2 : 0);
	}

	void COTCDownLoadingWin_Destructor(CWindow *this)
	{
	}
	
//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void COTCDownLoadingWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_KEY_PWR:
			case VK_PWR:
				if (DST_g_PowerOn) // 
				{
					DST_g_PowerOn = false;
				}
				else // 
				{
					DST_g_PowerOn = true;
				} 
				JST_POWER_Display(DST_g_PowerOn);
				break;
		}
	}

	void COTCDownLoadingWin_DrawProgressBar(CWindow *this, DS_U32 nPos, DS_U32 nTotal, int x, int y, DS_U32 width)
	{
		int line = DST_GetFontHeight(15);
		int y_str = y+10;
		char tmpProgStr[50] = {0,};

		this->DrawBox32(this, x, y, width, 10, CONV32_16(0xffe5e5ff));
		if(nPos == nTotal)
			this->DrawBox32(this, x, y, width, 10, CONV32_16(0xff65a5cc));
		else
			this->DrawBox32(this, x, y, (nPos*width)/nTotal, 10, CONV32_16(0xff65a5cc));

		this->setFontStyle(this, 15,0xFFE1E1E1,ALIGN_MIDDLE,ALIGN_CENTER);
		
		sprintf(tmpProgStr,"(%d%%)",(nPos == nTotal)?(100):(int)((nPos*100)/nTotal));
		this->DrawBox32(this, x, y_str, width, line, CONV32_16(0xff24435e));
		this->DrawTextUTF8(this, x, y_str, width, line, (DS_U8*)tmpProgStr, &(this->font)); 


	}
	
//	virtual void OnMessage(SWinEventMsg event)
	void COTCDownLoadingWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		static int old_count = -1;
		switch (event.cmd)
		{
			case WM_RF_UPDATE:
				switch(event.data32[0])
				{
					case DATA_RECEIVING: // DATA RECEIVING
						this->KillTimer(this, 1);
						COTCDownLoadingWin_DrawProgressBar(this, event.data32[1],  100, this->rect.w/10, COTCDownLoadingWin_center_pos+2*COTCDownLoadingWin_line_spacing-10,this->rect.w*8/10);
						if(old_count != (int)event.data32[1])
						{
							old_count = event.data32[1];
							this->KillTimer(this, 2);
							this->SetTimer(this, 2, 15*60*1000);
						}
						break;
					default: break;
				}
				break;		
		}
	}

//	virtual void OnTimer(char nID)
	void COTCDownLoadingWin_OnTimer(CWindow *this, char nID)
	{
		switch(nID)
		{
			case 1:
				DST_CreateWin(WIN_OTC_DOWNLOAD_FAIL,WIN_NULL,(DST_g_Lock == true)?(OTC_WAIT_TIMEOUT_FAIL):(TUNING_FAIL),0 ,0, 0);
				this->Close(this);
				break;
			case 2:
				DST_CreateWin(WIN_OTC_DOWNLOAD_FAIL,WIN_NULL,OTC_COMPLETE_TIMEOUT_FAIL, 0, 0, 0);
				this->Close(this);
				break;
#if 0  //test code		
			case 3:
				{
					static int count = 0;
					this->KillTimer(this, 3);
					
					COTCDownLoadingWin_DrawProgressBar(this, count,  100,rect.w/10,center_pos+2*line_spacing-10,rect.w*8/10);
					count++;
					if(count == 100) count = 0;
					
					this->SetTimer(this, 3,300);
				}
				break;
#endif				
			case 4:
				{
					static int loading = 0;
					
					loading = loading%6;
					switch(loading)
					{
						case 0:	this->DrawImage(this, (this->rect.w-34)/2, 30, newcon2_gui_downaload_Wait1,true); break;
						case 1:	this->DrawImage(this, (this->rect.w-34)/2, 30, newcon2_gui_downaload_Wait2,true); break;
						case 2:	this->DrawImage(this, (this->rect.w-34)/2, 30, newcon2_gui_downaload_Wait3,true); break;
						case 3:	this->DrawImage(this, (this->rect.w-34)/2, 30, newcon2_gui_downaload_Wait4,true); break;
						case 4:	this->DrawImage(this, (this->rect.w-34)/2, 30, newcon2_gui_downaload_Wait5,true); break;
						case 5:	this->DrawImage(this, (this->rect.w-34)/2, 30, newcon2_gui_downaload_Wait6,true); break;
					}
					loading ++;
					
				}
				break;
			default:  break;
		}
	}

	void COTCDownLoadingWin_Draw(CWindow *this)
	{
		this->DrawBox32(this, 0, 0, this->rect.w, this->rect.h, CONV32_16(0xff24435e));
		
		this->setFontStyle(this, fontItemSize,0xFFE1E1E1,ALIGN_MIDDLE,ALIGN_CENTER);
		
		this->DrawTextUni(this, 0, COTCDownLoadingWin_center_pos-60+25, this->rect.w, COTCDownLoadingWin_line_spacing, pz_OTC_Download1[OSD_Lang], &(this->font)); 
		this->DrawTextUni(this, 0, COTCDownLoadingWin_center_pos+COTCDownLoadingWin_line_spacing-50+25, this->rect.w, COTCDownLoadingWin_line_spacing, pz_OTC_Download2[OSD_Lang], &(this->font)); 
//		this->SetTimer(this, 3,500);
		this->SetTimer(this, 4,300);

	}

//	virtual void Show(void)
	void COTCDownLoadingWin_Show(CWindow *this)
	{
		COTCDownLoadingWin_Draw(this);
		
		this->RegisterAllKey(this);
	}


//};



//class COTCDownloadFailResetWin : public CWindow
//{
//private:
	static int COTCDownloadFailResetWin_nErr;
//public:
//	COTCDownloadFailResetWin(SWinEventMsg event):CWindow(event)
	void COTCDownloadFailResetWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "OTCDownFail");
		this->rect.w = 382; 
		this->rect.h = 241; 
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight()- this->rect.h) / 2;
		this->RegisterAllKey(this);
		this->SetTimeOut(this, 0);
		DST_g_bOTCMode = false;
		
		DST_g_LED_PowerState = 1;
		COTCDownloadFailResetWin_nErr = event.data[2];;

	}

	void COTCDownloadFailResetWin_Destructor(CWindow *this)
	{
		if (DST_g_PowerOn)
		{
			T();
		DST_Reset(__func__); // â 鼭 
	}
		else
		{
			T();
			DHL_SYS_Off();
		}
	}
	
//	virtual void OnTimer(char nID)
	void COTCDownloadFailResetWin_OnTimer(CWindow *this, char nID)
	{
		switch(nID)
		{
			case 1:
				this->KillTimer(this, 1);
				this->SetTimer(this, 2, 1000);
				this->Show(this);
				break;
			case 2:
				this->KillTimer(this, 2);
				this->Close(this);
				break;
			default:
				break;
		}
	}
	
	
//	virtual void Show(void)
	void COTCDownloadFailResetWin_Show(CWindow *this)
	{
		int	center_pos =  this->rect.h / 2; 
		int line_spacing = DST_GetFontHeight(fontItemSize) * 150 / 100;

		this->DrawBox32(this, 0, 0, this->rect.w, this->rect.h, CONV32_16(0xff24435e));
		this->setFontStyle(this, 22,0xFFE1E1E1,ALIGN_MIDDLE,ALIGN_CENTER);

		switch(COTCDownloadFailResetWin_nErr)
		{
			case TUNING_FAIL:
				DST_Printf("OTCDownloadFail : ERROR %d TUNING_FAIL\n",COTCDownloadFailResetWin_nErr);
				this->DrawTextUni(this, 0, center_pos-2*line_spacing, this->rect.w, line_spacing, pz_Update_Err_101[OSD_Lang], &(this->font)); 
				break;
			case OTC_WAIT_TIMEOUT_FAIL:
				DST_Printf("OTCDownloadFail : ERROR %d OTC_WAIT_TIMEOUT_FAIL\n",COTCDownloadFailResetWin_nErr);
				this->DrawTextUni(this, 0, center_pos-2*line_spacing, this->rect.w, line_spacing, pz_Update_Err_201[OSD_Lang], &(this->font)); 
				break;
			case OTC_COMPLETE_TIMEOUT_FAIL:
				DST_Printf("OTCDownloadFail : ERROR %d OTC_COMPLETE_TIMEOUT_FAIL\n",COTCDownloadFailResetWin_nErr);
				this->DrawTextUni(this, 0, center_pos-2*line_spacing, this->rect.w, line_spacing, pz_Update_Err_202[OSD_Lang], &(this->font)); 
				break;
		}

		this->DrawTextUni(this, 0, center_pos-line_spacing, this->rect.w, line_spacing, pz_OTC_Download_Fail1[OSD_Lang], &(this->font)); 
		this->DrawTextUni(this, 0, center_pos, this->rect.w, line_spacing, pz_OTC_Download_Fail2[OSD_Lang], &(this->font)); 
		this->DrawTextUni(this, 0, center_pos+line_spacing, this->rect.w, line_spacing, pz_OTC_Download_Fail3[OSD_Lang], &(this->font)); 

		this->UpdateScreen(this);
		
		this->RegisterAllKey(this);
		this->SetTimer(this, 2, 5000);
	}
//};

void DST_CreateOTCDownloadFailResetWin(SWinEventMsg event)
{
	DST_RemoveAllWindowExceptBasicWin();
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor 	= COTCDownloadFailResetWin_Destructor;
	pWin->OnTimer		= COTCDownloadFailResetWin_OnTimer;
	pWin->Show 			= COTCDownloadFailResetWin_Show;
	//  ȣ
	COTCDownloadFailResetWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);	
}


void DST_CreateOTCDownLoadingWin(SWinEventMsg event)
{
	if (DST_GetWin(WIN_UPDATE)) return;
	DST_RemoveAllWindowExceptBasicWin();
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor 	= COTCDownLoadingWin_Destructor;
	pWin->KeyInput 		= COTCDownLoadingWin_KeyInput;
	pWin->OnTimer		= COTCDownLoadingWin_OnTimer;
	pWin->OnMessage		= COTCDownLoadingWin_OnMessage;
	pWin->Show 			= COTCDownLoadingWin_Show;
	//  ȣ
	COTCDownLoadingWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);	
}



