#include "DST_Window.h"
#include "DST_WinManager.h"
#include "DST_CommonAPI.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"
#include "DST_ISDBT_ChannelTask.h"
#include "DST_DB.h"
#include "DST_ChannelTune.h"
#include "DST_SignalMonitor.h"



#if 0
____CFactoryWin___()
#endif
void DST_Tune(DS_U8 RF, DS_U16 program_number);

char *DST_GetBoardVersion(void);
char* DST_GetAppShortVersion();
void JST_RFUpdate(DS_U8 RF);



//class CFactoryWin : public CWindow
//{
//private:
	static DS_U16 CFactoryWin_Pos;
	static DS_U16 CFactoryWin_Top;
	static DS_U16 CFactoryWin_Select;
	static DS_U16 CFactoryWin_ListNum;
	static DS_U16 CFactoryWin_ItemNum;
	static int CFactoryWin_signal;
	static bool CFactoryWin_nPWR_pressed;
	static bool CFactoryWin_nCHUP_pressed;
	static bool CFactoryWin_nCHDN_Pressed;
	static int CFactoryWin_nRF[2];
	static int CFactoryWin_chUp;
	
//public:
void CFactoryWin_InitValues();

//	CFactoryWin(SWinEventMsg event):CWindow(event)
	void CFactoryWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "Factory");
		DST_g_bFactoryMode = true;
		CFactoryWin_InitValues();

		this->setFontStyle(this, 22, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_LEFT);
		this->rect.w = 576;
		this->rect.h = 384;
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight() - this->rect.h) / 2;

		this->SetTimeOut(this, 0);


		// ִ 
		DST_UI_SetMute(false);
		DST_UI_SetVolume(50);
		this->SetTimeOut(this, 0);
		// ʱȭ
		DST_EEPROM_SetMinRF(-1); // DST_EEPROM_SetNeedReset ʱȭ  ʱ⶧  ⺻ ش.
		DST_EEPROM_SetMaxRF(-1); // DST_EEPROM_SetNeedReset ʱȭ  ʱ⶧  ⺻ ش.
		DST_EEPROM_SetNeedReset(1);
		DST_DB_Sync();
		// ä Ʃ
		
		DST_Tune(CFactoryWin_nRF[CFactoryWin_chUp], 0); // ä4
		this->SetTimer(this, 1, 500);
	}

	void CFactoryWin_Destructor(CWindow *this)
	{
	
	}
	
	void CFactoryWin_InitValues()
	{		
		CFactoryWin_nPWR_pressed = false;
		CFactoryWin_nCHUP_pressed = false;
		CFactoryWin_nCHDN_Pressed = false;
		CFactoryWin_signal	= DST_GetSignalStrength();
		CFactoryWin_Pos = 0;
		CFactoryWin_Top = 0;
		CFactoryWin_Select = 0;
		CFactoryWin_ListNum = 3;
		CFactoryWin_ItemNum = 3;
		if (CFactoryWin_ItemNum < CFactoryWin_ListNum) CFactoryWin_ListNum = CFactoryWin_ItemNum;

		CFactoryWin_nRF[0] = DST_GetIndexByRFNumber(4);
		CFactoryWin_nRF[1] = DST_GetIndexByRFNumber(48);
		CFactoryWin_chUp = 0;
	}

//	virtual void OnTimer(char nID)
	void CFactoryWin_OnTimer(CWindow *this, char nID)
	{
		
//		DST_Tune(Select+14, 1, 1);
		switch (nID)
		{
			case 1:
				this->Show(this);
				break;
			case 2:
				this->KillTimer(this,2);
				CFactoryWin_nCHUP_pressed = false;
				CFactoryWin_nCHDN_Pressed = false;
				CFactoryWin_nPWR_pressed = false;				
				this->Show(this);
				break;
			case 3:
				this->KillTimer(this,3);
				CFactoryWin_nCHUP_pressed = false;
				CFactoryWin_nCHDN_Pressed = false;
				CFactoryWin_nPWR_pressed = false;	
				this->Show(this);
				break;
			case 4:
				this->KillTimer(this,4);				
				CFactoryWin_nCHUP_pressed = false;
				CFactoryWin_nCHDN_Pressed = false;
				CFactoryWin_nPWR_pressed = false;	
				this->Show(this);
				break;
			default:
				break;
	}
	}

//	virtual void Show()
	void CFactoryWin_Show(CWindow *this)
	{
		DS_U8 RF = 0;
		int i = 0;
		char strText[10][256];
		
		DST_GetAVState(&RF , 0, 0);
		
		this->RegisterAllKey(this); //  Ű 
		this->DrawBox32(this, 0, 0, this->rect.w, this->rect.h, CONV32_16(0x00000000));
		
		this->setFontStyle(this, 22, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_LEFT);
		for( i=0;i<10;i++)
		{
			memset(strText[i], 0, 256);
		}
		this->setFontStyle(this, 22, 0xFFFFFF00, ALIGN_MIDDLE, ALIGN_LEFT);
		sprintf(strText[0], " S/W version : %s", DST_GetAppShortVersion() );
		this->DrawText(this, 2, 2, this->rect.w, 30, strText[0], &(this->font));
		this->setFontStyle(this, 22, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_LEFT);

		sprintf(strText[1], " H/W version : %s", DST_GetBoardVersion());
		this->DrawText(this, 2, 32, this->rect.w, 30, strText[1], &(this->font));

		sprintf(strText[2], " FrontEnd : Broadcom" );
		this->DrawText(this, 2, 62, this->rect.w, 30, strText[2], &(this->font));

		CFactoryWin_signal	= DST_GetSignalStrength();
		sprintf(strText[3], " Signal Strength : %d ", CFactoryWin_signal);
		this->FontSetColor(this, CONV32_16((CFactoryWin_signal > 28 && DST_g_Lock == 1) ? 0xFF00FF00 : 0xFFFF0000));
		this->DrawText(this, 2, 92, this->rect.w, 30, strText[3], &(this->font));
		
		this->setFontStyle(this, 22, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_LEFT);

		sprintf(strText[4], " RF : %d", DST_GetFrequencyNumberbyIndex(RF));
		this->DrawText(this, 2, 122, this->rect.w, 30, strText[4], &(this->font));
		
		sprintf(strText[5], " Front Key Test :  ");
		this->DrawText(this, 2, 152, this->rect.w, 30, strText[5], &(this->font));
		
		this->setFontStyle(this, 22, 0xFF000000, ALIGN_MIDDLE, ALIGN_CENTER);
		
		sprintf(strText[6], "UP");
		this->DrawBox32(this, 69, 192, 100, 40, CONV32_16(CFactoryWin_nCHUP_pressed ? 0xFFFF0000 : 0xFFFFFFFF));
		this->DrawText(this, 69, 192, 100, 40, strText[6], &(this->font));
		

		sprintf(strText[7], "DOWN");
		this->DrawBox32(this, 238, 192, 100, 40, CONV32_16(CFactoryWin_nCHDN_Pressed ? 0xFFFF0000 : 0xFFFFFFFF));
		this->DrawText(this, 238, 192, 100, 40, strText[7], &(this->font));

		sprintf(strText[8], "POWER");
		this->DrawBox32(this, 407, 192, 100, 40, CONV32_16(CFactoryWin_nPWR_pressed ? 0xFFFF0000 : 0xFFFFFFFF));
		this->DrawText(this, 407, 192, 100, 40, strText[8], &(this->font));
		

		
		this->setFontStyle(this, 22, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_LEFT);
		sprintf(strText[9], " 1.CH_UP  7.RF UPDATE  " );
		this->DrawText(this, 2, 344, this->rect.w, 30, strText[9], &(this->font));
	}

	
//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CFactoryWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch(key)
		{
			case VK_FAC_CANCEL:
			case VK_1:
			case VK_FAC_1:
				DST_g_bUseAirFreq = true;

				CFactoryWin_chUp = (CFactoryWin_chUp+1)%2;
				DST_UI_ChannelTune(CFactoryWin_nRF[CFactoryWin_chUp], 0);
				this->SetTimer(this, 2, 300);
				break;
			case VK_FAC_7:
			case VK_7:
				DST_g_bUseAirFreq = true;
				JST_RFUpdate(DST_GetIndexByRFNumber(18)); // RF 18 RF Ʈ ļ
				DST_Printf("Enter RF Update Mode\n");
				DST_CreateWin(WIN_RF_UPDATE, 0, 0, 0, 0, 0); // RF Ʈ  
				break;
			case VK_KEY_UP:
				CFactoryWin_nCHUP_pressed = true;
				CFactoryWin_nCHDN_Pressed = false;
				CFactoryWin_nPWR_pressed = false;
				this->Show(this);
				this->SetTimer(this, 2, 100);
				break;
			case VK_KEY_DN:
				CFactoryWin_nCHUP_pressed = false;
				CFactoryWin_nCHDN_Pressed = true;
				CFactoryWin_nPWR_pressed = false;
				this->Show(this);
				this->SetTimer(this, 3, 100);
				break;
			case VK_KEY_PWR:
				CFactoryWin_nCHUP_pressed = false;
				CFactoryWin_nCHDN_Pressed = false;
				CFactoryWin_nPWR_pressed = true;
				this->Show(this);
				this->SetTimer(this, 4, 100);
				break;
		}
//		Close(); 忡 OSD   
	}
//};

void DST_CreateFactoryWin(SWinEventMsg event)
{
	DST_RemoveAllWindowExceptBasicWin();
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor	= CFactoryWin_Destructor;
	pWin->KeyInput		= CFactoryWin_KeyInput;
	pWin->OnTimer		= CFactoryWin_OnTimer;
	pWin->Show			= CFactoryWin_Show;
	//  ȣ
	CFactoryWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);

}

