#ifndef __DST_USERINTERFACE_H__
#define __DST_USERINTERFACE_H__

#include "DST_Common.h"
#include "DST_CCTask.h"

#define BANNER_NORMAL	 0
#define BANNER_DIGIT	 1

#define ASPECT_RATIO_WIDE    0
#define ASPECT_RATIO_NORMAL 1
#define ASPECT_RATIO_ZOOM    2

#define SM_GOOD_SIGNAL  		0
#define SM_WAIT_SIGNAL  		1
#define SM_WEAK_SIGNAL  		2
#define SM_NO_PROGRAM   		3
#define SM_AUDIO_ONLY   		4

typedef enum
{
	MN_AUTO_SCAN,
	MN_MANUAL_SCAN,
	MN_SIGNAL_METER,
	MN_AV_DISPLAY_MODE,
	MN_AV_AUDIO_PREF,
#if SUPPORT_CHANNEL_EDIT
	MN_CHANNEL_EDIT,
#endif
	MN_AV_VI,
	MN_CC_DISPLAY,
	MN_SLEEP_TIMER,
	MN_AV_PREFERRED_CONN,
	MN_FACTORY_RESET,
	MN_STB_INFO,
	MN_MAX_NUM
}	MainMenuLists;

typedef enum
{
	DISPLAY_MODE_WIDE,
	DISPLAY_MODE_NORMAL,
	DISPLAY_MODE_ZOOM,
	DISPLAY_MODE_MAX_NUM
}	DisplayModeLists;

typedef enum
{
	PREFERRED_CONN_LINE_OUT,
	PREFERRED_CONN_CH34,
	PREFERRED_CONN_MAX_NUM
}	PreferredConnLists;

typedef enum
{
	SLEEP_TIMER_OFF,
	SLEEP_TIMER_15M,
	SLEEP_TIMER_30M,
	SLEEP_TIMER_60M,
	SLEEP_TIMER_120M,
	SLEEP_TIMER_MAX_NUM
}	SleepTimerLists;

#if 0
____Channel_UI___()
#endif

// ä ٿ Լ
void DST_UI_ChannelUpDn(bool bUp);

// ä Ʃ Ѵ.TUNE_MODE_AUTO
// void DST_UI_ChannelTune(DS_U8 RF, DS_U16 program_number=0);
void DST_UI_ChannelTune(DS_U8 RF, DS_U16 program_number);

#if 0
____Settings_UI___()
#endif

void DST_UI_InitMenuCursor();

// Aspect 
DS_U8 DST_UI_GetAspect(void);

// Aspect 
void DST_UI_SetAspect(DS_U8 value);

// MTS Setting (0) ѱ (1) ܱ
DS_U8 DST_UI_GetMTS();

void DST_UI_SetMTS( DS_U8 nVal);

// VI Setting (0) Off (1) On
DS_U8 DST_UI_GetVI();

void DST_UI_SetVI( DS_U8 nVal);

// CC 
void DST_UI_SetCloseCaption(DS_U8 value);

// 0̸ RF3 1̸ RF4
DS_U8 DST_UI_GetCh34(void);

void DST_UI_SetCh34(DS_U8 bVal);
	
#if 0
____Volum_UI___()
#endif

//  
DS_U8 DST_UI_GetVolume(void);

//  
void DST_UI_SetVolume(DS_U8 value);

// Ʈ 
bool DST_UI_GetMute(void);

// Ʈ 
void DST_UI_SetMute(bool bVal);

#if 0
____Info_Banner_UI___()
#endif

//    HD ΰ?
bool DST_UI_GetHDInfo(void);

//  CC ֱⰡ Ѱ?
bool DST_UI_GetCCInfo(void);

#if SUPPORT_CHANNEL_EDIT
//  ä   Ȯ
void DST_UI_SetChannelEditEnable(DS_U32 ienable);

#endif

#if 0
____EPG_UI___()
#endif

//  ä äιȣ ̸ ´.
// ȯ true̸ äθʿ ִ ä false  ä
// chNum ȭ鿡 ǥ ä ȣ
// chName ȭ鿡 ǥ ä ̸
// num ڷ  ä ȣ
// Է 迭  chNum 20 chName 21
//bool DST_UI_GetCurrentChannelInfo(char* chNum, DS_U32* chName, int *num);
//bool DST_UI_GetCurrentChannelInfo2(char* chNum, DS_U32* chName, int *num);
int DST_GetCurrentChannelIndex2(void);

// äιȣ ä̸
// Է 迭  40
int DST_UI_GetCurrentChannelInfo(DS_U32 *chInfo);

// ð ڿ ȯѴ.
int DST_UI_GetTimeString(int hour, int min, DS_U16* timeInfo);

// ļ ̺ 
int DST_GetFreqCount();
// ε Էϰ ļ ȣ ޴´.
DS_U16 DST_GetFrequencyNumberbyIndex(int index);
// ε Էϰ MHz  ļ ޴´.
DS_U16 DST_GetMHzFrequencybyIndex(int index);
// ļ ȣ Էϰ ε  ޴´.
int DST_GetIndexByRFNumber(int rf_number);
// MHz ļ Էϰ ε  ޴´.
int DST_GetIndexByMHzFrequency(int MHz);

#endif //__DST_USERINTERFACE_H__

