#include "DST_WinManager.h"
#include "DST_ChannelTune.h"
#include "DST_SignalMonitor.h"

#include "DST_DataStrings.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"

#include "DST_ISDBT_ChannelTask.h"
#include "DST_ChannelTune.h"
#include "DST_DB.h"
#include "DST_DB_Engine.h"
#include "DST_MemoryDB.h"

//class CAutoSearchWin : public CWindow
//{
//private:
	static int CAutoSearchWin_m_nState;
	static int CAutoSearchWin_m_nRF; // ĵ ġ
	static CHANNEL_DISPLAY CAutoSearchWin_ch[4];
	static DS_U8 CAutoSearchWin_nAutoSearchMode;
	static int CAutoSearchWin_nChCount[DB_CHANNEL_DB_MAX];
	static bool CAutoSearchWin_bLockTimeOut;
	static bool CAutoSearchWin_bPSIPTimeOut;
	static bool CAutoSearchWin_bReceiveTVCT; 
	static bool CAutoSearchWin_bReceivePMT;
	static int    nPrevChannelCount = 0;
	static bool CAutoSearchWin_bCanceled; 
	static DS_U16 CAutoSearchWin_g_nPos;
	static DS_U16 CAutoSearchWin_g_nTop;
	static DS_U16 CAutoSearchWin_mainSelect;
	static DS_U16 CAutoSearchWin_mainListNum;
	static DS_U16 CAutoSearchWin_mainItemNum;
//public:
void CAutoSearchWin_InitValues();

//	CAutoSearchWin(SWinEventMsg event):CWindow(event)
	void CAutoSearchWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "AutoSearch");
		CAutoSearchWin_bCanceled = false;
		CAutoSearchWin_bPSIPTimeOut = false; 
		CAutoSearchWin_bLockTimeOut = false; 
		CAutoSearchWin_bReceiveTVCT = false;
		CAutoSearchWin_bReceivePMT = false;
		
		CAutoSearchWin_nAutoSearchMode = 1; // 0 Ʈ 1 ĵ
		CAutoSearchWin_InitValues();
		
//		DST_Printf("nAutoSearchMode = %d\n", nAutoSearchMode);
		this->rect.w = DST_GetImageWidth(auto_scan_back);
		this->rect.h = DST_GetImageHeight(auto_scan_back);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight()- this->rect.h) / 2;
		
		this->RegisterAllKey(this);
		this->RegisterKey(this, VK_PWR, false, 0, 0);
		this->RegisterKey(this, VK_KEY_PWR, false, 0, 0);
		
		this->SetTimeOut(this, 0);
		CAutoSearchWin_m_nState = 0; // ĵ 
		CAutoSearchWin_m_nRF = DST_DB_GetUnexceptedFirstRF();
		memset(CAutoSearchWin_ch, 0, sizeof(CAutoSearchWin_ch));
		memset(CAutoSearchWin_nChCount, 0, sizeof(CAutoSearchWin_nChCount));

		if(DST_DB_GetChannelCount() == 0 || event.data[2]) this->KeyInput(this, VK_OK, false);
//		if(event.data[3]) this->KeyInput(this, VK_OK, false);  //äνĵ Ű  
	}

	
	void CAutoSearchWin_Destructor()
	{
		if(DST_GetWin(WIN_ERROR)) DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL ,0, 0, 0);
	}
	
	void CAutoSearchWin_InitValues()
	{
		CAutoSearchWin_mainItemNum = 2;
		CAutoSearchWin_g_nTop = 0;
		CAutoSearchWin_g_nPos = 0;
		CAutoSearchWin_mainSelect = CAutoSearchWin_nAutoSearchMode;
		
		CAutoSearchWin_mainListNum = 2;
		if (CAutoSearchWin_mainItemNum < CAutoSearchWin_mainListNum) CAutoSearchWin_mainListNum = CAutoSearchWin_mainItemNum;
		
		InitItemValues(CAutoSearchWin_mainListNum, CAutoSearchWin_mainSelect, &CAutoSearchWin_g_nTop, &CAutoSearchWin_g_nPos);
	}
	
	void CAutoSearchWin_AddChList(int rf, int major, int minor, char* name)
	{
		int i = 0;
		int nPos = 4;
		for ( i = 0; i < 4; i++)
		{
			if (strlen(CAutoSearchWin_ch[i].num) != 0) continue;
			nPos = i;
			break;
		}
		if (nPos > 3) 
		{
			nPos = 3;
			memcpy(&CAutoSearchWin_ch[0], &CAutoSearchWin_ch[1], sizeof(CHANNEL_DISPLAY)* 3);
		}
		if (minor == 0)
		{
			sprintf(CAutoSearchWin_ch[nPos].num, "%d(%d)", major, DST_GetFrequencyNumberbyIndex(rf));
		}
		else
		{
			sprintf(CAutoSearchWin_ch[nPos].num, "%d-%d(%d)", major, minor, DST_GetFrequencyNumberbyIndex(rf));
		}
		strcpy((char*)CAutoSearchWin_ch[nPos].name, (char*)name);
	}
	
	void CAutoSearchWin_SearchChDB(int RF)
	{
		// DST_Printf("RF = %d\n", RF);
		int i = 0;
		CAutoSearchWin_nChCount[RF] = 0;
		DBLock(true);
		for (i=0; i < DB_CHANNEL_DB_MAX; i++)
		{
			if (db_channel_db[i].program_number == 0) continue;
			if (db_channel_db[i].rf  != RF) continue;
			CAutoSearchWin_nChCount[RF]++;
			CAutoSearchWin_AddChList(RF, db_channel_db[i].major, db_channel_db[i].minor, db_channel_db[i].name);
		}
		DBLock(false);
	}
	
	void CAutoSearchWin_DrawProgressBar(CWindow *this, int x, int y, int w, int range, int pos)
	{
		// DST_Printf("range = %d pos = %d\n", range, pos);
		int position = (w*pos)/(range);
		int i = 0;
		for ( i = x; i < x+position; i++)
		{
			this->DrawImage(this, i, y, prog_y,true);
		}
	}	

	DS_U16* CAutoSearchWin_GetString(int index)
	{
		switch(index)
		{
			case 0: return pz_Scan_Update[OSD_Lang];
			case 1: return pz_Scan_Start[OSD_Lang];
			default: break;
		}
		return 0;
	}	
	
	// nState == 0; //   ư 
	// nState == 1; //    ư
	// nState == 2; //     ư
	void CAutoSearchWin_Draw(CWindow *this, int nState, int nRF)
	{
		int i = 0;
		int nTotalCount = 0;
		int nProg = 0;
		
		// 
		this->DrawImage(this, 0, 0, auto_scan_back, false);
		// ŸƲ
		this->setFontStyle(this, 20,0xC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
		// ׸ ̸  äιȣ RF ä̸ 
		this->DrawTextUni(this, 26, 19,  126, 24, pz_Scan_ChannelNumber[OSD_Lang], &(this->font));
		this->DrawTextUni(this, 180, 19, 208, 24, pz_chName[OSD_Lang], &(this->font));


		// ư ׸
		
//		this->setFontStyle(this, 19,0xC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
//		this->DrawImage(this, 390, 12, newcon2_gui_depth3_button_small_selected,true);
//		this->DrawTextUni(this, 390, 12, DST_GetImageWidth(newcon2_gui_depth3_button_small_selected), 38, pz_Scan_Update[OSD_Lang], &(this->font));
		this->setFontStyle(this,20,0xFFFFFF,ALIGN_MIDDLE,ALIGN_CENTER);

		this->DrawImage(this, 416, 16, Button_h,true);
		this->DrawTextUni(this, 416, 16, DST_GetImageWidth(Button_h),  DST_GetImageHeight(Button_h), (nState==1)?pz_Stop[OSD_Lang]:CAutoSearchWin_GetString(CAutoSearchWin_mainSelect), &(this->font));
		
		this->setFontStyle(this, 20,0xC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
		// ׸ ǥ
		i = 0;
		for (i=0; i < 4; i++)
		{
			if (strlen(CAutoSearchWin_ch[i].num) == 0) continue;
			DS_U32* strText32 = DST_UTF82Uni((DS_U8*)CAutoSearchWin_ch[i].name); // ȣ ʿ ޸ 
			// ä ȣ , RF
			// RF
			this->DrawText(this, 26, 28+(i+1)*35,	126, 24,  CAutoSearchWin_ch[i].num, &(this->font));
			// ä ̸
			this->DrawText32(this, 180, 28+(i+1)*35, 208, 24, strText32, &(this->font));
		}
		// 
		switch (nState)
		{
			case 0: nProg = 0; break;
			case 1: nProg = nRF - DST_MinRF() + 1 - DST_DB_GetExceptRFCount(); break;
			case 2: nProg = DST_MaxRF() - DST_MinRF()+1 - DST_DB_GetExceptRFCount(); break;
			default: break;
		}
		// DST_Printf("nProg = %d\n", nProg);
		
		CAutoSearchWin_DrawProgressBar(this, 34, 210, 346,  DST_MaxRF() - DST_MinRF() +1-DST_DB_GetExceptRFCount(), nProg);
				
		// Ȳ 
		// 5 channels found. searching...
		i = 0;
		for ( i = 0; i <= nRF; i++) nTotalCount+=CAutoSearchWin_nChCount[i];

		if( CAutoSearchWin_m_nState == 0 ) 
		{
			this->DrawTextUni(this, 404, 166, 130, 29, pz_Scan_Ready[OSD_Lang], &(this->font));
			this->UpdateScreen(this);
			return;
		}
		char _strTextNum[20];
		sprintf(_strTextNum, "RF : %d", DST_GetFrequencyNumberbyIndex(nRF));
		DS_U16 _strText16[64];
		str2uni(_strText16, _strTextNum);
		if(CAutoSearchWin_m_nState == 1)
		{
			this->DrawTextUni(this, 404, 106, 130, 29, pz_Scan_Searching[OSD_Lang], &(this->font));
			this->DrawTextUni(this, 404, 136, 130, 29, _strText16, &(this->font));
		}
		if(nTotalCount == 0 &&CAutoSearchWin_m_nState == 1)
		{
			
		}
		else
		{
//			if (nTotalCount)
//			{

				char strTextNum[20];
				sprintf(strTextNum, " %d", nTotalCount);
				DS_U16 strText16[64];
				str2uni(strText16, strTextNum);
				strcat16(strText16, pz_Scan_ChannelFound[OSD_Lang]);
				this->DrawTextUni(this, 404, 166, 130, 29, strText16, &(this->font));
				this->DrawTextUni(this, 404, 196, 130, 29, pz_Scan_ChannelFound_P1[OSD_Lang], &(this->font));
//			}
		}
		
		this->UpdateScreen(this);
		
	}	
	void CAutoSearchWin_Scan(int nRF)
	{
		if (CAutoSearchWin_bCanceled) return;
		JST_Scan(nRF);
		CAutoSearchWin_m_nState = 1; //ĵ
		CAutoSearchWin_m_nRF = nRF;
	}

	void CAutoSearchWin_ScanComplete(CWindow *this)
	{
		DST_DB_TuneFirstChannel();
		CAutoSearchWin_m_nState = 2;	// ĵ 
		CAutoSearchWin_Draw(this, CAutoSearchWin_m_nState, CAutoSearchWin_m_nRF);
		this->SetTimeOut(this, 5);
		
//		this->KeyInput(this, VK_OK, false);
		
	}	

//	virtual void OnMessage(SWinEventMsg event)
	void CAutoSearchWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				this->Close(this);
				break;
				
			case WM_CT_MSG:
				switch (event.data32[0])
				{
					case CT_STOPPED:
						CAutoSearchWin_m_nState = 2;
						CAutoSearchWin_Draw(this, CAutoSearchWin_m_nState, CAutoSearchWin_m_nRF);
						CAutoSearchWin_ScanComplete(this);
						break;
						
					case CT_SCAN_START:
						CAutoSearchWin_Draw(this, CAutoSearchWin_m_nState, event.data32[1]);
						CAutoSearchWin_bPSIPTimeOut = false; // LOCK ȵǰų PSIP ޾Ƽ ŸӾƿ  
						CAutoSearchWin_bLockTimeOut = false; // LOCK ȵǰų PSIP ޾Ƽ ŸӾƿ  
						CAutoSearchWin_bReceiveTVCT = false; // PSIP ޾Ҵ.
						CAutoSearchWin_bReceivePMT = false; //PMT ޾Ҵ. VCT  ä  ִ
						nPrevChannelCount = 0;
						DBLock(true);
						{
							int i;
							for (i = 0; i < DB_CHANNEL_DB_MAX; i++) 
							{
								if (db_channel_db[i].program_number == 0) continue;
								if (db_channel_db[i].rf != event.data32[1]) continue;
								nPrevChannelCount++;
								break;
							}
						}
						DBLock(false);
						break;
					
					case CT_SCAN_PSIP_WAIT:
						// DST_Printf("CT_SCAN_PSIP_WAIT %d %d %d\n", (int)event.data32[1], (int)event.data32[2], (int)event.data32[3]);
						if ((int)event.data32[1] != CAutoSearchWin_m_nRF)
						{
							// DST_Printf("event.data32[1] = %d CAutoSearchWin_m_nRF = %d\n", event.data32[1], CAutoSearchWin_m_nRF);
							break;
						}
						if (CAutoSearchWin_bReceiveTVCT == true) break;
						if (CAutoSearchWin_bPSIPTimeOut == true) break;
						if (event.data32[2] < 7000) break;
						// DST_Printf("CT_SCAN_PSIP_WAIT timeout\n");
						CAutoSearchWin_bPSIPTimeOut = true;
						
						//  ä .
						if (CAutoSearchWin_bReceivePMT == false && CAutoSearchWin_bReceiveTVCT == false)
						{
							JST_DB_Del(CAutoSearchWin_m_nRF);
						}
						 if (CAutoSearchWin_bReceivePMT == true && CAutoSearchWin_bReceiveTVCT == false ) // PSIP äϼ ִ.
						 {
						 	CAutoSearchWin_SearchChDB(event.data32[1]);
						}
						if (event.data32[1] >= DST_DB_GetUnexceptedLastRF())
						{
							CAutoSearchWin_ScanComplete(this);
						}
						else
						{
							//CAutoSearchWin_Scan(event.data32[1]+1);
							CAutoSearchWin_Scan(DST_DB_GetNextUnexceptRF(event.data32[1]));
						} 
						break;
							
					case CT_SCAN_LOCK_WAIT:
						//DST_Printf("CT_SCAN_LOCK_WAIT %d %d %d %d\n", 
						//		(int)event.data32[1], (int)event.data32[2], (int)event.data32[3], (int)event.data32[4]);
						if ((int)event.data32[1] != CAutoSearchWin_m_nRF)
						{
							// DST_Printf("event.data32[1] = %d CAutoSearchWin_m_nRF = %d\n", event.data32[1], CAutoSearchWin_m_nRF);
							break;
						}
						if (CAutoSearchWin_bReceiveTVCT == true) break;
						if (CAutoSearchWin_bReceivePMT == true) break;
						if (CAutoSearchWin_bLockTimeOut == true) break;
						if (event.data32[4] < 20) // POWER LEVEL 20   ȣ °ɷ ϰ ٷ .
						{
							if (event.data32[2] < 200) break; 
						}
						else if (event.data32[4] < 27) // POWER LEVEL 27   ̾ȣ ǴϿ 2.2 ٸ.
						{
							if (event.data32[2] < 2200) break; 
						}
						else // Ϲ  1300ms ٸ.
						{
							if (event.data32[2] < 1300) break; 
						}
						if (nPrevChannelCount > 0) //  ä ִ ļ 5ʱ ٷ 
						{
							if (event.data32[2] < 5000) break; 
						}
						if (event.data32[3] > 0) break; // lock Ǿ ִٸ 
						// DST_Printf("CT_SCAN_LOCK_WAIT timeout\n");
						CAutoSearchWin_bLockTimeOut = true;
						
						//  ä .
						if (CAutoSearchWin_bReceivePMT == false && CAutoSearchWin_bReceiveTVCT == false) // 0 Ʈ 1 ĵ 2: ġ
						{
							JST_DB_Del(CAutoSearchWin_m_nRF);
						}
						if (CAutoSearchWin_bReceivePMT == true && CAutoSearchWin_bReceiveTVCT == false) // PSIP äϼ ִ.
						{
						 	CAutoSearchWin_SearchChDB(event.data32[1]);
						}
						if (event.data32[1] >= DST_DB_GetUnexceptedLastRF())
						{
							CAutoSearchWin_ScanComplete(this);
						}
						else
						{
							//CAutoSearchWin_Scan(event.data32[1]+1);
							CAutoSearchWin_Scan(DST_DB_GetNextUnexceptRF(event.data32[1]));
						} 
						break;
					
					case CT_SCAN_RECEIVE_TVCT:
#if CVCT_SUPPORT
					case CT_SCAN_RECEIVE_CVCT:
#endif
						// DST_Printf("CT_SCAN_RECEIVE_TVCT\n");
						if ((int)event.data32[1] != CAutoSearchWin_m_nRF)
						{
							// DST_Printf("event.data32[1] = %d CAutoSearchWin_m_nRF = %d\n", event.data32[1], CAutoSearchWin_m_nRF);
							break;
						}
						if (CAutoSearchWin_bReceiveTVCT == true) break;
//						if (CAutoSearchWin_bTimeOut == true) break;
						CAutoSearchWin_bReceiveTVCT = true;
						CAutoSearchWin_SearchChDB(event.data32[1]);
						if (event.data32[1] >= DST_DB_GetUnexceptedLastRF())
						{
							CAutoSearchWin_ScanComplete(this);
						}
						else
						{
							//CAutoSearchWin_Scan(event.data32[1]+1);
							CAutoSearchWin_Scan(DST_DB_GetNextUnexceptRF(event.data32[1]));
						} 
						break;
						
					case CT_SCAN_RECEIVE_PMT:
						// DST_Printf("CT_SCAN_RECEIVE_PMT\n");
						if ((int)event.data32[1] != CAutoSearchWin_m_nRF)
						{
							// DST_Printf("event.data32[1] = %d CAutoSearchWin_m_nRF = %d\n", event.data32[1], CAutoSearchWin_m_nRF);
							break;
						}
						// DST_Printf("CT_SCAN_RECEIVE_PMT %d %d %d\n", (int)event.data32[1], (int)event.data32[2], (int)event.data32[3]);
						CAutoSearchWin_bReceivePMT = true;
						break;
					case CT_SCAN_RECEIVE_PAT:
						// DST_Printf("CT_SCAN_RECEIVE_PAT\n");
						if ((int)event.data32[1] != CAutoSearchWin_m_nRF)
						{
							// DST_Printf("event.data32[1] = %d CAutoSearchWin_m_nRF = %d\n", event.data32[1], CAutoSearchWin_m_nRF);
							break;
						}
						break;
				}
				break;
		}
	}
	
//	virtual void Show(void)
	void CAutoSearchWin_Show(CWindow *this)
	{
		CAutoSearchWin_Draw(this, CAutoSearchWin_m_nState, CAutoSearchWin_m_nRF);
	}
	
//	virtual void KeyInput(unsigned char key, bool /*bRepeat*/)
	void CAutoSearchWin_KeyInput(CWindow *this, unsigned char key, bool bRepeat)
	{
		switch(key)
		{
//			case VK_UP:
//			case VK_DN:
//				if(m_nState==1) break;
//				if(key == VK_UP)
//					ItemIncrease(mainItemNum, 2, &g_nTop, &mainSelect, &g_nPos);
//				else
//					ItemDecrease(mainItemNum, 2, &g_nTop, &mainSelect, &g_nPos);
//				Draw(m_nState, m_nRF);
//				break;
			case VK_OK: 
				if(CAutoSearchWin_nAutoSearchMode == CAutoSearchWin_mainSelect && CAutoSearchWin_m_nState == 1)
				{
					CAutoSearchWin_bCanceled = true;
					JST_Stop();
					CAutoSearchWin_ScanComplete(this);			
				}
				else
				{
					this->SetTimeOut(this, 0);
					CAutoSearchWin_bCanceled = false;
					CAutoSearchWin_m_nRF = DST_DB_GetUnexceptedFirstRF();
					memset(CAutoSearchWin_ch, 0, sizeof(CAutoSearchWin_ch));
					memset(CAutoSearchWin_nChCount, 0, sizeof(CAutoSearchWin_nChCount));
					// nAutoSearchMode=mainSelect; ׻ ʱ ĵ̴.
					CAutoSearchWin_Scan(CAutoSearchWin_m_nRF);
					CAutoSearchWin_Draw(this, CAutoSearchWin_m_nState, CAutoSearchWin_m_nRF);
				}
				break;
			case VK_CANCEL:
			case VK_PREV_MENU:
				CAutoSearchWin_m_nState = 0;
				CAutoSearchWin_bCanceled = true;
				JST_Stop();
				CAutoSearchWin_ScanComplete(this);
				this->Close(this);
				break;
			case VK_CHANNEL_SEARCH:
			case VK_PREV:
			case VK_PREV_CH:
				CAutoSearchWin_m_nState = 0;
				CAutoSearchWin_bCanceled = true;
				JST_Stop();
				CAutoSearchWin_ScanComplete(this);
				if (this->GetParentWinID(this)) DST_CreateWin(this->GetParentWinID(this), 0, 0, 0, 0, 0);
				this->Close(this);
				break;

			case VK_MENU:
				CAutoSearchWin_m_nState = 0;
				CAutoSearchWin_bCanceled = true;
				JST_Stop();
				CAutoSearchWin_ScanComplete(this);
				DST_CreateWin(WIN_MAIN_MENU, WIN_NULL, 0 ,0, 0, 0);
				this->Close(this);
				break;
		}
	}
//};

void DST_CreateAutoSearchWin(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor 	= CAutoSearchWin_Destructor;
	pWin->KeyInput 		= CAutoSearchWin_KeyInput;
	pWin->OnMessage		= CAutoSearchWin_OnMessage;
	pWin->Show 			= CAutoSearchWin_Show;
	//  ȣ
	CAutoSearchWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}
