#include "DST_Window.h"
#include "DST_WinManager.h"
#include "DST_CommonAPI.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"
#include "DST_ISDBT_ChannelTask.h"
#include "DST_DB.h"
#include "DST_ChannelTune.h"
#include "DST_SignalMonitor.h"

#ifndef DSTAR
#include "DHL_OSAL.h"
#include "DHL_OSAL_Priv.h"
#include "bcmmemmgr.h"
#endif


#if 0
____CEngineerMenuWin___()
#endif

#define MAX_STR_COUNT 10

char* DST_GetAppShortVersion();
const char *DST_GetVendorInfo(void);
const char *DST_GetModelName(void);

//class CEngineerMenuWin : public CWindow
//{
//private:
//	
//public:
//	CEngineerMenuWin(SWinEventMsg event):CWindow(event)
	void CEngineerMenuWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "EngineerMenu");
		this->setFontStyle(this, 22, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_LEFT);
		this->rect.w = 576;
		this->rect.h = 384;
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight() - this->rect.h) / 2;

		this->SetTimeOut(this, 0);

		this->SetTimer(this, 1, 1000);
	}

	void CEngineerMenuWin_Destructor(CWindow *this)
	{
		if(DST_g_SignalState == SM_AUDIO_ONLY) DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL ,0, 0, 0);
	}
	
//	virtual void OnTimer(char nID)
	void CEngineerMenuWin_OnTimer(CWindow *this, char nID)
	{
		this->Show(this);
	}

//	virtual void Show(WinID id)
	void CEngineerMenuWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_MAIN_MENU:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
			case WIN_PASSWD_CHANGE:
			case WIN_PASSWD_CHECK:
			case WIN_PASSWD_CONFIRM:
			case WIN_AGE_RATING:
				this->Close(this);
				break;
			default:
				break;
		}
	}

//	virtual void Show()
	void CEngineerMenuWin_Show(CWindow *this)
	{
		this->RegisterKey(this, VK_CANCEL, true, 0, 0);
		this->RegisterKey(this, VK_PREV, true, 0, 0);
		this->RegisterKey(this, VK_PREV_CH, true, 0, 0);
		this->RegisterKey(this, VK_PREV_MENU, true, 0, 0);
		this->RegisterKey(this, VK_1, true, 0, 0);
		this->RegisterKey(this, VK_2, true, 0, 0);
		this->RegisterKey(this, VK_3, true, 0, 0);
		this->RegisterKey(this, VK_4, true, 0, 0);
		this->RegisterKey(this, VK_5, true, 0, 0);
		this->RegisterKey(this, VK_6, true, 0, 0);
		this->RegisterKey(this, VK_7, true, 0, 0);
		this->RegisterKey(this, VK_8, true, 0, 0);
		this->RegisterKey(this, VK_9, true, 0, 0);
		this->RegisterKey(this, VK_0, true, 0, 0);
		
		this->DrawBox32(this, 0, 0, this->rect.w, this->rect.h, CONV32_16(0xAA262626));
		this->setFontStyle(this, 15, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_LEFT);
		//((CT_AV_START)
		DS_U8 RF = 0;
		DS_U16 SourceID = 0;
//		DS_U8 tuneMode = 0;
//		DS_U8 state = 0;

		//(CT_AV_INFO)
		DS_U32 PCR = 0;
		DS_U32 vPid = 0;
		DS_U32 aPid = 0;
		DS_U32 vType = 0;
		DS_U32 aType = 0;

		//(CT_SIGNAL_INFO)
		bool bLock = 0;
		int ss = 0;
		int power = 0;
		int snr = 0;

		//(CT_VIDEO_RESOLUTION)
		DS_U16 vWidth = 0;
		DS_U16 vHeight = 0;
		DS_U16 fps = 0;
		bool bInterlace = false;
		bool bWide = false;

		//(CT_SIGNAL)
		bool vAlive = false;
		bool aAlive = false;

		//MEMORY
//		DS_U32 total_size = 0;
//		DS_U32 free_size = 0;
//		DS_U32 largest_free_size = 0;

		int i = 0;
#ifndef DSTAR

		//DHL_OS_HEAP_STATUS status;
		//DHL_OS_GetHeapStatus(&status);
		//total_size = status.total_size;
		//free_size = status.free_size;
		//largest_free_size = status.largest_free_size;
#endif
		extern DS_U8 origin_power_level;
		DST_GetAVState(&RF, 0, &SourceID);
		DST_GetAVInfo(&PCR, &vPid, &aPid, &vType, &aType);
		DST_GetSignalInfo(&bLock, &ss, &power, &snr);
		DST_GetVideoSize(&vWidth, &vHeight, &fps, &bInterlace, &bWide);
		DST_GetAVAliveInfo(&vAlive, &aAlive);

		char strText[MAX_STR_COUNT][256];
		for( i=0;i<MAX_STR_COUNT;i++)
		{
			memset(strText[i], 0, 256);
		}

		this->DrawText(this, 2, 2, this->rect.w, 20, (char*)"**** STATUS ****", &(this->font));	

		sprintf(strText[0], "S/W Version: %s %s, Compile Time : %s %s ",DST_GetModelName(), DST_GetAppShortVersion(),  __DATE__, __TIME__);
		this->DrawText(this, 2, 22, this->rect.w, 20, strText[0], &(this->font));

#ifdef DSTAR
#else
		sprintf(strText[1], "FrontEnd: %s, SNR: %ddB, PowerLevel: %ddBmV", bLock?(char*)"lock":(char*)"unlock", snr/256, ((origin_power_level)/2)-60);
#endif
		this->DrawText(this, 2, 42, this->rect.w, 20, strText[1], &(this->font));

		char chNum[20];
		DS_U32 chName[TEXT_LENGTH_MAX];
		int num = 0;
		if (DST_DB_GetCurrentChannelInfo(chNum, chName, &num) == false) sprintf(chNum, "%d ", num); // RF ȣ		

		DS_U32 tmpStr[256] = {0,};
		sprintf(strText[2], "Tuning: %s, [", chNum);
		str232(tmpStr,strText[2]);
		strcpy32(&tmpStr[strlen32(tmpStr)],chName);
		sprintf(strText[2], "], pva [0x%2X/0x%2X/0x%2X]", (unsigned int)PCR, (unsigned int)vPid, (unsigned int)aPid);
		str232(&tmpStr[strlen32(tmpStr)],strText[2]);
		this->DrawText32(this, 2, 62, this->rect.w, 20, tmpStr, &(this->font));

		sprintf(strText[3], "               video alive [%s], audio alive [%s]", vAlive?(char *)"true":(char *)"false", aAlive?(char *)"true":(char *)"false");
		this->DrawText(this, 2, 82, this->rect.w, 20, strText[3], &(this->font));
		

		DS_U16 avStr[256] = {0,};
		
		char strFPS[10] = "N/A";
		switch (fps)
		{
			case 1:	strcpy(strFPS, "23.976"); break;
			case 2: strcpy(strFPS, "24"); break;
			case 3: strcpy(strFPS, "25"); break;
			case 4: strcpy(strFPS, "29.97"); break;
			case 5: strcpy(strFPS, "30"); break;
			case 6: strcpy(strFPS, "50"); break;
			case 7: strcpy(strFPS, "59.94"); break;
			case 8: strcpy(strFPS, "60"); break;
		}
		
		if(vWidth==0)
			sprintf(strText[4], "AV: source( %dx%d %s %sHz %s ), output 480i, audio: ", (int)vWidth, (int)vHeight, (char *)"(null)", strFPS, (char *)"(null)");
		else
			sprintf(strText[4], "AV: source( %dx%d %s %sHz %s ), output 480i, audio: ", (int)vWidth, (int)vHeight, bInterlace?(char*)"i":(char*)"p", strFPS, bWide?(char*)"wide":(char*)"normal");
		str2uni(avStr,strText[4]);
		strcpy16(&avStr[strlen16(avStr)], DST_UI_GetMTS()==0?pz_MTS_Main[OSD_Lang]:pz_MTS_Sub[OSD_Lang]);
		this->DrawTextUni(this, 2, 102, this->rect.w, 20, avStr, &(this->font));

		char vTypeStr[20] = {0,};
		char aTypeStr[20] = {0,};
		switch (vType) // ABNT NBR 15602-3:2007 Table 5 ? Strem_type
		{
			case 0x01: sprintf(vTypeStr,(char *)"MPEG1"); break;
			case 0x02: sprintf(vTypeStr,(char *)"MPEG2"); break;
			case 0x1B: sprintf(vTypeStr,(char *)"AVC(H.264)"); break;
		};
		switch (aType) // ABNT NBR 15602-3:2007 Table 5 ? Strem_type
		{
			case 0x03: sprintf(aTypeStr,(char *)"MPEG1"); break;
			case 0x04: sprintf(aTypeStr,(char *)"MPEG2"); break;
			case 0x0F: sprintf(aTypeStr,(char *)"AAC(ADTS)"); break;
			case 0x11: sprintf(aTypeStr,(char *)"AAC(LATM)"); break;
		};

		sprintf(strText[5], "AV format: video %s[0x%2X], audio %s[0x%2X]", vTypeStr, (unsigned int)vType, aTypeStr, (unsigned int)aType);
		this->DrawText(this, 2, 122, this->rect.w, 20, strText[5], &(this->font));	
#ifndef DSTAR
		extern bcm_heap_t *g_p_sdram_heap;
		sprintf(strText[6], "Largest unused block : %d bytes",mem_available(g_p_sdram_heap));
		this->DrawText(this, 2, 142, this->rect.w, 20, strText[6], &(this->font));	
#endif
		DS_U32 hour = 0, min = 0, sec = 0;
		DST_OS_GetRunTime(&hour, &min, &sec);
		sprintf(strText[7], "Running time: %02d:%02d:%02d, Channel Count; %d",(int)hour, (int)min, (int)sec, CT_ChMapCount());
		this->DrawText(this, 2, 162, this->rect.w, 20, strText[7], &(this->font));	

		
		this->DrawText(this, 2, 222, this->rect.w, 20, (char*)"**** commands ****", &(this->font));	
		this->DrawText(this, 2, 242, this->rect.w, 20, (char*)"1. show SQL database", &(this->font));	
		sprintf(strText[8], "2. swich on/off WeakSignal Mute :  [%s]", DST_g_WeakSignalMuteOff?(char*)"OFF":(char*)"ON");
		this->DrawText(this, 2, 262, this->rect.w, 20, strText[8], &(this->font));	
		sprintf(strText[9], "3. swich Only-Terrestrial-Broadcasting Searching Mode :  [%s]", DST_g_isAirOnly?(char*)"ON":(char*)"OFF");
		this->DrawText(this, 2, 262, this->rect.w, 20, strText[8], &(this->font));	

		this->DrawText(this, 2, 362, this->rect.w, 20, (char*)"[0..9] Select ", &(this->font));	


	}


//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CEngineerMenuWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch(key)
		{
			case VK_1:
				DST_Printf("Enter DB SQL Menu\n");
				DST_CreateWin(WIN_DEBUG_SQL, 0, 0, 0, 0, 0); // Ͼ  
				this->Close(this);
				break;
			case VK_2:
				DST_g_WeakSignalMuteOff = !DST_g_WeakSignalMuteOff;
				this->Show(this);
			case VK_3:
				DST_g_isAirOnly = !DST_g_isAirOnly;
				this->Show(this);
			case VK_4:
			case VK_5:
			case VK_6:
			case VK_7:
			case VK_8:
			case VK_9:
			case VK_0:
				break;
			case VK_CANCEL:
			case VK_PREV:
			case VK_PREV_MENU:
			case VK_PREV_CH:
			default:
				this->Close(this);
				if(DST_g_SignalState == SM_AUDIO_ONLY) DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL ,0, 0, 0);
				break;
		}
	}

//};

void DST_CreateEngineerMenuWin(SWinEventMsg event)
{
	DST_RemoveAllWindowExceptBasicWin();
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor	= CEngineerMenuWin_Destructor;
	pWin->KeyInput		= CEngineerMenuWin_KeyInput;
	pWin->OnTimer		= CEngineerMenuWin_OnTimer;
	pWin->ShowWindow	= CEngineerMenuWin_ShowWindow;
	pWin->Show			= CEngineerMenuWin_Show;
	//  ȣ
	CEngineerMenuWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}


