#include <stdio.h>
#include <stdlib.h>
#include <memory.h>

int nBlockSize = 4000;

static unsigned int  DHL_PsiAPI_CalculateCRC(const unsigned char *data, unsigned int len)
{
	static unsigned int crcTable[256];
	static bool bFirst=true;
	if (bFirst)
	{
		bFirst = false;
		for (int i=0; i<256; i++) {
			unsigned int crc = 0;
			for (int j=7; j>=0; j--) {
				if (((i >> j) ^ (crc >> 31)) & 1) crc=(crc<<1)^0x04C11DB7;
				else crc<<=1;
			}
			crcTable[i] = crc;
		}
	}
	unsigned int crc = 0xFFFFFFFF;
	for (int i = 0; i < len; ++i) crc = (crc << 8) ^ crcTable[(crc >> 24) ^ (*data++)];
	return crc;
}

// 184Ʈ Է 188 Ʈ 
void write_packet(FILE *fp, unsigned char *buff, int size, bool bFirst, int pid)
{
	//printf("write_packet size = %d\n", size);
	unsigned char packet[188];
	memset(packet, 0xFF, 188);
	packet[0] = 0x47; //Sync
	packet[1] = (bFirst ? 0x40 : 0x00) + (pid / 256); // payload unit start indicator + 0x1FF5
	packet[2] = pid % 256; // pid 0x1FF5
	static unsigned char g_continuity_counter[0x1FFF];
	packet[3] = 0x10 + (g_continuity_counter[pid]%16); // Adaptation field control + continuity counter
	g_continuity_counter[pid]++;
	memcpy(&packet[4], buff, size); //  
	fwrite(packet, 1, 188, fp); //  
}

void write_section(FILE *fp, unsigned char *buff, int size, int pid)
{
	//printf("write_section size = %d\n", size);
	for (int i = 0; i < size; i+=184)
	{
		write_packet(fp, &buff[i], (i+184 < size) ? 184 : size-i, i==0, pid);
	}
}

void write_table(FILE *fp, unsigned char *buff, int size, int pid, unsigned char table)
{
	//printf("write_table size = %d\n", size);
	unsigned char section[5000];
	memset(section, 0xFF, 5000);
	int packet_length = size+4;
	section[0] = 0x00; 
	section[1] = table; // table id
	section[2] = 0x80 + (packet_length/256); // section syntax indicator
	section[3] = packet_length % 256; // length
	memcpy(&section[4], buff, size);
	// CRC 
	unsigned int crc = DHL_PsiAPI_CalculateCRC(&section[1], size+3);
	section[packet_length+0] = (crc >> 24) & 0xFF;
	section[packet_length+1] = (crc >> 16) & 0xFF;
	section[packet_length+2] = (crc >> 8) & 0xFF;
	section[packet_length+3] = (crc) & 0xFF;	
	write_section(fp, section, packet_length + 4, pid);
}

int get_block_count(int size)
{
	return (size + nBlockSize-1) / nBlockSize;
}

void write_ddb(FILE *fp, unsigned char *buff, int size, int pid, int nBlockNumber)
{	
	if (nBlockNumber >= get_block_count(size)) nBlockNumber = nBlockNumber % get_block_count(size);
	unsigned char *p = &buff[nBlockSize * nBlockNumber];
	int nBuffSize = nBlockSize;
	if ((nBlockSize+1) * nBlockNumber > size) nBuffSize = size-(nBlockSize * nBlockNumber);
	
	unsigned char tmp[4096];
	memset(tmp, 0xFF, 4096);
	tmp[7] = 0x10;
	tmp[8] = 0x03;
	tmp[14] = 0;
	tmp[15] = (nBuffSize+6) /256;
	tmp[16] = (nBuffSize+6) %256;
	tmp[21] = (nBlockNumber) /256;
	tmp[22] = (nBlockNumber) %256;
	memcpy(&tmp[23], p, nBuffSize);
	
	write_table(fp, tmp, nBuffSize+23, pid, 0x3C);
}

void write_dii(FILE *fp, int size, int pid)
{
		unsigned char tmp[100];
		memset(tmp, 0x00, 100);
		tmp[7] = 0x10;
		tmp[8] = 0x02;
		tmp[14] = 0;
		tmp[21] = nBlockSize / 0x100;
		tmp[22] = nBlockSize % 0x100;
		tmp[39] = size / 0x1000000;
		tmp[40] = (size % 0x1000000) / 0x10000;
		tmp[41] = (size % 0x10000) / 0x100;
		tmp[42] = size % 256;
		write_table(fp, tmp, 100, pid, 0x3B);
}

void write_dummy(FILE *fp)
{
	unsigned char packet[188];
	memset(packet, 0x00, 188);
	packet[0] = 0x47; //Sync
	packet[1] = 0x1F;
	packet[2] = 0xFF;
	packet[3] = 0x10;
	fwrite(packet, 1, 188, fp); //  
}

void write_dummys(FILE *fp, int nCount)
{
	for (int i= 0; i < nCount; i++)
	{
		write_dummy(fp);
	}
}

int main(int argc, char* argv[])
{
	// Է   Ȯ
	printf("argc = %d\n", argc);
	if (argc != 6)
	{
		printf("%s cvtfile cvtpid imagefile imagepid\n", argv[0]);
		return -1;
	}
	
	// cvt file Ȯ
	FILE *fp = fopen(argv[1],"rb");
	if (fp == 0)
	{
		printf("%s cvtfile cvtpid imagefile imagepid\n", argv[0]);
		printf("Can not find cvt file %s\n", argv[1]);
		return -2;
	}
	// Է   Ȯ
	fseek(fp, 0L, SEEK_END);
	int nlen_cvt = ftell(fp);
	if (nlen_cvt == 0)
	{
		printf("%s cvtfile cvtpid imagefile imagepid\n", argv[0]);
		printf("Can not find file %s\n", argv[1]);
		printf("File Size is Zero\n");
		return -3;
	}
	
	// Է  о 
	fseek(fp, 0L, SEEK_SET);
	unsigned char *cvt = (unsigned char*)malloc(nlen_cvt);
	if (cvt == 0)
	{
		printf("%s cvtfile cvtpid imagefile imagepid\n", argv[0]);
		printf("Can not find file %s\n", argv[1]);
		printf("Out of Memory\n");
		fclose(fp);
		return -4;
	}
	fread( cvt, 1, nlen_cvt, fp);
	fclose(fp);
	
	// image file Ȯ
	fp = fopen(argv[3],"rb");
	if (fp == 0)
	{
		printf("%s cvtfile cvtpid imagefile imagepid\n", argv[0]);
		printf("Can not find image file %s\n", argv[3]);
		return -2;
	}
	// Է   Ȯ
	fseek(fp, 0L, SEEK_END);
	int nlen_image = ftell(fp);
	if (nlen_image == 0)
	{
		printf("%s cvtfile cvtpid imagefile imagepid\n", argv[0]);
		printf("Can not find image file %s\n", argv[3]);
		printf("File Size is Zero\n");
		return -3;
	}
	
	// Է  о 
	fseek(fp, 0L, SEEK_SET);
	unsigned char *image = (unsigned char*)malloc(nlen_image);
	if (image == 0)
	{
		printf("%s cvtfile cvtpid imagefile imagepid\n", argv[0]);
		printf("Can not find image file %s\n", argv[3]);
		printf("Out of Memory\n");
		fclose(fp);
		return -4;
	}
	fread( image, 1, nlen_image, fp);
	fclose(fp);
	
	fp = fopen(argv[5], "wb");
	int nlenloop = get_block_count(nlen_image);
	//printf("nlenloop = %d\n", nlenloop);
	for (int i = 0; i < nlenloop; i++)
	{
		write_dii(fp, nlen_cvt, atoi(argv[2]));
		write_dummys(fp, 10);
		write_ddb(fp, cvt, nlen_cvt, atoi(argv[2]), i);
		write_dummys(fp, 10);
		write_dii(fp, nlen_image, atoi(argv[4]));
		write_dummys(fp, 10);
	  write_ddb(fp, image, nlen_image, atoi(argv[4]), i);
	  write_dummys(fp, 10);
	}
	
	fclose(fp);
	return 0;
}
