#include "DST_Window.h"
#include "DST_WinManager.h"
#include "DST_DataStrings.h"
#include "DST_CommonAPI.h"
#include "DST_EEPROM.h"
#include "DST_ChannelTune.h"
#include "DST_UserInterface.h"
#include "DST_Updates.h"
#include "DST_OSDImage.h"

#if 0
____CMessageWin___()
#endif


//class CUpdateWin : public CWindow
//{
//private:
	static bool CUpdateWin_bDone;
	static bool CUpdateWin_bNeedLine;
	static int CUpdateWin_progress;
	static int CUpdateWin_center_pos;
	static int CUpdateWin_line_spacing;	

//	static int CUpdateWin_nBlock;
	static int CUpdateWin_nErr;
	static int CUpdateWin_ErrCategory;
	static int CUpdateWin_category;
	
//public:
//	CUpdateWin(SWinEventMsg event):CWindow(event)
	void CUpdateWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "Update");
		DST_g_RFUpdateState = 0;
		this->rect.w = 382; 
		this->rect.h = 241;  
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight()- this->rect.h) / 2;

		DST_Printf("\n\n--------------------------WIN_UPDATE----------------------------------\n\n");
		

		CUpdateWin_center_pos =  this->rect.h / 2; 
		CUpdateWin_line_spacing = DST_GetFontHeight(fontItemSize) * 150 / 100;

		CUpdateWin_nErr = 0;
		CUpdateWin_ErrCategory = 0;
		CUpdateWin_category = 0;
		CUpdateWin_bNeedLine = false;
//		RegisterAllKey();
		this->SetTimeOut(this, 0);
		CUpdateWin_bDone = false;
		CUpdateWin_progress = 0;
	}

	void CUpdateWin_Destructor(CWindow *this)
	{
	
	}
	
	void CUpdateWin_DrawProgressBar(CWindow *this, DS_U32 nPos, DS_U32 nTotal, int x, int y, DS_U32 width)
	{
		this->DrawBox32(this, x, y, width, 10, CONV32_16(0xffe5e5ff));
		if(nPos == nTotal)
			this->DrawBox32(this, x, y, width, 10, CONV32_16(0xff65a5cc));
		else
			this->DrawBox32(this, x, y, (nPos*width)/nTotal, 10, CONV32_16(0xff65a5cc));
		this->UpdateScreen(this);
	}

	void CUpdateWin_Draw(CWindow *this, DS_U16 * category)
	{
		this->DrawBox32(this, 0, 0, this->rect.w, this->rect.h, CONV32_16(0xff24435e));
		
		this->setFontStyle(this, fontItemSize,0xFFE1E1E1,ALIGN_MIDDLE,ALIGN_CENTER);

		this->DrawTextUni(this, 0, CUpdateWin_center_pos-2*CUpdateWin_line_spacing-10, this->rect.w, CUpdateWin_line_spacing, category, &(this->font)); 
		this->DrawTextUni(this, 0, CUpdateWin_center_pos-CUpdateWin_line_spacing-10, this->rect.w, CUpdateWin_line_spacing, pz_Updating_1[OSD_Lang], &(this->font)); 
		this->DrawTextUni(this, 0, CUpdateWin_center_pos-10, this->rect.w, CUpdateWin_line_spacing, pz_Updating_2[OSD_Lang], &(this->font)); 
		this->DrawTextUni(this, 0, CUpdateWin_center_pos+CUpdateWin_line_spacing-10, this->rect.w, CUpdateWin_line_spacing, pz_Updating_3[OSD_Lang], &(this->font)); 
	}

//	virtual void OnTimer(char nID)
	void CUpdateWin_OnTimer(CWindow *this, char nID)
	{
		switch(nID)
		{
			case 1:
				DST_Printf("CUpdateWin_nErr : %d \n",CUpdateWin_nErr);
				this->KillTimer(this, 1);
				this->DrawBox32(this, 0, 0, this->rect.w, this->rect.h, CONV32_16(0xff24435e));
				switch(CUpdateWin_ErrCategory)
				{
					case UPDATE_BOOTLOADER:
						this->DrawTextUni(this, 0, CUpdateWin_center_pos-CUpdateWin_line_spacing, this->rect.w, CUpdateWin_line_spacing, pz_Updating_Cat_1[OSD_Lang], &(this->font)); 
						break;
					case UPDATE_APPLICATION:
						this->DrawTextUni(this, 0, CUpdateWin_center_pos-CUpdateWin_line_spacing, this->rect.w, CUpdateWin_line_spacing, pz_Updating_Cat_4[OSD_Lang], &(this->font)); 
						break;
					case UPDATE_APPLICATION0:
						this->DrawTextUni(this, 0, CUpdateWin_center_pos-CUpdateWin_line_spacing, this->rect.w, CUpdateWin_line_spacing, pz_Updating_Cat_4_1[OSD_Lang], &(this->font)); 
						break;
					case UPDATE_APPLICATION1:
						this->DrawTextUni(this, 0, CUpdateWin_center_pos-CUpdateWin_line_spacing, this->rect.w, CUpdateWin_line_spacing, pz_Updating_Cat_4_2[OSD_Lang], &(this->font)); 
						break;
					case UPDATE_VERSION_READ:
						this->DrawTextUni(this, 0, CUpdateWin_center_pos-CUpdateWin_line_spacing, this->rect.w, CUpdateWin_line_spacing, pz_Updating_Cat_5[OSD_Lang], &(this->font)); 
						break;
					default:
						break;
				}
				
				switch(CUpdateWin_nErr)
				{
					case WRITE_FLASH_FAIL:
						this->DrawTextUni(this, 0, (CUpdateWin_bNeedLine?CUpdateWin_center_pos:0), this->rect.w, (CUpdateWin_bNeedLine?CUpdateWin_line_spacing:this->rect.h), pz_Update_Err_301[OSD_Lang], &(this->font));
						break;
					case CRC_FLASH_BOOTLOADER_FAIL:
						this->DrawTextUni(this, 0, (CUpdateWin_bNeedLine?CUpdateWin_center_pos:0), this->rect.w, (CUpdateWin_bNeedLine?CUpdateWin_line_spacing:this->rect.h), pz_Update_Err_401[OSD_Lang], &(this->font));
						break;
					case CRC_FLASH_APPLICATION_FAIL:
						this->DrawTextUni(this, 0, (CUpdateWin_bNeedLine?CUpdateWin_center_pos:0), this->rect.w, (CUpdateWin_bNeedLine?CUpdateWin_line_spacing:this->rect.h), pz_Update_Err_402[OSD_Lang], &(this->font));
						break;
					case CRC_READ_BOOTLOADER_FAIL:
						this->DrawTextUni(this, 0, (CUpdateWin_bNeedLine?CUpdateWin_center_pos:0), this->rect.w, (CUpdateWin_bNeedLine?CUpdateWin_line_spacing:this->rect.h), pz_Update_Err_403[OSD_Lang], &(this->font));
						break;
					case CRC_READ_APPLICATION_FAIL:
						this->DrawTextUni(this, 0, (CUpdateWin_bNeedLine?CUpdateWin_center_pos:0), this->rect.w, (CUpdateWin_bNeedLine?CUpdateWin_line_spacing:this->rect.h), pz_Update_Err_404[OSD_Lang], &(this->font));
						break;
					case CRC_READ_TOTAL_FAIL:
						this->DrawTextUni(this, 0, (CUpdateWin_bNeedLine?CUpdateWin_center_pos:0), this->rect.w, (CUpdateWin_bNeedLine?CUpdateWin_line_spacing:this->rect.h), pz_Update_Err_405[OSD_Lang], &(this->font));
						break;
					case UPDATE_CHECKING_CRC:
						this->DrawTextUni(this, 0, CUpdateWin_center_pos-CUpdateWin_line_spacing, this->rect.w, CUpdateWin_line_spacing, pz_Updating_4[OSD_Lang], &(this->font)); 
						this->DrawTextUni(this, 0, CUpdateWin_center_pos, this->rect.w, CUpdateWin_line_spacing, pz_Updating_5[OSD_Lang], &(this->font)); 
						break;
					case UPDATE_FINISHED:
						this->DrawTextUni(this, 0, CUpdateWin_center_pos-CUpdateWin_line_spacing, this->rect.w, CUpdateWin_line_spacing, pz_Updating_6[OSD_Lang], &(this->font)); 
						this->DrawTextUni(this, 0, CUpdateWin_center_pos, this->rect.w, CUpdateWin_line_spacing, pz_sysreset[OSD_Lang], &(this->font)); 	

						break;
					default:
						break;
				}
				if(CUpdateWin_nErr == UPDATE_FINISHED || CUpdateWin_nErr == UPDATE_CHECKING_CRC)
				{
					DST_g_LED_PowerState = 2;
					
					this->SetTimer(this, 2,5000);
				}
				else
				{
					DST_g_LED_PowerState = 1;
				}
				this->UpdateScreen(this);	
				break;
			case 2:
				this->Close(this);
				DST_CreateWin(WIN_UPDATE_RESET, 0, 0, 0, 0, 0);
				break;
			default:
				break;
		}
	}

//	virtual void OnMessage(SWinEventMsg event)
	void CUpdateWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_RF_UPDATE:
				switch(event.data32[0])
				{
					case FLASH_WRITING: // FLASH WRITING
						if(CUpdateWin_category != (int)event.data32[2])
						{
							CUpdateWin_category = event.data32[2];
							switch(CUpdateWin_category)
							{
								case UPDATE_BOOTLOADER: CUpdateWin_Draw(this, pz_Updating_Cat_str_1[OSD_Lang]); break;
								case UPDATE_APPLICATION0: CUpdateWin_Draw(this, pz_Updating_Cat_str_4_1[OSD_Lang]); break;
								case UPDATE_APPLICATION1: CUpdateWin_Draw(this, pz_Updating_Cat_str_4_2[OSD_Lang]); break;
							}
							
						}
						
						CUpdateWin_DrawProgressBar(this, event.data32[1], 100,this->rect.w/10,CUpdateWin_center_pos+2*CUpdateWin_line_spacing-10,this->rect.w*8/10);		
						
						DST_g_RFUpdateState = 1;
						break;
					case FLASH_WRITING_COMPLETE: // FLASH WRITING COMPLETE
					case FLASH_WRITING_FAIL:
						CUpdateWin_nErr = event.data32[1];
						CUpdateWin_ErrCategory = event.data32[2];
						if(CUpdateWin_ErrCategory != UPDATE_OK) CUpdateWin_bNeedLine = true;
						else CUpdateWin_bNeedLine = false;
						if (CUpdateWin_nErr != 0) this->SetTimer(this, 1, 500);						
						break;
						default: break;
						
				}
				break;
				default: break;
				
		}
	}

	
//	virtual void Show(void)
	void CUpdateWin_Show(CWindow *this)
	{
		
		CUpdateWin_Draw(this, pz_Updating_Cat_str_system[OSD_Lang]);
		this->RegisterAllKey(this);
	}

//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CUpdateWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_KEY_PWR:
			case VK_PWR:
				if (DST_g_PowerOn) // 
				{
					DST_g_PowerOn = false;// ȭ .
				}
				else // 
				{
					DST_g_PowerOn = true;// ȭ Ҵ
				} 
				JST_POWER_Display(DST_g_PowerOn);
				break;
			default: break;
		}
	}

//};

void DST_CreateUpdateWin(SWinEventMsg event)
{
	if (DST_GetWin(WIN_UPDATE)) return;
	DST_RemoveAllWindowExceptBasicWin();
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor 	= CUpdateWin_Destructor;
	pWin->KeyInput 		= CUpdateWin_KeyInput;
	pWin->OnMessage		= CUpdateWin_OnMessage;
	pWin->OnTimer		= CUpdateWin_OnTimer;
	pWin->Show 			= CUpdateWin_Show;
	//  ȣ
	CUpdateWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);

}


//class CUpdateResetWin : public CWindow
//{
//private:
//	static DS_U8 winParentID;
//	static DS_U8 msg;
	
//public:
//	CUpdateResetWin(SWinEventMsg event):CWindow(event)
	void CUpdateResetWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "UpdateReset");
		this->rect.w = 382; 
		this->rect.h = 241;  

		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight()- this->rect.h) / 2;
		this->SetTimeOut(this, 0);
		

	}
	void CUpdateResetWin_Destructor(CWindow *this)
	{
		DST_g_bUpdateCompleted = true;
		if (DST_g_PowerOn)
		{
			DST_Reset(__func__); // â 鼭 
		}
		else
		{
			DST_PowerDown();
		}
	}
	
//	virtual void OnTimer(char nID)
	void CUpdateResetWin_OnTimer(CWindow *this, char nID)
	{
		switch(nID)
		{
			case 1:
				this->KillTimer(this, 1);
				this->Close(this);
				break;
			default:
				break;
		}
	}
	
//	virtual void Show(void)
	void CUpdateResetWin_Show(CWindow *this)
	{
		this->RegisterAllKey(this);
		this->DrawBox32(this, 0, 0, this->rect.w, this->rect.h, CONV32_16(0xff24435e));
		this->setFontStyle(this, 22,0xFFFFFFFF,ALIGN_MIDDLE,ALIGN_CENTER);
		this->DrawTextUni(this, 0, 0, this->rect.w, this->rect.h, pz_sysreset[OSD_Lang], &(this->font));
		this->UpdateScreen(this);
		
		this->SetTimer(this, 1, 1000);
	}

//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CUpdateResetWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_KEY_PWR:
			case VK_PWR:
				if (DST_g_PowerOn) // 
				{
					DST_g_PowerOn = false; // ȭ .
				}
				else // 
				{
					DST_g_PowerOn = true;// ȭ Ҵ
				} 
				JST_POWER_Display(DST_g_PowerOn);
				break;
			default:
				break;
		}
	}

//};
void DST_CreateUpdateResetWin(SWinEventMsg event)
{
	DST_RemoveAllWindowExceptBasicWin();
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor 	= CUpdateResetWin_Destructor;
	pWin->KeyInput 		= CUpdateResetWin_KeyInput;
	pWin->OnTimer		= CUpdateResetWin_OnTimer;
	pWin->Show 			= CUpdateResetWin_Show;
	//  ȣ
	CUpdateResetWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}


