#include "DST_WinManager.h"
#include "DST_ChannelTune.h"
#include "DST_SignalMonitor.h"
#include "DST_DataStrings.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_DB.h"
#include "DST_MemoryDB.h"

#if SUPPORT_CHANNEL_EDIT

#define CE_LIST		5

#define RF_W		30
#define CH_NO_W		61
#define CH_NAME_W	112
#define ADD_W		53

#if 0
____CChannelEditWin___()
#endif


//class CChannelEditWin : public CWindow
//{
//private:
	static int CChannelEditWin_totalNum;
	static ChannelMap *CChannelEditWin_chMap;

	static DS_U16 CChannelEditWin_g_nPos;
	static DS_U16 CChannelEditWin_g_nTop;
	static DS_U16 CChannelEditWin_select;
	static DS_U16 CChannelEditWin_listNum;
//public:
void CChannelEditWin_InitValues();
void CChannelEditWin_setSize(CWindow *this);

//	CChannelEditWin(SWinEventMsg event):CWindow(event)
	void CChannelEditWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "ChannelEdit");
		CChannelEditWin_InitValues();
		CChannelEditWin_setSize(this);
		this->SetTimeOut(this, 100);
	}

	void CChannelEditWin_Destructor(CWindow *this)
	{
		if(CChannelEditWin_chMap) DST_OS_Free(&CChannelEditWin_chMap);
	}
	
	void CChannelEditWin_setSize(CWindow *this)
	{
		this->rect.w = DST_GetImageWidth(newcon2_gui_channeledit_back);
		this->rect.h = DST_GetImageHeight(newcon2_gui_channeledit_back);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight()- this->rect.h) / 2;

	}	

	void CChannelEditWin_InitValues()
	{
		int i = 0;
		CChannelEditWin_totalNum = 0;
		if(CChannelEditWin_chMap) DST_OS_Free(&CChannelEditWin_chMap);
		CChannelEditWin_chMap = 0;
		CChannelEditWin_chMap = DST_DB_GetChannelMapForChEdit(&CChannelEditWin_totalNum);
		CChannelEditWin_g_nTop = 0;
		CChannelEditWin_g_nPos = 0;
		CChannelEditWin_select = 0;
		CChannelEditWin_listNum = 8;
		if (CChannelEditWin_totalNum < CChannelEditWin_listNum) CChannelEditWin_listNum = CChannelEditWin_totalNum;

		for( i=0;i<CChannelEditWin_totalNum;i++)
		{
			if(DST_EEPROM_GetRF() == CChannelEditWin_chMap[i].rf && DST_EEPROM_GetProgramNumber() == CChannelEditWin_chMap[i].number )
			{
				ItemDecrease(CChannelEditWin_totalNum, CChannelEditWin_listNum, &CChannelEditWin_g_nTop, &CChannelEditWin_select, &CChannelEditWin_g_nPos,CChannelEditWin_totalNum - i );
				DST_UI_ChannelTune(CChannelEditWin_chMap[CChannelEditWin_select].rf,CChannelEditWin_chMap[CChannelEditWin_select].number);
				break;
			}
		}
		
		DST_UI_ChannelTune(CChannelEditWin_chMap[CChannelEditWin_select].rf,CChannelEditWin_chMap[CChannelEditWin_select].number);
	}

	void CChannelEditWin_SetValues(int minor, DS_U16 major, bool bAdd)
	{
		DST_DB_SetSkipChannel(major, minor, bAdd);
//		DST_DB_MakeSkipChannel();
	}
	
	bool CChannelEditWin_CompareValues(int minor, DS_U16 major)
	{
		bool result = false;
		int i = 0;
		for( i=0;i<DB_SKIP_LIST_MAX;i++)
		{
			if(db_skip_list[i].minor == minor && db_skip_list[i].major == major)
				result = true;
		}
		return result;
	}

//	virtual void Focus(bool bVal)
	void CChannelEditWin_Focus(CWindow *this, bool bVal)
	{
		this->RegisterAllKey(this);
		this->RegisterKey(this, VK_PWR, false, 0, 0);
		this->RegisterKey(this, VK_SIGNAL_METER, false, 0, 0);
		this->RegisterKey(this, VK_ZOOM, false, 0, 0);
		this->RegisterKey(this, VK_CC, false, 0, 0);
		this->RegisterKey(this, VK_EPG, false, 0, 0);
	}

	
//	virtual void Show(WinID id)
	void CChannelEditWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_ENGINEER_MODE:
			case WIN_FREQUENCY_SETTING: 
			case WIN_EWS:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_PROGRAM_GUIDE:
				this->Close(this);
				break;
			default:
				break;
		}
	}
	
	 //׺̼ ׸
	void CChannelEditWin_DrawNavigation(CWindow *this)
	{
		DS_U16	final[20];
		this->setFontStyle(this, 20,0xFF8C8C8C,this->FontGetVerAlign(this),ALIGN_LEFT);

		memset(final,0,sizeof(final));
		strcpy16(final, pz_Edit_Menu[OSD_Lang]);
		str2uni(&final[strlen16(final)], (char *)" : ");
		strcpy16(&final[strlen16(final)], pz_Edit_Exit[OSD_Lang]);
		this->DrawTextUni(this, 17, 340, 142, 29, final, &(this->font));

		memset(final,0,sizeof(final));
		strcpy16(final, pz_Edit_OK[OSD_Lang]);
		str2uni(&final[strlen16(final)], (char *)" : ");
		strcpy16(&final[strlen16(final)], pz_Edit_Select[OSD_Lang]);
		this->DrawTextUni(this, 170, 340, 142, 29, final, &(this->font));

	}

	void CChannelEditWin_DrawTitle(CWindow *this)
	{
		this->setFontStyle(this, 19,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
		this->DrawTextUni(this, 16, 12, 116, 29, pz_Edit_ChannelNumber[OSD_Lang], &(this->font));
		this->DrawTextUni(this, 142, 12, 212, 29, pz_Edit_ChannelName[OSD_Lang], &(this->font));
		this->DrawTextUni(this, 364, 12, 47, 29, pz_Edit_RF[OSD_Lang], &(this->font));
		this->DrawTextUni(this, 420, 12, 60, 29, pz_Edit_ADD[OSD_Lang], &(this->font));
	}

	void CChannelEditWin_DrawItems(CWindow *this, int index,int y_Constant, int y_Multiplier, int width, int nFontSize)
	{
		char num[5] = {0,};
		
		this->setFontStyle(this, 19,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);

		this->DrawText(this, 16, 43+index*y_Multiplier, 124, 29, CChannelEditWin_chMap[index+CChannelEditWin_g_nTop].num, &(this->font));

		this->DrawTextUTF8(this, 142, 43+index*y_Multiplier, 219, 29, CChannelEditWin_chMap[index+CChannelEditWin_g_nTop].name, &(this->font));

		sprintf(num, "%d",DST_GetFrequencyNumberbyIndex(CChannelEditWin_chMap[index+CChannelEditWin_g_nTop].rf));

		this->DrawText(this, 364, 43+index*y_Multiplier, 53, 29, num, &(this->font));

		this->DrawImage(this, 417, 43+index*y_Multiplier, newcon2_gui_channeledit_button_check_empty, false);

		if(!CChannelEditWin_CompareValues(CChannelEditWin_chMap[index+CChannelEditWin_g_nTop].minor, CChannelEditWin_chMap[index+CChannelEditWin_g_nTop].major))
			this->DrawImage(this, 417, 43+index*y_Multiplier, newcon2_gui_channeledit_button_check, false);
		else
			this->DrawImage(this, 417, 43+index*y_Multiplier, newcon2_gui_channeledit_button_check_empty, false);
		if(CChannelEditWin_select == index+CChannelEditWin_g_nTop)
		{
			if(!CChannelEditWin_CompareValues(CChannelEditWin_chMap[index+CChannelEditWin_g_nTop].minor,CChannelEditWin_chMap[index+CChannelEditWin_g_nTop].major))
				this->DrawImage(this, 417, 43+index*y_Multiplier, newcon2_gui_channeledit_button_check_cursor, false);
			else
				this->DrawImage(this, 417, 43+index*y_Multiplier, newcon2_gui_channeledit_button_check_cursor_empty, false);
		}
	}

	void CChannelEditWin_DrawScrollBar3(CWindow *this, int x, int y, int h, int total_count, int page_count, int page_start)
	{
		if (total_count <= page_count) return;
		int nScrollPosition = total_count - page_count;
//		DST_Printf("nScrollPosition : %d h/nScrollPosition : %d/%d == %d y+page_start*ScrollHeight = %d\n",nScrollPosition,h,nScrollPosition ,ScrollHeight,y+page_start*ScrollHeight);
		this->DrawImage(this, x,y+(page_start*h)/nScrollPosition,newcon2_gui_scroll_button,true);
	}
	
	void CChannelEditWin_Draw(CWindow *this)
	{
		int i = 0;
		this->DrawImage(this, 0,0, newcon2_gui_channeledit_back, false);
		CChannelEditWin_DrawTitle(this);
		CChannelEditWin_DrawScrollBar3(this, 489, 30, 294, CChannelEditWin_totalNum, CChannelEditWin_listNum, CChannelEditWin_g_nTop);

		CChannelEditWin_DrawNavigation(this);
		for( i=0;i<CChannelEditWin_listNum;i++)
			CChannelEditWin_DrawItems(this, i, 195, 36, 85, 20);
	}
	
//	virtual void Show(void)
	void CChannelEditWin_Show(CWindow *this)
	{
		CChannelEditWin_Draw(this);
		this->DoFocus(this, true);
	}	

//	virtual void OnMessage(SWinEventMsg event)
	void CChannelEditWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				this->Close(this);
				break;
				
			case WM_CT_MSG:
				switch (event.data32[0])
				{
					case CT_CHMAP_UPDATE:
						CChannelEditWin_InitValues();
						this->Show(this);
						break;					
				}
				break;
			default: break;
		}
	}

//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CChannelEditWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_MENU:
			case VK_CANCEL:
			case VK_PREV:
			case VK_PREV_MENU:
			case VK_PREV_CH:
				if (this->GetParentWinID(this)) DST_CreateWin(this->GetParentWinID(this), 0, 0, 0, 0, 0);
				this->Close(this);
				break;
			case VK_UP:
			case VK_DN:
				if(key == VK_DN)
					ItemIncrease(CChannelEditWin_totalNum, CChannelEditWin_listNum, &CChannelEditWin_g_nTop, &CChannelEditWin_select, &CChannelEditWin_g_nPos, 1);
				else
					ItemDecrease(CChannelEditWin_totalNum, CChannelEditWin_listNum, &CChannelEditWin_g_nTop, &CChannelEditWin_select, &CChannelEditWin_g_nPos, 1);

				DST_UI_ChannelTune(CChannelEditWin_chMap[CChannelEditWin_select].rf,CChannelEditWin_chMap[CChannelEditWin_select].number);
				CChannelEditWin_Draw(this);
				break;
//			case VK_CH_UP:
//			case VK_CH_DN:
//				if(key == VK_CH_DN)
//					ItemIncrease(mainItemNum, mainListNum, &g_nTop, &mainSelect, &g_nPos, listNum);
//				else
//					ItemDecrease(mainItemNum, mainListNum, &g_nTop, &mainSelect, &g_nPos, listNum);
//				//DST_UI_ChannelTune(chMap[select].number);
//				Draw();
//				break;
			case VK_OK:
				CChannelEditWin_SetValues(CChannelEditWin_chMap[CChannelEditWin_select].minor , CChannelEditWin_chMap[CChannelEditWin_select].major, CChannelEditWin_CompareValues(CChannelEditWin_chMap[CChannelEditWin_select].minor, CChannelEditWin_chMap[CChannelEditWin_select].major)?false:true);
				CChannelEditWin_Draw(this);

				break;
			default:
				break;

		}
	}
//};

void DST_CreateChannelEditWin(SWinEventMsg event)
{
	if (DST_DB_PresentChMap() == false) return;

	CWindow*pWin = NewCWindow(event);
	pWin->Destructor	= CChannelEditWin_Destructor;
	pWin->KeyInput		= CChannelEditWin_KeyInput;
	pWin->OnMessage 	= CChannelEditWin_OnMessage;
	pWin->Focus			= CChannelEditWin_Focus;
	pWin->ShowWindow	= CChannelEditWin_ShowWindow;
	pWin->Show			= CChannelEditWin_Show;
	//  ȣ
	CChannelEditWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);

}
#endif

