#ifndef __DST_DB_H__
#define __DST_DB_H__

#include "DST_CommonAPI.h"

#define FLASH_VERSION 1

typedef struct 
{
	char num[20];
	DS_U8 name[TEXT_LENGTH_MAX];
} CHANNEL_DISPLAY;

typedef struct 
{
	int rf;
	int major;
	int minor;
	char num[20];
	DS_U16 number;
	DS_U8  name[TEXT_LENGTH_MAX];
}ChannelMap;


ChannelMap* DST_DB_GetChannelMapForChEdit(int *nChannels);

bool DST_DB_PresentChMap();


int DST_DB_GetMajor(DS_U8 RF, DS_U16 program_number);


int DST_DB_GetMinor(DS_U8 RF, DS_U16 program_number);


void DST_DB_ChannelUpDn(bool bUp);

int DST_DB_GetChannelCount();

bool DST_DB_GetCurrentChannelInfo(char* chNum, DS_U32* chName, int *num);

//   Ȥ  ĵ  ȣ ȴ.
void DST_DB_TuneFirstChannel();

// Ŵ ĵ  ش RF ù° äη .
void DST_DB_TuneFirstChannelinRF(int rf);

int DST_DB_GetProgramNumber(int major, int minor);

int DST_DB_GetProgramNumberbyRFNumber(int rf);

void DST_DB_Del();

void DST_DB_Sync();

bool DST_DB_IsSync();

void DST_DB_Open();

void DST_DB_Close();

int DST_DB_GetRF(int major, int *minor, bool* bFound);

int DST_DB_AvailableChannelCount(int major);

bool DST_DB_PresentMatchChannel(int rf, int major, int minor);

void DST_DB_SetSkipChannel(int rf, int program_number, bool bAdd);

DS_U32 DST_CRC32(DS_U8 *data, int len);


// ļ  ܵ ä?
// Է° rf index ̴
int DST_DB_IsExceptRF(int rf);

//  ä ܵǾ?
int DST_DB_GetExceptRFCount();

// ܵ   RF index ´
// Էµ   indexed rf 
int DST_DB_GetNextUnexceptRF(int rf);
int DST_DB_GetPrevUnexceptRF(int rf);
int DST_DB_GetUnexceptedFirstRF();
int DST_DB_GetUnexceptedLastRF();

#endif
