#include "DST_WinManager.h"
#include "DST_ChannelTune.h"
#include "DST_SignalMonitor.h"

#include "DST_DataStrings.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"

#include "DST_ISDBT_ChannelTask.h"
#include "DST_ChannelTune.h"
#include "DST_DB.h"
#include "DST_DB_Engine.h"
#include "DST_MemoryDB.h"

#define AS_RF_W			77
#define AS_CH_NO_W		111
#define AS_CH_NAME_W	364

#define PROGRESS_BAR_X	33
#define PROGRESS_BAR_Y	266
#define PROGRESS_BAR_W	333


//class CManualSearchWin : public CWindow
//{
//private:
	static CHANNEL_DISPLAY CManualSearchWin_ch[4];
	static int CManualSearchWin_m_nRF; // ȭ鿡 ǥõ RF ε ȣ
	static bool CManualSearchWin_m_bReceiveSI; 
//public:
void CManualSearchWin_ClearChList();
void CManualSearchWin_AddChList(int rf, int major, int minor, char* name);
void CManualSearchWin_SearchChDB(int RF);

//	CManualSearchWin(SWinEventMsg event):CWindow(event)
	void CManualSearchWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "ManualSearch");
		CManualSearchWin_m_nRF = DST_EEPROM_GetRF();
		CManualSearchWin_m_bReceiveSI = true;
		
		this->rect.w = DST_GetImageWidth(manualscan_back);
		this->rect.h = DST_GetImageHeight(manualscan_back);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight()- this->rect.h) / 2;
		
		this->RegisterAllKey(this);
		this->RegisterKey(this, VK_PWR, false, 0, 0);
		this->RegisterKey(this, VK_KEY_PWR, false, 0, 0);

		CManualSearchWin_ClearChList();
		CManualSearchWin_SearchChDB(CManualSearchWin_m_nRF);
		DST_UI_ChannelTune(CManualSearchWin_m_nRF, 0);	
	}

	void CManualSearchWin_Destructor(CWindow *this)
	{
		DST_DB_TuneFirstChannelinRF(CManualSearchWin_m_nRF);	
		if(DST_GetWin(WIN_ERROR)) DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL ,0, 0, 0);
	}
	
	void CManualSearchWin_ClearChList()
	{		
		memset(CManualSearchWin_ch, 0, sizeof(CManualSearchWin_ch));
	}
	
	void CManualSearchWin_AddChList(int rf, int major, int minor, char* name)
	{
		int nPos = 4;
		int i = 0;
		for ( i = 0; i < 4; i++)
		{
			if (strlen(CManualSearchWin_ch[i].num) != 0) continue;
			nPos = i;
			break;
		}
		if (nPos > 3) 
		{
			nPos = 3;
			memcpy(&CManualSearchWin_ch[0], &CManualSearchWin_ch[1], sizeof(CHANNEL_DISPLAY)* 3);
		}
		if (minor == 0)
		{
			sprintf(CManualSearchWin_ch[nPos].num, "%d(%d)", major, DST_GetFrequencyNumberbyIndex(rf));
		}
		else
		{
			sprintf(CManualSearchWin_ch[nPos].num, "%d-%d(%d)", major, minor, DST_GetFrequencyNumberbyIndex(rf));
		}
		strcpy((char*)CManualSearchWin_ch[nPos].name, (char*)name);
	}
	
	void CManualSearchWin_SearchChDB(int RF)
	{
		int i = 0;
		DBLock(true);
		for (i=0; i < DB_CHANNEL_DB_MAX; i++)
		{
			if (db_channel_db[i].program_number == 0) continue;
			if (db_channel_db[i].rf  != RF) continue;
			CManualSearchWin_AddChList(RF, db_channel_db[i].major, db_channel_db[i].minor, db_channel_db[i].name);
		}
		DBLock(false);
//		CDB db;
//		NewCDB(&db);
//		db.GetTable(&db, "select major, minor, name from channel_db where rf =%d order by major,minor", RF);
//		if (db.GetRow(&db) < 1) 
//		{
//			DeleteCDB(&db);
//			return;
//		}
//		for ( i = 0; i < db.GetRow(&db); i++)
//		{
//			CManualSearchWin_AddChList(RF, 
//				dst_atoi(db.GetResult(&db, (i+1)*db.GetCol(&db)+0)), 
//				dst_atoi(db.GetResult(&db, (i+1)*db.GetCol(&db)+1)), 
//				db.GetResult(&db, (i+1)*db.GetCol(&db)+2));
//		}
//		DeleteCDB(&db);
	}
	
//	virtual void OnTimer(char nID)
	void CManualSearchWin_OnTimer(CWindow *this, char nID)
	{
		switch (nID)
		{
			case 1:
				this->KillTimer(this, 1);
				CManualSearchWin_ClearChList();
				CManualSearchWin_SearchChDB(CManualSearchWin_m_nRF);
				this->Show(this);
				break;
			default:
				break;
		}
	}
	
//	virtual void OnMessage(SWinEventMsg event)
	void CManualSearchWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				this->Close(this);
				break;
				
			case WM_CT_MSG:
				switch (event.data32[0])
				{					

					case CT_SCAN_PSIP_WAIT:
						CManualSearchWin_m_bReceiveSI = true;
						break;
					case CT_RECEIVE_TVCT:
#if CVCT_SUPPORT
					case CT_RECEIVE_CVCT:
#endif
					case CT_RECEIVE_PMT:
						CManualSearchWin_m_bReceiveSI = true;
						this->SetTimer(this, 1, 100);
						break;
					case CT_SCAN_START:
						DST_UI_ChannelTune(CManualSearchWin_m_nRF, 0);	
						break;
					default: break;
				}
				break;
		}
	}
	
//	virtual void Show(void)
	void CManualSearchWin_Show(CWindow *this)
	{
		int i = 0;
		// 
		this->DrawImage(this, 0, 0, manualscan_back, false);
		// ŸƲ
		this->setFontStyle(this, 20,0xC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
		// ׸ ̸  äιȣ RF ä̸ 
		this->DrawTextUni(this,  26, 19,  126, 24, pz_Scan_ChannelNumber[OSD_Lang], &(this->font));
		this->DrawTextUni(this, 180, 19, 208, 24, pz_chName[OSD_Lang], &(this->font));

		// ư ׸ 
		char rfNumberStr[10] = {0,};
		sprintf(rfNumberStr,"%d",DST_GetFrequencyNumberbyIndex(CManualSearchWin_m_nRF));
		this->setFontStyle(this, 19,0xC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
		this->DrawTextUni(this, 404, 21, 130, 24, pz_Scan_NoRF[OSD_Lang], &(this->font));
		this->DrawText(this, 404, 57, 130, 24, rfNumberStr, &(this->font));
		
//		this->DrawImage(this, 416, 182, Button_h,true);
//		this->DrawTextUni(this, 416, 182, DST_GetImageWidth(Button_h), DST_GetImageHeight(Button_h), pz_Scan_ChannelSearch[OSD_Lang], &(this->font));
		this->setFontStyle(this, 20,0xFFFFFF,ALIGN_MIDDLE,ALIGN_CENTER);

		this->DrawImage(this, 416, 182, Button_h,true);
		this->DrawTextUni(this, 416, 182,
			DST_GetImageWidth(Button_h),  
			DST_GetImageHeight(Button_h), 
			CManualSearchWin_m_bReceiveSI ? pz_Scan_ChannelSearch[OSD_Lang] : pz_Scan_Searching[OSD_Lang], 
			&(this->font));
		this->setFontStyle(this, 20,0xC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
		// ׸ ǥ
		for ( i=0; i < 4; i++)
		{
			if (strlen(CManualSearchWin_ch[i].num) == 0) continue;
			DS_U32* strText32 = DST_UTF82Uni((DS_U8*)CManualSearchWin_ch[i].name); // ȣ ʿ ޸ 
			// ä ȣ , RF
			this->DrawText(this, 26, 28+(i+1)*35,	126, 24,  CManualSearchWin_ch[i].num, &(this->font));
			// ä ̸
			this->DrawText32(this, 180, 28+(i+1)*35, 208, 24, strText32, &(this->font));
		}
	}


//	virtual void KeyInput(unsigned char key, bool /*bRepeat*/)
	void CManualSearchWin_KeyInput(CWindow *this, unsigned char key, bool bRepeat)
	{
		int i = 0;
		switch(key)
		{
			case VK_UP:
//				CManualSearchWin_m_bReceiveSI = true;
				//CManualSearchWin_m_nRF+=10;
				//if (CManualSearchWin_m_nRF > DST_MaxRF()) CManualSearchWin_m_nRF = DST_MinRF();
				for (i=0; i < 10; i++) CManualSearchWin_m_nRF = DST_DB_GetNextUnexceptRF(CManualSearchWin_m_nRF);
				
				CManualSearchWin_ClearChList();	
				CManualSearchWin_SearchChDB(CManualSearchWin_m_nRF);
				this->Show(this);
				DST_UI_ChannelTune(CManualSearchWin_m_nRF, 0);		
				break;
			case VK_DN:
//				CManualSearchWin_m_bReceiveSI = true;
				//CManualSearchWin_m_nRF-=10;
				//if(CManualSearchWin_m_nRF < DST_MinRF()) CManualSearchWin_m_nRF = DST_MaxRF();
				for (i=0; i < 10; i++) CManualSearchWin_m_nRF = DST_DB_GetPrevUnexceptRF(CManualSearchWin_m_nRF);
				
				CManualSearchWin_ClearChList();	
				CManualSearchWin_SearchChDB(CManualSearchWin_m_nRF);
				this->Show(this);	
				DST_UI_ChannelTune(CManualSearchWin_m_nRF, 0);	
				break;
			case VK_RIGHT:
				//JST_Stop();
//				CManualSearchWin_m_bReceiveSI = true;
				//CManualSearchWin_m_nRF++;
				//if (CManualSearchWin_m_nRF > DST_MaxRF()) CManualSearchWin_m_nRF = DST_MinRF();
				CManualSearchWin_m_nRF = DST_DB_GetNextUnexceptRF(CManualSearchWin_m_nRF);
				
				CManualSearchWin_ClearChList();	
				CManualSearchWin_SearchChDB(CManualSearchWin_m_nRF);
				this->Show(this);	
				DST_UI_ChannelTune(CManualSearchWin_m_nRF, 0);	
				break;
			case VK_LEFT:
				//JST_Stop();
//				CManualSearchWin_m_bReceiveSI = true;
				//CManualSearchWin_m_nRF--;
				//if(CManualSearchWin_m_nRF < DST_MinRF()) CManualSearchWin_m_nRF = DST_MaxRF();
				CManualSearchWin_m_nRF = DST_DB_GetPrevUnexceptRF(CManualSearchWin_m_nRF);
				
				CManualSearchWin_ClearChList();	
				CManualSearchWin_SearchChDB(CManualSearchWin_m_nRF);
				this->Show(this);	
				DST_UI_ChannelTune(CManualSearchWin_m_nRF, 0);	
				break;
		case VK_OK:
			
				JST_Stop();
				JST_DB_Del(CManualSearchWin_m_nRF);
				CManualSearchWin_ClearChList();
				if(CManualSearchWin_m_bReceiveSI == false)
				{
					CManualSearchWin_m_bReceiveSI = true;
				}
				else
				{
					
					CManualSearchWin_m_bReceiveSI = false;
					JST_Scan(CManualSearchWin_m_nRF);	
				}

				this->Show(this);	
				//DST_UI_ChannelTune(m_nRF, 0);
				// DST_UI_ChannelTune ϸ  äο   õ   ʴ´.
				// 켱 ĵ ȣϰ ĵ  ݹ鿡 Ʃ Ѵ.
				break;
			case VK_CANCEL:
			case VK_MENU:
				this->Close(this);
				if(DST_GetWin(WIN_ERROR)) DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL ,0, 0, 0);
				break;
		}
	}
//};

void DST_CreateManualSearchWin(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor 	= CManualSearchWin_Destructor;
	pWin->KeyInput 		= CManualSearchWin_KeyInput;
	pWin->OnTimer		= CManualSearchWin_OnTimer;
	pWin->OnMessage		= CManualSearchWin_OnMessage;
	pWin->Show 			= CManualSearchWin_Show;
	//  ȣ
	CManualSearchWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}

