#include "dst_eroum_interface.h"

#ifdef DSTAR

#include "dsthallocal.h"
#include "dsthalerror.h"
#include "dsthalPsiProcess.h"
#include "dsthalcap.h"
#include "dsthalsys.h"
#include "dsthaldev.h"

#else

#include "DHL_SYS_Impl.h"
#include "DHL_SYS.h"
#include "DHL_PSI.h"
#include "DHL_FE.h"
#include "DHL_UIO.h"
#include "DHL_AVCAP.h"

#ifdef __cplusplus
extern "C" {
#endif

#include "DHL_Graphic.h"

#ifdef __cplusplus
}
#endif

#endif

#include "DST_ISDBT_ChannelTask.h"
#include "DST_CommonAPI.h"
#include "DST_HostInterface.h"

#include "DST_WinManagerTask.h"
#include "sqlite3.h"
#include "DST_UserInterface.h"

static DHL_SignalInfoCallBack g_SignalInfoCallBack = 0;
static DHL_VideoStartCallBack g_VideoStartCallBack = 0;
static DHL_AudioStartCallBack g_AudioStartCallBack = 0;
static DHL_SiCallBack g_SiCallBack = 0;
static DHL_CCCallBack g_CCCallBack = 0;
static DHL_IrCallBack g_IrCallBack = 0;

#ifdef DSTAR
DHL_PSI_HANDLE hPsi = 0;
#else
tDHL_TSD tsd = 0;
#endif

/*extern "C" */void change_file(int num, int bReadList, int bForce, int bCont);

#ifdef DSTAR
static void _DHL_SignalInfoCallBack(bool bFocus, DHL_CAP_VIDEO_INPUT vi, DS_U16 hRes, DS_U16 vRes, DS_U16 RefreshRate, bool bInterlaced, DHL_CAP_SRCASPECTRATIO Aspect)
{
	if (g_SignalInfoCallBack == 0) return;
	DHL_SOURCE_ASEPCT as = DHL_SOURCE_UNKNOWN;
	switch (Aspect)
	{
		case DHL_CAP_SRC_ASPECT_16_9:
			as = DHL_SOURCE_16x9;
			break;
		case DHL_CAP_SRC_ASPECT_SQUARE:
		case DHL_CAP_SRC_ASPECT_4_3:
			as = DHL_SOURCE_4x3;
			break;
		default:
			break;
	}
	g_SignalInfoCallBack(hRes, vRes, RefreshRate, bInterlaced ? true : false, as);
}
#endif

// 2012.12.04 USER DATA CC  
static void DHL_UserData_DTVCCPacketBlock(DS_U8 service_number, DS_U8 nSize, DS_U8 *buff)
{
#if 0
	DST_Printf("%s service_number = %d nSize = %d %X\n", __func__, service_number, nSize, buff);
	for (int i = 0; i<nSize; i++) DST_Printf("%02X ", buff[i]);
	DST_Printf("\n");
#endif
	//ZAS  1 񽺸 óѴ. 
	if (service_number != 1) return;
	if (g_CCCallBack) g_CCCallBack((DS_U8*)buff, (int)nSize);
}

static void DHL_UserData_DTVCCPacket(DS_U8 nSize, DS_U8 *buff)
{
	static DS_U8 nSeqNumber = 0xFF;
	static DS_U8 prev_nSize;
	static DS_U8 prev_buff[256];
	
	if (nSize == prev_nSize && memcmp(buff, prev_buff, nSize) == 0) return; // Ϳ ϸ 
	prev_nSize = nSize;
	memcpy(prev_buff,  buff, nSize);
	
	DS_U8 seq_number = (buff[0] >> 6) & 0x03;
	// DST_Printf("seq_number = %d\n", seq_number);
	if (nSeqNumber != 0xFF && ((nSeqNumber+1)%4) != seq_number)
	{
		DST_Printf("Seq Error\n");
		if (g_CCCallBack) g_CCCallBack((DS_U8*)0, -1);
	}
	nSeqNumber = seq_number;	
	if (nSize < 3) return;
	DS_U8 block_size = buff[1] & 0x1F; // Fugure 7 in EIA-708B
	if (block_size < 1) return; 
	DS_U8 service_number = (buff[1]>>5) & 0x07;
	if (service_number < 1) return;
	if (service_number == 7) 
	{
		if (nSize < 3) return;
		service_number += (buff[2] & 0x3F); // extended service_number Figure 8
		if (block_size > nSize-2) block_size = nSize-2; // block size 
		DHL_UserData_DTVCCPacketBlock(service_number, block_size, &buff[3]);
	}
	if (block_size > nSize-1) block_size = nSize-1; // block size 
	DHL_UserData_DTVCCPacketBlock(service_number, block_size, &buff[2]);
}

static void DHL_UserData_DTVCC(bool bStart, DS_U8 cc_data_1, DS_U8 cc_data_2)
{
	//DST_Printf("%s %d %02X %02X\n", __func__, bStart, cc_data_1, cc_data_2);
	static DS_U8 nPacketSize = 0;
	static DS_U8 data[256];
	static DS_U8 nReceiveCount = 0;
	if (bStart)
	{
		nPacketSize = (cc_data_1 & 0x3F);
		nPacketSize = (nPacketSize == 0) ? 128 : nPacketSize*2; // Figure 4
		data[0] = cc_data_1;
		data[1] = cc_data_2;
		nReceiveCount = 2;
	}
	else
	{
		if (nPacketSize == 0) return;
		if (nPacketSize > nReceiveCount) 
		{
			data[nReceiveCount] = cc_data_1;
			nReceiveCount++;
		}
		if (nPacketSize > nReceiveCount) 
		{
			data[nReceiveCount] = cc_data_2;
			nReceiveCount++;
		}
		if (nReceiveCount >=  nPacketSize)
		{
			DHL_UserData_DTVCCPacket(nReceiveCount, data);
			nPacketSize = 0;
			nReceiveCount = 0;
		}
	}
}

#ifdef DSTAR
static void DHL_UserData_ClosedCaption(DS_U16 nSize, DS_U8 *buff)
{
#if 0
	DST_Printf("%s %d %X\n", __func__, nSize, buff);
	for (int i = 0; i<nSize; i++) DST_Printf("%02X ", buff[i]);
	DST_Printf("\n");
#endif
	DS_U8 cc_count = buff[0] & 0x1F;
	if (nSize < cc_count * 3 + 2) return;
	int i;
	for ( i = 0; i < cc_count; i++)
	{
		bool cc_valid = (buff[i*3+2] & 0x04) ? true : false;
		DS_U8 cc_type = (buff[i*3+2] & 0x03);
		if (cc_valid == false) continue;
		switch (cc_type) // EIA-708B #7
		{
			case 0: // line21 field 1
				break;
			case 1: // line21 field 2
				break;
			case 2: // dtvcc data
				DHL_UserData_DTVCC(false, buff[i*3+3],  buff[i*3+4]);
				break;
			case 3: // dtvcc start
				DHL_UserData_DTVCC(true, buff[i*3+3],  buff[i*3+4]);
				break;
			default:
				break;
		}
	}
}
#endif

#ifdef DSTAR 
static void DHL_UserData_Callback(DS_U16 nSize, DS_U8 *buff)
{
	int i;
#if 0
	DST_Printf("%s %d %X\n", __func__, nSize, buff);
	for (i = 0; i<nSize; i++) DST_Printf("%02X ", (char*)buff[i]);
	DST_Printf("\n");
#endif

#ifdef DSTAR
		for ( i=0; i < nSize - 10; i++)
		{
			// user_data_start_code = 0x000001B2 a_53b 5.2.3
			if (buff[i] == 0x00 && buff[i+1] == 0x00 && buff[i+2] == 0x01 && buff[i+3] == 0xB2)
			{
				// ATSC_identifier = 0x47413934
				// user_data_type_code = 0x03
				if (buff[i+4] == 0x47 && buff[i+5] == 0x41 && buff[i+6] == 0x39 && buff[i+7] == 0x34 && buff[i+8] == 0x03)
				{
					DHL_UserData_ClosedCaption(nSize - i - 9, &buff[i+9]);
				}
			}
		}
#else
	for (i=0; i < nSize - 6; i++)
	{
		if (buff[i+0] == 0x47 && buff[i+1] == 0x41 && buff[i+2] == 0x39 && buff[i+3] == 0x34 && buff[i+4] == 0x03)
		{
			DHL_UserData_ClosedCaption(nSize - i - 5, &buff[i+5]);
		}
	}
#endif
}
#endif

#ifdef DSTAR
static void _DHL_CCCallBack(DS_U32 nSize, void *buffer)
{
	DHL_UserData_Callback((DS_U16)nSize, (DS_U8*)buffer);
}
#endif

#ifdef DSTAR

static void _DHL_VideoStartCallBack()
{
	if (g_VideoStartCallBack == 0) return;
	g_VideoStartCallBack();
}

#else

#define USER_DATA_COUNT_MAX 8
static int g_UserDataSize[USER_DATA_COUNT_MAX];
static DS_U8 g_UserData[USER_DATA_COUNT_MAX][256];
static int g_UserDataHead = 0;
static int g_UserDataTail = 0;
static void tUserData()
{
	while (1)
	{
		DST_OS_Delay(10); // 10ms
		if (g_UserDataHead == g_UserDataTail) continue;
//		DST_Printf("g_UserDataTail = %d\n", g_UserDataTail);
		int nLen = g_UserDataSize[g_UserDataTail];
		DS_U8 *pdata = g_UserData[g_UserDataTail];
		int i;
		for (i = 0; i < nLen; i+=3)
		{
			switch (pdata[i])
			{
				case 0: // line21 field 1
					break;
				case 1: // line21 field 2
					break;
				case 2: // dtvcc data
					DHL_UserData_DTVCC(false, pdata[i+1],  pdata[i+2]);
					break;
				case 3: // dtvcc start
					DHL_UserData_DTVCC(true, pdata[i+1],  pdata[i+2]);
					break;
				default:
					break;
			}
		}
		g_UserDataTail = (g_UserDataTail >= USER_DATA_COUNT_MAX-1) ? 0 : g_UserDataTail+1;
	}
}

static void _DHL_AV_CallBack(tDHL_AVCallbackType cb_type, DS_U32 param)
{
	if (cb_type == eDHL_CB_VideoSeqHdr && g_SignalInfoCallBack)
	{
		if (param == 0) return; 
		tDHL_VideoSeqHdr *pSeq = (tDHL_VideoSeqHdr *)param;
		DST_Printf("-- Video Sequence Header info -- \n");
		DST_Printf("aspect_ratio_information : %d \n", pSeq->aspect_ratio_information);
		DST_Printf("frame_rate_code : %d \n", pSeq->frame_rate_code);
		DST_Printf("horizontal_size : %d \n", pSeq->horizontal_size);
		DST_Printf("vertical_size : %d \n", pSeq->vertical_size);
		DST_Printf("progressive_sequence : %d \n", pSeq->progressive_sequence);

		g_SignalInfoCallBack(pSeq->horizontal_size, pSeq->vertical_size,
			pSeq->frame_rate_code, pSeq->progressive_sequence ? false : true,
			(pSeq->aspect_ratio_information == DAR_9_16) ? DHL_SOURCE_16x9 : DHL_SOURCE_4x3);
	}
	if (cb_type == eDHL_CB_FirstVideoShow && g_VideoStartCallBack)
	{
		g_VideoStartCallBack();
	}
	if (cb_type == eDHL_CB_VideoUserData)
	{
		if (param == 0) return;
		tDHL_UserData *pud=(tDHL_UserData *)param;
		if (pud->pdata == 0) return;
		if (pud->hdr.payload_size > 256) return;
		int nLen = pud->hdr.payload_size;
		nLen = (nLen/3)*3;
		g_UserDataSize[g_UserDataHead] = nLen;
		memcpy(g_UserData[g_UserDataHead], pud->pdata, nLen);
//		DST_Printf("g_UserDataHead = %d\n", g_UserDataHead);
		g_UserDataHead = (g_UserDataHead >= USER_DATA_COUNT_MAX-1) ? 0 : g_UserDataHead+1;
	}
}

#endif

#if 0
____System___()
#endif

#ifdef DSTAR
static void DSTAR_KeyCallBack(int bRemocon, DS_U32 Code, int bPressed);
#endif

// SYSTEM ʱȭ
/*extern "C" */void dbg_print(int val);
DHL_ERROR DHL_SYS_Initialize()
{
#ifdef DSTAR
#else
	DHL_SYS_PlatformInit(); // ʱȭ
	int DHL_NVM_FlashGetSize(int flashId);
	FLASH_TOTAL_SIZE =  DHL_NVM_FlashGetSize(0);
	if (FLASH_TOTAL_SIZE < 8*1024*1024) FLASH_BANK1_POS = FLASH_BANK0_POS;
	DST_OS_SpawnTask((void(*)(void *))tUserData, (char*)"tUserData", APP_TASK_USER_DATA, WIN_MGR_TASK_STACKSIZE,  0);
#endif
	return DHL_OK_;
}

typedef void (*irCallback)(unsigned int KeyCode, unsigned int repeat);
static void IRCallback(unsigned int code, unsigned int repeat);
extern void IR_Open(irCallback ircallback);

DHL_ERROR DHL_SYS_TV_Open(
		DHL_SignalInfoCallBack signal,
		DHL_VideoStartCallBack video,
		DHL_AudioStartCallBack audio,
		DHL_SiCallBack si,
		DHL_CCCallBack cc,
		DHL_IrCallBack Ir)
{
	// ݹ 
	g_SignalInfoCallBack = signal;
	g_VideoStartCallBack = video;
	g_AudioStartCallBack = audio;
	g_SiCallBack = si;
	g_CCCallBack = cc;
	g_IrCallBack = Ir;
	// ʱȭ ۾
#ifdef DSTAR
	DHL_DISP_PresetVideoOutputFormat(DHL_VIDEO_WXGA);
	DHL_SYS_Initiate();
	DHL_PSI_Init(&hPsi);
	DHL_FE_Init(TUNER_FAT);
	DHL_DTV_Init();
	DHL_DMX_Init();
	DHL_DMX_Start();
	DHL_CAP_PresetAudioInput(DHL_CAP_DTV0_AUDIO);
	DHL_DEV_InitSmartCardInterface((void*)0); //   ϸ DSTAR   .
	DHL_CAP_Init();
	DHL_CAP_StartVideoEx(DHL_CAP_DTV0_VIDEO, DHL_CAP_VIDEO_NONE, DHL_PIPMODE_NONE, DHL_PIP_NO_PIP);
	DHL_DTV_StopAudio();
	DHL_CAP_ChangeAudioInput(DHL_CAP_DTV0_AUDIO);
	DHL_CAP_StartAudio();
	DHL_DTV_PresetCallback((void *) _DHL_VideoStartCallBack, DHL_CB_NOTIFY_VSTARTING, 1);
	DHL_CAP_PresetCallback2((DHL_CAP_CBFUNC2_t)_DHL_SignalInfoCallBack);
	DHL_DTV_PresetCallback((void *) _DHL_CCCallBack, DHL_CB_VDC_CCUDP, 0);
	DHL_DTV_InitCC();
	DHL_DTV_EnableCC();
	DHL_IR_Init(DHL_IR_NEC);
	DHL_IR_SetCbFunc(DSTAR_KeyCallBack);
	void test_cc();
	test_cc();
#else
	DHL_AV_SetCallback(eDHL_CB_VideoSeqHdr, _DHL_AV_CallBack);
	DHL_AV_SetCallback(eDHL_CB_FirstVideoShow, _DHL_AV_CallBack);
	DHL_AV_SetCallback(eDHL_CB_VideoUserData, _DHL_AV_CallBack);
	// IR ½ũ 
	static void tIRTask();
	DST_OS_SpawnTask((void(*)(void *))tIRTask, (char*)"tIRTask", APP_TASK_PRIO_IR, WIN_MGR_TASK_STACKSIZE,  0);
	IR_Open(IRCallback);
#endif
	return DHL_OK_;
}

DHL_ERROR DHL_SYS_TV_Close()
{
	return DHL_OK_;
}

#ifdef DSTAR
#else
#define PSIDataArray_t tDHL_PSI_DataArray
#define DHL_TBL_HANDLE tDHL_PSI_ControlHandle
#define PSIEvent tDHL_PSI_Event
#define psiDataReceived ePSIEVENT_DATARECEIVED
#endif

typedef struct PSIMultiEventProcData_t
{
	int err;
	DS_U32 hEvent;
	DS_U32 id;
	DS_U32 freq;
	DS_U16 sID;
} PSIMultiEventProcData;

static void CT_MultiEventProc(PSIEvent event, DHL_TBL_HANDLE hTblHandle, DS_U32 userParam)
{
	if (!hTblHandle || event != psiDataReceived) return;
	PSIDataArray_t *desc;
	if (DHL_PSI_ReadPSIData(hTblHandle, &desc) != DHL_OK) return;
	PSIMultiEventProcData *procData = (PSIMultiEventProcData *) userParam;
	if (g_SiCallBack) g_SiCallBack(procData->freq, procData->id, desc->sectPtr, 0);
	DHL_PSI_FreePSIData(desc);
}

#if 0
____Video___()
#endif

static int prev_lock = 0; // Tuner Lock 
// Video 
static bool g_power_display = true;
static bool bVideoStart = false;
DHL_ERROR DHL_VID_Start(DS_U16 VideoPID, DS_U16 PcrPID, DHL_VIDEO_TYPE type)
{
	if (bVideoStart == true) DHL_VID_Stop();
	if (g_power_display == false) return DHL_FAIL_; 
	if (prev_lock == 0) return DHL_FAIL_; 
	bVideoStart = true;
#ifdef DSTAR
	DHL_DTV_StartVideoEx2(VideoPID, PcrPID, type );
#else
	tDHL_VideoCodingType nType = eDHL_VIDEO_TYPE_H264;
	switch (type)
	{
		case DHL_VIDEO_MPEG1:
			nType = eDHL_VIDEO_TYPE_MPEG1;
			break;
		case DHL_VIDEO_MPEG2:
			nType = eDHL_VIDEO_TYPE_MPEG2;
			break;
		default:
			break;
	}
	T();
	DHL_AV_VideoStart(0, VideoPID, PcrPID, nType);
	T();
#endif
	return DHL_OK_;
}

// Video 
DHL_ERROR DHL_VID_Stop()
{
	if (bVideoStart == false) return DHL_OK_;
	 bVideoStart = false;
#ifdef DSTAR
	DHL_DTV_StopVideo();
#else
	T();
	DHL_AV_VideoStop(0);
#endif
	return DHL_OK_;
}

// Video Mute  ȭ   ʵ . CVBS 
// bMute = false --> Video Unmute
// bMute = true  --> Video Mute
DHL_ERROR DHL_VID_Mute(bool bMute)
{
#ifndef DSTAR
	DST_Printf("DHL_VID_Mute %d\n", bMute);
	DHL_AV_VideoHide(0, bMute ? 1 : 0);
#endif
	return DHL_OK_;
}

// Video Alive ڵ  ִ θ ˷ִ Լ
bool DHL_VID_Alive()
{
#ifndef DSTAR
	tDHL_VideoStatus vs;
	DHL_AV_VideoGetStatus(0, &vs);
	if (!vs.bOutputExist) return false;
#endif
	return true;
}

// Video Aspect 
// Է ASPECT(4:3 16:9)     尡 
DHL_ERROR DHL_VID_Aspect(DHL_ASPECT_RATIO ar, DS_U16 w, DS_U16 h)
{
#ifndef DSTAR
	tDHL_DispARC adj = eDHL_ARC_FULLSCREEN;
	switch (ar)
	{
		case DHL_ASPECT_4x3_4x3:
			adj = eDHL_ARC_FULLSCREEN;
			printf("DHL_ASPECT_4x3_4x3 eDHL_ARC_FULLSCREEN\n");
			break;
		case DHL_ASPECT_16x9_4x3_WIDE:
			adj = eDHL_ARC_LETTERBOX;
			printf("DHL_ASPECT_16x9_4x3_WIDE eDHL_ARC_FULLSCREEN\n");
			break;
		case DHL_ASPECT_16x9_4x3_NORMAL:
			adj = eDHL_ARC_FULLSCREEN;
			printf("DHL_ASPECT_16x9_4x3_NORMAL eDHL_ARC_SIDEBAR\n");
			break;
		case DHL_ASPECT_16x9_4x3_ZOOM:
			adj = eDHL_ARC_ZOOM2;
			printf("DHL_ASPECT_16x9_4x3_ZOOM eDHL_ARC_ZOOM1\n");
			break;
		default:
			break;
	}
	DHL_AV_VideoSetARC(adj, adj);
#endif
	return DHL_OK_;
}

#if 0
____Audio___()
#endif

// Audio 
// PcrPID == 0 ΰ Audio Only ä
static bool bAudioStart = false;
DHL_ERROR DHL_AUD_Start(DS_U16 AudioPid, DS_U16 PcrPID, DHL_AUDIO_TYPE type)
{
	DST_Printf("%s(0x%X, 0x%X, %d)\n", __func__, AudioPid, PcrPID, type);
	if (bAudioStart == true) DHL_AUD_Stop();
	bAudioStart = true;
#ifndef DSTAR
	tDHL_AudioCodingType nType = eDHL_AUDIO_TYPE_AAC_LATM;
	switch (type)
	{
		case DHL_AUDIO_MPEG1:
			nType = eDHL_AUDIO_TYPE_MPEG_1;
			break;
		case DHL_AUDIO_MPEG2:
			nType = eDHL_AUDIO_TYPE_MPEG_2;
			break;
		case DHL_AUDIO_AAC_ADTS:
			nType = eDHL_AUDIO_TYPE_AAC_ADTS;
			break;
		case DHL_AUDIO_AAC_LATM:
			nType = eDHL_AUDIO_TYPE_AAC_LATM;
			break;
		case DHL_AUDIO_AC3:
			nType = eDHL_AUDIO_TYPE_AC3;
			break;
		default:
			break;
	}
	DHL_AV_AudioStart(AudioPid, PcrPID, nType);
#endif
	return DHL_OK_;
}

// Audio 
DHL_ERROR DHL_AUD_Stop()
{
	if (bAudioStart == false) return DHL_OK_;
	bAudioStart = false;
#ifndef DSTAR
	T();
	DHL_AV_AudioStop();
#endif
	return DHL_OK_;
}

// Audio Volume, 0 is mute
DHL_ERROR DHL_AUD_Volume(DS_U8 nVal)
{
	static DS_U8 prev = 200;
	if (prev == nVal) return DHL_OK_;
	prev = nVal;	
//	DST_Printf("%s|%d\n", __func__, nVal);
#ifndef DSTAR
//	T();
	DHL_AV_AudioSetUserVolumeRange(0,100);
	if (nVal == 0)
	{
		DHL_AV_AudioSetVolume(0);
		DHL_AV_AudioMuteControl(eDHL_AUDIO_MUTE_GPIO, TRUE);
	}
	else
	{
		DHL_AV_AudioMuteControl(eDHL_AUDIO_MUTE_GPIO, FALSE);
		DHL_AV_AudioSetVolume(nVal);
	}
#endif
	return DHL_OK_;
}

// Audio Alive ڵ  ִ θ ˷ִ Լ
bool DHL_AUD_Alive()
{
#ifndef DSTAR
	tDHL_AudioStatus as;
	DHL_AV_AudioGetStatus(&as);
	if (!as.bOutputExist) return false;
#endif
	return true;
}

// Play   带 ȯѴ.
DHL_AUDIO_MODE DHL_AUD_GetMode()
{
	return DHL_AUDIO_STEREO;
}

#if 0
____SI___()
#endif

typedef struct 
{
	DS_U32 nRequestID;
	PSIMultiEventProcData *aProcData;
	void **aPsiCtl;
} DHL_SI_HANDLE;

#ifdef DSTAR
#else
#define tableMode ePSIMODE_TABLE
#define sectionMode ePSIMODE_SECTION
#define PSIMode tDHL_PSI_Mode
#endif

static DHL_HANDLE DHL_SI_Monitor(DS_U32 RF, DS_U32 nRequestID, DS_U16 pid, DS_U8 tableID, PSIMode psiMode, DS_U16 source_id/* = 0*/, bool bETT/* = false*/)
{
	DHL_SI_HANDLE *handle = (DHL_SI_HANDLE *)DST_OS_Calloc(1, sizeof(DHL_SI_HANDLE));
	handle->nRequestID = nRequestID;
	handle->aProcData = (PSIMultiEventProcData *)DST_OS_Calloc(1, sizeof(PSIMultiEventProcData));
	handle->aProcData->err = noError;
	handle->aProcData->id = nRequestID;
	handle->aProcData->freq = RF;
	handle->aPsiCtl = (void **)DST_OS_Calloc(1, sizeof(void *));
#ifdef DSTAR
	PSIMask_t *pref = 0;
	if (source_id)
	{
		if (bETT == false) // EIT
		{
			DD_PSI_GetEmptyPSIMask(5,&pref);
			pref->entries[0].value = (tableID == 0xFF) ? 0 : tableID;
			pref->entries[0].matchMask = (tableID == 0xFF) ? 0 : 0xFF;
			pref->entries[3].value = (source_id >> 8) & 0xFF;
			pref->entries[3].matchMask = 0xFF;
			pref->entries[4].value = source_id & 0xFF;
			pref->entries[4].matchMask = 0xFF;
		}
		else // ETT
		{
			DD_PSI_GetEmptyPSIMask(11,&pref);
			pref->entries[0].value = (tableID == 0xFF) ? 0 : tableID;
			pref->entries[0].matchMask = (tableID == 0xFF) ? 0 : 0xFF;
			pref->entries[9].value = (source_id >> 8) & 0xFF;
			pref->entries[9].matchMask = 0xFF;
			pref->entries[10].value = source_id & 0xFF;
			pref->entries[10].matchMask = 0xFF;			
		}
		T();
	}
	else
	{
		DD_PSI_GetEmptyPSIMask(1,&pref);
		pref->entries[0].value = (tableID == 0xFF) ? 0 : tableID;
		pref->entries[0].matchMask = (tableID == 0xFF) ? 0 : 0xFF;
	}
	if (pref)
	{
		DHL_RESULT err = DD_PSI_MonitorPSIPid(hPsi, pid, psiMode,  psiCRCChange,
			pref, 4*1024, 256, CT_MultiEventProc, (DS_U32)handle->aProcData, handle->aPsiCtl);
		if (err) PSI_Free(pref);
		if (err) DST_Printf( "\t !! %s err %d \n", __func__, err);
	}
#else
	tDHL_PSI_Filter *pref = 0;
	if (source_id)
	{
		if (bETT == false) // EIT
		{
			DHL_PSI_AllocGenericFilter(&pref);
			pref->coef[0]= (tableID == 0xFF) ? 0 : tableID;
			pref->mask[0]  = (tableID == 0xFF) ? 0xFF : 0x00;
			pref->coef[3]= (source_id >> 8) & 0xFF;
			pref->mask[3]  = 0x00;
			pref->coef[4] = source_id & 0xFF;
			pref->mask[4]  = 0x00;
		}
		else // ETT
		{
			DHL_PSI_AllocGenericFilter(&pref);
			pref->coef[0]= (tableID == 0xFF) ? 0 : tableID;
			pref->mask[0]  = (tableID == 0xFF) ? 0xFF : 0x00;
			pref->coef[9]= (source_id >> 8) & 0xFF;
			pref->mask[9]  = 0x00;
			pref->coef[10] = source_id & 0xFF;
			pref->mask[10]  = 0x00;	
		}
	}
	else
	{
		DHL_PSI_AllocGenericFilter(&pref);
		pref->coef[0] = tableID; // Table ID 0xFF̸ HAL MApi_DMX_SectPatternSet ̸ 0 
		pref->mask[0] = (tableID == 0xFF) ? 0xFF : 0x00;
		//	pref->mode[0] = 0xFF;
	}
	if (pref)
	{
	 	DHL_RESULT err = DHL_PSI_StartMonitor(tsd, pid, psiMode, ePSIUPDATE_CRCCHANGE,
	 		pref, 4*1024, 256, CT_MultiEventProc, (DS_U32)handle->aProcData, (tDHL_PSI_ControlHandle *)handle->aPsiCtl);
		if (err) DST_OS_Free(&pref);
	}
#endif
	return (DHL_HANDLE)handle;
}

DHL_HANDLE DHL_SI_MonitorPAT(DS_U32 RF, DS_U32 nRequestID)
{
	DST_Printf("%s nRequestID = %d\n", __func__, (int)nRequestID);
	return DHL_SI_Monitor(RF, nRequestID, 0x0000, 0x00, tableMode, 0, false);
}

DHL_HANDLE DHL_SI_MonitorPMT(DS_U32 RF, DS_U32 nRequestID, DS_U16 Pid, DS_U16 source_id)
{
	DST_Printf("%s nRequestID = %d pid = 0x%X\n", __func__, (int)nRequestID, Pid);
	return DHL_SI_Monitor(RF, nRequestID, Pid, 0x02, tableMode, source_id, false);
}

DHL_HANDLE DHL_SI_MonitorTVCT(DS_U32 RF, DS_U32 nRequestID)
{
	DST_Printf("%s nRequestID = %d\n", __func__, (int)nRequestID);
	return DHL_SI_Monitor(RF, nRequestID, 0x1FFB, 0xC8, tableMode, 0, false);
}

#if CVCT_SUPPORT
DHL_HANDLE DHL_SI_MonitorCVCT(DS_U32 RF, DS_U32 nRequestID)
{
	DST_Printf("%s nRequestID = %d\n", __func__, (int)nRequestID);
	return 0;
}
#endif

#if EPG_SUPPORT
DHL_HANDLE DHL_SI_MonitorMGT(DS_U32 RF, DS_U32 nRequestID)
{
	DST_Printf("%s nRequestID = %d\n", __func__, (int)nRequestID);
	return DHL_SI_Monitor(RF, nRequestID, 0x1FFB, 0xC7, tableMode, 0, false);
}
#endif

DHL_HANDLE DHL_SI_MonitorSTT(DS_U32 RF, DS_U32 nRequestID)
{
	DST_Printf("%s nRequestID = %d\n", __func__, (int)nRequestID);
	return DHL_SI_Monitor(RF, nRequestID, 0x1FFB, 0xCD, sectionMode, 0, false);
}

#if EPG_SUPPORT
DHL_HANDLE DHL_SI_MonitorEIT(DS_U32 RF, DS_U32 nRequestID, DS_U16 pid, DS_U16 source_id)
{
	DST_Printf("%s nRequestID = %d pid = 0x%X source_id =0x%X\n", __func__, (int)nRequestID, pid, source_id);
	return DHL_SI_Monitor(RF, nRequestID, pid, 0xCB, tableMode, source_id, false);
}

DHL_HANDLE DHL_SI_MonitorETT(DS_U32 RF, DS_U32 nRequestID, DS_U16 pid, DS_U16 source_id)
{
	DST_Printf("%s nRequestID = %d pid = 0x%X source_id =0x%X\n", __func__, (int)nRequestID, pid, source_id);
	return DHL_SI_Monitor(RF, nRequestID, pid, 0xCC, tableMode, source_id, true);
}
#endif

DHL_HANDLE DHL_SI_MonitorRFUpdate(DS_U32 RF, DS_U32 nRequestID)
{
	DST_Printf("%s nRequestID = %d\n", __func__, (int)nRequestID);
	return DHL_SI_Monitor(RF, nRequestID, 0x1FF5, 0xF5, sectionMode, 0, false);
}

DHL_HANDLE DHL_SI_MonitorSCTE_CVT(DS_U32 RF, DS_U32 nRequestID)
{
	DST_Printf("%s nRequestID = %d\n", __func__, (int)nRequestID);
#ifdef DSTAR
	return DHL_SI_Monitor(RF, nRequestID, 0xDE1, 0x3C, sectionMode, 0, false);
#else // CMB  PID Ҵް Ȯ  ؾ 
	//return DHL_SI_Monitor(RF, nRequestID, 0xDF1, 0x3C, sectionMode, 0, false);
	//return DHL_SI_Monitor(RF, nRequestID, 0x3A2, 0x3C, sectionMode, 0, false); // ݰ
	return DHL_SI_Monitor(RF, nRequestID, 0x1FEA, 0x3C, sectionMode, 0, false); // 
#endif
}

DHL_HANDLE DHL_SI_MonitorSCTE_DII(DS_U32 RF, DS_U32 nRequestID, DS_U16 pid)
{
	DST_Printf("%s nRequestID = %d 0x%X\n", __func__, (int)nRequestID, pid);
	return DHL_SI_Monitor(RF, nRequestID, pid, 0x3B, tableMode, 0, false);
}

DHL_HANDLE DHL_SI_MonitorSCTE_DDB(DS_U32 RF, DS_U32 nRequestID, DS_U16 pid)
{
	DST_Printf("%s nRequestID = %d 0x%X\n", __func__, (int)nRequestID, pid);
	return DHL_SI_Monitor(RF, nRequestID, pid, 0x3C, sectionMode, 0, false);
}

DHL_ERROR DHL_SI_MonitorStop(DHL_HANDLE* handle)
{
	if (handle == 0 || *handle == 0) return DHL_FAIL_;
	T();
	DHL_SI_HANDLE *h = (DHL_SI_HANDLE *)*handle;
	PSIMultiEventProcData *aProcData = h->aProcData;
	void **aPsiCtl = h->aPsiCtl;
#ifdef DSTAR
	DHL_PSI_CancelMonitor(aPsiCtl[0]);
#else
	DHL_PSI_StopMonitor((tDHL_PSI_ControlHandle)aPsiCtl[0]);
#endif
	if (aPsiCtl) DST_OS_Free(&aPsiCtl);
	if (aProcData) DST_OS_Free(&aProcData);
	DST_OS_Free(&h);
	*handle = 0;
	return DHL_OK_;
}

#if 0
____Tuner___()
#endif

// Ʃ 
// Khz  ļ
static DS_U32 tuner_start_tick = 0;
DHL_ERROR DHL_TUN_Start(int rf, DHL_MODULATION_MODE nMode)
{
	int freqkHz = DST_GetMHzFrequencybyIndex(rf) * 1000;
	if (DST_g_bUseAirFreq)
	{
		if (rf == DST_GetIndexByRFNumber(4)) freqkHz = 69 * 1000;
		if (rf == DST_GetIndexByRFNumber(18)) freqkHz = 497 * 1000;
		if (rf == DST_GetIndexByRFNumber(48)) freqkHz = 677 * 1000;
	}
	DST_Printf("%s|%d|Tune Freq = %d kHz\n", __func__, __LINE__, freqkHz);
#ifdef DSTAR
	change_file(rf, 0, 0, 1);
	TunerDemod demod = DEMOD_8VSB;
	if (nMode == DHL_MODULATION_64QAM) demod = DEMOD_64QAM;
	if (nMode == DHL_MODULATION_256QAM) demod = DEMOD_256QAM;
	DHL_FE_Start(TUNER_FAT, freqkHz, demod, FREQ);
#else
	static bool bInit = false;
	if (bInit == false)
	{
		bInit = true;
		T();
		DHL_FE_Init();
		T();
	}
	tDHL_Demod demod = eDHL_DEMOD_8VSB;
	if (nMode == DHL_MODULATION_64QAM) demod = eDHL_DEMOD_64QAM;
	if (nMode == DHL_MODULATION_256QAM) demod = eDHL_DEMOD_256QAM;
	T();
	DHL_FE_Start(0, freqkHz, demod, 0);
	T();
#endif
	tuner_start_tick = DST_OS_GetTickCount();
	return DHL_OK_;
}

// Ʃ 
DHL_ERROR DHL_TUN_Stop()
{
#ifdef DSTAR
	DHL_FE_Stop(TUNER_FAT);
#else
	DHL_FE_Stop(0);
#endif
	return DHL_OK_;
}

DHL_ERROR DHL_TUNE_Info(DS_U8 RF, int *SignalStrength, bool *bLock, int *nPower, int *nSNR)
{
	
#ifdef DSTAR
	*SignalStrength = rand() % 100;
	*bLock = true;
	*nPower = rand() % 100;
#else
	int i;
	static int prev_snr[5];
//	static int prev_lock = 0;
	if (tuner_start_tick > DST_OS_GetTickCount()) tuner_start_tick = DST_OS_GetTickCount();
	if (DST_OS_GetTickCount() - tuner_start_tick < DST_OS_GetTicksPerSecond()/10) // 100ms ̳ ȣ 
	{
		*bLock = false;
		*SignalStrength = 0;
		for (i=0; i < 5; i++) prev_snr[i] = -1;
		prev_lock = 0;
		return DHL_OK_;
	}
	
	int lock = 0, snr = 0, power = 0;
	DHL_RESULT dhl_fe_get_sig_info_detail(int *lock, int *snr, int* power);
	dhl_fe_get_sig_info_detail(&lock, &snr, &power);
	if (prev_lock != lock)
	{
		DST_Printf("tuner lock = %d  %d0msec\n", lock, DST_OS_GetTickCount() - tuner_start_tick);
		prev_lock = lock;
	}
//	DST_Printf("power = %d %d0msec\n", power, DST_OS_GetTickCount() - tuner_start_tick);
	if (lock == 0 || snr > 20000) snr = 0;	//  Ѵ.
	*nSNR = snr;
	for (i=0; i < 4; i++) prev_snr[i] = prev_snr[i+1];
	prev_snr[4] = snr;
	
	int nValidCount = 0;
	int nSum = 0;
	for (i=0; i < 5; i++)
	{
		if (prev_snr[i] < 0) continue;
		nValidCount++;
		nSum += prev_snr[i];
	}
	snr = nSum / nValidCount;
	// snr  0~12000  ̴.
	snr-=2000;
	if (snr > 12000) snr = 12000;
	if (snr < 0) snr = 0;
	snr/=100;
	*bLock = lock ? true : false;
	*SignalStrength = snr; // 佺ĵ LOCK ƴ   0 ũ ȣ ִ° Ѵ.
	*nPower = power;
	if (*SignalStrength > 100) *SignalStrength = 100;
//	DST_Printf("tick = %d\n", DST_OS_GetTickCount() - tuner_start_tick);
//	DST_Printf("bLock = %d SignalStrength = %d\n", *bLock, *SignalStrength);
#endif
	return DHL_OK_;
}

#if 0
____GFX___()
#endif

#ifdef DSTAR

#if OSD_PIXEL_BPP == 16
#define DS_PIXEL_t DS_U16
#define PIXEL_FORMAT 10 //PF_RGB16
#else
#define DS_PIXEL_t DS_U32
#define PIXEL_FORMAT 0 //PF_RGB32
#endif

/*extern "C" */void DHL_GFX_DrawImage( DS_U32 pBufferId, int offsetX, int offsetY, int w, int h, DS_PIXEL_t *pPixels);
/*extern "C" */void DHL_GFX_UpdateScreen(int Plane);
static DS_U32 id = 0;
static DS_U32 gMsgQ = 0;

static void tUpdateScreen()
{
	DS_U32 msg = 0;
	DS_U32 retLen;
	while (1)
	{
		//T();
		DST_OS_ReceiveMessage_NoWait(gMsgQ, (DS_U32*)&msg, sizeof(DS_U32), &retLen);
		DHL_GFX_UpdateScreen(0); // ΰ ½ũ ÿ ȣϸ ý ...
	}
}

static void DHL_UpdateScreen()
{
	DS_U32 msg = 0;
	if (gMsgQ) DST_OS_SendMessage(gMsgQ, &msg, sizeof(DS_U32));
}

void DHL_GFX_Open()
{
	static bool bInit = false;
	if (bInit == false)
	{
		DHL_GFX_Init(0,
			0, 0, DST_GetScreenWidth(), DST_GetScreenHeight() + 16,
			DST_GetScreenWidth(), DST_GetScreenHeight() + 16, PIXEL_FORMAT, &id);
		bInit = true;
		gMsgQ = DST_OS_CreateMessageQueue("qUpdateScreen", 0, 100, sizeof(DS_U32));
		/*DS_U32 TaskID = */DST_OS_SpawnTask((void(*)(void *))tUpdateScreen, (char*)"tUpdateScreen", APP_TASK_PRIO_WIN_MGR, WIN_MGR_TASK_STACKSIZE,  0);
	}
}

void DHL_GFX_Draw(OSD_PIXEL_T *src, int x, int y, int w, int h)
{
	DHL_GFX_DrawImage(id, x, y, w, h, src);
	DHL_UpdateScreen();
}

void DHL_SetLED(bool bRed, bool bGreen)
{
	static bool old_bRed = false;
	static bool old_bGreen = false;

	if (bRed == old_bRed && bGreen == old_bGreen) return;
	old_bRed = bRed;
	old_bGreen = bGreen;
	DHL_GFX_Open();
	OSD_PIXEL_T *src = (OSD_PIXEL_T *)DST_OS_Calloc(DST_GetScreenWidth() * 16, sizeof(OSD_PIXEL_T));
	OSD_PIXEL_T color = 0;
	if (bRed)
	{
		color = bGreen ? CONV32_16(0xFFFFFF00) : CONV32_16(0xFFFF0000);
	}
	else
	{
		color = bGreen ? CONV32_16(0xFF00FF00) : CONV32_16(0xFF000000);
	}
	int i;
	for ( i = 0; i < DST_GetScreenWidth() * 16; i++) src[i] = color;
	DHL_GFX_DrawImage(id, 0, DST_GetScreenHeight(), DST_GetScreenWidth(), 16, src);
	DHL_UpdateScreen();
	DST_OS_Free(&src);
}

#else

//extern "C" DS_U8 MsOS_Dcache_Flush(DS_U32 u32Start, DS_U32 u32Size);

void DHL_GFX_Open()
{
	T();
	DHL_RESULT DHL_GrpInit();
	DHL_GrpInit();
	T();
}

void DHL_GFX_Draw(OSD_PIXEL_T *src, int x, int y, int w, int h)
{
	void dhl_draw_image2(char* src, int x, int y, int w, int h);
	dhl_draw_image2((char*)src, x, y, w, h);
}

void DHL_SetLED(bool bRed, bool bGreen)
{
	static bool bFirst = true;
	static bool bRedOld = false;
	static bool bGreenOld = false;
	if (bFirst == true || bRedOld != bRed || bGreenOld != bGreen)
	{
		void dhl_led_control2(DS_U32 onoff);
		DS_U32 value = (bGreen ? 2 : 0) + (bRed ? 1: 0);
		{
			#include "bsettop_rfm.h"
			extern brfm_t	g_sys_rfm;
			buser_AOV_input_LED(g_sys_rfm, value);
		}	
		bFirst = false;
		bRedOld = bRed;
		bGreenOld =  bGreen;
	}
}
#endif

char *DST_GetBoardVersion(void)
{
	char *strVersion = (char*)"R0.1";
#ifndef DSTAR
	// TO DO GPIO  о H/W  ڿ ȯ
#endif
	return strVersion;
}

void DHL_SetCh34(DS_U8 nVal)
{
#ifndef DSTAR
	DHL_SetRFM34(nVal ? 1 : 0);
#endif
}

#if 0
____IR___()
#endif

static DS_U8 g_KeyPadGPIO = 0;
DS_U8 DHL_GetKeyPadGPIO()
{
#ifndef DSTAR
	// TO DO
	// KEY PAD GPIO о´
	// POWER = 1 UP  =2 DN =4
// TODO  Ȯ ʿ
//	g_KeyPadGPIO = DHL_SYS_ReadGPIO(7) ? 1:0;
//	g_KeyPadGPIO += DHL_SYS_ReadGPIO(GPIO_CH_UP/*6*/) ? 2: 0;
//	g_KeyPadGPIO += DHL_SYS_ReadGPIO(GPIO_CH_DN/*5*/) ? 4: 0;
#endif
	return g_KeyPadGPIO;
}

#ifdef DSTAR
// DSTAR NEC Ű 䳻  ½ũ 110ms Ű óѴ.
static DS_U32 DSTAR_KEY_MsgQ = 0;
typedef struct 
{
	DS_U32 Code;
	DS_U32 bPressed;
	DS_U32 tick;
} DSTAR_KEY;

static void tRepeatKey()
{
	DSTAR_KEY msg ={0,0,0};
	DS_U32 retLen = 0;
	DS_U32 tick = 0;
	while (1)
	{
//		T();
		DST_OS_Delay(10); // 10ms
		if (DSTAR_KEY_MsgQ == 0) continue;
		DSTAR_KEY tmp ={0,0,0};
		if (DST_OS_ReceiveMessage_NoWait(DSTAR_KEY_MsgQ, (DS_U32*)&tmp, sizeof(DSTAR_KEY), &retLen) == noError)
		{
			msg = tmp;
			if (msg.bPressed) 
			{
				if (g_IrCallBack) g_IrCallBack(msg.Code, 0, DST_OS_GetTickCount());
			}
			tick = DST_OS_GetTickCount();
		}
		if (msg.bPressed == 0) continue;
		if (tick > DST_OS_GetTickCount()) tick = DST_OS_GetTickCount();
		if (DST_OS_GetTickCount() - tick < DST_OS_GetTicksPerSecond()/10) continue;
		if (msg.bPressed) 
		{
			if (g_IrCallBack) g_IrCallBack(msg.Code, 1, DST_OS_GetTickCount());
		}
		tick = DST_OS_GetTickCount();
	}
}

// DSTAR Ű ݹ
static void DSTAR_KeyCallBack(int bRemocon, DS_U32 Code, int bPressed)
{
	DST_Printf("|%s| code = 0x%02X, bPressed = %d\n", __func__, (int)Code, bPressed);
	static bool bStart = true;
	if (bStart == true)
	{
		bStart = false;
		DSTAR_KEY_MsgQ = DST_OS_CreateMessageQueue("DSTAR_KEY", 0, 100, sizeof(DSTAR_KEY));
		DST_OS_SpawnTask((void(*)(void *))tRepeatKey, (char*)"DSTAR_KEY", APP_TASK_PRIO_WIN_MGR, WIN_MGR_TASK_STACKSIZE,  0);
}
	// Űе带 䳻  Ű
	// Home + -
	if (Code == 0xCAFE0116 || Code == 0xCAFE010E || Code ==0xCAFE010D)
	{
		// DSTAR Űе
		if (bPressed == 1)
		{
			if (Code ==0xCAFE0116) g_KeyPadGPIO = 1;// home key
			if (Code ==0xCAFE010E) g_KeyPadGPIO = 2;// +
			if (Code ==0xCAFE010D) g_KeyPadGPIO = 4;// -
		}
		else
		{
			g_KeyPadGPIO = 0;
		}
	}
	else
	{
		DSTAR_KEY msg;
		msg.Code = Code;
		msg.bPressed = bPressed;
		msg.tick = DST_OS_GetTickCount();
		DST_OS_SendMessage(DSTAR_KEY_MsgQ, (DS_U32 *)&msg, sizeof(DSTAR_KEY));
	}
}
#else

static DS_U32 g_ir_code = 0;
static DS_U32 g_ir_repeat = 0;
static void tIRTask()
{
	while (1)
	{
		DST_OS_Delay(10);
		if (g_ir_code == 0) continue;
		DS_U32 ir_code = g_ir_code;
		DS_U32 ir_repeat = g_ir_repeat;
		g_ir_code = 0;
		g_ir_repeat = 0;
		DST_g_KeyPressTime = DST_OS_GetTickCount();
		if (g_IrCallBack) g_IrCallBack(ir_code, ir_repeat, DST_g_KeyPressTime);
	}
}
static void IRCallback(unsigned int code, unsigned int repeat)
{
	int i = 0;
	unsigned int _code = 0;
	for (i = 0; i < 32; i++) // Ʈ 
	{
		_code |= ((code >> i) & 0x1) << (31-i);
	}
	g_ir_code = _code;
	g_ir_repeat = (repeat == 85) ? 0 : 1;
}

#endif


#if 0
____OS___()
#endif

DS_U32 DST_OS_GetTickCount()
{
	static DS_U32 sema4 = 0;
	if (sema4== 0) sema4 = DST_OS_CreateLock((char*)"tick");
	DST_OS_Lock(sema4);
	static unsigned int old_tick = 0;
    static unsigned int loop = 0;
#ifdef DSTAR
	static unsigned start_tick = 0;
	if (start_tick == 0) start_tick = OS_GetTickCount();
    unsigned int tick = (OS_GetTickCount() - start_tick) & 0xFFFF;
#else
    unsigned int tick = (osi_gettickcount() >> 1) & 0xFFFF;
#endif
    if (old_tick > tick) loop += 0x10000;
    old_tick = tick;
    unsigned int ret = loop  + tick;
    DST_OS_Unlock(sema4);
    return ret;
}

void DST_OS_Delay(DS_U32 ms)
{
#ifdef DSTAR
	if (ms < 10) ms = 10;
	OS_Delay(ms/10);
#else
	DHL_OS_Delay(ms);
#endif
}

DS_U32 DST_OS_GetTicksPerSecond()
{
#ifdef DSTAR
	return OS_GetTicksPerSecond();
#else
	return 100;
#endif
}

void DST_OS_GetRunTime(DS_U32 *hour, DS_U32 *min, DS_U32 *sec)
{
	DS_U32 n_sec = DST_OS_GetTickCount() / DST_OS_GetTicksPerSecond();
	DS_U32 n_min = n_sec / 60;
	DS_U32 n_hour = n_min / 60;
	*sec = n_sec % 60;
	*min = n_min % 60;
	*hour = n_hour;
}

DS_U32 DST_OS_SpawnTask (void (*func)(void* ), char *name, DS_U16 prio, DS_U16 stacksize, DS_U32 arg)
{
#ifdef DSTAR
	return OS_SpawnTask((void (*)(DS_U32))func, name, prio, stacksize, arg);
#else
	return DHL_OS_CreateTask(func, name, prio, stacksize, arg);
#endif
}

void DST_OS_SelfDeleteTask()
{
#ifdef DSTAR
#else
	DHL_OS_SelfDeleteTask();
#endif
}

DS_U32 DST_OS_ReceiveMessage_NoWait(DS_U32 qId, DS_U32 *msgBuf, DS_U32 maxLen, DS_U32 *retLen)
{
#ifdef DSTAR
	return OS_ReceiveMessage_NoWait(qId, msgBuf, maxLen, retLen);
#else
	return DHL_OS_ReceiveMessage((DHL_OS_MSGQ_ID)qId, msgBuf, 0);
#endif
}

DS_U32 DST_OS_ReceiveMessage_Wait(DS_U32 qId, DS_U32 *msgBuf, DS_U32 maxLen, DS_U32 *retLen, DS_U32 timeOut)
{
#ifdef DSTAR
	if (timeOut < 10) timeOut = 10;
	return OS_ReceiveMessage_Wait(qId, msgBuf, maxLen, retLen, timeOut/10);
#else
	return DHL_OS_ReceiveMessage((DHL_OS_MSGQ_ID)qId, msgBuf, timeOut == 0 ? DHL_TIMEOUT_FOREVER : timeOut);
#endif
}

DS_U32 DST_OS_SendMessage (DS_U32 qId, DS_U32 *pBuffer, DS_U32 nBytes)
{
#ifdef DSTAR
	return OS_SendMessage(qId, pBuffer, nBytes);
#else
	return DHL_OS_SendMessage((DHL_OS_MSGQ_ID)qId, pBuffer, nBytes);
#endif
}

DS_U32 DST_OS_DeleteMessageQueue(DS_U32 qId)
{
#ifdef DSTAR
	return OS_DeleteMessageQueue(qId);
#else
	DHL_OS_DeleteMessageQueue((DHL_OS_MSGQ_ID)qId);
	return 0;
#endif
}

DS_U32 DST_OS_CreateMessageQueue (const char *name, DS_U32 option, DS_U32 maxMessage, DS_U32 messageLength)
{
#ifdef DSTAR
	return OS_CreateMessageQueue (name, option, maxMessage, messageLength);
#else
	return (DS_U32)DHL_OS_CreateMessageQueue (name, option, maxMessage, messageLength);
#endif
}

DS_U32 DST_OS_CreateLock(char *name)
{
#ifdef DSTAR
	return OS_CreateMutex(name);
#else
	return (DS_U32)DHL_OS_CreateMutexSemaphore(name);
#endif
}

void DST_OS_Lock(DS_U32 id)
{
#ifdef DSTAR
	OS_TakeMutex(id);
#else
	DHL_OS_TakeSemaphore((void*)id, DHL_TIMEOUT_FOREVER);
#endif
}

void DST_OS_Unlock(DS_U32 id)
{
#ifdef DSTAR
	OS_GiveMutex(id);
#else
	DHL_OS_GiveSemaphore((void*)id);
#endif
}

#if 0
____MEMORY___()
#endif

// LEVEL 0  ̾
// ÷  ؾ ϴ ̾
// malloc free ⿡ Ѵ.

// LEVEL 1 C ǥԼ 
// malloc free calloc realloc  C ̽ ϰ 
// freetype sqlite  ýÿ ȣ
// C ǥԼ ȣȯǴ ޸ Լ (̺귯 ÿ)
// C   extern "C"  

void *DST_OS_MallocDirect(int size) // malloc
{
	if (size <= 0) return 0;
#ifdef DSTAR
	void *p = malloc(size);
#else
	void *p = OS_Malloc(size);
#endif

	memset(p, 0, size);
	return p;
}

void *DST_OS_CallocDirect(int num, int size) // calloc
{
	return DST_OS_MallocDirect(num * size);
}

void DST_OS_FreeDirect( void *ptr) // free
{
#ifdef DSTAR
	free(ptr);
#else
	OS_FreeDirect(ptr);
#endif
}

void *DST_OS_ReallocDirect(void *ptr, int size) // realloc
{
    if (!ptr) return DST_OS_MallocDirect(size);
    void *nptr = DST_OS_MallocDirect(size);
    if (!nptr) return NULL;
    memcpy(nptr,ptr,size);
    DST_OS_FreeDirect(ptr);
    return nptr;
}



// LEVEL 2 APP ȣ Լ 
// ޸ Ʈ ؼ Ȯ  ִ.

#define MAX_FUNC_NAME 32 //  ִ Լ ̸ 
#define MAX_COUNT 500 //  

typedef struct
{
	char func[MAX_FUNC_NAME+1];
	int nLine;
	void *p;
	int nSize;
	unsigned int tick;
} MEM_LIST;

static MEM_LIST memlist[MAX_COUNT];

void DST_OS_PrintMemUnit(void)
{
	int i = 0, nSum = 0, nCount = 0;
	DST_Printf("|------------+----------+----------------------------------+------|\n");
	DST_Printf("|   Address  |    Size  |             Function             | Line |\n");
	DST_Printf("|------------+----------+----------------------------------+------|\n");
	for (i = 0; i < MAX_COUNT; i++)
	{
		if (memlist[i].p == 0) continue;
		DST_Printf("| 0x%08X | %8d | %32s | %4d | %4d |\n", (int)memlist[i].p, memlist[i].nSize, memlist[i].func, memlist[i].nLine, (int)(DST_OS_GetTickCount() - memlist[i].tick)/100 );
		nSum+=memlist[i].nSize;
		nCount++;
	}
	DST_Printf("|------------+----------+----------------------------------+------|\n");
	DST_Printf("| %10d | %8d |                                         |\n", nCount, nSum);
	DST_Printf("|------------+----------+----------------------------------+------|\n");
}

static void Add_MemUint(const char* func, int nLine, void *p, int nSize)
{
	int i = 0;
	for (i = 0; i < MAX_COUNT; i++)
	{
		if (memlist[i].p != 0) continue;
		if (strlen(func) > MAX_FUNC_NAME)
		{
			memcpy(memlist[i].func, func, MAX_FUNC_NAME);
			memlist[i].func[MAX_FUNC_NAME] = 0;
		}
		else
		{
			strcpy(memlist[i].func, func);
		}
		memlist[i].nLine = nLine;
		memlist[i].p = p;
		memlist[i].nSize = nSize;
		memlist[i].tick = DST_OS_GetTickCount();
		break;
	}
	//Print_MemUnit();
}


static void Del_MemUnit(void *p, const char * func, int nLine)
{
	int i = 0;
	if (p == 0) return;
	for (i = 0; i < MAX_COUNT; i++)
	{
		if (memlist[i].p != p) continue;
		memlist[i].p = 0;
		break;
	}
	if (i >= MAX_COUNT)
	{
#if 0
		DST_Printf("\n\n\n\nTry to delete unallocated memory 0x%08X. %s %d\n\n\n", (int)p, func, nLine);
		Print_All_MemUnit();
		DST_OS_Delay(5);
#endif
	}
	//Print_MemUnit();
}

void *_DST_OS_Malloc(unsigned int size, const char* func, int nLine)
{
	void *p = 0;
	if (size == 0) return 0;
	p = DST_OS_MallocDirect(size);
	if (p == 0)
	{
		DST_Printf("%s|%s|%d|size =%d|Out of memory\n", __func__, func, nLine, size);
		DST_OS_PrintMemUnit();
	}
	else
	{
		Add_MemUint(func, nLine, p, size);
	}
	return p;
}

void *_DST_OS_Calloc(unsigned int count, unsigned int size, const char* func, int nLine)
{
	void *p = _DST_OS_Malloc(count * size, func, nLine);
	if (!p) return 0;
	memset(p, 0, count*size);
	return p;
}

void _DST_OS_Free(void *where, const char* func, int nLine)
{
	if (where == 0) return;
	Del_MemUnit(where, func, nLine);
	DST_OS_FreeDirect(where);
	where = 0;
}

#if 0
____POWER___()
#endif

void DHL_SYS_Off()
{
#ifdef DSTAR
	DHL_SYS_Terminate();
	exit(1);
#else
	DHL_SYS_Reset(eDHL_RESET_Standby);
#endif
}

void DHL_SYS_Reboot()
{
#ifdef DSTAR
	DHL_SYS_Reset();
	exit(1);
#else
	DHL_SYS_Reset(eDHL_RESET_Reboot);
#endif
}

// Video  On / OFF
void DHL_POWER_Display(bool bOn)
{
	static bool bOn_Old = true;
	if (bOn == bOn_Old) return;
	if (bVideoStart == true) return; //  ۽ÿ  ʵ Ѵ
	bOn_Old = bOn;
	T();
	DST_Printf("%s %s\n", __func__, bOn ? "On" : "Off");
#ifdef DSTAR
#else
	void DHL_AV_DispStop(BOOL onoff);
	DHL_AV_DispStop(bOn ? 0 : 1);
	DHL_RESULT DHL_SetLTO(BOOL onoff);
	DHL_SetLTO(bOn ? 0 : 1);
#endif
	g_power_display = bOn;
}

// Flash Memory Bank ȣ о´.
// Flash ޸ ù° Ʈ 1 ƴϸ Bank0 1̸ Bank1̴.
static DS_U8 g_BankNumber = 0xFF;
// Return  0̸ Bank0 1̸ Bank1
bool DHL_INFO_GetBankNumber()
{
	if (g_BankNumber == 0xFF)
	{
		DS_U8* buff = DHL_Flash_Read(FLASH_BANK_SELECT_POS, 1);
		g_BankNumber = (buff[0]==1) ? 1 : 0;
		DST_OS_Free(&buff);
	}
	return g_BankNumber ==1 ? 1 : 0;
}

void DHL_INFO_SetBankNumber(DS_U8 data)
{
	if (FLASH_TOTAL_SIZE < 8*1024*1024) data = 0; // 4MB Flash Bank ׻ 0̴
	if (g_BankNumber == data) return;
	DHL_Flash_Write(FLASH_BANK_SELECT_POS, 1, & data);
	DST_Printf("%s %d\n", __func__, data);
	g_BankNumber = data;
}

// Flash Memory LAST POWER STATE о´.
// Flash ޸ ù° Ʈ 0̸ OFF  0 ƴϸ ON̴.
static DS_U8 g_LastPowerState = 0xFF;
bool DHL_INFO_GetLastPowerState()
{
	if (g_LastPowerState == 0xFF)
	{
		DS_U8* buff = DHL_Flash_Read(FLASH_LAST_POWER_POS, 1);
		g_LastPowerState = (buff[0]!=0) ? 1 : 0;
		DST_OS_Free(&buff);
	}
	return g_LastPowerState ? true : false;
}

void DHL_INFO_SetLastPowerState(bool bOn)
{
	DS_U8 data = bOn ? 1 : 0;
	if (g_LastPowerState == data) return;
//	data = 1; // JUST TEST
	DHL_Flash_Write(FLASH_LAST_POWER_POS, 1, & data);
	DST_Printf("%s %d\n", __func__, data);
	g_LastPowerState = data;
}

#if 0
____Flash_Memory___()
#endif

static void FlashLock(bool bLock)
{
	static DS_U32 sema4 = 0;
	if (sema4== 0) 
	{
#ifndef DSTAR
		// DHL_NVM_Init(); // DHL_SYS_PlatformInit  ȣϹǷ 
#endif
		sema4 = DST_OS_CreateLock((char*)"flash");
	}
	bLock ? DST_OS_Lock(sema4) : DST_OS_Unlock(sema4);
}

DS_U32 FLASH_TOTAL_SIZE =  (8*1024*1024);
DS_U32 FLASH_BANK1_POS = (0x400000);

// 4Kbyte   Write 0~1023  ͹ȣ
static void _FlashWrite(DS_U16 nSector, DS_U16 nSize, DS_U8* data)
{
#ifndef DSTAR
	DHL_RESULT DHL_NVM_FlashWrite(int flashId, UINT32 offset, UINT8 *pBuffer, UINT32 len);
	if (DHL_NVM_FlashWrite(0, nSector * 4096, data, nSize) != 0)
	{
		DST_Printf("|%s|Err|DHL_NVM_FlashWrite(addr:0x%X, len:%d)\n",__func__, nSector * 4096, nSize);
	}
#else
	if (nSector*4096 + nSize >= FLASH_TOTAL_SIZE)
	{
		T();
		exit(1);
	}
	FILE *fp = fopen("flash.bin" , "rb+");
	fseek(fp, nSector * 4096, SEEK_SET);
	fwrite(data, 1, nSize, fp);
	fclose(fp);
#endif
}

// address 4Kbyte  ؾ Ѵ.
// nSize  ̷  .
void DHL_Flash_Write(DS_U32 address, DS_U32 nSize, DS_U8 *data)
{
	if (address%4096 != 0)
	{
		DST_Printf("%s|invalid address = %d(0x%X) nSize = %d\n", __func__, (int)address, (int)address, (int)nSize);
		return;
	}
	FlashLock(true);
	// 4Kbyte   ȣѴ.
	DS_U32 i;
	for ( i =  0; i < nSize; i+= 4096)
	{
		DS_U32 nSize2 = 4096;
		if (i+nSize2 > nSize) nSize2 = nSize - i;
		_FlashWrite((address + i)/4096, nSize2, &data[i]);
	}
	FlashLock(false);
}

// ȣ ʿ ޸  ʿ
// ׻ Write  ȣǹǷ ʱȭ ڵ嵵 Ѵ.
DS_U8* DHL_Flash_Read(DS_U32 address, DS_U32 nSize)
{
	FlashLock(true);
	DS_U8* data = (DS_U8*)DST_OS_Malloc(nSize);
#ifdef DSTAR
	if (address + nSize >= FLASH_TOTAL_SIZE)
	{
		T();
		exit(1);
	}
	//   Ѵ.
	FILE *fp = fopen("flash.bin" , "rb");
	int nFileLength = 0;
	if (fp)
	{
		fseek(fp, 0, SEEK_END);
		nFileLength = ftell(fp);
		fclose(fp);
	}
	if (nFileLength != FLASH_TOTAL_SIZE)
	{
		fp = fopen("flash.bin", "wb");
		DS_U8 *tmp = (DS_U8*)DST_OS_Malloc(FLASH_TOTAL_SIZE);
		memset(tmp,0xFF, FLASH_TOTAL_SIZE);
		fwrite(tmp, 1, FLASH_TOTAL_SIZE, fp);
		DST_OS_Free(&tmp);
		fclose(fp);
	}
	fp = fopen("flash.bin" , "rb");
	fseek(fp, address, SEEK_SET);
	fread(data, 1, nSize, fp);
	fclose(fp);
#else
	// TO DO Flash Init DHL_SYS_PlatformInit ̹ ȣ
	// TO DO Flash Read
	DHL_RESULT DHL_NVM_FlashRead(int flashId, UINT32 offset, UINT8 *pBuffer, UINT32 len);
	if (DHL_NVM_FlashRead(0, address, data, nSize) != 0)
	{
		DST_Printf("|%s|Err|DHL_NVM_FlashRead(addr:0x%x, len:0x%x)\n",__func__, (int)address, (int)nSize);
	}
#endif
	FlashLock(false);
	return data;
}


// ministd  ʴ stdc Լ

int dst_atoi(char *st)
{
        bool bMinus = false;
 		if (*st == '-' ) 
 		{
 			bMinus = true;
 			st++;
 		}
 		int i = 0;
        while((*st >= '0' && *st <= '9'))
        {
                i = i * 10 + (*(st)) - '0';
                st++;
        }
        return bMinus ? -i : i;
}

#ifndef DSTAR
void *memchr(s, c, n)
	const void *s;
	register unsigned char c;
	register size_t n;
{
	if (n != 0) {
		register const unsigned char *p = s;

		do {
			if (*p++ == c)
				return ((void *)(p - 1));
		} while (--n != 0);
	}
	return (0);
}
#include <time.h>
struct tm * gmtime(register const time_t *timer)
{
	static struct tm br_time;
	return &br_time;
}

size_t strftime(char *s, size_t maxsize,	const char *format,  const struct tm *t)
{
	s[0] = 0;
	return 0;
}
#endif


#ifdef DSTAR // CC Feeding  ׽Ʈ Լ
#include <stdlib.h>
#define SIZE_BUFF (1024*32)
static void ttest__cc()
{
	FILE *fp = fopen("/home/megakiss/stream/KBS.tp", "rb");
	if (fp == 0) return;
	while(1)
	{
		OS_Delay(OS_GetTicksPerSecond()/100);
		DS_U8 buff[SIZE_BUFF*2];
		int n = fread(buff, 1,SIZE_BUFF, fp);
		if (n != SIZE_BUFF)
		{
			fclose(fp);
			return;
		} 
		_DHL_CCCallBack( SIZE_BUFF, buff);
	}
}

static void ttest_cc()
{
	while (1)
	{
		OS_Delay(OS_GetTicksPerSecond());
		ttest__cc();
	}
}

void test_cc()
{
	static int taskID = 0;
	if (taskID) return;
	taskID = OS_SpawnTask((void (*)(DS_U32)) ttest_cc, (char*)"ttest_cc", APP_TASK_PRIO_WIN_MGR, WIN_MGR_TASK_STACKSIZE, 0);
}
#endif // CC Feeding  ׽Ʈ Լ
