#include "DST_WinManager.h"
#include "DST_ChannelTune.h"
#include "DST_DB.h"
//#include "DST_OTC_Main.h"
#include "DST_ISDBT_ChannelTask.h"
#include "DST_MemoryDB.h"

#if 0
____CBasicSystemWin___()
#endif

bool DST_IsTuneMode();

//class CBasicSystemWin : public CWindow
//{
//private:
	static int nScanCount = 0;
	static int nRF = 10000;
	static bool bPSIPTimeOut = false; // LOCK ȵǰų PSIP ޾Ƽ ŸӾƿ  
	static bool bLockTimeOut = false; // LOCK ȵǰų PSIP ޾Ƽ ŸӾƿ  
	static bool bReceiveTVCT = false; // PSIP ޾Ҵ.
	static int    nPrevChannelCount = 0; //  ش RF  ִ äΰ
//public:
//	virtual ~CBasicSystemWin()
	void CBasicSystemWin_Destructor(CWindow *pWin)
	{
		DST_Printf("\n\n\n\n\n\n\n\n\n\nERROR : Base Window Deleted!!!!\n\n\n\n\n\n\n\n\n\n\n");
	}
//	CBasicSystemWin(SWinEventMsg event):CWindow(event)
	void CBasicSystemWin_CBasicSystemWin(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "Basic");
		this->RegisterAllKey(this);
		this->RegisterKey(this, VK_LEFT, true, KEY_DELAY_VOLUME, KEY_REPEAT_VOLUME);
		this->RegisterKey(this, VK_RIGHT, true, KEY_DELAY_VOLUME, KEY_REPEAT_VOLUME);
		this->RegisterKey(this, VK_UP, true, KEY_DELAY_CHANNEL, 400);
		this->RegisterKey(this, VK_DN, true, KEY_DELAY_CHANNEL, 400);
		this->SetTimeOut(this, 0);
		nScanCount = 0;
//		DST_CreateWin(WIN_MAIN_MENU, WIN_NULL,0,0,0,0);
	}

//	virtual void OnMessage(SWinEventMsg event)
	void CBasicSystemWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		if (event.cmd == WM_CVT)
		{
			this->KillTimer(this, 1); // Background Scan Ѵ.
			memcpy(&DST_g_strSWVersion[0], &event.data[0], 16);
			DS_U8 download_command = event.data32[4];
			DST_g_OTC_Modulation_type = (event.data32[5]==1)?(DHL_MODULATION_64QAM):(DHL_MODULATION_256QAM);
			DST_g_OTC_RF = event.data32[6];
			DST_g_OTC_PID = event.data32[7];
			
			DST_Printf("WM_CVT\n");
			DST_Printf("strSWVersion = %02X %02X %02X %02X\n", DST_g_strSWVersion[0], DST_g_strSWVersion[1], DST_g_strSWVersion[2], DST_g_strSWVersion[3]); 
			DST_Printf("download_command = %s(%d)\n", download_command==0 ? "Download Now" : download_command==1 ? "Deferred Download" : "No Exception", download_command);
			DST_Printf("modulation_type = %s(%d)\n", event.data32[5]==1 ? "64QAM" : "256QAM", (int)event.data32[5]);
			DST_Printf("rf = %d Hz\n", (int)DST_g_OTC_RF);
			DST_Printf("pid = 0x%X\n", DST_g_OTC_PID);
			download_command = 2; //   Ѵ.			
			JST_OTC(DST_GetIndexByMHzFrequency(DST_g_OTC_RF/1000000), (DHL_MODULATION_MODE)DST_g_OTC_Modulation_type, DST_g_OTC_PID);
			DST_CreateWin(WIN_OTC_DOWNLOAD, WIN_NULL, 0,0,0,0);
		}
		
		switch (event.cmd)
		{
			case WM_SIGNAL_STATE:
				if (DST_g_PowerOn == false)
				{
					if (DST_GetWin(WIN_ERROR)) DST_CloseWin(WIN_ERROR);
					break;
				}
				switch (event.data32[0])
				{
					case SM_WAIT_SIGNAL:
					case SM_GOOD_SIGNAL: // Good Signal
						if (DST_GetWin(WIN_ERROR)) DST_CloseWin(WIN_ERROR);
						break;
					case SM_NO_PROGRAM:
					case SM_AUDIO_ONLY:
						if (DST_g_HWTestMode == false && DST_g_bFactoryMode == false) DST_CreateWin(WIN_ERROR, WIN_NULL, event.data32[0],0,0,0);
						break;
					case SM_WEAK_SIGNAL: // Error 
						if (DST_GetWin(WIN_UPDATE)) break;
						if (DST_GetWin(WIN_POWER_DOWN_CAUTION)) break;
						if (DST_GetWin(WIN_OTC_DOWNLOAD)) break;
//						if (DST_GetWin(WIN_CHANNEL_BANNER)) break;
						if (DST_GetWin(WIN_DIRECT_TUNE)) break;
//						if (DST_GetWin(WIN_VOLUME)) break;
//						if (DST_GetWin(WIN_VOLUME_MUTE)) break;
						if (DST_GetWin(WIN_SIGNAL_METER)) break;
						if (DST_GetWin(WIN_AUDIO_HOT)) break;
//						if (DST_GetWin(WIN_DISPLAY_MODE_HOT)) break;
						if (DST_GetWin(WIN_CLOSED_CAPTION_HOT)) break;
						if (DST_GetWin(WIN_AGE_RATING)) break;
						if (DST_GetWin(WIN_FACTORY_RESET)) break;
						if (DST_GetWin(WIN_MAIN_MENU)) break;
						if (DST_GetWin(WIN_PASSWD_CONFIRM)) break;
						if (DST_GetWin(WIN_PASSWD_CHANGE)) break;
						if (DST_GetWin(WIN_PASSWD_CHECK)) break;
						if (DST_GetWin(WIN_AUTO_SEARCH)) break;
						if (DST_GetWin(WIN_MANUAL_SEARCH)) break;
						if (DST_GetWin(WIN_PROGRAM_GUIDE)) break;
						if (DST_GetWin(WIN_CHANNEL_LIST)) break;
						if (DST_g_HWTestMode == false && DST_g_bFactoryMode == false) DST_CreateWin(WIN_ERROR, WIN_NULL, event.data32[0], 0,0,0);
						break;

					default:
						break;
				}
				break;
				
			case WM_POWER_DOWN_ENTER:
				JST_POWER_Display(false);
				printf("Channel Count = %d\n", CT_ChMapCount());
				DST_PowerDown();
				break;
				
			case WM_POWER_OFF:
				DST_Printf("WM_POWER_OFF\n");
				DST_g_PowerOn = false;
				DST_g_SleepTimer = 0;
				DST_g_sleepTimercheckTime = 0;
				DST_g_bSleepTimerOut = false;
				DST_g_PrevRF = 0;
				DST_g_PrevProgramNumber = 0;
				DST_UI_InitMenuCursor();
				
#if 1
				JST_POWER_Display(false);
				DHL_INFO_SetLastPowerState(true); // AC Ŀ  ׻  Ѵ. 
				DST_RemoveAllWindowExceptBasicWin();
				nScanCount = 0;
				// CMB CVT ļ 639MHz
				//JST_CVT(DST_GetIndexByMHzFrequency(639), DHL_MODULATION_256QAM); // CMB OTC üũ
				//JST_CVT(DST_GetIndexByMHzFrequency(651), DHL_MODULATION_256QAM); // ݰ
				JST_CVT(DST_GetIndexByMHzFrequency(639), DHL_MODULATION_256QAM); // 
				this->SetTimer(this, 1, 5000);
#else   // 忡 Ű  ٷ  ӽ 
				DST_PowerDown();
#endif
				break;
				
			case WM_POWER_ON:
				this->KillTimer(this, 1); // Background Scan Ѵ.
				DHL_INFO_SetLastPowerState(true);
				T();
				nScanCount = 0;
				DST_g_PowerOn = true;
				DST_UI_SetMute(false);
				DST_DB_TuneFirstChannel();
				JST_POWER_Display(true);
				break;
			
			case WM_CT_MSG:
				if (DST_g_PowerOn == true) break;
				switch (event.data32[0])
				{
					case CT_SCAN_START:
//						T();
						bPSIPTimeOut = false; // LOCK ȵǰų PSIP ޾Ƽ ŸӾƿ  
						bLockTimeOut = false; // LOCK ȵǰų PSIP ޾Ƽ ŸӾƿ  
						bReceiveTVCT = false; // PSIP ޾Ҵ.
						nPrevChannelCount = 0;
						DBLock(true);
						{
							int i;
							for (i = 0; i < DB_CHANNEL_DB_MAX; i++) 
							{
								if (db_channel_db[i].program_number == 0) continue;
								if (db_channel_db[i].rf != event.data32[1]) continue;
								nPrevChannelCount++;
								break;
							}
						}
						DBLock(false);
						break;
						
					case CT_SCAN_PSIP_WAIT:
//						T();
						if (event.data32[2] < 7000) break;
						if (bPSIPTimeOut || bLockTimeOut || bReceiveTVCT) break;
						bPSIPTimeOut = true;
						if (nScanCount > 0 && CT_ScanFindChannel() == false) JST_DB_Del(event.data32[1]);
						if (nScanCount > DST_MaxRF() - DST_MinRF()+1 - DST_DB_GetExceptRFCount())
						{
							DST_SendWindowEventWithOnlyCmd(WM_POWER_DOWN_ENTER);
							return;
						}
						//nRF = (nRF >= DST_MaxRF()) ? DST_MinRF() : nRF+1;
						nRF = DST_DB_GetNextUnexceptRF(nRF);
						JST_Scan(nRF);
						nScanCount++;
						break;
							
					case CT_SCAN_LOCK_WAIT:
//						T();
						if (event.data32[4] < 20) // POWER LEVEL 20   ȣ °ɷ ϰ ٷ .
						{
							if (event.data32[2] < 200) break; 
						}
						else if (event.data32[4] < 27) // POWER LEVEL 27   ̾ȣ ǴϿ 2.2 ٸ.
						{
							if (event.data32[2] < 2200) break; 
						}
						else // Ϲ  1300ms ٸ.
						{
							if (event.data32[2] < 1300) break; 
						}
						if (nPrevChannelCount > 0) //  ä ִ ļ 5ʱ ٷ 
						{
							if (event.data32[2] < 5000) break; 
						}
						if (event.data32[3] > 0) break; // lock Ǿ ִٸ 
						if (bPSIPTimeOut || bLockTimeOut || bReceiveTVCT) break;
						bLockTimeOut = true;
						if (nScanCount > 0 && CT_ScanFindChannel() == false) JST_DB_Del(event.data32[1]);
						if (nScanCount > DST_MaxRF() - DST_MinRF()+1- DST_DB_GetExceptRFCount())
						{
							DST_SendWindowEventWithOnlyCmd(WM_POWER_DOWN_ENTER);
							return;
						}
						//nRF = (nRF >= DST_MaxRF()) ? DST_MinRF() : nRF+1;
						nRF = DST_DB_GetNextUnexceptRF(nRF);
						JST_Scan(nRF);
						nScanCount++;
						break;
					
					case CT_SCAN_RECEIVE_TVCT:
//						T();
						if (bPSIPTimeOut || bLockTimeOut || bReceiveTVCT) break;
						bReceiveTVCT = true;
						if (nScanCount > DST_MaxRF() - DST_MinRF()+1- DST_DB_GetExceptRFCount())
						{
							DST_SendWindowEventWithOnlyCmd(WM_POWER_DOWN_ENTER);
							return;
						}
						//nRF = (nRF >= DST_MaxRF()) ? DST_MinRF() : nRF+1;
						nRF = DST_DB_GetNextUnexceptRF(nRF);
						JST_Scan(nRF);
						nScanCount++;
						break;
				}
		}
	}
	bool IsTVHotKeyPossible()
	{
		if (DST_g_PowerOn == false) return false;
		if (DST_IsTuneMode() == false) return false;
		if (DST_g_LastTuneTime == 0) return false;
		if (DST_GetWin(WIN_AUTO_SEARCH)) return false;
		if (DST_GetWin(WIN_MANUAL_SEARCH)) return false;
		return true;
	}
//	virtual void OnTimer(char nID)
	void CBasicSystemWin_OnTimer(CWindow *this, char nID)
	{
		switch (nID)
		{
			case 1:
#if 0				
				// OTC Ȯϰ ׶ ĵ ϰ ٷ 
				DST_SendWindowEventWithOnlyCmd(WM_POWER_DOWN_ENTER);
#else				
				this->KillTimer(this, 1); // Background Scan Ѵ.
				if (DST_g_PowerOn == true) break;
				//nRF = (nRF >= DST_MaxRF()) ? DST_MinRF() : nRF+1;
				nRF = DST_DB_GetNextUnexceptRF(nRF);
				JST_Scan(nRF);
				nScanCount++;
#endif
				break;
		}
	}
//	virtual void KeyInput(unsigned char key, bool /*bRepeat*/)
	void CBasicSystemWin_KeyInput(CWindow *this, unsigned char key, bool bRepeat)
	{
		static bool power_key_pressed = false;
		static DS_U32 power_key_tick = 0; // POWER Ű  ° ´.
		if (power_key_tick > DST_OS_GetTickCount()) power_key_tick = DST_OS_GetTickCount();
		if (DST_OS_GetTickCount() - power_key_tick < DST_OS_GetTicksPerSecond()) return; // POWER Ű  1 ̳ ٸ Ű ó  
		switch (key)
		{
			case VK_PWR:
			case VK_KEY_PWR:
				power_key_tick = DST_OS_GetTickCount();
				if (DST_g_PowerOn == true)
				{
					DST_SendWindowEventWithOnlyCmd(WM_POWER_OFF);
					power_key_pressed = true;
				}
				else
				{
					DST_SendWindowEventWithOnlyCmd(WM_POWER_ON);
					power_key_pressed = false;
				}
				break;
		}
		// POWER OFF Ű   ٸ Űó 
		if (power_key_pressed == true) return;
			
		switch (key)
		{
			case VK_0:
			case VK_1:
			case VK_2:
			case VK_3:
			case VK_4:
			case VK_5:
			case VK_6:
			case VK_7:
			case VK_8:
			case VK_9:
				if (IsTVHotKeyPossible())
				{
					if(DST_GetWin(WIN_CHANNEL_BANNER)) DST_CloseWin(WIN_CHANNEL_BANNER);
					DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_DIGIT, key, 0, 0);
				}
				break;

			case VK_ZOOM:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_DISPLAY_MODE_HOT, WIN_NULL,0,0,0,0);
				break;
			case VK_AUDIO:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_AUDIO_HOT, WIN_NULL,0,0,0,0);
				break;
				
			case VK_EPG:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_PROGRAM_GUIDE, WIN_NULL,0,0,0,0);
				break;

				
			case VK_HYPHEN:
				//if (IsTVHotKeyPossible()) DST_CreateWin(WIN_DIRECT_TUNE, WIN_NULL,0,0,0,0);
				break;
				
			case VK_VOL_DN:
			case VK_VOL_UP:
				if (IsTVHotKeyPossible() == false) break; 
				DST_CreateWin(WIN_VOLUME, WIN_NULL,0,0,0,0);
				break;
				
			case VK_MUTE:
				if (IsTVHotKeyPossible() == false) break; 
				DST_UI_SetMute(!DST_UI_GetMute());
				if(DST_UI_GetMute())
					DST_CreateWin(WIN_VOLUME_MUTE, WIN_NULL,0,0,0,0);
				else
					DST_CreateWin(WIN_VOLUME, WIN_NULL,0,0,0,0);
			
			
				break;

			case VK_SIGNAL_METER:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_SIGNAL_METER, WIN_NULL,0,0,0,0);
				break;

			case VK_CC:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_CLOSED_CAPTION_HOT,WIN_NULL, 0,0,0,0);
//				{
//					SWinEventMsg event;
//					memset(&event, 0, sizeof(SWinEventMsg));
//					event.cmd = WM_CVT;
//					char swversion[16] = {0,};
//					sprintf(swversion, "0.2000");
//					memcpy(&event.data[0], swversion, 16);
//		//		case 0: DST_Printf("Download Now\n"); break;
//		//		case 1: DST_Printf("Deferred Download\n"); break;
//		//		case 2: DST_Printf("No Exception\n"); break;
//					event.data32[4] = 0;
//					event.data32[5] = 1;
//					event.data32[6] = 627000000;
//					event.data32[7] = 0x66;
//					DST_SendWindowEvent(event);
//				}

				break;
				
			case VK_CH_UP:
			case VK_CH_DN:
			case VK_KEY_UP:
			case VK_KEY_DN:
				if (IsTVHotKeyPossible() == false) break;
				T();
				if (DST_DB_PresentChMap() == false) // äθ  
				{
				T();
					DST_CreateWin(WIN_AUTO_SEARCH, WIN_NULL, 1, 0, 0, 0); // Rescan
					break;
				}
				T();
				switch (key)
				{
					case VK_CH_UP:
					case VK_KEY_UP:
						DST_UI_ChannelUpDn(true);
						break;
					default:
						DST_UI_ChannelUpDn(false);
						break;
				}
				break;

			case VK_MENU:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_MAIN_MENU, WIN_NULL,0,0,0,0);
				break;

			case VK_OK:
#if EPG_SUPPORT				
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_INFOR_BANNER, WIN_NULL,0,0,0,0);
#else
				DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL, 3, 0, 0);
#endif
			  	break;

			case VK_PREV:
			case VK_PREV_CH:
				if (IsTVHotKeyPossible()) 
				{
					int nCh_Major = DST_DB_GetMajor(DST_g_PrevRF,DST_g_PrevProgramNumber);
					int nCh_Minor = DST_DB_GetMinor(DST_g_PrevRF,DST_g_PrevProgramNumber);
					if(DST_DB_PresentMatchChannel(DST_g_PrevRF, nCh_Major,nCh_Minor ))
					{
						DST_UI_ChannelTune(DST_g_PrevRF, DST_g_PrevProgramNumber);
					}
					else
					{
						DST_g_PrevRF = DST_EEPROM_GetRF();
						DST_g_PrevProgramNumber = DST_EEPROM_GetProgramNumber();
					}
				}
				break;
			case VK_DISPLAY_MODE:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_DISPLAY_MODE_HOT, WIN_NULL,0,0,0,0);
				break;
			case VK_CHANNEL_SEARCH:
				if (IsTVHotKeyPossible()) DST_CreateWin(WIN_AUTO_SEARCH, WIN_NULL, 0, 1, 0, 0);
				
				break;
		}
	}
//};

void DST_CreateBaseSystemWindow(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor = CBasicSystemWin_Destructor;
	pWin->OnMessage = CBasicSystemWin_OnMessage;	
	pWin->OnTimer = CBasicSystemWin_OnTimer;
	pWin->KeyInput = CBasicSystemWin_KeyInput;
	//  ȣ
	CBasicSystemWin_CBasicSystemWin(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}
