#include "bapp.h"
#include "bstd.h"
#include "gist.h"
#include "bchp_aon_ctrl.h"
#include "bchp_aon_pm_l2.h"
#include "bchp_kbd1.h"
#include "bchp_gio_aon.h"

BDBG_MODULE("birw");

extern void bdisplay_standby(bdisplay_t display, bool standby);
#if HAS_HDMI
extern void bsettop_hdmi_standby(bsettop_hdmi_t h_hdmi, bool standby);
#endif
extern void brfm_standby(brfm_t rfm, bool standby);
extern void baudio_decode_standby(baudio_decode_t audio, bool standby);

#ifdef ACB612
#if(USERIO_ID == 5)
const uint32_t cir_rca_param_regs[] =
{
	//BCHP_KBD1_CMD,	  0,
	BCHP_KBD1_CIR_ADDR, 0,  BCHP_KBD1_CIR_DATA, 0x87,
	BCHP_KBD1_CIR_ADDR, 1,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 2,  BCHP_KBD1_CIR_DATA, 0x02,     
	BCHP_KBD1_CIR_ADDR, 3,  BCHP_KBD1_CIR_DATA, 0x190,
	BCHP_KBD1_CIR_ADDR, 4,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 5,  BCHP_KBD1_CIR_DATA, 0x190,
	BCHP_KBD1_CIR_ADDR, 6,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 7,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 8,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 9,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 10, BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 11, BCHP_KBD1_CIR_DATA, 0x17,
	BCHP_KBD1_CIR_ADDR, 12, BCHP_KBD1_CIR_DATA, 0xc32,
	BCHP_KBD1_CIR_ADDR, 13, BCHP_KBD1_CIR_DATA, 0x400,
	BCHP_KBD1_CIR_ADDR, 14, BCHP_KBD1_CIR_DATA, 0x96,
	BCHP_KBD1_CIR_ADDR, 15, BCHP_KBD1_CIR_DATA, 0x64,
	BCHP_KBD1_CIR_ADDR, 16, BCHP_KBD1_CIR_DATA, 0x10d,
	BCHP_KBD1_CIR_ADDR, 17, BCHP_KBD1_CIR_DATA, 0x32,
	BCHP_KBD1_CIR_ADDR, 18, BCHP_KBD1_CIR_DATA, 0xb0,
	BCHP_KBD1_CIR_ADDR, 19, BCHP_KBD1_CIR_DATA, 0x31,
	BCHP_KBD1_CIR_ADDR, 20, BCHP_KBD1_CIR_DATA, 0xb,
	BCHP_KBD1_CIR_ADDR, 21, BCHP_KBD1_CIR_DATA, 0xc, 
	BCHP_KBD1_CIR_ADDR, 22, BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 23, BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 24, BCHP_KBD1_CIR_DATA, 0,
	//BCHP_KBD1_CMD,      0x130,  						/* must match, enable interrupt, CIR */
	0
};
#endif

#if(USERIO_ID == 4 || USERIO_ID == 10 || USERIO_ID == 11 || USERIO_ID == 12 || USERIO_ID == 15)

const uint32_t cir_nec_param_regs[] =
{
	//BCHP_KBD1_CMD,	  0,
    BCHP_KBD1_CIR_ADDR, 0,  BCHP_KBD1_CIR_DATA, 0xc8,
    BCHP_KBD1_CIR_ADDR, 1,  BCHP_KBD1_CIR_DATA, 0,
    BCHP_KBD1_CIR_ADDR, 2,  BCHP_KBD1_CIR_DATA, 0x12,
    BCHP_KBD1_CIR_ADDR, 3,  BCHP_KBD1_CIR_DATA, 0x384,
    BCHP_KBD1_CIR_ADDR, 4,  BCHP_KBD1_CIR_DATA, 0x381,
    BCHP_KBD1_CIR_ADDR, 5,  BCHP_KBD1_CIR_DATA, 0x1c2,
    BCHP_KBD1_CIR_ADDR, 6,  BCHP_KBD1_CIR_DATA, 0xe1,
    BCHP_KBD1_CIR_ADDR, 7,  BCHP_KBD1_CIR_DATA, 0,
    BCHP_KBD1_CIR_ADDR, 8,  BCHP_KBD1_CIR_DATA, 0,
    BCHP_KBD1_CIR_ADDR, 9,  BCHP_KBD1_CIR_DATA, 0,
    BCHP_KBD1_CIR_ADDR, 10, BCHP_KBD1_CIR_DATA, 0,
    BCHP_KBD1_CIR_ADDR, 11, BCHP_KBD1_CIR_DATA, 0x1f,
    BCHP_KBD1_CIR_ADDR, 12, BCHP_KBD1_CIR_DATA, 0xc32,
    BCHP_KBD1_CIR_ADDR, 13, BCHP_KBD1_CIR_DATA, 0x400,
    BCHP_KBD1_CIR_ADDR, 14, BCHP_KBD1_CIR_DATA, 0x71,
    BCHP_KBD1_CIR_ADDR, 15, BCHP_KBD1_CIR_DATA, 0x71,
    BCHP_KBD1_CIR_ADDR, 16, BCHP_KBD1_CIR_DATA, 0x10d,
    BCHP_KBD1_CIR_ADDR, 17, BCHP_KBD1_CIR_DATA, 0x32,
    BCHP_KBD1_CIR_ADDR, 18, BCHP_KBD1_CIR_DATA, 0xb0,
    BCHP_KBD1_CIR_ADDR, 19, BCHP_KBD1_CIR_DATA, 0x31,
    BCHP_KBD1_CIR_ADDR, 20, BCHP_KBD1_CIR_DATA, 0x16,
    BCHP_KBD1_CIR_ADDR, 21, BCHP_KBD1_CIR_DATA, 0x6,
    BCHP_KBD1_CIR_ADDR, 22, BCHP_KBD1_CIR_DATA, 0,
    BCHP_KBD1_CIR_ADDR, 23, BCHP_KBD1_CIR_DATA, 0,
    BCHP_KBD1_CIR_ADDR, 24, BCHP_KBD1_CIR_DATA, 0,
	0
};
#endif
#endif

void b_s3_standby(uint32_t id)
{
	uint32_t val;

	/* setup data filter for PWR IR code */
	if (id == 1) {
		BREG_Write32(GetREG(), BCHP_KBD1_CMD, 0x121);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK0,0xFFFF00FF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK1,0x00FFFFFF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK2,0xFFFFFFFF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT0, 0x00000F00);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT1, 0x0F000000);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT2, 0x00000000);
	}
	else if (id == 8) {
		BREG_Write32(GetREG(), BCHP_KBD1_CMD, 0x134);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK0,0xFFFFFF00);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK1,0xFF00FFFF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK2,0xFFFFFFFF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT0, 0x0000000A);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT1, 0x000A0000);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT2, 0x00000000);
	}
	else if (id == 9) {
		BREG_Write32(GetREG(), BCHP_KBD1_CMD, 0x130);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK0,0xFF00FFFF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK1,0xFFFFFFFF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK2,0xFFFFFF00);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT0, 0x000a0000);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT1, 0x00000000);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT2, 0x0000000a);
	}
#ifdef ACB612
#if(USERIO_ID == 5)
	else if (5 == id) {
		int i, count;

		count = sizeof(cir_rca_param_regs)/sizeof(cir_rca_param_regs[0]);
		i = 0;
		do {
			if (0 == cir_rca_param_regs[i]) {
				break;
			}
			if (BCHP_KBD1_CMD == cir_rca_param_regs[i]) { 
				BREG_Write32(GetREG(), cir_rca_param_regs[i], cir_rca_param_regs[i+1]);
				i += 2;
			}
			else {
				/* progress CIR */
				/* CIR address */
				BREG_Write32(GetREG(), cir_rca_param_regs[i], cir_rca_param_regs[i+1]); i += 2;
				/* CIR data */
				BREG_Write32(GetREG(), cir_rca_param_regs[i], cir_rca_param_regs[i+1]); i += 2;
			}
		} while (i < count);

		/* RCA */
		BREG_Write32(GetREG(), BCHP_KBD1_CMD, 0x130);			/* must match, enable interrupt, CIR */
		
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK0,0xFF8FFF00);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT0, 0x007000d5);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK1,0xFF00FFFF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT1, 0x00d50000);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK2,0xFFFFFF8F);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT2, 0x00000070);
	}
#endif
#if(USERIO_ID == 12 || USERIO_ID == 11 || USERIO_ID == 10 || USERIO_ID == 4 || USERIO_ID == 15)
	else if (12 == id ||11 == id || 10 == id || 4 == id || 15 == id) {
		int i, count;

		count = sizeof(cir_nec_param_regs)/sizeof(cir_nec_param_regs[0]);
		i = 0;
		do {
			if (0 == cir_nec_param_regs[i]) {
				break;
			}
			if (BCHP_KBD1_CMD == cir_nec_param_regs[i]) { 
				BREG_Write32(GetREG(), cir_nec_param_regs[i], cir_nec_param_regs[i+1]);
				i += 2;
			}
			else {
				/* progress CIR */
				/* CIR address */
				BREG_Write32(GetREG(), cir_nec_param_regs[i], cir_nec_param_regs[i+1]); i += 2;
				/* CIR data */
				BREG_Write32(GetREG(), cir_nec_param_regs[i], cir_nec_param_regs[i+1]); i += 2;
			}
		} while (i < count);
		/* NEC */
#if( USERIO_ID == 12)/*janzy@20121030,add remote Skyworth_01*//*0x80BF3BC4*/
		BREG_Write32(GetREG(), BCHP_KBD1_CMD, 0x130);			/* must match, enable interrupt, CIR */
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK0,	0xFFFFFF00);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT0, 	0x000000C4);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK1,	0xFF00FFFF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT1, 	0x00BF0000);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK2,	0xFFFFFFFF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT2, 	0x00000000);
#endif		
		
#if( USERIO_ID == 11)/*0x008118e7*/
		BREG_Write32(GetREG(), BCHP_KBD1_CMD, 0x130);			/* must match, enable interrupt, CIR */
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK0,	0xFFFFFF00);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT0, 	0x000000E7);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK1,	0xFF00FFFF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT1, 	0x00810000);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK2,	0xFFFFFFFF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT2, 	0x00000000);
#endif		
#if( USERIO_ID == 10)/*0x01FEC03F*/
		BREG_Write32(GetREG(), BCHP_KBD1_CMD, 0x130);			/* must match, enable interrupt, CIR */
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK0,	0xFFFFFF00);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT0, 	0x0000003F);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK1,	0xFF00FFFF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT1, 	0x003F0000);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK2,	0xFFFFFFFF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT2, 	0x00000000);
#endif		
#if(USERIO_ID == 4)/*0x0066B847*/
		BREG_Write32(GetREG(), BCHP_KBD1_CMD, 0x130);			/* must match, enable interrupt, CIR */

		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK0,	0xFF8FFF00);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT0, 	0x00600047);
													
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK1,	0xFF00FFFF);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT1, 	0x00660000);

		BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK2,	0xFFFF0000);
		BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT2, 	0x0000B847);
#endif
#if (15 == USERIO_ID) // CMB 0xFF000820 --> 0x041000FF (Ʈ  Ųٷ) Ųٷε Ʈ 24Ʈ   ؾ 
        BREG_Write32(GetREG(), BCHP_KBD1_CMD, 0x130);           /* must match, enable interrupt, CIR */
        BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK0, ~0x51AF30CF); // 0xF6090820
        BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT0,   0x51AF30CF);
        BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK1, ~0x30CF0000);
        BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT1,   0x30CF0000);
        BREG_Write32(GetREG(), BCHP_KBD1_KBD_MASK2, ~0x000051AF);
        BREG_Write32(GetREG(), BCHP_KBD1_KBD_PAT2,   0x000051AF);  
#endif
	}
#endif
#endif
	else {
		BDBG_ERR(("USERIO_ID %d is not supported for S3 standby now", id));
		return;
	}
	/* clear KBD1 interrupt */
	val = BREG_Read32(GetREG(), BCHP_KBD1_STATUS);
	val &= ~BCHP_KBD1_STATUS_irq_MASK;		
	BREG_Write32(GetREG(), BCHP_KBD1_STATUS, val);
	
	/* clear reset history */
	BREG_Write32(GetREG(), BCHP_AON_CTRL_RESET_CTRL, BCHP_AON_CTRL_RESET_CTRL_clear_reset_history_MASK);

	/* reset wake up device */
	BREG_Write32(GetREG(), BCHP_AON_PM_L2_CPU_MASK_SET, 0xFFFFFFFF);
	BREG_Write32(GetREG(), BCHP_AON_PM_L2_CPU_CLEAR, 0xFFFFFFF);

#ifdef ACB612
	/* just allow the power button to generate wake up interrupt, Agpio07 */
	BREG_Write32(GetREG(), BCHP_GIO_AON_MASK_LO, 0x00000080);
	BREG_Write32(GetREG(), BCHP_GIO_AON_MASK_EXT, 0x00000000);
#endif

	/* enable IR interrupt and GPIO for wakeup */
	BREG_Write32(GetREG(), BCHP_AON_CTRL_PM_LED_AUTO_ON_ENABLES, 0x2);
#ifdef ACB612
	BREG_Write32(GetREG(), BCHP_AON_PM_L2_CPU_MASK_CLEAR, BCHP_AON_PM_L2_CPU_MASK_CLEAR_IRR_INTR_MASK | BCHP_AON_PM_L2_CPU_MASK_STATUS_GPIO_MASK);
#else
	BREG_Write32(GetREG(), BCHP_AON_PM_L2_CPU_MASK_CLEAR, BCHP_AON_PM_L2_CPU_MASK_CLEAR_IRR_INTR_MASK);
#endif
	BREG_Write32(GetREG(), BCHP_AON_CTRL_PM_LED_CTRL, BCHP_AON_CTRL_PM_LED_CTRL_led_turn_on_MASK);
	/* power down request */
	BREG_Write32(GetREG(), BCHP_AON_CTRL_PM_CTRL, 0);

	/* enable S3 standby */
	val = BCHP_AON_CTRL_PM_CTRL_pm_deep_standby_MASK;
	BREG_Write32(GetREG(), BCHP_AON_CTRL_PM_CTRL, val);
	
	/* load precharge value for fast pwrdn */
	BREG_Write32(GetREG(), BCHP_AON_CTRL_PM_FAST_PWRDN_PRECHARGE, 0xB9E1DC );
	/* enable fast power down, and issue pwrn down 0->1 transition */
	val |= BCHP_AON_CTRL_PM_CTRL_pm_fast_power_down_MASK|BCHP_AON_CTRL_PM_CTRL_pm_start_pwrdn_MASK;
	BREG_Write32(GetREG(), BCHP_AON_CTRL_PM_CTRL, val);
}

void bpwr_control(bapp_t *p_app, bool standby)
{
#if HAS_HDMI
	bsettop_hdmi_standby(p_app->hdmi, standby);
#endif
	brfm_standby(p_app->p_rfm, standby);
	bdisplay_standby(p_app->display, standby);
	baudio_decode_standby(p_app->audio,standby);
}
