/*************************************************************************
**  Broadcom Corp. Confidential
**  Copyright 2011 Broadcom Corp.  All Rights Reserved.
**
**  THIS SOFTWARE MAY ONLY BE USED SUBJECT TO AN EXECUTED SOFTWARE LICENSE
**  AGREEMENT  BETWEEN THE USER AND BROADCOM.  YOU HAVE NO RIGHT TO USE OR
**  EXPLOIT THIS MATERIAL EXCEPT SUBJECT TO THE TERMS OF SUCH AN AGREEMENT.
**
**  File:           bls2.S
**  Description:    low level board dependent startup code stage 2
**  Created:        alexp
**
**  REVISION:
**
***************************************************************************/

#include "bmips3300.h"
#include "bchp_common.h"
#include "bchp_sun_top_ctrl.h"
#include "bchp_aon_ctrl.h"
#include "bchp_aon_pm_l2.h"
#include "bchp_kbd1.h"
/* for power button */
#include "bchp_gio_aon.h"

#define BCHP_REG_BASE PHYS_TO_K1(BCHP_PHYSICAL_OFFSET)

#if (USERIO_ID==1)
#define IR_WAKEUP_CODE_MASK 0x0000FF00
#define IR_WAKEUP_CODE		0x00000F00
#elif (USERIO_ID==8)
#define IR_WAKEUP_CODE_MASK	0x000000FF
#define IR_WAKEUP_CODE		0x0000000A
#elif (USERIO_ID==12)         /*ACM612 XXX-XXXX */
#define IR_WAKEUP_CODE_MASK 0x000000FF
#define IR_WAKEUP_CODE		0x000000C4
#elif (USERIO_ID==11)         /*ACM612 ZRC-4502 */
#define IR_WAKEUP_CODE_MASK 0x000000FF
#define IR_WAKEUP_CODE		0x000000E7
#elif (USERIO_ID==10)         /*ACM612 MK 35 */
#define IR_WAKEUP_CODE_MASK 0x000000FF
#define IR_WAKEUP_CODE		0x0000003F
#elif (USERIO_ID==5)         /*ACM612 RCA */
#define IR_WAKEUP_CODE_MASK 0x007000FF
#define IR_WAKEUP_CODE		0x007000d5
#elif (USERIO_ID==4)         /*ACM612 ARC xxx */
#define IR_WAKEUP_CODE_MASK 0x000000FF
#define IR_WAKEUP_CODE		0x00000047
#elif (USERIO_ID==15)         /* DST IR */
#define IR_WAKEUP_CODE_MASK 0xFFFFFFFF
#define IR_WAKEUP_CODE		0x51AF30CF
#else
#define IR_WAKEUP_CODE_MASK	0x00FF0000
#define IR_WAKEUP_CODE		0x000A0000
#endif


#define SR_BEV_0 ((CP0_STATUS_SR_MASK | CP0_STATUS_CU0_MASK | CP0_STATUS_CU1_MASK | CP0_STATUS_IE_MASK) & ~( CP0_STATUS_BEV_MASK | CP0_STATUS_ERL_MASK | CP0_STATUS_EXL_MASK))
        .equ S2_STACK_SIZE, 0x1000
        .lcomm s2_stack, S2_STACK_SIZE
        .local __jump_to_cache
        .extern stage2_main
        .globl __start_s2
        .set    noreorder
        .func __start_s2
__start_s2:

        bal clear_all_d_cache
        nop

        bal init_mips
        nop

        bal _writeasm
        li a0, 'C'
1:
/* relocate exception handlers */
        la t0, exception_handlers
		la t1, 0x80000000
		la t2, exception_handlers_end
		subu t2, t2, t0
1:
		lw a0, 0(t0)
		sw a0, 0(t1)
		addi t0, t0, 4
		addi t1, t1, 4
		sub t2, t2, 4
		bnez t2, 1b
		nop
/* flush d cache */		
        bal clear_all_d_cache
        nop
/* invalidate i cache */
		bal invalidate_all_i_cache
		nop
		
        la t0, __jump_to_cache
        j t0
        nop
__jump_to_cache:
/* switch to exception vectors in ddr */
		li t0, SR_BEV_0
		mtc0 t0, CP0_STATUS
		nop
		nop
/* clear bss */        
        la  a0,_fbss
        la  a1,_end
        subu    a1,a1,a0    

        beqz a1, 2f
        nop
1:
        sw zero,0(a0)
        sub a1, a1, 4
        addi a0, a0, 4
        bnez a1, 1b
        nop
2:
#ifdef CONFIG_STANDBY
/* if just power on the box first time, enter standby mode instead boot up directly */
        .extern cir_configure		/* implemented in cir.c */
		/* cir_configure */
        bal _writeasm
        li a0, '>'

		/* set IRR cmd accordingly and configure CIR if needed */
		li a0,USERIO_ID
        jal cir_configure
		nop

        #li  a0,(BCHP_REG_BASE|BCHP_AON_CTRL_RESET_HISTORY)
        #lw  v0,0(a0)
	#li  v1,BCHP_AON_CTRL_RESET_HISTORY_s3_wakeup_reset_MASK
	#and v0,v0,v1
       	#beqz v0,ir_power_off
	b check_ir
        nop

check_ir:
		li	a0,(BCHP_REG_BASE|BCHP_AON_PM_L2_CPU_STATUS)
		lw  v0,0(a0)
		li	v1,BCHP_AON_PM_L2_CPU_STATUS_IRR_INTR_MASK
		and v0,v0,v1
		bne v0,v1,ir_done
		nop
	
		li	a0,(BCHP_REG_BASE|BCHP_KBD1_DATA0)
		lw	t8,0(a0)
		li	t9,IR_WAKEUP_CODE_MASK
		and t8,t8,t9

		li	t7,IR_WAKEUP_CODE
		beq t8,t7,ir_done
		nop

        # power button is pressed?
        li  a0,(BCHP_REG_BASE|BCHP_GIO_AON_DATA_LO)
        lw  v0,0(a0)
        li  v1,0x80
        and v0,v0,v1
        beqz v0,ir_done
        nop

ir_power_off:
		/* clear interrupt */
		li	a0,(BCHP_REG_BASE|BCHP_KBD1_STATUS)
		sw	zero,0(a0)

		/* clear reset history */
		li	a0,(BCHP_REG_BASE|BCHP_AON_CTRL_RESET_CTRL)
		sw	zero,0(a0)
		li	a1,BCHP_AON_CTRL_RESET_CTRL_clear_reset_history_MASK
		sw	a1,0(a0)

		/* set fast power down mode, pm_start_pwrdn should be 0->1 transition to initiate power down */
		li	a0,(BCHP_REG_BASE|BCHP_AON_PM_L2_CPU_MASK_SET)
		li	a1,0xFFFFFFFF
		sw	a1,0(a0)
		
		li	a0,(BCHP_REG_BASE|BCHP_AON_PM_L2_CPU_MASK_SET)
		li	a1,0xFFFFFFFF
		sw	a1,0(a0)

		# just allow the power button to generate wake up interrupt, Agpio07
		li	a0,(BCHP_REG_BASE|BCHP_GIO_AON_MASK_LO)
		li	a1,0x00000080
		sw	a1,0(a0)

		li	a0,(BCHP_REG_BASE|BCHP_GIO_AON_MASK_EXT)
		li	a1,0x0
        sw  a1,0(a0)

		li	a0,(BCHP_REG_BASE|BCHP_AON_PM_L2_CPU_MASK_CLEAR)
		# for ACB612
		li	a1,(BCHP_AON_PM_L2_CPU_MASK_CLEAR_IRR_INTR_MASK | BCHP_AON_PM_L2_CPU_MASK_CLEAR_GPIO_MASK)
		#li	a1,BCHP_AON_PM_L2_CPU_MASK_CLEAR_IRR_INTR_MASK
		sw	a1,0(a0)
		li	a0,(BCHP_REG_BASE|BCHP_AON_CTRL_PM_FAST_PWRDN_PRECHARGE)	
		li	a1,0xB9E1DC
		sw	a1,0(a0)
		li	a0,(BCHP_REG_BASE|BCHP_AON_CTRL_PM_CTRL)
		sw	zero,0(a0)
		li	a1,(BCHP_AON_CTRL_PM_CTRL_pm_deep_standby_MASK|BCHP_AON_CTRL_PM_CTRL_pm_fast_power_down_MASK)
		sw	a1,0(a0)
		nop
		nop
		nop
		or	a1,a1,BCHP_AON_CTRL_PM_CTRL_pm_start_pwrdn_MASK
		sw	a1,0(a0)

		nop
		nop
		nop
		nop
		nop
		nop
		b ir_power_off
		nop
#endif
ir_done:
/* flush cache one more time as CFE does it */        
        bal clear_all_d_cache
        nop

        la sp, s2_stack + S2_STACK_SIZE - 24
        jal stage2_main
        move a0, zero
1:
        b 1b
        nop
        .endfunc
	
LEAF(aligned_copy)

1:
        lw      v0, 0(a0)
        addiu   a2, a2, -4
        sw      v0, 0(a1)
        addiu   a0, a0, 4
        bnez    a2, 1b
        addiu   a1, a1, 4

        jr      ra
        nop

END(aligned_copy)

LEAF(exception_handlers)

1:
        b 1b
        nop
        nop
        nop
        .skip 0x170
1:
        b     1b
        nop
        nop
        nop
exception_handlers_end:
		
END(exception_handlers)
#include "uart.s"
#include "mips_libs.s"
#include "cache_lib.s"
