/***************************************************************
**
**  Broadcom Corp. Confidential
**  Copyright 2012 Broadcom Corp.  All Rights Reserved.
**
**  THIS SOFTWARE MAY ONLY BE USED SUBJECT TO AN EXECUTED 
**  SOFTWARE LICENSE AGREEMENT  BETWEEN THE USER AND BROADCOM.  
**  YOU HAVE NO RIGHT TO USE OR EXPLOIT THIS MATERIAL EXCEPT 
**  SUBJECT TO THE TERMS OF SUCH AN AGREEMENT.
**
**  File:         cir.c
**  Description:  IR remote CIR related defines and routines
**  Created:      10/18/2012 Liqun Ruan
**
****************************************************************/
/* include files        */
#include "bstd.h"
#include "bmips.h"
#include "bchp_common.h"
//#include "bchp_memc_arb_0.h"
#include "bchp_kbd1.h"

#include "bchp_aon_ctrl.h"
#include "bchp_gio_aon.h"

#ifdef CONFIG_STANDBY
const uint32_t cir_nec_param_regs[] =
{
	BCHP_KBD1_CMD,	  0,
	BCHP_KBD1_CIR_ADDR, 0,  BCHP_KBD1_CIR_DATA, 0xc8,
	BCHP_KBD1_CIR_ADDR, 1,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 2,  BCHP_KBD1_CIR_DATA, 0x12,     
	BCHP_KBD1_CIR_ADDR, 3,  BCHP_KBD1_CIR_DATA, 0x384,
	BCHP_KBD1_CIR_ADDR, 4,  BCHP_KBD1_CIR_DATA, 0x381,
	BCHP_KBD1_CIR_ADDR, 5,  BCHP_KBD1_CIR_DATA, 0x1c2,
	BCHP_KBD1_CIR_ADDR, 6,  BCHP_KBD1_CIR_DATA, 0xe1,
	BCHP_KBD1_CIR_ADDR, 7,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 8,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 9,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 10, BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 11, BCHP_KBD1_CIR_DATA, 0x1f,
	BCHP_KBD1_CIR_ADDR, 12, BCHP_KBD1_CIR_DATA, 0xc32,
	BCHP_KBD1_CIR_ADDR, 13, BCHP_KBD1_CIR_DATA, 0x400,
	BCHP_KBD1_CIR_ADDR, 14, BCHP_KBD1_CIR_DATA, 0x71,
	BCHP_KBD1_CIR_ADDR, 15, BCHP_KBD1_CIR_DATA, 0x71,
	BCHP_KBD1_CIR_ADDR, 16, BCHP_KBD1_CIR_DATA, 0x10d,
	BCHP_KBD1_CIR_ADDR, 17, BCHP_KBD1_CIR_DATA, 0x32,
	BCHP_KBD1_CIR_ADDR, 18, BCHP_KBD1_CIR_DATA, 0xb0,
	BCHP_KBD1_CIR_ADDR, 19, BCHP_KBD1_CIR_DATA, 0x31,
	BCHP_KBD1_CIR_ADDR, 20, BCHP_KBD1_CIR_DATA, 0x16,
	BCHP_KBD1_CIR_ADDR, 21, BCHP_KBD1_CIR_DATA, 0x6, 
	BCHP_KBD1_CIR_ADDR, 22, BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 23, BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 24, BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CMD,      0x10,
	0
};

const uint32_t cir_rca_param_regs[] =
{
	BCHP_KBD1_CMD,	  0,
	BCHP_KBD1_CIR_ADDR, 0,  BCHP_KBD1_CIR_DATA, 0x87,
	BCHP_KBD1_CIR_ADDR, 1,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 2,  BCHP_KBD1_CIR_DATA, 0x02,     
	BCHP_KBD1_CIR_ADDR, 3,  BCHP_KBD1_CIR_DATA, 0x190,
	BCHP_KBD1_CIR_ADDR, 4,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 5,  BCHP_KBD1_CIR_DATA, 0x190,
	BCHP_KBD1_CIR_ADDR, 6,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 7,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 8,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 9,  BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 10, BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 11, BCHP_KBD1_CIR_DATA, 0x17,
	BCHP_KBD1_CIR_ADDR, 12, BCHP_KBD1_CIR_DATA, 0xc32,
	BCHP_KBD1_CIR_ADDR, 13, BCHP_KBD1_CIR_DATA, 0x400,
	BCHP_KBD1_CIR_ADDR, 14, BCHP_KBD1_CIR_DATA, 0x96,
	BCHP_KBD1_CIR_ADDR, 15, BCHP_KBD1_CIR_DATA, 0x64,
	BCHP_KBD1_CIR_ADDR, 16, BCHP_KBD1_CIR_DATA, 0x10d,
	BCHP_KBD1_CIR_ADDR, 17, BCHP_KBD1_CIR_DATA, 0x32,
	BCHP_KBD1_CIR_ADDR, 18, BCHP_KBD1_CIR_DATA, 0xb0,
	BCHP_KBD1_CIR_ADDR, 19, BCHP_KBD1_CIR_DATA, 0x31,
	BCHP_KBD1_CIR_ADDR, 20, BCHP_KBD1_CIR_DATA, 0xb,
	BCHP_KBD1_CIR_ADDR, 21, BCHP_KBD1_CIR_DATA, 0xc, 
	BCHP_KBD1_CIR_ADDR, 22, BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 23, BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CIR_ADDR, 24, BCHP_KBD1_CIR_DATA, 0,
	BCHP_KBD1_CMD,      0x10,
	0
};

void cir_configure(uint32_t id)
{
	int i, count;

	/* setup data filter for PWR IR code */
	if (id == 1) {
    	*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_CMD) = 0x121;
    	*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK0) = 0xFFFF00FF;
    	*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT0 ) = 0x00000F00;
    	*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK1) = 0x00FFFFFF;
    	*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT1 ) = 0x0F000000;
    	*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK2) = 0xFFFFFFFF;
    	*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT2 ) = 0x00000000;
	}
	else if (id == 8) {
        *(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_CMD) = 0x134;
        *(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK0) = 0xFFFFFF00;
        *(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT0 ) = 0x0000000A;
        *(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK1) = 0xFF00FFFF;
        *(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT1 ) = 0x000A0000;
        *(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK2) = 0xFFFFFFFF;
        *(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT2 ) = 0x00000000;
	}
	else if (id == 9) {
		*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_CMD) = 0x130;
		*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK0) = 0xFF00FFFF;
		*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT0 ) = 0x000a0000;
		*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK1) = 0xFFFFFFFF;
		*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT1 ) = 0x00000000;
		*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK2) = 0xFFFFFF00;
		*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT2 ) = 0x0000000a;
	}
	else if (5 == id) {
		count = sizeof(cir_rca_param_regs)/sizeof(cir_rca_param_regs[0]);
		i = 0;
		do {
			if (0 == cir_rca_param_regs[i]) {
				break;
			}
			if (BCHP_KBD1_CMD == cir_rca_param_regs[i]) { 
				*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+cir_rca_param_regs[i]) = cir_rca_param_regs[i+1];
				i += 2;
			}
			else {
				/* progress CIR */
				/* CIR address */
				*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+cir_rca_param_regs[i]) = cir_rca_param_regs[i+1];
				i += 2;
				/* CIR data */
				*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+cir_rca_param_regs[i]) = cir_rca_param_regs[i+1];
				i += 2;
			}
		} while (i < count);

		/* RCA */
		*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_CMD) = 0x130;	/* must match, enable interrupt, CIR */
		*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK0) = 0xFF8FFF00;
		*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT0 ) = 0x007000d5;
		*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK1) = 0xFF00FFFF;
		*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT1 ) = 0x00d50000;
		*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK2) = 0xFFFFFF8F;
		*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT2 ) = 0x00000070;
	}
	else if (10 == id || 4 == id || 11 == id || 12 == id || 15 == id) {
		count = sizeof(cir_nec_param_regs)/sizeof(cir_nec_param_regs[0]);
		i = 0;
		do {
			if (0 == cir_nec_param_regs[i]) {
				break;
			}
			if (BCHP_KBD1_CMD == cir_nec_param_regs[i]) { 
				*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+cir_nec_param_regs[i]) = cir_nec_param_regs[i+1];
				i += 2;
			}
			else {
				/* progress CIR */
				/* CIR address */
				*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+cir_nec_param_regs[i]) = cir_nec_param_regs[i+1];
				i += 2;
				/* CIR data */
				*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+cir_nec_param_regs[i]) = cir_nec_param_regs[i+1];
				i += 2;
			}
		} while (i < count);
		if (10 == id) {
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_CMD) 		= 0x130;	/* must match, enable interrupt, CIR */
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK0) 	= 0xFFFFFF00;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT0 ) 	= 0x0000003F;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK1) 	= 0xFF00FFFF;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT1 ) 	= 0x003F0000;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK2) 	= 0xFFFFFFFF;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT2 ) 	= 0x00000000;
		}
		else if (4 == id) {
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_CMD) 		= 0x130;	/* must match, enable interrupt, CIR */
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK0) 	= 0xFF8FFF00;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT0 ) 	= 0x00600047;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK1) 	= 0xFF00FFFF;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT1 ) 	= 0x00660000;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK2) 	= 0xFFFF0000;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT2 ) 	= 0x0000B847;
		}
		else if (11 == id) {
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_CMD) 		= 0x130;	/* must match, enable interrupt, CIR */
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK0) 	= 0xFFFFFF00;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT0 ) 	= 0x000000E7;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK1) 	= 0xFF00FFFF;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT1 ) 	= 0x00810000;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK2) 	= 0xFFFFFFFF;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT2 ) 	= 0x00000000;	
		}
		else if (12 == id) {
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_CMD) 		= 0x130;	/* must match, enable interrupt, CIR */
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK0) 	= 0xFFFFFF00;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT0 ) 	= 0x000000C4;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK1) 	= 0xFF00FFFF;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT1 ) 	= 0x00BF0000;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK2) 	= 0xFFFFFFFF;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT2 ) 	= 0x00000000;	
		}
		else if (15 == id) {
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_CMD) 		= 0x130;	/* must match, enable interrupt, CIR */
#if 0
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK0) 	= ~0x041000FF;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT0 ) 	= 0x041000FF;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK1) 	= ~0x00FF0000;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT1 ) 	= 0x00FF0000;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK2) 	= ~0x00000410;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT2 ) 	= 0x00000410;	
#else
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK0) 	= ~0x51AF30CF;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT0 ) 	= 0x51AF30CF;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK1) 	= ~0x00FF0000;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT1 ) 	= 0x00FF0000;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_MASK2) 	= ~0x00000410;
			*(volatile unsigned long *)PHYS_TO_K1(BCHP_PHYSICAL_OFFSET+BCHP_KBD1_KBD_PAT2 ) 	= 0x00000410;	
#endif
		}
	}
}
#endif	/*CONFIG_STANDBY*/
