#include "DST_WinManager.h"
#include "DST_CC_Setup.h"
#include "DST_CCTask.h"
#include "DST_HostInterface.h"
#include "DST_FontEngine.h"

extern DS_U16 DMW_KSX2UniSub(DS_U8 high, DS_U8 low);
#define COLOR_TRANSPARENT	0
#if 0
____CC_708_Font_Size_Decide__()
#endif

static int debug_cc = 0;

/*extern "C" */void DST_708Debug(bool bOn)
{
	debug_cc = bOn ? 1 : 0;
}

#define MAX_708_ROW 15
#define MAX_708_COL 52 // korean 708 cc  

static int DST_708_FontSize[3] = {0,0,0}; // 0 = small, 1 = standard, 2 = large

int DST_708_GetFontSize(int n) // 0 = min, 1 = std, 2 = max
{
	if (DST_708_FontSize[0] == 0)
	{
		DST_708_FontSize[0] = DST_DecideFontSize(13); // ũ ̿ 15 ׸  Samll
		DST_708_FontSize[1] = DST_DecideFontSize(12); // ũ ̿ 12 ׸  Standard
		DST_708_FontSize[2] = DST_DecideFontSize(11); // ũ ̿ 9 ׸  Large
		DST_Printf("708 Font Size = %d %d %d\n", DST_708_FontSize[0], DST_708_FontSize[1], DST_708_FontSize[2]);
	}
	return DST_708_FontSize[n];
}

#if 0
____CC_708_Region_Process___()
#endif

static DST_RECT cc708_rect = { 0,0,0,0};
static void DST_UpdateRegionReset()
{
    memset(&cc708_rect, 0, sizeof(DST_RECT));
}

static void DST_UpdateRegionAdd(DST_RECT rectNew)
{
  if (rectNew.w == 0 || rectNew.h == 0) return;
	// ڽ ũⰡ 0̸ ڽ ũ üѴ.
	if (cc708_rect.w == 0 || cc708_rect.h == 0)
	{
		cc708_rect = rectNew;
		return;
	}
	DST_RECT rectTemp = cc708_rect;
#ifndef min
	#define min(a,b) ((a)>(b)?(b):(a))
#endif
#ifndef max
	#define max(a,b) ((a)>(b)?(a):(b))
#endif
	cc708_rect.x = min(rectTemp.x, rectNew.x );
	cc708_rect.y = min(rectTemp.y, rectNew.y );
	cc708_rect.w = max(rectTemp.x + rectTemp.w, rectNew.x + rectNew.w) - cc708_rect.x;
	cc708_rect.h = max(rectTemp.y + rectTemp.h, rectNew.y + rectNew.h) - cc708_rect.y;

	if (cc708_rect.x < 0) cc708_rect.x = 0;
	if (cc708_rect.y < 0) cc708_rect.y = 0;
	int nScreenHeight = DST_GetCCScreenHeight();
	int nScreenWidth = DST_GetCCScreenWidth();
	if (cc708_rect.w > nScreenWidth - cc708_rect.x) cc708_rect.w = nScreenWidth - cc708_rect.x;
	if (cc708_rect.h > nScreenHeight - cc708_rect.y) cc708_rect.h = nScreenHeight - cc708_rect.y;
}

static DST_RECT DST_UpdateRegionGet()
{
	return cc708_rect;
}

#if 0
____CC_708_Queue____()
#endif

#define QUEUE_LENGTH 2048

typedef struct _CCCIRCULARQUEUE CCCircularQueue;
typedef void (*CCCIRCULARQUEUE_Constructor) (CCCircularQueue* this);
typedef void (*CCCIRCULARQUEUE_Desstructor) (CCCircularQueue* this);
typedef void (*CCCIRCULARQUEUE_Reset) (CCCircularQueue* this);
typedef int (*CCCIRCULARQUEUE_GetSize) (CCCircularQueue* this);
typedef int (*CCCIRCULARQUEUE_GetFreeSize) (CCCircularQueue* this);
typedef bool (*CCCIRCULARQUEUE_Add1) (CCCircularQueue* this, unsigned char  *Buff, int nSize);
typedef bool (*CCCIRCULARQUEUE_Add2) (CCCircularQueue* this, unsigned char  ucBuff);
typedef unsigned char (*CCCIRCULARQUEUE_GetByte) (CCCircularQueue* this);
typedef unsigned char (*CCCIRCULARQUEUE_GetNextByte) (CCCircularQueue* this);
typedef unsigned char (*CCCIRCULARQUEUE_GetNextNextByte) (CCCircularQueue* this);
typedef bool (*CCCIRCULARQUEUE_Get) (CCCircularQueue* this, unsigned char  *data, int nSize);
typedef void (*CCCIRCULARQUEUE_RemoveByte) (CCCircularQueue* this);


struct _CCCIRCULARQUEUE
{
	int head;
	int tail;
	int nLength;
	unsigned char buffer[QUEUE_LENGTH];
	
	CCCIRCULARQUEUE_Constructor Constructor;
	CCCIRCULARQUEUE_Desstructor Destructor;
	CCCIRCULARQUEUE_Reset Reset;
	CCCIRCULARQUEUE_GetSize GetSize;
	CCCIRCULARQUEUE_GetFreeSize GetFreeSize;
	CCCIRCULARQUEUE_Add1 Add1;
	CCCIRCULARQUEUE_Add2 Add2;
	CCCIRCULARQUEUE_GetByte  GetByte;
	CCCIRCULARQUEUE_GetNextByte  GetNextByte;
	CCCIRCULARQUEUE_GetNextNextByte  GetNextNextByte;
	CCCIRCULARQUEUE_Get Get;
	CCCIRCULARQUEUE_RemoveByte RemoveByte;
};


void QWin_Constructor(CCCircularQueue* this)
{
	this->Reset(this);
}

void QWin_Destructor(CCCircularQueue* this)
{

}

void QWin_Reset(CCCircularQueue* this)
{
	this->head = 0;
	this->tail = 0;
	this->nLength = 0;

}

int QWin_GetSize(CCCircularQueue* this)
{
	return this->nLength;

}

int QWin_GetFreeSize(CCCircularQueue* this)
{
	return QUEUE_LENGTH - this->GetSize(this);

}

bool QWin_Add1(CCCircularQueue* this, unsigned char  *Buff, int nSize)
{
	if (this->GetFreeSize(this) < nSize) return false;
	while (nSize--) this->Add2(this, *(Buff++));
	return true;

}

bool QWin_Add2(CCCircularQueue* this, unsigned char  ucBuff)
{
	if (this->GetFreeSize(this) < 1) return false;
	this->buffer[this->head] = ucBuff;
	this->head = (this->head == QUEUE_LENGTH-1) ? 0 : this->head + 1;
	this->nLength++;
	return true;

}

unsigned char QWin_GetByte(CCCircularQueue* this)
{
	if (this->GetSize(this) < 1) return 0;
	return this->buffer[this->tail];

}

unsigned char QWin_GetNextByte(CCCircularQueue* this)
{
	if (this->GetSize(this) < 2) return 0;
	switch (this->tail)
	{
		case QUEUE_LENGTH - 1:
			return this->buffer [0];
	}
	return this->buffer[this->tail+1];

}

unsigned char QWin_GetNextNextByte(CCCircularQueue* this)
{
	if (this->GetSize(this) < 3) return 0;
	switch (this->tail)
	{
		case QUEUE_LENGTH - 2:
			return this->buffer [0];
		case QUEUE_LENGTH - 1:
			return this->buffer [1];
	}
	return this->buffer[this->tail+2];

}

bool QWin_Get(CCCircularQueue* this, unsigned char  *data, int nSize)
{
	int i = 0;
	if (this->GetSize(this) < nSize) return false;
	for ( i = 0; i < nSize; i++)
	{
		data[i] = this->GetByte(this);
		this->RemoveByte(this);
	}
	return true;

}

void QWin_RemoveByte(CCCircularQueue* this)
{
	if (this->GetSize(this) < 1) return;
	this->tail = (this->tail == QUEUE_LENGTH-1) ? 0 : this->tail+1;
	this->nLength--;

}



// ⺻ 츦 Ѵ.
CCCircularQueue* NewCCCircularQueue()
{
	CCCircularQueue* pWin= (CCCircularQueue *)DST_OS_Calloc(sizeof(CCCircularQueue), 1);
	pWin->Constructor = QWin_Constructor;
	pWin->Destructor = QWin_Destructor;
	pWin->Reset = QWin_Reset;
	pWin->GetSize = QWin_GetSize;
	pWin->GetFreeSize = QWin_GetFreeSize;
	pWin->Add1 = QWin_Add1;
	pWin->Add2 = QWin_Add2;
	pWin->GetByte = QWin_GetByte;
	pWin->GetNextByte = QWin_GetNextByte;
	pWin->GetNextNextByte = QWin_GetNextNextByte;
	pWin->Get = QWin_Get;
	pWin->RemoveByte = QWin_RemoveByte;
	//  ȣ
	pWin->Constructor(pWin);
	return pWin;
}

// Ҹ ȣ
void DeleteCCCircularQueue(CCCircularQueue*pWin)
{
	if (pWin == 0) return;
	if (pWin->Destructor) pWin->Destructor(pWin);
//	if (pWin->DestructorMother) pWin->DestructorMother(pWin);
	DST_OS_Free(&pWin);
}

#if 0
____CC_708_Window____()
#endif

typedef struct 
{
   DS_U8 red;
   DS_U8 green;
   DS_U8 blue;
} DST_708_Color;

typedef struct 
{
    // Define Window
   DS_U8 priority; // 0 ~ 7
   DS_U8 anchor_point; // 0 ~8
   DS_U8 relative_positioning; // 0 ~ 1
   DS_U8 anchor_vertical;
   DS_U8 anchor_horizontal;
   DS_U8 row_count;
   DS_U8 column_count;
   DS_U8 row_lock;
   DS_U8 column_lock;
   DS_U8 visible;
   DS_U8 window_styleID;
   DS_U8 pen_styleID;
    // Set Window Attributes
   DS_U8 justify;
   DS_U8 print_direction;
   DS_U8 scroll_direction;
   DS_U8 wordwrap;
   DS_U8 display_effect;
   DS_U8 effect_direction;
   DS_U8 effect_speed;
    DST_708_Color fill_color;
   DS_U8 fill_opacity;
   DS_U8 border_type;
    DST_708_Color border_color;
} DST_708_Window;

typedef struct 
{
    // Set Pen Attributes
   DS_U8 pen_size;
   DS_U8 font_style;
   DS_U8 text_tag;
   DS_U8 offset;
   DS_U8 italics;
   DS_U8 underline;
   DS_U8 edge_type;
    // Set Pen Color
    DST_708_Color fg_color;
   DS_U8 fg_opacity;
    DST_708_Color bg_color;
   DS_U8 bg_opacity;
    DST_708_Color edge_color;
} DST_708_Pen;

typedef struct 
{
    DS_U16 nCode;
    DST_708_Pen pen;
} DST_708_Char;


typedef struct _CC708WINDOW CC708Window;
typedef void (*CC708WINDOW_SetID) (CC708Window* this, DS_U8 _id);
typedef void (*CC708WINDOW_SetKorean) (CC708Window* this, bool bVal);
typedef bool (*CC708WINDOW_GetNeedRedraw) (CC708Window* this);
typedef void (*CC708WINDOW_SetNeedRedraw) (CC708Window* this, bool bValue);
typedef bool (*CC708WINDOW_GetVisible) (CC708Window* this);
typedef int (*CC708WINDOW_GetPriority) (CC708Window* this);
typedef OSD_PIXEL_T *(*CC708WINDOW_GetImgBuff) (CC708Window* this);
typedef DST_RECT (*CC708WINDOW_GetSize) (CC708Window* this);
typedef void (*CC708WINDOW_Constructor) (CC708Window* this, bool bKorea, bool bWide);
typedef void (*CC708WINDOW_Initialize) (CC708Window* this);
typedef void (*CC708WINDOW_Destructor) (CC708Window* this);
typedef void (*CC708WINDOW_DefineWindow) (CC708Window* this,DS_U8 priority,
											                   DS_U8 anchor_point,
											                   DS_U8 relative_positioning,
											                   DS_U8 anchor_vertical,
											                   DS_U8 anchor_horizontal,
											                   DS_U8 row_count,
											                   DS_U8 column_count,
											                   DS_U8 row_lock,
											                   DS_U8 column_lock,
											                   DS_U8 visible,
											                   DS_U8 window_styleID,
											                   DS_U8 pen_styleID);
typedef void (*CC708WINDOW_SetPredefinedPenStyleID ) (CC708Window* this, unsigned char StyleID);
typedef void (*CC708WINDOW_SetPredefinedWindowStyleID ) (CC708Window* this, unsigned char StyleID);
typedef void (*CC708WINDOW_ClearWindow ) (CC708Window* this);
typedef void (*CC708WINDOW_DeleteWindow ) (CC708Window* this);
typedef void (*CC708WINDOW_DisplayWindow ) (CC708Window* this);
typedef void (*CC708WINDOW_HideWindow ) (CC708Window* this);
typedef void (*CC708WINDOW_ToggleWindow  ) (CC708Window* this);
typedef void (*CC708WINDOW_SetWindowAttribute  ) (CC708Window* this, DS_U8 justify,
													                       DS_U8 print_direction,
													                       DS_U8 scroll_direction,
													                       DS_U8 wordwrap,
													                       DS_U8 display_effect,
													                       DS_U8 effect_direction,
													                       DS_U8 effect_speed,
													                       DS_U8 fill_color_red, //DST_708_Color fill_color,
													                       DS_U8 fill_color_green,
													                       DS_U8 fill_color_blue,
													                       DS_U8 fill_opacity,
													                       DS_U8 border_type,
													                       DS_U8 border_color_red, //DST_708_Color border_color
													                       DS_U8 border_color_green,
													                       DS_U8 border_color_blue);
typedef void (*CC708WINDOW_SetPenAttribute  ) (CC708Window* this,unsigned char pen_size,
														    		unsigned char font_style,
														    		unsigned char text_tag,
														    		unsigned char offset,
														    		unsigned char italics,
														    		unsigned char underline,
														    		unsigned char edge_type);
typedef void (*CC708WINDOW_SetPenColor  ) (CC708Window* this, unsigned char fg_color_red,
															   DS_U8 fg_color_green,
															   DS_U8 fg_color_blue,
															   DS_U8 fg_opacity,
															   DS_U8 bg_color_red,
															   DS_U8 bg_color_green,
															   DS_U8 bg_color_blue,
															   DS_U8 bg_opacity,
															   DS_U8 edge_color_red,
															   DS_U8 edge_color_green,
															  	unsigned char edge_color_blue);
typedef void (*CC708WINDOW_SetPenLocation  ) (CC708Window* this, unsigned char x,DS_U8 y);
typedef void (*CC708WINDOW_Reset) (CC708Window* this);
typedef void (*CC708WINDOW_ScrollUp) (CC708Window* this);
typedef void (*CC708WINDOW_ScrollMultiUp) (CC708Window* this, int nLines);
typedef void (*CC708WINDOW_ScrollDown) (CC708Window* this);
typedef void (*CC708WINDOW_ScrollMultiDown) (CC708Window* this, int nLines);
typedef bool (*CC708WINDOW_IsFullCharater) (CC708Window* this, DS_U16 nCode);
typedef void (*CC708WINDOW_AddChar) (CC708Window* this, DS_U16 data);
typedef void (*CC708WINDOW_AddCharBottomToTop ) (CC708Window* this, DS_U16 data);
typedef void (*CC708WINDOW_AddCharTopToBottom ) (CC708Window* this, DS_U16 data);
typedef unsigned char (*CC708WINDOW_ARGB ) (CC708Window* this, unsigned char alpha,DS_U8 red,DS_U8 green,DS_U8 blue);
typedef unsigned char (*CC708WINDOW_S_RGB ) (CC708Window* this, DST_708_Color color);
typedef unsigned char (*CC708WINDOW_T_RGB ) (CC708Window* this, DST_708_Color color);
typedef int (*CC708WINDOW_GetBorderSize ) (CC708Window* this);
typedef OSD_PIXEL_T (*CC708WINDOW_ColorConvert ) (CC708Window* this, DS_U8 c);
typedef DS_U8 (*CC708WINDOW_GetBackGroundColor ) (CC708Window* this, bool bFlash);
typedef void (*CC708WINDOW_DrawBackGround ) (CC708Window* this, bool bFlash);
typedef int (*CC708WINDOW_GetStingLength) (CC708Window* this, int nLine);
typedef int (*CC708WINDOW_GetStringLines ) (CC708Window* this);
typedef void (*CC708WINDOW_DrawStrings ) (CC708Window* this, bool bFlash);
typedef void (*CC708WINDOW_DrawImage ) (CC708Window* this, int x_pos, int y_pos, int w, int h, OSD_PIXEL_T *buff);
typedef int (*CC708WINDOW_GetCharHeight  ) (CC708Window* this);
typedef int (*CC708WINDOW_GetCharWidth  ) (CC708Window* this);
typedef unsigned char (*CC708WINDOW_ConvertFontSize  ) (CC708Window* this, unsigned char nSize);
typedef unsigned char (*CC708WINDOW_ConvertFontStyle  ) (CC708Window* this, unsigned char nStyle);
typedef bool (*CC708WINDOW_ConvertFontItalic  ) (CC708Window* this, unsigned char italics);
typedef unsigned char (*CC708WINDOW_ConvertFontEdgeStyle  ) (CC708Window* this, unsigned char edge_type);
typedef bool (*CC708WINDOW_ConvertFontUnderLine  ) (CC708Window* this, unsigned char underline);
typedef unsigned char (*CC708WINDOW_ConvertFontOffset  ) (CC708Window* this, unsigned char offset);
typedef unsigned char (*CC708WINDOW_ConvertFontColor  ) (CC708Window* this, unsigned char opacity, DST_708_Color color, bool bFlash);
typedef unsigned char (*CC708WINDOW_ConvertFontEdgeColor  ) (CC708Window* this, unsigned char opacity, DST_708_Color color, bool bFlash);
typedef unsigned char (*CC708WINDOW_ConvertFontBackColor  ) (CC708Window* this, unsigned char opacity, DST_708_Color color, bool bFlash);
typedef DS_U8  (*CC708WINDOW_CalcColor  ) (CC708Window* this, DS_U8 foreColor, DS_U8 backColor);
typedef FONT_CC  (*CC708WINDOW_ConvertCCStyleToFontStyle  ) (CC708Window* this, DST_708_Char cc, bool bFlash);
typedef OSD_PIXEL_T * (*CC708WINDOW_GetLineImage  ) (CC708Window* this, int nLine, int *nWidth, int *nHeight, bool bFlash);
typedef void (*CC708WINDOW_Resize  ) (CC708Window* this, bool bFlash);
typedef void (*CC708WINDOW_Draw  ) (CC708Window* this, bool bFlash);
typedef void (*CC708WINDOW_UpdateScreen  ) (CC708Window* this);
typedef void (*CC708WINDOW_UpdateScreenEx  ) (CC708Window* this, int x, int y, int w, int h);
typedef void (*CC708WINDOW_OnFlash   ) (CC708Window* this);



struct _CC708WINDOW
{
	DST_708_Window window_data;
	DST_708_Pen pen_data;
	DST_708_Char strText[MAX_708_COL][MAX_708_ROW]; // ۿ  
	bool bDefined;
	int pos_x; // Ŀ ġ
	int pos_y;
	DST_RECT rect;
	OSD_PIXEL_T *imgBuff;
	bool bNeedDraw;
	bool bKorean;
	bool bWideScreen;
	DS_U8 nID;
	int nLineWidth[MAX_708_ROW];
	int nLineHeight[MAX_708_ROW];
	bool bHide; // HDW DSW TGW ɿ ؼ ° ȴ.
							// true Ǹ ڿ  ̻ ޾Ƶ ʴ´.

							
	CC708WINDOW_SetID SetID;
	CC708WINDOW_SetKorean SetKorean;
	CC708WINDOW_GetNeedRedraw GetNeedRedraw;
	CC708WINDOW_SetNeedRedraw SetNeedRedraw;
	CC708WINDOW_GetVisible GetVisible;
	CC708WINDOW_GetPriority GetPriority;
	CC708WINDOW_GetImgBuff GetImgBuff;
	CC708WINDOW_GetSize GetSize;
	CC708WINDOW_Constructor Constructor;
	CC708WINDOW_Initialize Initialize;
	CC708WINDOW_Destructor Destructor;
	CC708WINDOW_DefineWindow DefineWindow;
	CC708WINDOW_SetPredefinedPenStyleID SetPredefinedPenStyleID;
	CC708WINDOW_SetPredefinedWindowStyleID SetPredefinedWindowStyleID;
	CC708WINDOW_ClearWindow ClearWindow;
	CC708WINDOW_DeleteWindow DeleteWindow;
	CC708WINDOW_DisplayWindow DisplayWindow;
	CC708WINDOW_HideWindow HideWindow;
	CC708WINDOW_ToggleWindow ToggleWindow;
	CC708WINDOW_SetWindowAttribute SetWindowAttribute;
	CC708WINDOW_SetPenAttribute SetPenAttribute;
	CC708WINDOW_SetPenColor SetPenColor;
	CC708WINDOW_SetPenLocation SetPenLocation;
	CC708WINDOW_Reset Reset;
	CC708WINDOW_ScrollUp ScrollUp;
	CC708WINDOW_ScrollMultiUp ScrollMultiUp;
	CC708WINDOW_ScrollDown ScrollDown;
	CC708WINDOW_ScrollMultiDown ScrollMultiDown;
	CC708WINDOW_IsFullCharater IsFullCharater; // ڵ ڵ̴.
	CC708WINDOW_AddChar AddChar;
	CC708WINDOW_AddCharBottomToTop AddCharBottomToTop;
	CC708WINDOW_AddCharTopToBottom AddCharTopToBottom;
	CC708WINDOW_ARGB ARGB;
	CC708WINDOW_S_RGB S_RGB;
	CC708WINDOW_T_RGB T_RGB;
	CC708WINDOW_GetBorderSize GetBorderSize;
	CC708WINDOW_ColorConvert ColorConvert;
	CC708WINDOW_GetBackGroundColor GetBackGroundColor;
	CC708WINDOW_DrawBackGround DrawBackGround;
	CC708WINDOW_GetStingLength GetStingLength;
	CC708WINDOW_GetStringLines GetStringLines;
	CC708WINDOW_DrawStrings DrawStrings;
	CC708WINDOW_DrawImage DrawImage;
	CC708WINDOW_GetCharHeight GetCharHeight;
	CC708WINDOW_GetCharWidth GetCharWidth;
	CC708WINDOW_ConvertFontSize ConvertFontSize;
	CC708WINDOW_ConvertFontStyle ConvertFontStyle;
	CC708WINDOW_ConvertFontItalic ConvertFontItalic;
	CC708WINDOW_ConvertFontEdgeStyle ConvertFontEdgeStyle;
	CC708WINDOW_ConvertFontUnderLine ConvertFontUnderLine;
	CC708WINDOW_ConvertFontOffset ConvertFontOffset;
	CC708WINDOW_ConvertFontColor ConvertFontColor;
	CC708WINDOW_ConvertFontEdgeColor ConvertFontEdgeColor;
	CC708WINDOW_ConvertFontBackColor ConvertFontBackColor;
	CC708WINDOW_CalcColor CalcColor;
	CC708WINDOW_ConvertCCStyleToFontStyle ConvertCCStyleToFontStyle;
	CC708WINDOW_GetLineImage GetLineImage;
	CC708WINDOW_Resize Resize; //    Ѵ.
	CC708WINDOW_Draw Draw;
	CC708WINDOW_UpdateScreen UpdateScreen;
	CC708WINDOW_UpdateScreenEx UpdateScreenEx;
	CC708WINDOW_OnFlash OnFlash;
	
};



void CCWin_SetID(CC708Window* this, DS_U8 _id)
{
	this->nID = _id;
}

void CCWin_SetKorean(CC708Window* this, bool bVal)
{
	this->bKorean = bVal;
}

bool CCWin_GetNeedRedraw(CC708Window* this)
{
	return this->bNeedDraw;
}
void CCWin_SetNeedRedraw(CC708Window* this, bool bValue)
{
	this->bNeedDraw = bValue;
}

bool CCWin_GetVisible(CC708Window* this)
{
	return this->window_data.visible == 0 ? false : true;
}

int CCWin_GetPriority(CC708Window* this)
{
	return this->window_data.priority;
}

OSD_PIXEL_T *CCWin_GetImgBuff(CC708Window* this)
{
	return this->imgBuff;
}

DST_RECT CCWin_GetSize(CC708Window* this)
{
	return this->rect;
}

void CCWin_Constructor(CC708Window* this, bool bKorea, bool bWide)
{
	int i = 0;
	this->imgBuff = 0;
	for ( i = 0; i < MAX_708_ROW; i++)
	{
		this->nLineWidth[i] = 0;
		this->nLineHeight[i] = 0;
	}
	this->Initialize(this);
	this->bKorean = bKorea;
	this->bWideScreen = bWide;
}

void CCWin_Initialize(CC708Window* this)
{
	int i = 0;
	this->bHide = false;
	memset(&this->window_data, 0, sizeof(DST_708_Window));
	memset(&this->pen_data, 0, sizeof(DST_708_Pen));
	memset(&this->rect, 0, sizeof(DST_RECT));
	this->ClearWindow(this);
	if (this->imgBuff) DST_OS_Free(&this->imgBuff);
	this->imgBuff = 0;
	for ( i = 0; i < MAX_708_ROW; i++)
	{
		this->nLineWidth[i] = 0;
		this->nLineHeight[i] = 0;
	}
	this->bDefined = false;
	this->bNeedDraw = false;
}

void CCWin_Destructor(CC708Window* this)
{
	int i = 0;
	if (this->imgBuff) DST_OS_Free(&this->imgBuff);
	this->imgBuff = 0;
	for ( i = 0; i < MAX_708_ROW; i++)
	{
		this->nLineWidth[i] = 0;
		this->nLineHeight[i] = 0;
	}
}

void CCWin_DefineWindow(CC708Window* this,DS_U8 priority,
										                   DS_U8 anchor_point,
										                   DS_U8 relative_positioning,
										                   DS_U8 anchor_vertical,
										                   DS_U8 anchor_horizontal,
										                   DS_U8 row_count,
										                   DS_U8 column_count,
										                   DS_U8 row_lock,
										                   DS_U8 column_lock,
										                   DS_U8 visible,
										                   DS_U8 window_styleID,
										                   DS_U8 pen_styleID)
{
	int i = 0;
	if (debug_cc)
	{
		DST_Printf("Define Window[%d]", this->nID);
		DST_Printf(" p(%d)", priority);
		DST_Printf(" a(%d)", anchor_point);
		DST_Printf(" r(%d)", relative_positioning);
		DST_Printf(" v(%d)", anchor_vertical);
		DST_Printf(" h(%d)", anchor_horizontal);
		DST_Printf(" row(%d)", row_count);
		DST_Printf(" col(%d)", column_count);
		DST_Printf(" rl(%d)", row_lock);
		DST_Printf(" cl(%d)", column_lock);
		DST_Printf(" v(%d)", visible);
		DST_Printf(" s(%d)", window_styleID);
		DST_Printf(" pen(%d)", pen_styleID);
		DST_Printf("\n");
	}
	// 608    4 ŸϷ  row_count 2 δ.
	//  football.trp
	if (this->bKorean == false && this->window_data.window_styleID == 4)
	{
		if (row_count > 0) row_count--;
	}
	// 4-Line Roll-Up  608   
	// 2 ŸϷ 鼭  row_count 2,3,4 µ 1,2,3 ; ´ ̴.
	// DTVCC1080 v1.1_8-08-01.trp 2 50
	// SPL ׹° ٷ  ڿ  ٹٲ ´.
	// c41miscc 10.2ä  Ʒ ƾ Ҽ 
	if (this->bKorean == false && this->window_data.window_styleID == 2 && column_count == 32)
	{
		if (row_count == 2) row_count = 1;
		if (row_count == 3) row_count = 2;
		if (row_count == 4) row_count = 3;
	}
	if ( this->bDefined == true &&
		this->window_data.priority ==   priority &&
		this->window_data.anchor_point ==   anchor_point &&
		this->window_data.relative_positioning ==   relative_positioning &&
		this->window_data.anchor_vertical ==   anchor_vertical &&
		this->window_data.anchor_horizontal ==   anchor_horizontal &&
		this->window_data.row_count ==   row_count &&
		this->window_data.column_count ==   column_count &&
		this->window_data.row_lock ==   row_lock &&
		this->window_data.column_lock ==   column_lock &&
		this->window_data.visible ==   visible &&
		this->window_data.window_styleID ==   window_styleID &&
		this->window_data.pen_styleID ==   pen_styleID )
	{
		if (debug_cc) DST_Printf("Same Define Window. Ignore\n");
		return;
	}
    // PBS_CCD  row_count  پ  
    if (this->window_data.row_count >   row_count)
    {
    	for ( i = 0; i < this->window_data.row_count - row_count; i++)
    	{
    		this->ScrollUp(this);
    		if (this->pos_y > 0) this->pos_y--;
    	}
  	}
	
	this->window_data.priority =   priority;
	this->window_data.anchor_point =   anchor_point;
	this->window_data.relative_positioning =   relative_positioning;
	this->window_data.anchor_vertical =   anchor_vertical;
	this->window_data.anchor_horizontal =   anchor_horizontal;
	this->window_data.row_count =   row_count;
	this->window_data.column_count =   column_count;
	this->window_data.row_lock =   row_lock;
	this->window_data.column_lock =   column_lock;
	this->window_data.visible =   visible;
	this->window_data.window_styleID =   window_styleID;
	this->window_data.pen_styleID =   pen_styleID;

	//  Ÿ 1~7  ̶ Ѵ.
	//  0̶ ÿ .
	if (this->window_data.window_styleID == 0)
	{
		if (this->bDefined == false) this->SetPredefinedWindowStyleID(this,1);
	}
	else
	{
		this->SetPredefinedWindowStyleID(this, this->window_data.window_styleID);
	}
	//  Ÿ 1~7  ̶ Ѵ.
	//  0̶ ÿ .
	if (this->window_data.pen_styleID == 0)
	{
		if (this->bDefined == false) this->SetPredefinedPenStyleID(this, 1);
	}
	else
	{
		this->SetPredefinedPenStyleID(this, this->window_data.pen_styleID);
	}
	this->bDefined = true;
	this->bNeedDraw = true;

}

void CCWin_SetPredefinedPenStyleID(CC708Window* this, unsigned char StyleID)
{
	this->pen_data.pen_size = 1;
	this->pen_data.font_style = 0;
	this->pen_data.text_tag = 0;
	this->pen_data.offset = 1;
	this->pen_data.italics = 0;
	this->pen_data.underline = 0;
	this->pen_data.edge_type = 0;
	// Set Pen Color
	this->pen_data.fg_color.red = 2;
	this->pen_data.fg_color.green = 2;
	this->pen_data.fg_color.blue = 2;
	this->pen_data.fg_opacity = 0;
	this->pen_data.bg_color.red = 0;
	this->pen_data.bg_color.green = 0;
	this->pen_data.bg_color.blue = 0;
	this->pen_data.bg_opacity = 0;
	this->pen_data.edge_color.red = 0;
	this->pen_data.edge_color.green = 0;
	this->pen_data.edge_color.blue = 0;
	
	switch (StyleID)
	{
		case 2: this->pen_data.font_style = 1; break;
		case 3: this->pen_data.font_style = 2; break;
		case 4: this->pen_data.font_style = 3; break;
		case 5: this->pen_data.font_style = 4; break;
		case 6: this->pen_data.font_style = 3; this->pen_data.edge_type = 3; this->pen_data.bg_opacity = 3; break;
		case 7: this->pen_data.font_style = 4; this->pen_data.edge_type = 3; this->pen_data.bg_opacity = 3; break;
	}

}

void CCWin_SetPredefinedWindowStyleID(CC708Window* this, unsigned char StyleID)
{
	this->window_data.justify = 0;
	this->window_data.print_direction = 0;
	this->window_data.scroll_direction = 3;
	this->window_data.wordwrap = 1;
	this->window_data.display_effect = 0;
	this->window_data.effect_direction = 0;
	this->window_data.effect_speed = 0;
	this->window_data.fill_color.red = 0;
	this->window_data.fill_color.green = 0;
	this->window_data.fill_color.blue = 0;
	this->window_data.fill_opacity = 0;
	this->window_data.border_type = 0;
	this->window_data.border_color.red = 0;
	this->window_data.border_color.green = 0;
	this->window_data.border_color.blue = 0;
	
	switch (StyleID)
	{
		case 2:
			 this->window_data.fill_opacity = 3;
			 break;
		case 3: this->window_data.justify = 2; break;
		case 4: this->window_data.wordwrap = 0; break;
		case 5: this->window_data.wordwrap = 0;
			this->window_data.fill_opacity = 3;
			break;
		case 6: this->window_data.wordwrap = 0; this->window_data.justify = 2; break;
		case 7: this->window_data.print_direction = 2; this->window_data.scroll_direction = 1; break;
	}

}

void CCWin_ClearWindow(CC708Window* this)
{
	memset(&this->strText, 0, sizeof(DST_708_Char) * MAX_708_ROW * MAX_708_COL);
	this->pos_x = 0;
	this->pos_y = 0;
	this->bNeedDraw = true;

}

void CCWin_DeleteWindow(CC708Window* this)
{
	if (this->bDefined == false) return;
	this->UpdateScreen(this); // ʱȭϸ visible Ӽ Ƿ ̸ Ʈ Ѵ.
	this->Initialize(this);

}

void CCWin_DisplayWindow(CC708Window* this)
{
	if (this->bDefined == false) return;
	this->window_data.visible = true;
	this->bNeedDraw = true;
	this->bHide = false;
	this->UpdateScreen(this);

}

void CCWin_HideWindow(CC708Window* this)
{
	if (this->bDefined == false) return;
	this->window_data.visible = false;
	this->bNeedDraw = true;
	this->bHide = true;
	this->UpdateScreen(this);

}

void CCWin_ToggleWindow(CC708Window* this)
{
	if (this->bDefined == false) return;
	this->window_data.visible = !this->window_data.visible;
	//bHide = !bHide;
	this->bNeedDraw = true;
	this->UpdateScreen(this);

}

void CCWin_SetWindowAttribute(CC708Window* this, DS_U8 justify,
								                       DS_U8 print_direction,
								                       DS_U8 scroll_direction,
								                       DS_U8 wordwrap,
								                       DS_U8 display_effect,
								                       DS_U8 effect_direction,
								                       DS_U8 effect_speed,
								                       DS_U8 fill_color_red, //DST_708_Color fill_color,
								                       DS_U8 fill_color_green,
								                       DS_U8 fill_color_blue,
								                       DS_U8 fill_opacity,
								                       DS_U8 border_type,
								                       DS_U8 border_color_red, //DST_708_Color border_color
								                       DS_U8 border_color_green,
								                       DS_U8 border_color_blue)
{
	if (this->bDefined == false) return;
	this->window_data.justify =	justify;
	this->window_data.print_direction =	print_direction;
	this->window_data.scroll_direction =	 scroll_direction;
	this->window_data.wordwrap =	 wordwrap;
	this->window_data.display_effect =   display_effect;
	this->window_data.effect_direction =	 effect_direction;
	this->window_data.effect_speed =	 effect_speed;
	this->window_data.fill_color.red =   fill_color_red;
	this->window_data.fill_color.green =	 fill_color_green;
	this->window_data.fill_color.blue =	fill_color_blue;
	this->window_data.fill_opacity =	 fill_opacity;
	this->window_data.border_type =	border_type;
	this->window_data.border_color.red =	 border_color_red;
	this->window_data.border_color.green =   border_color_green;
	this->window_data.border_color.blue =   border_color_blue;
	this->bNeedDraw = true;
	if (debug_cc)
	{
		DST_Printf("SetWindowAttribute[%d]", this->nID);
		DST_Printf(" j(%d)", justify);
		DST_Printf(" p(%d)", print_direction);
		DST_Printf(" s(%d)", scroll_direction);
		DST_Printf(" w(%d)", wordwrap);
		DST_Printf(" e(%d)", display_effect);
		DST_Printf(" ed(%d)", effect_direction);
		DST_Printf(" es(%d)", effect_speed);
		DST_Printf(" fill(%d,%d,%d)", fill_color_red, fill_color_green, fill_color_blue);
		DST_Printf(" o(%d)", fill_opacity);
		DST_Printf(" b(%d)", border_type);
		DST_Printf(" border(%d,%d,%d)", border_color_red, border_color_green, border_color_blue);
		DST_Printf("\n");
	}

}

void CCWin_SetPenAttribute(CC708Window* this,unsigned char pen_size,
										    		unsigned char font_style,
										    		unsigned char text_tag,
										    		unsigned char offset,
										    		unsigned char italics,
										    		unsigned char underline,
										    		unsigned char edge_type)
{
		if (this->bDefined == false) return;
		this->pen_data.pen_size =  pen_size;
		this->pen_data.font_style =  font_style;
		this->pen_data.text_tag =  text_tag;
//		this->pen_data.offset =  offset;				  2013.02.20  YTN  OFFSET  ʵ 
		this->pen_data.italics =	italics;
		this->pen_data.underline =  underline;
		this->pen_data.edge_type =  edge_type;
		if (debug_cc)
		{
			DST_Printf("SetPenAttribute[%d]", this->nID);
			DST_Printf(" size(%d)", pen_size);
			DST_Printf(" style(%d)", font_style);
			DST_Printf(" tt(%d)", text_tag);
			DST_Printf(" o(%d)", offset);
			DST_Printf(" i(%d)", italics);
			DST_Printf(" u(%d)", underline);
			DST_Printf(" b(%d)", edge_type);
			DST_Printf("\n");
		}

}

void CCWin_SetPenColor(CC708Window* this, unsigned char fg_color_red,
										   DS_U8 fg_color_green,
										   DS_U8 fg_color_blue,
										   DS_U8 fg_opacity,
										   DS_U8 bg_color_red,
										   DS_U8 bg_color_green,
										   DS_U8 bg_color_blue,
										   DS_U8 bg_opacity,
										   DS_U8 edge_color_red,
										   DS_U8 edge_color_green,
										  	unsigned char edge_color_blue)
{
	if (this->bDefined == false) return;
	// Set Pen Color
	this->pen_data.fg_color.red = fg_color_red;
	this->pen_data.fg_color.green = fg_color_green;
	this->pen_data.fg_color.blue = fg_color_blue;
	this->pen_data.fg_opacity = fg_opacity;
	this->pen_data.bg_color.red = bg_color_red;
	this->pen_data.bg_color.green = bg_color_green;
	this->pen_data.bg_color.blue = bg_color_blue;
	this->pen_data.bg_opacity = bg_opacity;
	this->pen_data.edge_color.red = edge_color_red;
	this->pen_data.edge_color.green = edge_color_green;
	this->pen_data.edge_color.blue = edge_color_blue;
	if (debug_cc)
	{
		DST_Printf("SetPenColor[%d]", this->nID);
		DST_Printf(" fg_color(%d,%d,%d)", fg_color_red, fg_color_green, fg_color_blue);
		DST_Printf(" fg_o(%d)", fg_opacity);
		DST_Printf(" bg_color(%d,%d,%d)", bg_color_red, bg_color_green, bg_color_blue);
		DST_Printf(" bg_opacity(%d)", bg_opacity);
		DST_Printf(" edge_color(%d,%d,%d)", edge_color_red, edge_color_green, edge_color_blue);
		DST_Printf("\n");
	}

}

void CCWin_SetPenLocation (CC708Window* this, unsigned char x,DS_U8 y)
{
	int i = 0;
	int xx = 0;
	int nLineLength = 0;
	int nCount = 0;
	if (this->bDefined == false) return;
	if (x > this->window_data.column_count) return;
	if (y > this->window_data.row_count) return;
	// 608  708 űٰ ߻ϴ  Ѵ.
	//  Ÿ 2  CR ʰ SPL  ݺؼ    PBS_CCD
	// kcsm43.trp
	this->pos_y = y;
	//    x ġ Ѵ.
//		if (window_data.justify != 0) return;
	// ѱ CC  ó  ó  ʿ
	if (this->bKorean == true)
	{
		nLineLength = this->GetStingLength(this, this->pos_y);
		
		for ( i = 0; i < nLineLength; i++)
		{
			nCount = this->IsFullCharater(this,this->strText[i][this->pos_y].nCode) ? nCount+2 : nCount+1;
			if (nCount < x) continue;
			//    ȿ ġϴ ġ ִ 
			this->pos_x = i;
			return;
		}
		this->pos_x = nLineLength + x - nCount;
	}
	else
	{
		if (this->window_data.justify == 0)
		{
			this->pos_x = x;
		}
		else
		{
			for ( xx = 0; xx < MAX_708_COL; xx++) this->strText[xx][this->pos_y].nCode = 0; //    .
			this->pos_x = 0;
		}
	}

}

void CCWin_Reset(CC708Window* this)
{
	this->window_data.visible = false;
	if (this->bDefined == false) return;
	this->DeleteWindow(this);

}

void CCWin_ScrollUp(CC708Window* this)
{
	int y = 0;
	int x = 0;
	for ( y = 0; y < MAX_708_ROW - 1; y++) for ( x = 0; x < MAX_708_COL; x++) this->strText[x][y] = this->strText[x][y+1];
	x = 0;
	for ( x = 0; x < MAX_708_COL; x++) memset(&this->strText[x][MAX_708_ROW-1], 0, sizeof(DST_708_Char));

}

void CCWin_ScrollMultiUp(CC708Window* this, int nLines)
{
	int i = 0;
	for ( i = 0; i < nLines; i++)  this->ScrollUp(this);

}

void CCWin_ScrollDown(CC708Window* this)
{
	int y = 0;
	int x = 0;
	for (y = 0; y < MAX_708_ROW - 1; y++) for ( x = 0; x < MAX_708_COL; x++) this->strText[x][y+1] = this->strText[x][y];
	x = 0;
	for (x = 0; x < MAX_708_COL; x++) memset(&this->strText[x][0], 0, sizeof(DST_708_Char));

}

void CCWin_ScrollMultiDown(CC708Window* this, int nLines)
{
	int i = 0;
	for ( i = 0; i < nLines; i++)  this->ScrollDown(this);

}

bool CCWin_IsFullCharater(CC708Window* this, DS_U16 nCode)
{
	if (0x1100 <= nCode && nCode < 0x1200) return true; // ѱ ڸ
	if (0x2113 <= nCode && nCode < 0x2127) return true; //	Tel, TM 
	if (0x2E80 <= nCode && nCode < 0xA500) return true; //	󰡳, Ÿī
	if (0xAC00 <= nCode && nCode < 0xD800) return true; //	ѱ
	if (0xF900 <= nCode && nCode < 0xFB00) return true; //	CJK compatibility ideographs
	if (0xFE30 <= nCode && nCode < 0xFE50) return true; //	CJK compatibility forms
	return false;

}

void CCWin_AddChar(CC708Window* this, DS_U16 data)
{
//		if (bHide == true) return; // C16S6Pkc 10.3
#if 0 // 080703_dfa_buick_csd
		if (this->window_data.scroll_direction == 2)
		{
			this->AddCharTopToBottom(this, data); //  Ʒ ũ ٿ
		}
		else
#endif
		{
			this->AddCharBottomToTop(this, data); // Ʒ  ũ 
		}

}

void CCWin_AddCharBottomToTop(CC708Window* this, DS_U16 data)
{
	int x = 0;
	int nOverLines = this->GetStringLines(this) - this->window_data.row_count - 1;

	int nLineLength = 0;
	int nCount = 0;
	int i = 0;
	if (nOverLines > 0) this->ScrollMultiUp(this, nOverLines);
	if (data == 0x08) // Back Space
	{
		if (this->pos_x == 0) return;
		this->strText[this->pos_x][this->pos_y].nCode = 0;
		this->pos_x--;
		this->bNeedDraw = true;
		return;
	}
	if (data == 0x0C) // FF   ó ġ ư.
	{
		this->ClearWindow(this); // c67gseta 10.3ä ȭ  ó ư.
		return;
	}
	if (data == 0x0E) // HCR ش   ó ġ ư.
	{
		for ( x = 0; x < MAX_708_COL; x++) memset(&this->strText[x][this->pos_y], 0, sizeof(DST_708_Char));
		this->pos_x = 0;
		this->bNeedDraw = true;
		return;
	}
	if (data == 0x0D) //  
	{
		// 608    WindowStyle 5  CR   ٹٲ 
		// PBS CCD.trp
		if ( /*window_data.window_styleID == 4 || */
			(this->bKorean == false && this->window_data.window_styleID == 5 && this->pos_y != 0) ||
			this->pos_y >= this->window_data.row_count ||
			this->pos_y >= MAX_708_ROW-1)
		{
			this->ScrollUp(this); //  
			this->bNeedDraw = true;
		}
		else
		{
			this->pos_y++;
		}
		this->pos_x = 0;
		return;
	}
	// ڿ Column Count  ū   ٷ .
	if (this->bKorean == true)
	{
		nLineLength = this->GetStingLength(this, this->pos_y);
		nCount = 0;
		for (i = 0; i < nLineLength; i++)
		{
			nCount = this->IsFullCharater(this, this->strText[i][this->pos_y].nCode) ? nCount+2 : nCount+1;
		}
		if (nCount >= this->window_data.column_count + 1 || nCount >= MAX_708_COL)
		{
			this->pos_y++;
			this->pos_x = 0;
		}
	}
	else
	{
		if (this->pos_x > this->window_data.column_count + 1 || this->pos_x >= MAX_708_COL)
		{
			this->pos_y++;
			this->pos_x = 0;
		}
	}
	// ڿ Row Count  ū  ũ Ѵ.
	if (this->pos_y >= this->window_data.row_count + 1 || this->pos_y >= MAX_708_ROW)
	{
		this->ScrollUp(this); //  
		this->pos_y--;
	}
	this->strText[this->pos_x][this->pos_y].nCode = data;
	this->strText[this->pos_x][this->pos_y].pen = this->pen_data;
	this->pos_x++;
	this->bNeedDraw = true;
	//DST_Printf("%d %d %d\n", pos_x, pos_y, data);

}

void CCWin_AddCharTopToBottom(CC708Window* this, DS_U16 data)
{
	int x = 0;
	int nOverLines = this->GetStringLines(this) - this->window_data.row_count - 1;

	int nLineLength = 0;
	int nCount = 0;	
	int i = 0;
	if (nOverLines > 0) this->ScrollMultiDown(this, nOverLines);
	if (data == 0x08) // Back Space
	{
		if (this->pos_x == 0) return;
		this->strText[this->pos_x][this->pos_y].nCode = 0;
		this->pos_x--;
		this->bNeedDraw = true;
		return;
	}
	if (data == 0x0C) // FF   ó ġ ư.
	{
		this->ClearWindow(this); // c67gseta 10.3ä ȭ  ó ư.
		return;
	}
	if (data == 0x0E) // HCR ش ó ġ ư.
	{
		for ( x = 0; x < MAX_708_COL; x++) memset(&this->strText[x][this->pos_y], 0, sizeof(DST_708_Char));
		this->pos_x = 0;
		this->bNeedDraw = true;
		return;
	}
	if (data == 0x0D) //  
	{
		this->ScrollDown(this); //  
		this->bNeedDraw = true;
		this->pos_y = 0;
		this->pos_x = 0;
		return;
	}
	// ڿ Column Count  ū   ٷ .
	if (this->bKorean == true)
	{
		nLineLength = this->GetStingLength(this, this->pos_y);
		nCount = 0;
		for ( i = 0; i < nLineLength; i++)
		{
			nCount = this->IsFullCharater(this, this->strText[i][this->pos_y].nCode) ? nCount+2 : nCount+1;
		}
		if (nCount >= this->window_data.column_count + 1 || nCount >= MAX_708_COL)
		{
			this->ScrollDown(this); //  
			this->pos_y = 0;
			this->pos_x = 0;
		}
	}
	else
	{
	if (this->pos_x >= this->window_data.column_count || this->pos_x >= MAX_708_COL-1)
	{
		this->ScrollDown(this); //  
		this->pos_y = 0;
		this->pos_x = 0;
	}
	}
	this->strText[this->pos_x][this->pos_y].nCode = data;
	this->strText[this->pos_x][this->pos_y].pen = this->pen_data;
	this->pos_x++;
	this->bNeedDraw = true;

}

unsigned char CCWin_ARGB(CC708Window* this, unsigned char alpha,DS_U8 red,DS_U8 green,DS_U8 blue)
{
	if (alpha == 0 || alpha > 2) return 0;
	return (alpha & 0x03) * 64 + (red & 0x03) * 16 + (green & 0x03) * 4  + (blue & 0x03);

}

unsigned char CCWin_S_RGB(CC708Window* this, DST_708_Color color)
{
	return this->ARGB(this, 2, color.red, color.green, color.blue);

}

unsigned char CCWin_T_RGB(CC708Window* this, DST_708_Color color)
{
	return this->ARGB(this, 1, color.red, color.green, color.blue);

}

int CCWin_GetBorderSize(CC708Window* this)
{
	return DST_GetCCScreenHeight() / 200;

}

OSD_PIXEL_T CCWin_ColorConvert(CC708Window* this, DS_U8 c)
{
	DS_U32 color = 0;
	switch (c & 0xC0)
	{
		case 0x40: // 
			color = 0x7F000000 + (c & 0x30) * 348160 + (c & 0x0C) * 5440 + (c & 0x03) * 85;
			break;
		case 0x80: // 
			color = 0xFF000000 + (c & 0x30) * 348160 + (c & 0x0C) * 5440 + (c & 0x03) * 85;;
			break;
	}
	return CONV32_16(color);

}

DS_U8 CCWin_GetBackGroundColor(CC708Window* this, bool bFlash)
{
	if (this->window_data.fill_opacity == 3) return COLOR_TRANSPARENT;
	if (bFlash && this->window_data.fill_opacity == 1) return COLOR_TRANSPARENT;
	if (this->window_data.fill_opacity == 2) return this->T_RGB(this, this->window_data.fill_color);
	return this->S_RGB(this, this->window_data.fill_color);

}

void CCWin_DrawBackGround(CC708Window* this, bool bFlash)
{
	if (this->imgBuff == 0) return;
	OSD_PIXEL_T color = this->ColorConvert(this, this->GetBackGroundColor(this, bFlash));
	int nSize = this->rect.w * this->rect.h;
	if (color == 0)
	{
		memset(this->imgBuff, 0, nSize * sizeof(OSD_PIXEL_T));
	}
	else
	{
		OSD_PIXEL_T* buff = this->imgBuff;
		while (nSize--) *buff++ = color;
	}

}

int CCWin_GetStingLength(CC708Window* this, int nLine)
{
	int x = 0;
	for ( x = MAX_708_COL - 1; x >= 0; x--) if (this->strText[x][nLine].nCode != 0) return x+1;
	return 0;

}

int CCWin_GetStringLines(CC708Window* this)
{
	int y = 0;
	for ( y = MAX_708_ROW - 1; y >= 0; y--) if (this->GetStingLength(this, y) != 0) return y+1;
	return 0;

}

void CCWin_DrawStrings(CC708Window* this, bool bFlash)
{
	int y_pos = 0;
	int nLines = this->GetStringLines(this);
	int nOldHeight = this->GetCharHeight(this);
	int y = 0;
	int x_pos = 0;
	//OSD_PIXEL_T *LineBuff = 0;
	for ( y = 0; y < nLines; y++)
	{
		x_pos = 0;
		OSD_PIXEL_T *LineBuff = this->GetLineImage(this, y, &this->nLineWidth[y], &this->nLineHeight[y], bFlash);
		switch (this->window_data.justify)
		{
			case 1: x_pos = this->rect.w - this->nLineWidth[y]; break; // right justify
			case 2: x_pos = (this->rect.w - this->nLineWidth[y])/2; break;// center justify
		}
		this->DrawImage(this, x_pos, y_pos, this->nLineWidth[y], this->nLineHeight[y], LineBuff);
		// DST_OS_Free(&LineBuff);
		if (this->nLineHeight[y] == 0) this->nLineHeight[y] = nOldHeight;
		y_pos+=this->nLineHeight[y];
		this->nLineWidth[y] = 0;
		this->nLineHeight[y] = 0;
	}

}

void CCWin_DrawImage(CC708Window* this, int x_pos, int y_pos, int w, int h, OSD_PIXEL_T *buff)
{
	int ww = 0;
	int y = 0;
	int x = 0;
	OSD_PIXEL_T *src = 0;
	OSD_PIXEL_T *des = 0;	
	int des_delta = 0;
	if (this->imgBuff == 0) return;
	if (x_pos + w > this->rect.w) // ȭ鿡 ׷ ̹ ȭ麸 ū  ޺κ .
	{
		ww = this->rect.w - x_pos;
		if (ww <= 0) return;
		for ( y = 0; y < h; y++)
		{
			for ( x = 0; x < ww; x++) buff[y*ww+x] = buff[y*w+x];
		}
		this->DrawImage(this, x_pos, y_pos, ww, h, buff);
		return;
	}
		
	src = buff;
	des = this->imgBuff + y_pos * this->rect.w + x_pos;
	des_delta = this->rect.w - w;
	y = h;
	x = 0;
	while (y--)
	{
		x = w;
		while (x--)
		{
			if (*src != 0) *des = *src;
			src++;
			des++;
		}
		des +=	des_delta;
	}

}

int CCWin_GetCharHeight(CC708Window* this)
{
	int nFontSize = DST_708_GetFontSize(1); // Default, Medium
	switch (DST_CC_GetSize())
	{
		case 1: nFontSize = DST_708_GetFontSize(0); break;// Small
		case 3: nFontSize =  DST_708_GetFontSize(2); break;// Large
	}
	return DST_GetFontHeight(nFontSize);

}

int CCWin_GetCharWidth(CC708Window* this)
{
	if (this->bKorean)
	{
		return this->GetCharHeight(this) * 46 / 100; //   40% ⺻  Ѵ.
	}
	return this->GetCharHeight(this) * 45 / 100; //   40% ⺻  Ѵ.

}

unsigned char CCWin_ConvertFontSize(CC708Window* this, unsigned char nSize)
{
	return DST_708_GetFontSize((DST_CC_GetSize() == 0) ? nSize : DST_CC_GetSize() - 1);

}

unsigned char CCWin_ConvertFontStyle(CC708Window* this, unsigned char nStyle)
{
	if (this->bKorean == true) return 0; // ѱ  ׻ ⺻ Ʈ .
	return (nStyle == 0) ? 4 : nStyle; //  ⺻ Ʈ 4.Proportionally without serifs.ttf

}

bool CCWin_ConvertFontItalic(CC708Window* this, unsigned char italics)
{
	switch (DST_CC_GetItalic())
	{
		case 0: return italics == 0 ? false : true;// default
		case 1: return true; // Italic on
	}
	return false;

}

unsigned char CCWin_ConvertFontEdgeStyle(CC708Window* this, unsigned char edge_type)
{
	return (DST_CC_GetEdge() == 0) ? edge_type : DST_CC_GetEdge() - 1;

}

bool CCWin_ConvertFontUnderLine(CC708Window* this, unsigned char underline)
{
	switch (DST_CC_GetUnderline())
	{
		case 0: return underline == 0 ? false : true; // default
		case 1: return true; // underline on
	}
	return false;

}

unsigned char CCWin_ConvertFontOffset(CC708Window* this, unsigned char offset)
{
	switch (offset)
	{
		case 0: return 1; // Sub Script
		case 1: return 0; // normal
		case 2: return 2; // Super Script
	}
	return 0;

}

unsigned char CCWin_ConvertFontColor(CC708Window* this, unsigned char opacity, DST_708_Color color, bool bFlash)
{
	switch (DST_CC_GetColor())
	{
		case 1: color.red = 0; color.green = 0; color.blue = 0; break; // black
		case 2: color.red = 3; color.green = 3; color.blue = 3; break; // white
		case 3: color.red = 3; color.green = 0; color.blue = 0; break; // red
		case 4: color.red = 0; color.green = 3; color.blue = 0; break; // green
		case 5: color.red = 0; color.green = 0; color.blue = 3; break; // blue
		case 6: color.red = 3; color.green = 3; color.blue = 0; break; // yellow
		case 7: color.red = 3; color.green = 0; color.blue = 3; break; // magenta
		case 8: color.red = 0; color.green = 3; color.blue = 3; break; // cyan
	}
	
	switch (DST_CC_GetOpacity())
	{
		case 0: // default
			switch (opacity)
			{
				case 0: return this->S_RGB(this, color); // Solid
				case 1: return (bFlash) ? COLOR_TRANSPARENT : this->S_RGB(this, color);// Flash
				case 2: return this->T_RGB(this, color);// TransLucent
				case 3: return COLOR_TRANSPARENT;
			}
			break;
		case 1: // Solid
			return this->S_RGB(this, color);
		case 2: // TransParent
			return COLOR_TRANSPARENT;
		case 3: // Translucent
			return this->T_RGB(this, color);
		case 4: // Flashing
			return (bFlash) ? COLOR_TRANSPARENT : this->S_RGB(this, color);
	}
	return this->S_RGB(this, color);

}

unsigned char CCWin_ConvertFontEdgeColor(CC708Window* this, unsigned char opacity, DST_708_Color color, bool bFlash)
{
	switch (DST_CC_GetEdgeColor())
	{
		case 1: color.red = 0; color.green = 0; color.blue = 0; break; // black
		case 2: color.red = 3; color.green = 3; color.blue = 3; break; // white
		case 3: color.red = 3; color.green = 0; color.blue = 0; break; // red
		case 4: color.red = 0; color.green = 3; color.blue = 0; break; // green
		case 5: color.red = 0; color.green = 0; color.blue = 3; break; // blue
		case 6: color.red = 3; color.green = 3; color.blue = 0; break; // yellow
		case 7: color.red = 3; color.green = 0; color.blue = 3; break; // magenta
		case 8: color.red = 0; color.green = 3; color.blue = 3; break; // cyan
	}
	switch (DST_CC_GetOpacity())
	{
		case 0: // default
			switch (opacity)
			{
				case 0: return this->S_RGB(this, color); // Solid
				case 1: return (bFlash) ? COLOR_TRANSPARENT : this->S_RGB(this, color);// Flash
				case 2: return this->T_RGB(this, color);// TransLucent
				case 3: return COLOR_TRANSPARENT;
			}
			break;
		case 1: // Solid
			return this->S_RGB(this, color);
		case 2: // TransParent
			return COLOR_TRANSPARENT;
		case 3: // Translucent
			return this->T_RGB(this, color);
		case 4: // Flashing
			return (bFlash) ? COLOR_TRANSPARENT : this->S_RGB(this, color);
	}
	return this->S_RGB(this, color);

}

unsigned char CCWin_ConvertFontBackColor(CC708Window* this, unsigned char opacity, DST_708_Color color, bool bFlash)
{
	switch (DST_CC_GetBackColor())
	{
		case 1: color.red = 0; color.green = 0; color.blue = 0; break; // black
		case 2: color.red = 3; color.green = 3; color.blue = 3; break; // white
		case 3: color.red = 3; color.green = 0; color.blue = 0; break; // red
		case 4: color.red = 0; color.green = 3; color.blue = 0; break; // green
		case 5: color.red = 0; color.green = 0; color.blue = 3; break; // blue
		case 6: color.red = 3; color.green = 3; color.blue = 0; break; // yellow
		case 7: color.red = 3; color.green = 0; color.blue = 3; break; // magenta
		case 8: color.red = 0; color.green = 3; color.blue = 3; break; // cyan
	}
	
	switch (DST_CC_GetBackOpacity())
	{
		case 0: // default
			switch (opacity)
			{
			case 0: return this->S_RGB(this, color); // Solid
			case 1: return (bFlash) ? COLOR_TRANSPARENT : this->S_RGB(this, color);// Flash
			case 2: return this->T_RGB(this, color);// TransLucent
			case 3: return COLOR_TRANSPARENT;
			}
			break;
		case 1: // Solid
			return this->S_RGB(this, color);
		case 2: // TransParent
			return COLOR_TRANSPARENT;
		case 3: // Translucent
			return this->T_RGB(this, color);
		case 4: // Flashing
			return (bFlash) ? COLOR_TRANSPARENT : this->S_RGB(this, color);
	}
	return this->S_RGB(this, color);

}

DS_U8  CCWin_CalcColor(CC708Window* this, DS_U8 foreColor, DS_U8 backColor)
{
	switch (foreColor & 0xC0)
	{
		case 0x40: // 
		case 0x80: // 
			return foreColor;
	}
	return backColor; // 

}

FONT_CC  CCWin_ConvertCCStyleToFontStyle(CC708Window* this, DST_708_Char cc, bool bFlash)
{
	FONT_CC font;
	font.nCode = cc.nCode;
	font.nSize = this->ConvertFontSize(this, cc.pen.pen_size);
	font.nStyle = this->ConvertFontStyle(this, cc.pen.font_style);
	font.bItalic = this->ConvertFontItalic(this, cc.pen.italics);
	font.nEdgeType = this->ConvertFontEdgeStyle(this, cc.pen.edge_type);
	font.bUnderLine = this->ConvertFontUnderLine(this, cc.pen.underline);
	font.nOffset = this->ConvertFontOffset(this, cc.pen.offset);
	
	DS_U8 backWindowColor = this->GetBackGroundColor(this, bFlash);
	DS_U8 foreGroundColor = this->ConvertFontColor(this, cc.pen.fg_opacity, cc.pen.fg_color, bFlash);
	DS_U8 edgeColor = this->ConvertFontEdgeColor(this, cc.pen.fg_opacity, cc.pen.edge_color, bFlash);
	DS_U8 backGroundColor = this->ConvertFontBackColor(this, cc.pen.bg_opacity, cc.pen.bg_color, bFlash);
	
	font.Color = this->ColorConvert(this, this->CalcColor(this, foreGroundColor, backWindowColor));
	font.EdgeColor = this->ColorConvert(this, this->CalcColor(this, edgeColor, backWindowColor));
	font.BackColor = this->ColorConvert(this, this->CalcColor(this, backGroundColor, backWindowColor));
	return font;

}

OSD_PIXEL_T * CCWin_GetLineImage(CC708Window* this, int nLine, int *nWidth, int *nHeight, bool bFlash)
{
	int nStrLen = this->GetStingLength(this, nLine);
	if (nStrLen == 0)
	{
		*nWidth = 0;
		*nHeight = 0;
		return 0;
	}
	
	static FONT_CC strFont[MAX_708_COL];
	int x = 0;
	for ( x = 0; x < nStrLen; x++)
	{
		strFont[x] = this->ConvertCCStyleToFontStyle(this, this->strText[x][nLine], bFlash);
	}
	
	//    ũ  鹮ڰ ƴ ù ڿ  Ѵ.
	int nDefaultSize = strFont[0].nSize;
	x = 0;
	for ( x = 0; x < nStrLen; x++)
	{
		if (strFont[x].nCode == 0) continue;
		nDefaultSize = strFont[x].nSize;
		break;
	}
	//	   ä
	x = 0;
	for ( x = 0; x < nStrLen; x++)
	{
		if (strFont[x].nCode != 0) continue;
		strFont[x].nCode = ' ';
		strFont[x].nSize = nDefaultSize;
		strFont[x].nStyle = 0;
		strFont[x].bItalic = false;
		strFont[x].nEdgeType = 0;
		strFont[x].bUnderLine = false;
		strFont[x].nOffset = 0;
		strFont[x].Color = COLOR_TRANSPARENT;
		strFont[x].EdgeColor = COLOR_TRANSPARENT;
		strFont[x].BackColor = COLOR_TRANSPARENT;
	}
	
	*nWidth = DST_GetFontWidthCC(strFont, nStrLen);
	*nHeight = DST_GetFontHeightCC(strFont, nStrLen);
	static OSD_PIXEL_T LineBuff[720*48]; //ִ  ٿ   ũ
	DST_GetFontImageCC(strFont, nStrLen, LineBuff);
	return LineBuff;

}

void CCWin_Resize(CC708Window* this, bool bFlash)
{
	// define window   ⺻ ũ
	int default_width = this->GetCharWidth(this) * (this->window_data.column_count+1);
	int default_height =  this->GetCharHeight(this) * (this->window_data.row_count+1);
	
	// ȭ鿡 ǥõ ڿ  ũ 
	int nMaxWidth = 0;
	int nTotalHeight = 0;
	int nOldHeight = this->GetCharHeight(this);
	int nLines = this->GetStringLines(this);
	bool bReachMaxColumn = false; // column count Ѿ
	int y = 0;
//	OSD_PIXEL_T* LineBuff = 0;
	//  κ ̹ ׷.
	for ( y = 0; y < nLines; y++)
	{
		if (this->GetStingLength(this, y) >= this->window_data.column_count+1) bReachMaxColumn = true;
		OSD_PIXEL_T*  LineBuff = this->GetLineImage(this, y, &this->nLineWidth[y], &this->nLineHeight[y], bFlash);
//		DST_OS_Free(&LineBuff);
		if (nMaxWidth < this->nLineWidth[y]) nMaxWidth = this->nLineWidth[y];
		if (this->nLineHeight[y] == 0) this->nLineHeight[y] = nOldHeight; // ̸  ̸ .
		nOldHeight = this->nLineHeight[y];
		nTotalHeight += this->nLineHeight[y];
	}
	
	if (bReachMaxColumn)
	{
		this->rect.w = nMaxWidth;
	}
	else
	{
		this->rect.w =  (nMaxWidth > default_width) ? nMaxWidth : default_width;
	}
	if (this->rect.w == 0) return;
	this->rect.h = (nTotalHeight > default_height) ? nTotalHeight : default_height;
	if (this->rect.h == 0) return;
	
	int nScreenHeight = DST_GetCCScreenHeight();
	int nScreenWidth = DST_GetCCScreenWidth();
	
	if (this->rect.w > nScreenWidth) this->rect.w = nScreenWidth;
	if (this->rect.h > nScreenHeight) this->rect.h = nScreenHeight;
	
	//  ̰ ļ  Ǿٸ  κε  ̷ Ѵ.
	int nDataEmptyHeight = 0;
	int nDataHeight = 0;
	int nEmptyLineCount = 0;
	y = 0;
	for ( y = 0; y < nLines; y++)
	{
		nDataEmptyHeight += this->nLineHeight[y];
		if (this->nLineWidth[y] == 0)
		{
			nEmptyLineCount++;
		}
		else
		{
			nDataHeight += this->nLineHeight[y];
		}
	}

	int nCompensation = 0;
	if (nDataHeight > this->rect.h)
	{
		DST_Printf("Error || OVER HEIGHT\n");
	}
	else
	{
		if (nDataEmptyHeight > this->rect.h)
		{
			nCompensation = (this->rect.h - nDataHeight) / nEmptyLineCount;
			DST_Printf("nCompensation = %d\n", nCompensation);
			y = 0;
			for ( y = 0; y < nLines; y++)
			{
				if (this->nLineWidth[y] != 0) continue;
				this->nLineHeight[y] = nCompensation;
			}
		}
	}
	
	
	//   ġ Ѵ.
	int default_x = 0;
	int default_y = 0;
	
	
	int max_x = nScreenWidth - 1;
	int max_y = nScreenHeight - 1;
	if (this->window_data.relative_positioning == 1)
	{
		default_x = max_x * this->window_data.anchor_horizontal / 99;
		default_y = max_y * this->window_data.anchor_vertical / 99;
	}
	else
	{
		if (this->bWideScreen)
		{
			default_x = max_x * this->window_data.anchor_horizontal / 209;
			default_y = max_y * this->window_data.anchor_vertical / 74;
		}
		else
		{
			default_x = max_x * (this->window_data.anchor_horizontal + 25) / 209;
			default_y = max_y * this->window_data.anchor_vertical / 74;
		}
	}
	if (default_x < 0) default_x = 0;
	if (default_y < 0) default_y = 0;
	if (default_x > max_x) default_x = max_x;
	if (default_y > max_y) default_y = max_y;
	
	switch (this->window_data.anchor_point)
	{
		case 0: break;
		case 1: default_x -= (this->rect.w/2); break;
		case 2: default_x -= this->rect.w; break;
		case 3: default_y -= (this->rect.h/2); break;
		case 4: default_y -= (this->rect.h/2); default_x -= (this->rect.w/2); break;
		case 5: default_y -= (this->rect.h/2); default_x -= this->rect.w; break;
		case 6: default_y -= this->rect.h; break;
		case 7: default_y -= this->rect.h; default_x -= (this->rect.w/2); break;
		case 8: default_y -= this->rect.h; default_x -= this->rect.w; break;
	}
	
	if (default_x + this->rect.w > nScreenWidth) default_x = nScreenWidth - this->rect.w;
	if (default_y + this->rect.h > nScreenHeight) default_y = nScreenHeight - this->rect.h;
	
	if (default_x < 0) default_x = 0;
	if (default_y < 0) default_y = 0;
	if (default_x >= nScreenWidth) default_x = nScreenWidth - 1;
	if (default_y >= nScreenHeight) default_y = nScreenHeight - 1;
	
	this->rect.x = default_x;
	this->rect.y = default_y;

}

void CCWin_Draw(CC708Window* this, bool bFlash)
{
	if (this->GetVisible(this) == false || this->GetNeedRedraw(this) == false) return;
	this->UpdateScreen(this);
	this->Resize(this, bFlash);
	this->UpdateScreen(this);
	if (this->imgBuff) DST_OS_Free(&this->imgBuff);
	this->imgBuff = 0;
	if (this->rect.w == 0 || this->rect.h == 0) return;
	this->imgBuff = (OSD_PIXEL_T*)DST_OS_Malloc(this->rect.w * this->rect.h * sizeof(OSD_PIXEL_T));
	this->DrawBackGround(this, bFlash);
	this->DrawStrings(this, bFlash);
	this->SetNeedRedraw(this, false);

}

void CCWin_UpdateScreen(CC708Window* this)
{
	DST_UpdateRegionAdd(this->rect);

}

void CCWin_UpdateScreenEx(CC708Window* this, int x, int y, int w, int h)
{
	DST_RECT rectTemp;
	rectTemp.x = this->rect.x + x;
	rectTemp.y = this->rect.y + y;
	rectTemp.w = w;
	rectTemp.h = h;
	DST_UpdateRegionAdd(rectTemp);

}

void CCWin_OnFlash(CC708Window* this)
{
	if (this->GetVisible(this) == false || this->bNeedDraw == true) return;
	if (this->window_data.fill_opacity == 1) //  Flash Ӽ̶ ٽ ׸.
	{
		this->bNeedDraw = true;
		return;
	}
	// ߿ Flash Ӽ ִ ڰ 1ڶ  ٽ ׸.
	int nLines = this->GetStringLines(this);
	int y = 0;
	int nColumn = 0;
	int x = 0;
	for ( y = 0; y < nLines; y++)
	{
		nColumn = this->GetStingLength(this, y);
		for ( x = 0; x < nColumn; x++)
		{
			if (DST_CC_GetOpacity() == CC_FLASHING) this->bNeedDraw = true;
			if (DST_CC_GetBackOpacity() == CC_FLASHING) this->bNeedDraw = true;
			if (this->strText[x][y].pen.fg_opacity == 1) this->bNeedDraw = true;
			if (this->strText[x][y].pen.bg_opacity == 1) this->bNeedDraw = true;
			if (this->bNeedDraw == true) return;
		}
	}

}


// ⺻ 츦 Ѵ.
CC708Window* NewCC708Window(bool bKorea, bool bWide)
{
	CC708Window* pWin= (CC708Window *)DST_OS_Calloc(sizeof(CC708Window), 1);
	pWin->SetID = CCWin_SetID;
	pWin->SetKorean = CCWin_SetKorean;
	pWin->GetNeedRedraw = CCWin_GetNeedRedraw;
	pWin->SetNeedRedraw = CCWin_SetNeedRedraw;
	pWin->GetVisible = CCWin_GetVisible;
	pWin->GetPriority = CCWin_GetPriority;
	pWin->GetImgBuff = CCWin_GetImgBuff;
	pWin->GetSize = CCWin_GetSize;
	pWin->Constructor = CCWin_Constructor;
	pWin->Initialize = CCWin_Initialize;
	pWin->Destructor = CCWin_Destructor;
	pWin->DefineWindow = CCWin_DefineWindow;
	pWin->SetPredefinedPenStyleID = CCWin_SetPredefinedPenStyleID;
	pWin->SetPredefinedWindowStyleID = CCWin_SetPredefinedWindowStyleID;
	pWin->ClearWindow = CCWin_ClearWindow;
	pWin->DeleteWindow = CCWin_DeleteWindow;
	pWin->DisplayWindow = CCWin_DisplayWindow;
	pWin->HideWindow = CCWin_HideWindow;
	pWin->ToggleWindow = CCWin_ToggleWindow;
	pWin->SetWindowAttribute = CCWin_SetWindowAttribute;
	pWin->SetPenAttribute = CCWin_SetPenAttribute;
	pWin->SetPenColor = CCWin_SetPenColor;
	pWin->SetPenLocation = CCWin_SetPenLocation ;
	pWin->Reset = CCWin_Reset;
	pWin->ScrollUp = CCWin_ScrollUp;
	pWin->ScrollMultiUp = CCWin_ScrollMultiUp;
	pWin->ScrollDown = CCWin_ScrollDown;
	pWin->ScrollMultiDown = CCWin_ScrollMultiDown;
	pWin->IsFullCharater = CCWin_IsFullCharater; // ڵ ڵ̴.
	pWin->AddChar = CCWin_AddChar;
	pWin->AddCharBottomToTop = CCWin_AddCharBottomToTop;
	pWin->AddCharTopToBottom = CCWin_AddCharTopToBottom;
	pWin->ARGB = CCWin_ARGB;
	pWin->S_RGB = CCWin_S_RGB;
	pWin->T_RGB = CCWin_T_RGB;
	pWin->GetBorderSize = CCWin_GetBorderSize;
	pWin->ColorConvert = CCWin_ColorConvert;
	pWin->GetBackGroundColor = CCWin_GetBackGroundColor;
	pWin->DrawBackGround = CCWin_DrawBackGround;
	pWin->GetStingLength = CCWin_GetStingLength;
	pWin->GetStringLines = CCWin_GetStringLines;
	pWin->DrawStrings = CCWin_DrawStrings;
	pWin->DrawImage = CCWin_DrawImage;
	pWin->GetCharHeight = CCWin_GetCharHeight;
	pWin->GetCharWidth = CCWin_GetCharWidth;
	pWin->ConvertFontSize = CCWin_ConvertFontSize;
	pWin->ConvertFontStyle = CCWin_ConvertFontStyle;
	pWin->ConvertFontItalic = CCWin_ConvertFontItalic;
	pWin->ConvertFontEdgeStyle = CCWin_ConvertFontEdgeStyle;
	pWin->ConvertFontUnderLine = CCWin_ConvertFontUnderLine;
	pWin->ConvertFontOffset = CCWin_ConvertFontOffset;
	pWin->ConvertFontColor = CCWin_ConvertFontColor;
	pWin->ConvertFontEdgeColor = CCWin_ConvertFontEdgeColor;
	pWin->ConvertFontBackColor = CCWin_ConvertFontBackColor;
	pWin->CalcColor = CCWin_CalcColor;
	pWin->ConvertCCStyleToFontStyle = CCWin_ConvertCCStyleToFontStyle;
	pWin->GetLineImage = CCWin_GetLineImage;
	pWin->Resize = CCWin_Resize; //    Ѵ.
	pWin->Draw = CCWin_Draw;
	pWin->UpdateScreen = CCWin_UpdateScreen;
	pWin->UpdateScreenEx = CCWin_UpdateScreenEx;
	pWin->OnFlash = CCWin_OnFlash;	
	//  ȣ
	pWin->Constructor(pWin, bKorea, bWide);
	return pWin;
}

// Ҹ ȣ
void DeleteCC708Window(CC708Window*pWin)
{
	if (pWin == 0) return;
	if (pWin->Destructor) pWin->Destructor(pWin);
//	if (pWin->DestructorMother) pWin->DestructorMother(pWin);
	DST_OS_Free(&pWin);
}

//  ڽ   Ѵ.
static bool DST_GetCommonRect(DST_RECT A, DST_RECT B, DST_RECT *C)
{
	C->x= (A.x > B.x) ? A.x : B.x;
	C->y= (A.y > B.y) ? A.y : B.y;
	C->w= (A.x + A.w < B.x + B.w) ? (A.x + A.w - C->x) : (B.x + B.w - C->x);
	C->h= (A.y + A.h < B.y + B.h) ? (A.y + A.h - C->y) : (B.y + B.h - C->y);
	if (C->w <= 0 || C->h <= 0) return false;
	return true;
}

#if 0
____CC_708_Decoder____()
#endif

// EIA 708 ɾ 
#define CW0  0x80
#define CW1  0x81
#define CW2  0x82
#define CW3  0x83
#define CW4  0x84
#define CW5  0x85
#define CW6  0x86
#define CW7  0x87

#define DF0  0x98
#define DF1  0x99
#define DF2  0x9A
#define DF3  0x9B
#define DF4  0x9C
#define DF5  0x9D
#define DF6  0x9E
#define DF7  0x9F

#define CLW  0x88
#define DLW  0x8C
#define DSW  0x89
#define HDW  0x8A
#define TGW  0x8B
#define SWA  0x97
#define SPA  0x90
#define SPC  0x91
#define SPL  0x92
#define DLY  0x8D
#define DLC  0x8E
#define RST  0x8F

#define EXT1 0x10
#define BS   0x08
#define CR	 0x0D
#define ETX  0x03

//class CC708Decoder : public CWindow
//{
//private:
	static int CC708Decoder_nCurrentWindow;
	static CC708Window *CC708Decoder_win[8];
	static bool CC708Decoder_bKorean;
	static bool CC708Decoder_bWideScreen;
	static bool CC708Decoder_bUnicode;
	static DS_U8 CC708Decoder_nServiceNumber;
	static CCCircularQueue *CC708Decoder_Queue;
	static bool CC708Decoder_bFlashDraw;
	static DS_U32 CC708Decoder_LastShowTime;


	
//public:
//	CC708Decoder(SWinEventMsg event):CWindow(event)
	void CC708Decoder_Constructor(CWindow *this, SWinEventMsg event)
	{
		CC708Decoder_LastShowTime = 0;
		//DST_Printf("CC708Decoder Create start\n");
		CC708Decoder_bFlashDraw = false;
		CC708Decoder_nCurrentWindow = -1;
		CC708Decoder_nServiceNumber = event.data[2]; /*1~6  */
		DST_CheckCCDescription(CC708Decoder_nServiceNumber, &CC708Decoder_bKorean, &CC708Decoder_bWideScreen, &CC708Decoder_bUnicode);
		//DST_Printf("!!!!!!!!![nServiceNumber: %d][bKorean: %d][bWideScreen: %d][bUnicode: %d]!!!!!!!!!\n",nServiceNumber, bKorean, bWideScreen, bUnicode);
		DS_U8 i = 0;
		for ( i = 0; i < 8; i++)
		{
			CC708Decoder_win[i] = NewCC708Window(CC708Decoder_bKorean, CC708Decoder_bWideScreen);
			CC708Decoder_win[i]->SetID(CC708Decoder_win[i], i);
		}
		CC708Decoder_Queue = NewCCCircularQueue();
		this->rect.w = DST_GetCCScreenWidth();
		this->rect.h = DST_GetCCScreenHeight();
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight() - this->rect.h) / 2;
		//DST_Printf("RECT %d %d %d %d\n", rect.x, rect.y, rect.w, rect.h);
		this->SetTimeOut(this, 16); // 16 ȿ ο  ٸ . TTAK.KO-07.0093 5.7.22. ڸ  ڵ  
		this->SetTimer(this, 1, 500); // Flashing
		this->bTransparentWindow = false;
		//DST_Printf("CC708Decoder Create end\n");
	}

	void CC708Decoder_Destructor(CWindow *this)
	{
		DS_U8 i = 0;
		//DST_Printf("CC708Decoder Delete start\n");
		for ( i = 0; i < 8; i++) DeleteCC708Window(CC708Decoder_win[i]);
		//DST_Printf("CC708Decoder Delete end\n");
		DeleteCCCircularQueue(CC708Decoder_Queue);
	}

	void CC708Decoder_OnFlash()
	{
		int i = 0;
		for (i = 0; i < 8; i++) CC708Decoder_win[i]->OnFlash(CC708Decoder_win[i]); // ÷ ° ٲ ׸ ִ ƮѴ.
	}

//	virtual void OnTimer(char nID)
	void CC708Decoder_OnTimer(CWindow *this, char nID)
	{
		switch (nID)
		{
			case 1: // Flashing
				CC708Decoder_bFlashDraw = !CC708Decoder_bFlashDraw;
				CC708Decoder_OnFlash();
				this->Show(this);
				break;
			case 2: // ý  ϸ ؼ Showϱ
				this->Show(this); // Show ȿ Kill Ÿ̸簡 ȣ
				break;
		}
	}

	void CC708Decoder_Delay(unsigned char TenthsOfSeconds)
	{
		// TO DO
	}

	void CC708Decoder_DelayCancel()
	{
		// TO DO
	}

	void CC708Decoder_Reset()
	{
		int i = 0;
		for ( i = 0; i < 8; i++) CC708Decoder_win[i]->Reset(CC708Decoder_win[i]);
		CC708Decoder_nCurrentWindow = -1;
	}
	
	void CC708Decoder_PrintChar(DS_U16 code)
	{
		if (CC708Decoder_nCurrentWindow == -1) return;
		CC708Decoder_win[CC708Decoder_nCurrentWindow]->AddChar(CC708Decoder_win[CC708Decoder_nCurrentWindow], code);
	}

	bool CC708Decoder_ProcessC01Byte(CCCircularQueue *Q)
	{
		switch (Q->GetByte(Q))
		{
			case 0x0C: CC708Decoder_PrintChar(0x0C); if (debug_cc) DST_Printf("FF\n"); break; // FF   ó ġ ư.
			case 0x0E: CC708Decoder_PrintChar(0x0E); if (debug_cc) DST_Printf("HCR\n"); break;// HCR   ó ġ ư.
			case 0x0D: CC708Decoder_PrintChar(0x0D); if (debug_cc) DST_Printf("CR\n"); break;// CR ͸   ø.
			case 0x08: CC708Decoder_PrintChar(0x08); if (debug_cc) DST_Printf("Back Space\n"); break; // Back Space
			case ETX: if (debug_cc) DST_Printf("End Of Text\n"); break;// End Of Text
			default: /*if (debug_cc) DST_Printf("Unknown C0 Code 0x%02X\n", Q->GetByte(Q));*/ break;
		}
		Q->RemoveByte(Q);
		return true;
	}

	bool CC708Decoder_ProcessC2(CCCircularQueue *Q)
	{
		unsigned char ucNext = Q->GetNextByte(Q);
		unsigned char buff[5];
		if (ucNext < 0x08)  // C2 0-Additional bytes
		{
			Q->Get(Q, buff, 2);
			if (debug_cc)
			{
				DST_Printf("C2 0-Additional bytes 0x%02X 0x%02X\n", buff[0], buff[1]);
			}
			return true;
		}
		if (ucNext < 0x10)  // C2 1-Additional bytes
		{
			if (Q->GetSize(Q) < 3) return false;
			Q->Get(Q, buff, 3);
			if (debug_cc)
			{
				DST_Printf("C2 1-Additional bytes 0x%02X 0x%02X 0x%02X\n", buff[0], buff[1], buff[2]);
			}
			return true;
		}
		if (ucNext < 0x18) // C2 2-Additional bytes
		{
			if (Q->GetSize(Q) < 4) return false;
			Q->Get(Q, buff, 4);
			if (debug_cc)
			{
				DST_Printf("C2 2-Additional bytes 0x%02X 0x%02X 0x%02X 0x%02X\n", buff[0], buff[1], buff[2], buff[3]);
			}
			return true;
		}
		// C2 3-Additional bytes
		if (Q->GetSize(Q) < 5) return false;
		Q->Get(Q, buff, 5);
		if (debug_cc)
		{
			DST_Printf("C2 3-Additional bytes 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X\n",
				buff[0], buff[1], buff[2], buff[3], buff[4]);
		}
		return true;
	}

	bool CC708Decoder_ProcessG2(CCCircularQueue *Q)
	{
		switch (Q->GetNextByte(Q))
		{
			case 0x20: CC708Decoder_PrintChar(0); break; // TSP
			case 0x21: CC708Decoder_PrintChar(0); break; // NBTSP
			case 0x25: CC708Decoder_PrintChar(0x2026); break; // Unicode Character 'HORIZONTAL ELLIPSIS' (U+2026)
			case 0x2A: CC708Decoder_PrintChar(0x0160); break; // Unicode Character 'LATIN CAPITAL LETTER S WITH CARON' (U+0160)
			case 0x2C: CC708Decoder_PrintChar(0x0152); break; // Unicode Character 'LATIN CAPITAL LIGATURE OE' (U+0152)
			case 0x30: CC708Decoder_PrintChar(0x2588); break; // Unicode Character 'FULL BLOCK' (U+2588)
			case 0x31: CC708Decoder_PrintChar(0x2018); break; // Unicode Character 'LEFT SINGLE QUOTATION MARK' (U+2018)
			case 0x32: CC708Decoder_PrintChar(0x2019); break; // Unicode Character 'RIGHT SINGLE QUOTATION MARK' (U+2019)
			case 0x33: CC708Decoder_PrintChar(0x201C); break; // Unicode Character 'LEFT DOUBLE QUOTATION MARK' (U+201C)
			case 0x34: CC708Decoder_PrintChar(0x201D); break; // Unicode Character 'RIGHT DOUBLE QUOTATION MARK' (U+201D)
			case 0x35: CC708Decoder_PrintChar(0x2022); break; // Unicode Character 'BULLET' (U+2022)
			case 0x39: CC708Decoder_PrintChar(0x2122); break; // Unicode Character 'TRADE MARK SIGN' (U+2122)
			case 0x3A: CC708Decoder_PrintChar(0x0161); break; //Unicode Character 'LATIN SMALL LETTER S WITH CARON' (U+0161)
			case 0x3C: CC708Decoder_PrintChar(0x0153); break; // Unicode Character 'LATIN SMALL LIGATURE OE' (U+0153)
			case 0x3D: CC708Decoder_PrintChar(0x2120); break; // Unicode Character 'SERVICE MARK' (U+2120)
			case 0x3F: CC708Decoder_PrintChar(0x0178); break; // LATIN CAPITAL LETTER Y WITH DIAERESIS' (U+0178)
			case 0x76: CC708Decoder_PrintChar(0x215B); break; // Unicode Character 'VULGAR FRACTION ONE EIGHTH' (U+215B)
			case 0x77: CC708Decoder_PrintChar(0x215C); break; // Unicode Character 'VULGAR FRACTION THREE EIGHTHS' (U+215C)
			case 0x78: CC708Decoder_PrintChar(0x215D); break; // Unicode Character 'VULGAR FRACTION FIVE EIGHTHS' (U+215D)
			case 0x79: CC708Decoder_PrintChar(0x215E); break; // Unicode Character 'VULGAR FRACTION SEVEN EIGHTHS' (U+215E)
			case 0x7A: CC708Decoder_PrintChar(0x2502); break; // Unicode Character 'BOX DRAWINGS LIGHT VERTICAL' (U+2502)
			case 0x7B: CC708Decoder_PrintChar(0x2510); break; // Unicode Character 'BOX DRAWINGS LIGHT DOWN AND LEFT' (U+2510)
			case 0x7C: CC708Decoder_PrintChar(0x2514); break; // Unicode Character 'BOX DRAWINGS LIGHT UP AND RIGHT' (U+2514)
			case 0x7D: CC708Decoder_PrintChar(0x2500); break;// Unicode Character 'BOX DRAWINGS LIGHT HORIZONTAL' (U+2500)
			case 0x7E: CC708Decoder_PrintChar(0x2518); break; // Unicode Character 'BOX DRAWINGS LIGHT UP AND LEFT' (U+2518)
			case 0x7F: CC708Decoder_PrintChar(0x250C); break; // Unicode Character 'BOX DRAWINGS LIGHT DOWN AND RIGHT' (U+250C)
		}
		unsigned char buff[2];
		Q->Get(Q, buff, 2);
		if (debug_cc)
		{
			DST_Printf("G2 0x%02X 0x%02X\n", buff[0], buff[1]);
		}
		return true;
	}

	bool CC708Decoder_ProcessC3(CCCircularQueue *Q)
	{
		unsigned char ucNext = Q->GetNextByte(Q);
		unsigned char buff[256];
		if (ucNext < 0x88) // C3 4-Additional bytes
		{
			if (Q->GetSize(Q) < 6) return false;
			Q->Get(Q, buff, 6);
			if (debug_cc)
			{
				DST_Printf("C3 4-Additional bytes 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X\n",
					buff[0], buff[1], buff[2], buff[3], buff[4], buff[5]);
			}
			return true;
		}
		if (ucNext < 0x90) // C3 5-Additional bytes
		{
			if (Q->GetSize(Q) < 7) return false;
			Q->Get(Q, buff, 7);
			if (debug_cc)
			{
				DST_Printf("C3 5-Additional bytes 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X\n",
					buff[0], buff[1], buff[2], buff[3], buff[4], buff[5], buff[6]);
			}
			return true;
		}
		// C3 Variable Length Additional bytes
		if (Q->GetSize(Q) < 3) return false;
		unsigned char ucNextNext = Q->GetNextNextByte(Q) & 0x3F; //  6Ʈ  Ʈ̴.
		if (Q->GetSize(Q) < 3 + ucNextNext) return false;
		Q->Get(Q, buff, 3 + ucNextNext);
		if (debug_cc)  DST_Printf("C3 Variable Length Additional bytes\n");
		return true;
	}

	bool CC708Decoder_ProcessG3(CCCircularQueue *Q)
	{
		if (Q->GetNextByte(Q) == 0xA0) CC708Decoder_PrintChar(0xE1A0); // [CC]     
		unsigned char buff[2];
		Q->Get(Q, buff, 2);
		if (debug_cc) DST_Printf("G3 0x%02X 0x%02X\n", buff[0], buff[1]);
		return true;
	}

	bool CC708Decoder_ProcessExt1(CCCircularQueue *Q)
	{
		unsigned char ucData = Q->GetNextByte(Q);
		if (ucData < 0x20)
		{
			return CC708Decoder_ProcessC2(Q);
		}
		if (ucData < 0x80)
		{
			return CC708Decoder_ProcessG2(Q);
		}
		if (ucData < 0xA0)
		{
			return CC708Decoder_ProcessC3(Q);
		}
		return CC708Decoder_ProcessG3(Q);
	}
	
	// C0  ó
	bool CC708Decoder_ProcessC0(CCCircularQueue *Q)
	{
		unsigned char buff[4] = {0,0,0,0};
		unsigned char ucData = Q->GetByte(Q);
		if (ucData < 0x10) // 1Ʈ ɾ
		{
			return CC708Decoder_ProcessC01Byte(Q);
		}
		if (ucData < 0x18) // 2Ʈ ɾ
		{
			if (Q->GetSize(Q) < 2) return false;
			if (ucData == EXT1)
			{
				return CC708Decoder_ProcessExt1(Q);
			}
			Q->Get(Q, buff, 2);
			if (debug_cc) DST_Printf("C0 0x%02X 0x%02X\n", buff[0], buff[1]);
			return true;
		}
		// 3Ʈ ɾ
		if (Q->GetSize(Q) < 3) return false;

		Q->Get(Q, buff, 3);
		if (ucData == 0x18 && CC708Decoder_bKorean == true)
		{
			// ASC      ڿ Ѵ.
			if (buff[1] == 0 && (buff[2] < 0x20 || (buff[2] >= 0x80 && buff[2] < 0xA0)))
			{
				if (debug_cc) DST_Printf("P16 Not supported ascii 0x%02X\n", buff[2]);
				return true;
			}
			if (debug_cc)
			{
				if (buff[1] == 0)
				{
					DST_Printf("P16 0x%04X [%s]\n", (buff[1]*256)+buff[2], &buff[2]);
				}
				else
				{
					DST_Printf("P16 0x%04X [%s]\n", (buff[1]*256)+buff[2], &buff[1]);
				}
			}
			if (buff[1] == 0) // 0x007F 0x00A0 鹮ڷ ġȯѴ.
			{
				switch (buff[2])
				{
					case 0x7F:
					case 0xA0:
						buff[2] = 0x20;
						break;
				}
			}
			CC708Decoder_PrintChar(CC708Decoder_bUnicode ? (DS_U16)(buff[1]*256+buff[2]) : DMW_KSX2UniSub(buff[1], buff[2]));
			return true;
		}
		return true;
	}

	bool CC708Decoder_ProcessC1(CCCircularQueue *Q)
	{
		unsigned char ucData = Q->GetByte(Q);
		unsigned char buff[10];
		switch (ucData)
		{
			case CW0: // Current Window
			case CW1:
			case CW2:
			case CW3:
			case CW4:
			case CW5:
			case CW6:
			case CW7:
				CC708Decoder_nCurrentWindow = ucData & 0x07;
				Q->RemoveByte(Q);
				if (debug_cc)  DST_Printf("CW%d 0x%02X\n", CC708Decoder_nCurrentWindow, ucData);
				return true;

			case DF0: // Define Window
			case DF1:
			case DF2:
			case DF3:
			case DF4:
			case DF5:
			case DF6:
			case DF7:
				if (Q->GetSize(Q) < 7) return false;
				Q->Get(Q, buff, 7);
				if (debug_cc)  DST_Printf("DF 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X\n",
					buff[0], buff[1], buff[2], buff[3], buff[4], buff[5], buff[6]);
					CC708Decoder_nCurrentWindow = buff[0] & 0x07; // test code
				CC708Decoder_win[buff[0] & 0x07]->DefineWindow(CC708Decoder_win[buff[0] & 0x07],// Window ID
																buff[1] & 0x07, // Priority
																(buff[4] >> 4) & 0x0F, // Anchor Point
																(buff[2] & 0x80) ? 1 : 0, // Relative Position
																buff[2] & 0x7F, // Anchor Vertical
																buff[3], // Anchor Horizontal
																buff[4] & 0x0F, // Row Count
																buff[5] & 0x3F, // Column Count
																(buff[1] & 0x10) ? 1 : 0, // Row Lock
																(buff[1] & 0x08) ? 1 : 0, // Column Lock
																(buff[1] & 0x20) ? 1 : 0, // Visible
																(buff[6] >> 3) & 0x07, // Window Style ID
																buff[6] & 0x07 // Pen Style ID
				);
				return true;

			case CLW: // Clear Window
				if (Q->GetSize(Q) < 2) return false;
				Q->Get(Q, buff, 2);
				if (debug_cc)  DST_Printf("CLW 0x%02X 0x%02X\n", buff[0], buff[1]);
				if (buff[1] & 0x01) CC708Decoder_win[0]->ClearWindow(CC708Decoder_win[0]);
				if (buff[1] & 0x02) CC708Decoder_win[1]->ClearWindow(CC708Decoder_win[1]);
				if (buff[1] & 0x04) CC708Decoder_win[2]->ClearWindow(CC708Decoder_win[2]);
				if (buff[1] & 0x08) CC708Decoder_win[3]->ClearWindow(CC708Decoder_win[3]);
				if (buff[1] & 0x10) CC708Decoder_win[4]->ClearWindow(CC708Decoder_win[4]);
				if (buff[1] & 0x20) CC708Decoder_win[5]->ClearWindow(CC708Decoder_win[5]);
				if (buff[1] & 0x40) CC708Decoder_win[6]->ClearWindow(CC708Decoder_win[6]);
				if (buff[1] & 0x80) CC708Decoder_win[7]->ClearWindow(CC708Decoder_win[7]);
				return true;

			case DLW: // Delete Window
				if (Q->GetSize(Q) < 2) return false;
				Q->Get(Q, buff, 2);
				if (debug_cc)  DST_Printf("DLW 0x%02X 0x%02X\n", buff[0], buff[1]);
				if (buff[1] & 0x01) CC708Decoder_win[0]->DeleteWindow(CC708Decoder_win[0]);
				if (buff[1] & 0x02) CC708Decoder_win[1]->DeleteWindow(CC708Decoder_win[1]);
				if (buff[1] & 0x04) CC708Decoder_win[2]->DeleteWindow(CC708Decoder_win[2]);
				if (buff[1] & 0x08) CC708Decoder_win[3]->DeleteWindow(CC708Decoder_win[3]);
				if (buff[1] & 0x10) CC708Decoder_win[4]->DeleteWindow(CC708Decoder_win[4]);
				if (buff[1] & 0x20) CC708Decoder_win[5]->DeleteWindow(CC708Decoder_win[5]);
				if (buff[1] & 0x40) CC708Decoder_win[6]->DeleteWindow(CC708Decoder_win[6]);
				if (buff[1] & 0x80) CC708Decoder_win[7]->DeleteWindow(CC708Decoder_win[7]);
				return true;

			case DSW: // Display Window
				if (Q->GetSize(Q) < 2) return false;
				Q->Get(Q, buff, 2);
				if (debug_cc)  DST_Printf("DSW 0x%02X 0x%02X\n", buff[0], buff[1]);
				if (buff[1] & 0x01) CC708Decoder_win[0]->DisplayWindow(CC708Decoder_win[0]);
				if (buff[1] & 0x02) CC708Decoder_win[1]->DisplayWindow(CC708Decoder_win[1]);
				if (buff[1] & 0x04) CC708Decoder_win[2]->DisplayWindow(CC708Decoder_win[2]);
				if (buff[1] & 0x08) CC708Decoder_win[3]->DisplayWindow(CC708Decoder_win[3]);
				if (buff[1] & 0x10) CC708Decoder_win[4]->DisplayWindow(CC708Decoder_win[4]);
				if (buff[1] & 0x20) CC708Decoder_win[5]->DisplayWindow(CC708Decoder_win[5]);
				if (buff[1] & 0x40) CC708Decoder_win[6]->DisplayWindow(CC708Decoder_win[6]);
				if (buff[1] & 0x80) CC708Decoder_win[7]->DisplayWindow(CC708Decoder_win[7]);
				return true;

			case HDW: // Hide Window
				if (Q->GetSize(Q) < 2) return false;
				Q->Get(Q, buff, 2);
				if (debug_cc)  DST_Printf("HDW 0x%02X 0x%02X\n", buff[0], buff[1]);
				if (buff[1] & 0x01) CC708Decoder_win[0]->HideWindow(CC708Decoder_win[0]);
				if (buff[1] & 0x02) CC708Decoder_win[1]->HideWindow(CC708Decoder_win[1]);
				if (buff[1] & 0x04) CC708Decoder_win[2]->HideWindow(CC708Decoder_win[2]);
				if (buff[1] & 0x08) CC708Decoder_win[3]->HideWindow(CC708Decoder_win[3]);
				if (buff[1] & 0x10) CC708Decoder_win[4]->HideWindow(CC708Decoder_win[4]);
				if (buff[1] & 0x20) CC708Decoder_win[5]->HideWindow(CC708Decoder_win[5]);
				if (buff[1] & 0x40) CC708Decoder_win[6]->HideWindow(CC708Decoder_win[6]);
				if (buff[1] & 0x80) CC708Decoder_win[7]->HideWindow(CC708Decoder_win[7]);
				return true;

			case TGW: // Toggle Window
				if (Q->GetSize(Q) < 2) return false;
				Q->Get(Q, buff, 2);
				if (debug_cc)  DST_Printf("TGW 0x%02X 0x%02X\n", buff[0], buff[1]);
				if (buff[1] & 0x01) CC708Decoder_win[0]->ToggleWindow(CC708Decoder_win[0]);
				if (buff[1] & 0x02) CC708Decoder_win[1]->ToggleWindow(CC708Decoder_win[1]);
				if (buff[1] & 0x04) CC708Decoder_win[2]->ToggleWindow(CC708Decoder_win[2]);
				if (buff[1] & 0x08) CC708Decoder_win[3]->ToggleWindow(CC708Decoder_win[3]);
				if (buff[1] & 0x10) CC708Decoder_win[4]->ToggleWindow(CC708Decoder_win[4]);
				if (buff[1] & 0x20) CC708Decoder_win[5]->ToggleWindow(CC708Decoder_win[5]);
				if (buff[1] & 0x40) CC708Decoder_win[6]->ToggleWindow(CC708Decoder_win[6]);
				if (buff[1] & 0x80) CC708Decoder_win[7]->ToggleWindow(CC708Decoder_win[7]);
				return true;

			case SWA: // Set Window Attributes
				if (Q->GetSize(Q) < 5) return false;
				Q->Get(Q, buff, 5);
				if (debug_cc)  DST_Printf("SWA 0x%02X 0x%02X 0x%02X 0x%02X 0x%02X\n",
					buff[0], buff[1], buff[2], buff[3], buff[4]);
				if (CC708Decoder_nCurrentWindow == -1) return true;
				CC708Decoder_win[CC708Decoder_nCurrentWindow]->SetWindowAttribute(
					CC708Decoder_win[CC708Decoder_nCurrentWindow],
					buff[3] & 0x03, // Justify
					(buff[3] >> 4) & 0x03, // Print Direction
					(buff[3] >> 2) & 0x03, // Scroll Direction
					((buff[3] >> 5) & 0x01) ? true : false, // Word Wrap
					buff[4] & 0x03, // Display Effect
					(buff[4] >> 2) & 0x03, // Effect Direction
					(buff[4] >> 4) & 0x0F, // Effect Speed
					(buff[1] >> 4) & 0x03, // Fill Color Red
					(buff[1] >> 2) & 0x03, // Fill Color Green
					buff[1] & 0x03, // Fill Color Blue
					(buff[1] >> 6) & 0x03, // Fill Color Opacity
					((buff[3] >> 5) & 0x04) | ((buff[2] >> 6) & 0x03), // Border Type
					(buff[2] >> 4) & 0x03, // Border Color Red
					(buff[2] >> 2) & 0x03, // Border Color Green
					buff[2] & 0x03 // Border Color Blue
				);
				return true;

			case SPA: // Set Pen Attributes
				if (Q->GetSize(Q) < 3) return false;
				Q->Get(Q, buff, 3);
				if (debug_cc)  DST_Printf("SPA 0x%02X 0x%02X 0x%02X\n", buff[0], buff[1], buff[2]);
				if (CC708Decoder_nCurrentWindow < 0) return true;
				CC708Decoder_win[CC708Decoder_nCurrentWindow]->SetPenAttribute
				(
					CC708Decoder_win[CC708Decoder_nCurrentWindow],
					buff[1] & 0x03, // Pen Size
					buff[2] & 0x07, // Font Style
					(buff[1] >> 4) & 0x0F, // Text Tag
					(buff[1] >> 2) & 0x03, // Offset
					(buff[2] & 0x80) ? 1 : 0, // Italics
					(buff[2] & 0x40) ? 1 : 0, // UnderLine
					(buff[2] >> 3) & 0x07	// Edge Type
				);
				return true;

			case SPC: // Set Pen Color
				if (Q->GetSize(Q) < 4) return false;
				Q->Get(Q, buff, 4);
				if (debug_cc)  DST_Printf("SPC 0x%02X 0x%02X 0x%02X 0x%02X\n", buff[0], buff[1], buff[2], buff[3]);
				if (CC708Decoder_nCurrentWindow < 0) return true;
				CC708Decoder_win[CC708Decoder_nCurrentWindow]->SetPenColor
				(
					CC708Decoder_win[CC708Decoder_nCurrentWindow],
					(buff[1] >> 4) & 0x03, // Foreground Body Color Red
					(buff[1] >> 2) & 0x03, // Foreground Body Color Green
					(buff[1] >> 0) & 0x03, // Foreground Body Color Blue
					(buff[1] >> 6) & 0x03, // Foreground Body Opacity
					(buff[2] >> 4) & 0x03, // BackGround Body Color Red
					(buff[2] >> 2) & 0x03, // BackGround Body Color Green
					(buff[2] >> 0) & 0x03, // BackGround Body Color Blue
					(buff[2] >> 6) & 0x03, // BackGround Body Opacity
					(buff[3] >> 4) & 0x03, // Edgeground Body Color Red
					(buff[3] >> 2) & 0x03, // Edgeground Body Color Green
					(buff[3] >> 0) & 0x03  // Edgeground Body Color Blue
				);
				return true;

			case SPL: // Set Pen Location
				if (Q->GetSize(Q) < 3) return false;
				Q->Get(Q, buff, 3);
				if (debug_cc)  DST_Printf("SPL 0x%02X 0x%02X 0x%02X\n", buff[0], buff[1], buff[2]);
				if (CC708Decoder_nCurrentWindow == -1) return true;
				CC708Decoder_win[CC708Decoder_nCurrentWindow]->SetPenLocation(
					CC708Decoder_win[CC708Decoder_nCurrentWindow],
					buff[2] & 0x3F, // Column
					buff[1] & 0x0F // Row
				);
				if (debug_cc)  DST_Printf("SPL %d %d\n", buff[2] & 0x3F, buff[1] & 0x0F);
				return true;

			case DLY:
				if (Q->GetSize(Q) < 2) return false;
				Q->Get(Q, buff, 2);
				if (debug_cc)  DST_Printf("DLY 0x%02X 0x%02X\n", buff[0], buff[1]);
				CC708Decoder_Delay (buff[1]);
				return true;

			case DLC:
				if (debug_cc)  DST_Printf("DLC 0x%02X\n", ucData);
				CC708Decoder_DelayCancel();
				Q->RemoveByte(Q);
				DST_Printf("DLC\n");
				return true;

			case RST:
				if (debug_cc)  DST_Printf("RST 0x%02X\n", ucData);
				Q->RemoveByte(Q);
				CC708Decoder_Reset();
				return true;
		}
		if (debug_cc)  DST_Printf("Unknown C1 Command 0x%02X\n", ucData);
		Q->RemoveByte(Q); // Undefined Command.
		return true;
	}

	bool CC708Decoder_DecodeSub(CCCircularQueue *Q)
	{
		if (Q->GetSize(Q) < 1) return false;
		unsigned char ucData = Q->GetByte(Q);
		if (ucData < 0x20) // C0 
		{
			return CC708Decoder_ProcessC0(Q);
		}
		if (ucData < 0x80) // G0 
		{
			if (debug_cc)  DST_Printf("G0 %c 0x%02X\n", ucData, ucData);
			//if (bKorean == false) // JTBC G0 0x20 ϴ  ⿡ G0  2013.03.13
			{
				switch (ucData)
				{
					case 0x7F:
						CC708Decoder_PrintChar(0x266A); //Unicode Character 'EIGHTH NOTE' (U+266A)
						break;
						
					default:
						CC708Decoder_PrintChar((DS_U16)ucData);
						break;
				}
			}
			Q->RemoveByte(Q);
			return true;
		}
		if (ucData < 0xA0) // C1 
		{
			return CC708Decoder_ProcessC1(Q);
		}
		// G1 
		if (debug_cc)  DST_Printf("G1 %c0x%02X\n", ucData, ucData);
		//if (CC708Decoder_bKorean == false)
		{
		CC708Decoder_PrintChar((DS_U16)ucData);
		}
		Q->RemoveByte(Q);
		return true;
	}
	
//	virtual void Show()
	void CC708Decoder_Show(CWindow *this)
	{
		int i = 0;
		int j = 0;
		OSD_PIXEL_T *tmp_buff = 0;
		DST_RECT rectUpdate;

		OSD_PIXEL_T *srcBuff = 0;
		DST_RECT rectCommon;
		DST_RECT rectSrc;
		int srcStartX = 0;
		int srcStartY = 0;
		OSD_PIXEL_T* src = 0;
		OSD_PIXEL_T* des = 0;
		int y = 0;
		int nSize = 0;
		int src_delta = 0;
		int des_delta = 0;
		int x = 0;	
		
		if (this->imgBuff == 0) return;
		this->KillTimer(this, 2); // ؼ ׸ Ÿ̸Ӹ .
		// EIT PMT CC description Ǿٸ ݴ´.
		bool _bKorean, _bWideScreen, _bUnicode;
		DST_CheckCCDescription(CC708Decoder_nServiceNumber, &_bKorean, &_bWideScreen, &_bUnicode);
		if (CC708Decoder_bKorean != _bKorean || CC708Decoder_bWideScreen != _bWideScreen)
		{
			this->Close(this);
			return;
		}
		if (CC708Decoder_bKorean == true && CC708Decoder_bUnicode != _bUnicode)
		{
			this->Close(this);
			return;
		}

		i = 0;
		for (i = 0; i < 8; i++) CC708Decoder_win[i]->Draw(CC708Decoder_win[i], CC708Decoder_bFlashDraw);//  ִٸ ׸.
		//  ׷ ȭ鿡 ׸.
		rectUpdate = DST_UpdateRegionGet();
		if (rectUpdate.w == 0 || rectUpdate.h == 0) return;
		//DST_Printf("rectUpdate %d %d %d %d \n", rectUpdate.x, rectUpdate.y, rectUpdate.w, rectUpdate.h);
		this->UpdateScreenEx(this, rectUpdate.x, rectUpdate.y, rectUpdate.w, rectUpdate.h);

		//DrawBox(rectUpdate.x, rectUpdate.y, rectUpdate.w, rectUpdate.h, COLOR_TRANSPARENT);
		{ // Ʈ    ä
			tmp_buff = this->imgBuff + this->rect.w * rectUpdate.y + rectUpdate.x;
			nSize = rectUpdate.w * sizeof(OSD_PIXEL_T);
			y = rectUpdate.h;
			while (y--)
			{
				memset(tmp_buff, 0, nSize);
				tmp_buff += this->rect.w;
			}
		}

		bool bFirst = true;
		int priority = 0;
		for ( priority = 7; priority >= 0; priority--)
		{
			// 2013.05.16  priority nCurrentWindow   ׸ Ѵ.
			int order_table[8] = {0,1,2,3,4,5,6,7};
			order_table[0] = (CC708Decoder_nCurrentWindow > -1) ? CC708Decoder_nCurrentWindow : 0;
			i = 0;
			j = 0;
			nSize = 0;
			y = 0;
			for (i = 1; i < 8; i++) order_table[i] = (i <= order_table[0]) ? i-1 : i;
			i = 0;


			for (j = 7; j >= 0; j--)
			{
				
				srcBuff = 0;
				memset(&rectCommon,0,sizeof(DST_RECT));
				memset(&rectSrc,0,sizeof(DST_RECT));
				srcStartX = 0;
				srcStartY = 0;
				src = 0;
				des = 0;
				y = 0;
				nSize = 0;
				src_delta = 0;
				des_delta = 0;
				x = 0;				
				i = order_table[j];
				
				if (priority != CC708Decoder_win[i]->GetPriority(CC708Decoder_win[i])) continue;
				if (CC708Decoder_win[i]->GetVisible(CC708Decoder_win[i]) == false) continue;

				srcBuff = CC708Decoder_win[i]->GetImgBuff(CC708Decoder_win[i]);
				if (srcBuff == 0) continue;

				rectSrc = CC708Decoder_win[i]->GetSize(CC708Decoder_win[i]);
				
				if (DST_GetCommonRect(rectUpdate, rectSrc, &rectCommon ) == false) continue;
				
				srcStartX = rectCommon.x - rectSrc.x;
				if (srcStartX < 0) srcStartX = 0;
				srcStartY = rectCommon.y - rectSrc.y;
				if (srcStartY < 0) srcStartY = 0;
				//DS_U8* des1 = imgBuff + rect.w * rectCommon.y + rectCommon.x;
				//DS_U8* src1 = srcBuff + rectSrc.w * srcStartY + srcStartX;
				if (bFirst == true)
				{
					bFirst = false;

					src = srcBuff + rectSrc.w * srcStartY + srcStartX;
					des = this->imgBuff + rectCommon.y * this->rect.w + rectCommon.x;
					y = rectCommon.h;
					nSize = rectCommon.w * sizeof(OSD_PIXEL_T);
					while (y--)
					{
						memcpy(des, src, nSize);
						src += rectSrc.w;
						des += this->rect.w;
					}
				}
				else
				{
					src = srcBuff + rectSrc.w * srcStartY + srcStartX;
					des = this->imgBuff + rectCommon.y * this->rect.w + rectCommon.x;
					src_delta = rectSrc.w-rectCommon.w;
					des_delta = this->rect.w-rectCommon.w;
					y = rectCommon.h;
					while (y--)
					{
						x = rectCommon.w;
						while (x--)
						{
							if (*src) *des = *src;
							src++;
							des++;
						}
						src+=src_delta;
						des+=des_delta;
						x = 0;
					}
				}
			}
		}
		DST_UpdateRegionReset();
		CC708Decoder_LastShowTime = DST_OS_GetTickCount();
	}


	
//	virtual void OnMessage(SWinEventMsg event)
	void CC708Decoder_OnMessage(CWindow *this, SWinEventMsg event)
	{
		int i = 0;
		switch (event.cmd)
		{
			case WM_SEQ_ERROR:
				
//				T();
				this->Close(this);
				break;

			case WM_CS1:
				
//				T();
				if (this->GetState(this) != 1) break;
				this->ResetTimer(this, 0); //  ŸӾƿ  Ѵ.
				for (i = 0 ; i < event.data[0]; i++) 
				{
					if (debug_cc) DST_Printf("%02X ", event.data[i+1]);
					CC708Decoder_Queue->Add2(CC708Decoder_Queue, event.data[i+1]);
				}
				if (debug_cc) DST_Printf("\n");
				while (1)
				{
					if (CC708Decoder_DecodeSub(CC708Decoder_Queue)== false) break;
				}
				if (CC708Decoder_LastShowTime > DST_OS_GetTickCount()) CC708Decoder_LastShowTime = DST_OS_GetTickCount();
				if (DST_OS_GetTickCount() - CC708Decoder_LastShowTime < DST_OS_GetTicksPerSecond()/10)
				{
					this->SetTimer(this, 2, 100); // 100ms Ŀ ׸
				}
				else
				{
					this->Show(this);
				}
				break;

			case WM_CC_CLOSE:
//				T();
				this->Close(this);
				break;
		}
	}
//};

void DST_CreateCC708Win(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor	= CC708Decoder_Destructor;
	pWin->OnMessage 	= CC708Decoder_OnMessage;
	pWin->OnTimer		= CC708Decoder_OnTimer;
	pWin->Show			= CC708Decoder_Show;
	//  ȣ
	CC708Decoder_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);

}
