
#include "DST_HostInterface.h"
#include "DST_SignalMonitor.h"
#include "DST_ChannelTune.h"
#include "dst_eroum_interface.h"
#include "DST_EEPROM.h"
#include "DST_WinManagerTask.h"
#include "DST_WinManager.h"

void DST_Mute();

// Simple Task 10ms  ȣ
void DST_AspectRatio(void)
{
	static DHL_ASPECT_RATIO ar_old = (DHL_ASPECT_RATIO)-1;
	if (DST_g_LastTuneTime == 0) return;
	if (DST_IsVideoPlay() == false) return;
	DS_U16 w = 0, h = 0, fps = 0;
	bool bInterlace = false, bWide = false;
	DST_GetVideoSize(&w, &h, &fps, &bInterlace, &bWide);
	
	static DS_U16 old_w = 0;
	static DS_U16 old_h = 0;
	static DS_U16 old_fps = 0;
	static bool old_bInterlace = false;
	static bool old_bWide = false;
	if (old_w != w || old_h != h || old_fps != fps || old_bInterlace != bInterlace || old_bWide != bWide)
	{
		DST_SendWindowEventWithOnlyCmd(WM_SOURCE_FORMAT_DONE);
		old_w = w;
		old_h = h;
		old_fps = fps;
		old_bInterlace = bInterlace;
		old_bWide = bWide;
	}

	if (h == 0) return;
	DHL_ASPECT_RATIO ar = DHL_ASPECT_4x3_4x3;
	bool bSource4x3 = (!bWide);
	DS_U8 AspectRatio = DST_EEPROM_GetAspect(bSource4x3);

	if (bSource4x3)
	{
		ar = DHL_ASPECT_4x3_4x3;
	}
	else
	{
		switch (AspectRatio)
		{
			case ASPECT_RATIO_WIDE: ar = DHL_ASPECT_16x9_4x3_WIDE; break;
			case ASPECT_RATIO_NORMAL: ar = DHL_ASPECT_16x9_4x3_NORMAL; break;
			case ASPECT_RATIO_ZOOM: ar = DHL_ASPECT_16x9_4x3_ZOOM; break;
			default: break;
		}
	}
	
	
	if (ar_old == ar) return;
	DHL_VID_Aspect(ar, w, h);
	ar_old = ar;

}


void DST_SleepTimer()
{
	DS_U32 shutdownTime = 0;
	static DS_U32 wraparoundTime1 = 0;

	//60 ʹ īƮٿ OSD ǥؾ ϹǷ sleeptime 1 
	//0  off return
	switch(DST_GetSleepTimer())
	{
		case 1: shutdownTime = 14*60*DST_OS_GetTicksPerSecond(); break;
		case 2: shutdownTime = 29*60*DST_OS_GetTicksPerSecond(); break;
		case 3: shutdownTime = 59*60*DST_OS_GetTicksPerSecond(); break;
		case 4: shutdownTime = 119*60*DST_OS_GetTicksPerSecond(); break;
		default: return;
	}

	DS_U32 addedTime = 0;
	//ñؽð tickcount Ŀ  DS_U32 max ʰ   tickcount 0 ʱȭ ǹǷ
	// 쿡 DS_U32 max (0xFFFFFFFF)  ñؽð  Ѵ.
	//  0 ʱȭ Ǿ 귯 tickcount ϸ ð ´.
	if(DST_g_sleepTimercheckTime > DST_OS_GetTickCount())
	{
		wraparoundTime1 = 0xFFFFFFFF - DST_g_sleepTimercheckTime;
		addedTime = wraparoundTime1 + DST_OS_GetTickCount();
	}
	else //Ϲ 쿡 tickcount ñؽð  ð Ѵ
	{
		wraparoundTime1 = 0;
		addedTime = DST_OS_GetTickCount() - DST_g_sleepTimercheckTime ;
	}

	//ð  sleeptime  return
	if(addedTime < shutdownTime) return;
	
	DST_CreateWin(WIN_POWER_DOWN_CAUTION,WIN_NULL,0,0,0,0);
}


void DST_Timer()
{
	if(DST_g_bSleepTimerOut) return;

	//hostinterface bPressed 1   true 
	//̰ true  ⼭ false .
	//SleepTimer  PowerDown ñؽð Ű   
	//60 īƮٿ OSD ִٸ closeŴ
	if(DST_g_KeyPressed)
	{
		//60 īƮٿ OSD  쿡, Ű Է  sleeptimer 0ff 
		if(DST_GetWin(WIN_POWER_DOWN_CAUTION))	DST_SetSleepTimer(0);
		
		DST_g_BadSignalStartTime = DST_OS_GetTickCount();
		DST_g_KeyPressed = false;
		if(DST_GetWin(WIN_POWER_DOWN_CAUTION)) DST_CloseWin(WIN_POWER_DOWN_CAUTION);
	}

	//60 īƮٿ OSD ִٸ ̹ ð Ƿ returnѴ
	if(DST_GetWin(WIN_POWER_DOWN_CAUTION)) return;
	
	//߿   Ǵ timer 켱ϸ, 60  ϴ  īƮٿ OSD Ѵ. 
	DST_SleepTimer();
}

// LED Ʈ
static void DST_LED()
{
	// POWER OFF  
	if (DST_g_PowerOn == false)
	{
		DHL_SetLED(true, false); // 
		return;
	}
	
	// RF UPDATE 
	if (DST_GetWin(WIN_FACTORY_MODE) || DST_GetWin(WIN_RF_UPDATE) || DST_GetWin(WIN_OTC_DOWNLOAD) || DST_GetWin(WIN_OTC_DOWNLOAD_FAIL) || DST_GetWin(WIN_UPDATE) || DST_GetWin(WIN_UPDATE_RESET)) // RF Ʈ  0.5  RED/GREEN/YELLOW 
	{
		int nPos = DST_OS_GetTickCount() / (DST_OS_GetTicksPerSecond()/ 3);
		switch (DST_g_RFUpdateState)
		{
			case 0: //  //
				switch (nPos%3)
				{
					case 0:DHL_SetLED(true , false); break;
					case 1:DHL_SetLED(false, true); break;
					case 2:DHL_SetLED(true , true); break;
				}
				break;
			case 1: //   
				switch (nPos%3)
				{
					case 0:DHL_SetLED(false ,true); break;
					case 1:DHL_SetLED(false, true); break;
					case 2:DHL_SetLED(false ,false); break;
				}
				break;
			case 2: //   
				switch (nPos%3)
				{
					case 0:DHL_SetLED(true ,false); break;
					case 1:DHL_SetLED(true, false); break;
					case 2:DHL_SetLED(false ,false); break;
				}
				break;
		}
		return;
	}
	
	// Ű  
	if (DST_OS_GetTickCount() - DST_g_KeyPressTime < DST_OS_GetTicksPerSecond()/10) 
	{
		DHL_SetLED(false, false); // Ű  100ms  OFF
		return;
	}
	
	// Ϲ 
	DHL_SetLED(false, true); // 
}

// 10ms ȣ ɵ ִ´.
// ð  ½ũ ٸ ½ũ  ġǷ  óѴ.
static void tSimpleTaskSub()
{
	DST_LED();
	DST_AspectRatio();	
	DST_Timer();
	if (DST_g_LastTuneTryTime == 0)
		DST_g_LastTuneTryTime = DST_OS_GetTickCount();
}

static void tSimpleTask()
{
	while (1)
	{
		DST_OS_Delay(10);
		tSimpleTaskSub();
	}
}

void DST_SimpleTask(void)
{
	static DS_U32 TaskID = 0;
	if (TaskID == 0) TaskID = DST_OS_SpawnTask((void(*)(void *))tSimpleTask, (char*)"tSimple", APP_TASK_PRIO_SIMPLE, WIN_MGR_TASK_STACKSIZE,  0);
}
