#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"
#include "DST_DB_Engine.h"
#include "DST_MemoryDB.h"

#if 0
____CPowerDownCautionWin___()
#endif

typedef struct 
{
	char* name;
}DBNAMES;

typedef struct 
{
	DS_U8 type;
	char* name;
}ATTRIBUTES;

static DB_NO_LIST g_no_list;

//class CDebugSQLWin : public CWindow
//{
//private:
	static DS_U16 CDebugSQLWin_Pos;
	static DS_U16 CDebugSQLWin_Top;
	static DS_U16 CDebugSQLWin_Select;
	static DS_U16 CDebugSQLWin_ListNum;
	static DS_U16 CDebugSQLWin_ItemNum;

	static DS_U16 CDebugSQLWin_pre_Pos;
	static DS_U16 CDebugSQLWin_pre_Top;
	static DS_U16 CDebugSQLWin_pre_Select;
	static DS_U16 CDebugSQLWin_pre_ListNum;
	static DS_U16 CDebugSQLWin_pre_ItemNum;

//	static DBNAMES* CDebugSQLWin_names;
//public:
void CDebugSQLWin_InitValues();
//	CDebugSQLWin(SWinEventMsg event):CWindow(event)
	void CDebugSQLWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "DebugSql");
		CDebugSQLWin_InitValues();
		this->rect.w = 576;
		this->rect.h = 384;
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight() - this->rect.h) / 2;

		this->SetTimeOut(this, 0);

		this->RegisterKey(this, VK_CANCEL, true, 0, 0);
		this->RegisterKey(this, VK_PREV, true, 0, 0);
		this->RegisterKey(this, VK_PREV_CH, true, 0, 0);
		this->RegisterKey(this, VK_PREV_MENU, true, 0, 0);
		this->RegisterKey(this, VK_OK, true, 0, 0);
		this->RegisterKey(this, VK_RIGHT, true, 0, 0);
		this->RegisterKey(this, VK_LEFT, true, 0, 0);
		this->RegisterKey(this, VK_UP, true, 0, 0);
		this->RegisterKey(this, VK_DN, true, 0, 0);
	}

	void CDebugSQLWin_Destructor(CWindow *this)
	{
//		int i = 0; 
//		if (CDebugSQLWin_names) 
//		{
//			for ( i = 0; i < CDebugSQLWin_ItemNum; i++) if (CDebugSQLWin_names[i].name) DST_OS_Free(&CDebugSQLWin_names[i].name);
//			DST_OS_Free(&CDebugSQLWin_names);
//		}

	}
	
//	DBNAMES* CDebugSQLWin_GetDBTableName(DS_U16 *size)
//	{
//
//		CDB db;
//		NewCDB(&db);
//		DBNAMES* n;
//		int i = 0;
//		db.GetTable(&db, "SELECT name FROM sqlite_master where type='table' order by name");
//		*size = db.GetRow(&db);
//		if (*size < 1) 
//		{
//			DeleteCDB(&db);
//			return 0;
//		}
//		n = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), *size);
//		for ( i = 0; i < *size; i++)
//		{
//			int nLen = strlen(db.GetResult(&db, (i+1)*db.GetCol(&db)+0));
//			n[i].name = 0;
//			n[i].name = (char*)DST_OS_Calloc((nLen+1)*sizeof(char),1);
//			memcpy(n[i].name,db.GetResult(&db, (i+1)*db.GetCol(&db)+0),nLen);
//		}
//		DeleteCDB(&db);
//		return n;
//	}	
//	
	void CDebugSQLWin_UpdateList()
	{
//		int i = 0;
//		if (CDebugSQLWin_names) 
//		{
//			for ( i = 0; i < CDebugSQLWin_ItemNum; i++) if (CDebugSQLWin_names[i].name) DST_OS_Free(&CDebugSQLWin_names[i].name);
//			DST_OS_Free(&CDebugSQLWin_names);
//		}
//		CDebugSQLWin_names = CDebugSQLWin_GetDBTableName(&CDebugSQLWin_ItemNum);	
	}
		
	void CDebugSQLWin_InitValues()
	{		
//		CDebugSQLWin_names = 0;
		CDebugSQLWin_Pos = 0;
		CDebugSQLWin_Top = 0;
		CDebugSQLWin_Select = 0;
		CDebugSQLWin_ListNum = 30;
		CDebugSQLWin_ItemNum = NO_DB_MAX;

		CDebugSQLWin_pre_Pos = CDebugSQLWin_Pos;
		CDebugSQLWin_pre_Top = CDebugSQLWin_Top;
		CDebugSQLWin_pre_Select = CDebugSQLWin_Select;
		CDebugSQLWin_pre_ListNum = CDebugSQLWin_ListNum;
		CDebugSQLWin_pre_ItemNum = CDebugSQLWin_ItemNum;
		
//		CDebugSQLWin_UpdateList();
		if (CDebugSQLWin_ItemNum < CDebugSQLWin_ListNum) CDebugSQLWin_ListNum = CDebugSQLWin_ItemNum;
	}

//	virtual void Show(WinID id)
	void CDebugSQLWin_ShowWindow(CWindow *this, WinID id)
	{
		DST_Printf("id=%d\n",id);
		switch(id)
		{
			case WIN_DEBUG_SQL_SUB:
			case WIN_DEBUG_SQL:
			case WIN_CHANNEL_BANNER:
			case WIN_ERROR:				
				break;
			default:
				this->Close(this);
				break;
		}
	}

	void CDebugSQLWin_DrawAll(CWindow *this)
	{
		int x = 0;
		int y = 0;
		
		this->setFontStyle(this, 15, 0xAAC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);

		this->DrawBox32(this, 0, 0, this->rect.w, this->rect.h, CONV32_16(0xAA262626));

		for( x=0;x<3;x++)
		{
			for( y=0;y<10;y++)
			{
				if(CDebugSQLWin_ItemNum > y+x*10)
				{
					if(CDebugSQLWin_Select+CDebugSQLWin_Top == y+x*10)
						this->DrawBox32(this, 2+x*192, 84+2+y*30, 192-4, 30-4, CONV32_16(0xAA1C3923));
					else
						this->DrawBox32(this, 2+x*192, 84+2+y*30, 192-4, 30-4, CONV32_16(0xAAFFA52C));
					this->DrawText(this, 2+x*192, 84+2+y*30, 192-4, 30-4,db_list[y+x*10].name,&(this->font));
				}
			}
		}
		
	}

	void CDebugSQLWin_Draw(CWindow *this)
	{
		int x = 0;
		int y = 0;
		this->setFontStyle(this, 15, 0xAAC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);

		for( x=0;x<3;x++)
		{
			for( y=0;y<10;y++)
			{
				if(CDebugSQLWin_ItemNum > y+x*10)
				{
					if(CDebugSQLWin_Select+CDebugSQLWin_Top == y+x*10)
						this->DrawBox32(this, 2+x*192, 84+2+y*30, 192-4, 30-4, CONV32_16(0xAA1C3923));
					else
						this->DrawBox32(this, 2+x*192, 84+2+y*30, 192-4, 30-4, CONV32_16(0xAAFFA52C));
					this->DrawText(this, 2+x*192, 84+2+y*30, 192-4, 30-4,db_list[y+x*10].name,&(this->font));
				}
			}
		}
		
	}

//	virtual void Show()
	void CDebugSQLWin_Show(CWindow *this)
	{
		CDebugSQLWin_DrawAll(this);
	}	

//		virtual void OnTimer(char nID)
	void CDebugSQLWin_OnTimer(CWindow *this, char nID)
	{
		switch(nID)
		{
			case 1:
				break;
			default: break;
		}
	}	

//	virtual void KeyInput(DS_U8 key,bool)
	void CDebugSQLWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch(key)
		{
			case VK_PREV_CH:
			case VK_PREV:
			case VK_PREV_MENU:
			case VK_CANCEL: 
				if (DST_GetWin(WIN_ENGINEER_MODE)==0) DST_CreateWin(WIN_ENGINEER_MODE, 0, 0, 0, 0, 0);
				this->Close(this);
				break;
			case VK_OK: 
				g_no_list = db_list[CDebugSQLWin_Select+CDebugSQLWin_Top].list;
				DST_CreateWin(WIN_DEBUG_SQL_SUB, 0, 0, 0, 0, 0);
				this->SetVisible(this, false);
				break;
			case VK_RIGHT: break;
			case VK_LEFT: break;
			case VK_UP:
			case VK_DN:
				if(key == VK_DN)
					ItemIncrease(CDebugSQLWin_ItemNum, CDebugSQLWin_ListNum, &CDebugSQLWin_Top, &CDebugSQLWin_Select, &CDebugSQLWin_Pos, 1);
				else
					ItemDecrease(CDebugSQLWin_ItemNum, CDebugSQLWin_ListNum, &CDebugSQLWin_Top, &CDebugSQLWin_Select, &CDebugSQLWin_Pos, 1);
				CDebugSQLWin_Draw(this);
				break;
			default: break;
		}
	}
//};


void DST_CreateDebugSQLWin(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor	= CDebugSQLWin_Destructor;
	pWin->KeyInput		= CDebugSQLWin_KeyInput;
	pWin->OnTimer		= CDebugSQLWin_OnTimer;
	pWin->ShowWindow	= CDebugSQLWin_ShowWindow;
	pWin->Show			= CDebugSQLWin_Show;
	//  ȣ
	CDebugSQLWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}

//class CDebugSQLSubWin : public CWindow
//{
//private:
	static DS_U16 CDebugSQLSubWin_RowPos;
	static DS_U16 CDebugSQLSubWin_RowTop;
	static DS_U16 CDebugSQLSubWin_RowSelect;
	static DS_U16 CDebugSQLSubWin_RowListNum;
	static DS_U16 CDebugSQLSubWin_RowItemNum;

	static DS_U16 CDebugSQLSubWin_ColPos;
	static DS_U16 CDebugSQLSubWin_ColTop;
	static DS_U16 CDebugSQLSubWin_ColSelect;
	static DS_U16 CDebugSQLSubWin_ColListNum;
	static DS_U16 CDebugSQLSubWin_ColItemNum;

	static DS_U16 CDebugSQLSubWin_pre_RowPos;
	static DS_U16 CDebugSQLSubWin_pre_RowTop;
	static DS_U16 CDebugSQLSubWin_pre_RowSelect;
	static DS_U16 CDebugSQLSubWin_pre_RowListNum;
	static int CDebugSQLSubWin_pre_RowItemNum;

	static DS_U16 CDebugSQLSubWin_pre_ColPos;
	static DS_U16 CDebugSQLSubWin_pre_ColTop;
	static DS_U16 CDebugSQLSubWin_pre_ColSelect;
	static DS_U16 CDebugSQLSubWin_pre_ColListNum;
	static DS_U16 CDebugSQLSubWin_pre_ColItemNum;

	static DBNAMES * CDebugSQLSubWin_results;
	static ATTRIBUTES * CDebugSQLSubWin_attributes;
//public:
void CDebugSQLSubWin_InitValues(void);

//	CDebugSQLSubWin(SWinEventMsg event):CWindow(event)
	void CDebugSQLSubWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "DebugSqlSub");
		CDebugSQLSubWin_InitValues();
		this->rect.w = 576;
		this->rect.h = 384;
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight() - this->rect.h) / 2;

		this->SetTimeOut(this, 0);

		this->RegisterKey(this, VK_CANCEL, true, 0, 0);
		this->RegisterKey(this, VK_PREV, true, 0, 0);
		this->RegisterKey(this, VK_PREV_CH, true, 0, 0);
		this->RegisterKey(this, VK_PREV_MENU, true, 0, 0);
		this->RegisterKey(this, VK_OK, true, 0, 0);
		this->RegisterKey(this, VK_RIGHT, true, 0, 0);
		this->RegisterKey(this, VK_LEFT, true, 0, 0);
		this->RegisterKey(this, VK_UP, true, 0, 0);
		this->RegisterKey(this, VK_DN, true, 0, 0);

	}

	void CDebugSQLSubWin_Destructor(CWindow *this)
	{
		int i = 0;
		int j = 0;
		if (CDebugSQLSubWin_results)
		{
			for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
			{
				for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
				{
					if(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name)
					DST_OS_Free(&CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);
				}
			}
			DST_OS_Free(&CDebugSQLSubWin_results);			
		}
		if(CDebugSQLSubWin_attributes)
		{
//			j = 0;
//			for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
//			{
//				DST_Printf("   %d\n",j);
//				if(CDebugSQLSubWin_attributes[j].name)	DST_OS_Free(&CDebugSQLSubWin_attributes[j].name);
//			}
			DST_OS_Free(&CDebugSQLSubWin_attributes);
		}
	}

	void CDebugSQLSubWin_GetDBResult()
	{
		if(g_no_list >= NO_DB_MAX) return;
		int i = 0;
		int j = 0;
		char tmp_str[4096];
		DBLock(true);
		switch(g_no_list)
		{
			case NO_PAT:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< DB_PAT_MAX ; i++)
				{
					if(db_pat[i].program_number == 0) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 4;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"program_number";
				CDebugSQLSubWin_attributes[1].type = 1;
				CDebugSQLSubWin_attributes[2].name = (char *)"pid";
				CDebugSQLSubWin_attributes[2].type = 1;
				CDebugSQLSubWin_attributes[3].name = (char *)"crc";
				CDebugSQLSubWin_attributes[3].type = 1;				

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",db_pat[i].rf);	break;
							case 1:	sprintf(tmp_str,"%d",db_pat[i].program_number);	break;
							case 2:	sprintf(tmp_str,"%d",db_pat[i].pid); break;
							case 3:	sprintf(tmp_str,"%d",db_pat[i].crc); break;
							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;
			case NO_PMT:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< DB_PMT_MAX ; i++)
				{
					if(db_pmt[i].program_number == 0) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 8;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"program_number";
				CDebugSQLSubWin_attributes[1].type = 1;
				CDebugSQLSubWin_attributes[2].name = (char *)"pcr_pid";
				CDebugSQLSubWin_attributes[2].type = 1;
				CDebugSQLSubWin_attributes[3].name = (char *)"ca_pid";
				CDebugSQLSubWin_attributes[3].type = 1;		
				CDebugSQLSubWin_attributes[4].name = (char *)"video_pid";
				CDebugSQLSubWin_attributes[4].type = 1;	
				CDebugSQLSubWin_attributes[5].name = (char *)"video_type";
				CDebugSQLSubWin_attributes[5].type = 1;					
				CDebugSQLSubWin_attributes[6].name = (char *)"minor";
				CDebugSQLSubWin_attributes[6].type = 1;	
				CDebugSQLSubWin_attributes[7].name = (char *)"crc";
				CDebugSQLSubWin_attributes[7].type = 1;	

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",db_pmt[i].rf);	break;
							case 1:	sprintf(tmp_str,"%d",db_pmt[i].program_number);	break;
							case 2:	sprintf(tmp_str,"%d",db_pmt[i].pcr_pid); break;
							case 3:	sprintf(tmp_str,"%d",db_pmt[i].ca_pid); break;
							case 4:	sprintf(tmp_str,"%d",db_pmt[i].video_pid);	break;
							case 5:	sprintf(tmp_str,"%d",db_pmt[i].video_type);	break;
							case 6:	sprintf(tmp_str,"%d",db_pmt[i].minor); break;
							case 7:	sprintf(tmp_str,"%d",db_pmt[i].crc); break;							
							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;	
#if EPG_SUPPORT			
			case NO_EIT:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< DB_EIT_MAX ; i++)
				{
					if(db_eit[i].rf == 0 && db_eit[i].id == 0 && db_eit[i].source_id == 0 && db_eit[i].version_number == 0 && db_eit[i].crc == 0) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 5;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"id";
				CDebugSQLSubWin_attributes[1].type = 1;
				CDebugSQLSubWin_attributes[2].name = (char *)"source_id";
				CDebugSQLSubWin_attributes[2].type = 1;
				CDebugSQLSubWin_attributes[3].name = (char *)"version_number";
				CDebugSQLSubWin_attributes[3].type = 1;				
				CDebugSQLSubWin_attributes[4].name = (char *)"crc";
				CDebugSQLSubWin_attributes[4].type = 1;	

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",db_eit[i].rf);	break;
							case 1:	sprintf(tmp_str,"%d",db_eit[i].id);	break;
							case 2:	sprintf(tmp_str,"%d",db_eit[i].source_id); break;
							case 3:	sprintf(tmp_str,"%d",db_eit[i].version_number); break;
							case 4:	sprintf(tmp_str,"%d",db_eit[i].crc); break;
							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;				
			case NO_EIT_SUB:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< DB_EIT_SUB_MAX ; i++)
				{
					if(db_eit_sub[i].rf == 0 && db_eit_sub[i].id == 0 && db_eit_sub[i].source_id == 0 && db_eit_sub[i].event_id == 0 &&
						db_eit_sub[i].start_time == 0 && db_eit_sub[i].length_in_seconds == 0 && db_eit_sub[i].title==0?true:(strlen(db_eit_sub[i].title) == 0)?true:false) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 7;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"id";
				CDebugSQLSubWin_attributes[1].type = 1;
				CDebugSQLSubWin_attributes[2].name = (char *)"source_id";
				CDebugSQLSubWin_attributes[2].type = 1;
				CDebugSQLSubWin_attributes[3].name = (char *)"event_id";
				CDebugSQLSubWin_attributes[3].type = 1;				
				CDebugSQLSubWin_attributes[4].name = (char *)"start_time";
				CDebugSQLSubWin_attributes[4].type = 1;	
				CDebugSQLSubWin_attributes[5].name = (char *)"length_in_seconds";
				CDebugSQLSubWin_attributes[5].type = 1;	
				CDebugSQLSubWin_attributes[6].name = (char *)"title";
				CDebugSQLSubWin_attributes[6].type = 0;	

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",db_eit_sub[i].rf);	break;
							case 1:	sprintf(tmp_str,"%d",db_eit_sub[i].id);	break;
							case 2:	sprintf(tmp_str,"%d",db_eit_sub[i].source_id); break;
							case 3:	sprintf(tmp_str,"%d",db_eit_sub[i].event_id); break;
							case 4:	sprintf(tmp_str,"%d",db_eit_sub[i].start_time); break;
							case 5:	sprintf(tmp_str,"%d",db_eit_sub[i].length_in_seconds); break;
							case 6:	sprintf(tmp_str,"%s",db_eit_sub[i].title); break;
							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;				
			case NO_ETT:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< DB_ETT_MAX ; i++)
				{
					if(db_ett[i].rf == 0 && db_ett[i].source_id == 0 && db_ett[i].event_id == 0 && db_ett[i].title==0?true:(strlen(db_ett[i].title) == 0)?true:false  && db_ett[i].crc == 0) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 5;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"source_id";
				CDebugSQLSubWin_attributes[1].type = 1;
				CDebugSQLSubWin_attributes[2].name = (char *)"event_id";
				CDebugSQLSubWin_attributes[2].type = 1;
				CDebugSQLSubWin_attributes[3].name = (char *)"title";
				CDebugSQLSubWin_attributes[3].type = 0;				
				CDebugSQLSubWin_attributes[4].name = (char *)"crc";
				CDebugSQLSubWin_attributes[4].type = 1;		

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",db_ett[i].rf);	break;
							case 1:	sprintf(tmp_str,"%d",db_ett[i].source_id);	break;
							case 2:	sprintf(tmp_str,"%d",db_ett[i].event_id); break;
							case 3:	sprintf(tmp_str,"%s",db_ett[i].title); break;
							case 4:	sprintf(tmp_str,"%d",db_ett[i].crc); break;
							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;	
#endif
#if CHANNEL_EDIT_SUPPORT			
			case NO_SKIP_LIST:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< DB_SKIP_LIST_MAX ; i++)
				{
					if(db_skip_list[i].rf == 0 && db_skip_list[i].program_number == 0 ) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 2;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"program_number";
				CDebugSQLSubWin_attributes[1].type = 1;

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",db_skip_list[i].rf);	break;
							case 1:	sprintf(tmp_str,"%d",db_skip_list[i].program_number);	break;
							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;		
#endif	
#if CVCT_SUPPORT	
			case NO_CVCT:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< DB_CVCT_MAX ; i++)
				{
					if(db_cvct[i].rf == 0 && db_cvct[i].transport_stream_id == 0 && db_cvct[i].version_number == 0 && db_cvct[i].crc == 0) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 4;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"transport_stream_id";
				CDebugSQLSubWin_attributes[1].type = 1;
				CDebugSQLSubWin_attributes[2].name = (char *)"version_number";
				CDebugSQLSubWin_attributes[2].type = 1;
				CDebugSQLSubWin_attributes[3].name = (char *)"crc";
				CDebugSQLSubWin_attributes[3].type = 1;				

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",db_cvct[i].rf);	break;
							case 1:	sprintf(tmp_str,"%d",db_cvct[i].transport_stream_id);	break;
							case 2:	sprintf(tmp_str,"%d",db_cvct[i].version_number); break;
							case 3:	sprintf(tmp_str,"%d",db_cvct[i].crc); break;
							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;				
			case NO_CVCT_SUB:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< DB_CVCT_SUB_MAX ; i++)
				{
					if(db_cvct_sub[i].rf == 0 && db_cvct_sub[i].short_name==0?true:(strlen(db_cvct_sub[i].short_name) == 0)?true:false && db_cvct_sub[i].long_name==0?true:(strlen(db_cvct_sub[i].long_name) == 0)?true:false && db_cvct_sub[i].major_channel_number == 0 &&
						db_cvct_sub[i].minor_channel_number == 0 && db_cvct_sub[i].modulation_mode== 0 && db_cvct_sub[i].carrier_frequency== 0 && db_cvct_sub[i].channel_TSID == 0 &&
						db_cvct_sub[i].program_number == 0 && db_cvct_sub[i].ETM_location == 0 && db_cvct_sub[i].access_controlled == 0 && db_cvct_sub[i].hidden == 0 &&
						db_cvct_sub[i].show_guide == 0 && db_cvct_sub[i].service_type == 0 && db_cvct_sub[i].source_id == 0 ) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 15;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"short_name";
				CDebugSQLSubWin_attributes[1].type = 0;
				CDebugSQLSubWin_attributes[2].name = (char *)"long_name";
				CDebugSQLSubWin_attributes[2].type = 0;
				CDebugSQLSubWin_attributes[3].name = (char *)"major_channel_number";
				CDebugSQLSubWin_attributes[3].type = 1;				
				CDebugSQLSubWin_attributes[4].name = (char *)"minor_channel_number";
				CDebugSQLSubWin_attributes[4].type = 1;
				CDebugSQLSubWin_attributes[5].name = (char *)"modulation_mode";
				CDebugSQLSubWin_attributes[5].type = 1;
				CDebugSQLSubWin_attributes[6].name = (char *)"carrier_frequency";
				CDebugSQLSubWin_attributes[6].type = 1;
				CDebugSQLSubWin_attributes[7].name = (char *)"channel_TSID";
				CDebugSQLSubWin_attributes[7].type = 1;	
				CDebugSQLSubWin_attributes[8].name = (char *)"program_number";
				CDebugSQLSubWin_attributes[8].type = 1;
				CDebugSQLSubWin_attributes[9].name = (char *)"ETM_location";
				CDebugSQLSubWin_attributes[9].type = 1;
				CDebugSQLSubWin_attributes[10].name = (char *)"access_controlled";
				CDebugSQLSubWin_attributes[10].type = 1;
				CDebugSQLSubWin_attributes[11].name = (char *)"hidden";
				CDebugSQLSubWin_attributes[11].type = 1;	
				CDebugSQLSubWin_attributes[12].name = (char *)"show_guide";
				CDebugSQLSubWin_attributes[12].type = 1;
				CDebugSQLSubWin_attributes[13].name = (char *)"service_type";
				CDebugSQLSubWin_attributes[13].type = 1;
				CDebugSQLSubWin_attributes[14].name = (char *)"source_id";
				CDebugSQLSubWin_attributes[14].type = 1;

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",db_cvct_sub[i].rf);	break;
							case 1:	sprintf(tmp_str,"%s",db_cvct_sub[i].short_name);	break;
							case 2:	sprintf(tmp_str,"%s",db_cvct_sub[i].long_name); break;
							case 3:	sprintf(tmp_str,"%d",db_cvct_sub[i].major_channel_number); break;
							case 4:	sprintf(tmp_str,"%d",db_cvct_sub[i].minor_channel_number);	break;
							case 5:	sprintf(tmp_str,"%d",db_cvct_sub[i].modulation_mode);	break;
							case 6:	sprintf(tmp_str,"%d",db_cvct_sub[i].carrier_frequency); break;
							case 7:	sprintf(tmp_str,"%d",db_cvct_sub[i].channel_TSID); break;
							case 8:	sprintf(tmp_str,"%d",db_cvct_sub[i].program_number);	break;
							case 9:	sprintf(tmp_str,"%d",db_cvct_sub[i].ETM_location);	break;
							case 10: sprintf(tmp_str,"%d",db_cvct_sub[i].access_controlled); break;
							case 11: sprintf(tmp_str,"%d",db_cvct_sub[i].hidden); break;
							case 12: sprintf(tmp_str,"%d",db_cvct_sub[i].show_guide);	break;
							case 13: sprintf(tmp_str,"%d",db_cvct_sub[i].service_type);	break;
							case 14: sprintf(tmp_str,"%d",db_cvct_sub[i].source_id); break;

							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;	
#endif			
			case NO_TVCT:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< DB_TVCT_MAX ; i++)
				{
					if(db_tvct[i].crc == 0) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 4;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"transport_stream_id";
				CDebugSQLSubWin_attributes[1].type = 1;
				CDebugSQLSubWin_attributes[2].name = (char *)"version_number";
				CDebugSQLSubWin_attributes[2].type = 1;
				CDebugSQLSubWin_attributes[3].name = (char *)"crc";
				CDebugSQLSubWin_attributes[3].type = 1;				

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",db_tvct[i].rf);	break;
							case 1:	sprintf(tmp_str,"%d",db_tvct[i].transport_stream_id);	break;
							case 2:	sprintf(tmp_str,"%d",db_tvct[i].version_number); break;
							case 3:	sprintf(tmp_str,"%d",db_tvct[i].crc); break;
							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;				
			case NO_TVCT_SUB:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< DB_TVCT_SUB_MAX ; i++)
				{
					if(db_tvct_sub[i].program_number == 0) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 15;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"short_name";
				CDebugSQLSubWin_attributes[1].type = 0;
				CDebugSQLSubWin_attributes[2].name = (char *)"long_name";
				CDebugSQLSubWin_attributes[2].type = 0;
				CDebugSQLSubWin_attributes[3].name = (char *)"major_channel_number";
				CDebugSQLSubWin_attributes[3].type = 1;				
				CDebugSQLSubWin_attributes[4].name = (char *)"minor_channel_number";
				CDebugSQLSubWin_attributes[4].type = 1;
				CDebugSQLSubWin_attributes[5].name = (char *)"modulation_mode";
				CDebugSQLSubWin_attributes[5].type = 1;
				CDebugSQLSubWin_attributes[6].name = (char *)"carrier_frequency";
				CDebugSQLSubWin_attributes[6].type = 1;
				CDebugSQLSubWin_attributes[7].name = (char *)"channel_TSID";
				CDebugSQLSubWin_attributes[7].type = 1;	
				CDebugSQLSubWin_attributes[8].name = (char *)"program_number";
				CDebugSQLSubWin_attributes[8].type = 1;
				CDebugSQLSubWin_attributes[9].name = (char *)"ETM_location";
				CDebugSQLSubWin_attributes[9].type = 1;
				CDebugSQLSubWin_attributes[10].name = (char *)"access_controlled";
				CDebugSQLSubWin_attributes[10].type = 1;
				CDebugSQLSubWin_attributes[11].name = (char *)"hidden";
				CDebugSQLSubWin_attributes[11].type = 1;	
				CDebugSQLSubWin_attributes[12].name = (char *)"show_guide";
				CDebugSQLSubWin_attributes[12].type = 1;
				CDebugSQLSubWin_attributes[13].name = (char *)"service_type";
				CDebugSQLSubWin_attributes[13].type = 1;
				CDebugSQLSubWin_attributes[14].name = (char *)"source_id";
				CDebugSQLSubWin_attributes[14].type = 1;

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",db_tvct_sub[i].rf);	break;
							case 1:	sprintf(tmp_str,"%s",db_tvct_sub[i].short_name);	break;
							case 2:	sprintf(tmp_str,"%s",db_tvct_sub[i].long_name); break;
							case 3:	sprintf(tmp_str,"%d",db_tvct_sub[i].major_channel_number); break;
							case 4:	sprintf(tmp_str,"%d",db_tvct_sub[i].minor_channel_number);	break;
							case 5:	sprintf(tmp_str,"%d",db_tvct_sub[i].modulation_mode);	break;
							case 6:	sprintf(tmp_str,"%d",db_tvct_sub[i].carrier_frequency); break;
							case 7:	sprintf(tmp_str,"%d",db_tvct_sub[i].channel_TSID); break;
							case 8:	sprintf(tmp_str,"%d",db_tvct_sub[i].program_number);	break;
							case 9:	sprintf(tmp_str,"%d",db_tvct_sub[i].ETM_location);	break;
							case 10: sprintf(tmp_str,"%d",db_tvct_sub[i].access_controlled); break;
							case 11: sprintf(tmp_str,"%d",db_tvct_sub[i].hidden); break;
							case 12: sprintf(tmp_str,"%d",db_tvct_sub[i].show_guide);	break;
							case 13: sprintf(tmp_str,"%d",db_tvct_sub[i].service_type);	break;
							case 14: sprintf(tmp_str,"%d",db_tvct_sub[i].source_id); break;

							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;
			case NO_CONFIG:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< DB_CONFIG_MAX ; i++)
				{
					if(db_config[i].name==0?true:(strlen(db_config[i].name) == 0)?true:false && db_config[i].value == 0 ) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 2;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"name";
				CDebugSQLSubWin_attributes[0].type = 0;
				CDebugSQLSubWin_attributes[1].name = (char *)"value";
				CDebugSQLSubWin_attributes[1].type = 1;

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%s",db_config[i].name);	break;
							case 1:	sprintf(tmp_str,"%d",db_config[i].value);	break;
							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;				
			case NO_CHANNEL_DB:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< DB_CHANNEL_DB_MAX ; i++)
				{
					if(db_channel_db[i].program_number == 0) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 9;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"name";
				CDebugSQLSubWin_attributes[1].type = 0;
				CDebugSQLSubWin_attributes[2].name = (char *)"major";
				CDebugSQLSubWin_attributes[2].type = 1;
				CDebugSQLSubWin_attributes[3].name = (char *)"minor";
				CDebugSQLSubWin_attributes[3].type = 1;				
				CDebugSQLSubWin_attributes[4].name = (char *)"program_number";
				CDebugSQLSubWin_attributes[4].type = 1;
				CDebugSQLSubWin_attributes[5].name = (char *)"source_id";
				CDebugSQLSubWin_attributes[5].type = 1;
				CDebugSQLSubWin_attributes[6].name = (char *)"pcr_pid";
				CDebugSQLSubWin_attributes[6].type = 1;
				CDebugSQLSubWin_attributes[7].name = (char *)"video_pid";
				CDebugSQLSubWin_attributes[7].type = 1;		
				CDebugSQLSubWin_attributes[8].name = (char *)"video_type";
				CDebugSQLSubWin_attributes[8].type = 1;	

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",db_channel_db[i].rf);	break;
							case 1:	sprintf(tmp_str,"%s",db_channel_db[i].name);	break;
							case 2:	sprintf(tmp_str,"%d",db_channel_db[i].major); break;
							case 3:	sprintf(tmp_str,"%d",db_channel_db[i].minor); break;
							case 4:	sprintf(tmp_str,"%d",db_channel_db[i].program_number);	break;
							case 5:	sprintf(tmp_str,"%d",db_channel_db[i].source_id);	break;
							case 6:	sprintf(tmp_str,"%d",db_channel_db[i].pcr_pid); break;
							case 7:	sprintf(tmp_str,"%d",db_channel_db[i].video_pid); break;
							case 8:	sprintf(tmp_str,"%d",db_channel_db[i].video_type); break;
							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;				
			case NO_CHANNEL_UPDN:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< DB_CHANNEL_UPDN_MAX ; i++)
				{
					if(db_channel_updn[i].program_number == 0) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 4;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"major";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"rf";
				CDebugSQLSubWin_attributes[1].type = 1;
				CDebugSQLSubWin_attributes[2].name = (char *)"minor";
				CDebugSQLSubWin_attributes[2].type = 1;
				CDebugSQLSubWin_attributes[3].name = (char *)"program_number";
				CDebugSQLSubWin_attributes[3].type = 1;				

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",db_channel_updn[i].major);	break;
							case 1:	sprintf(tmp_str,"%d",db_channel_updn[i].rf);	break;
							case 2:	sprintf(tmp_str,"%d",db_channel_updn[i].minor); break;
							case 3:	sprintf(tmp_str,"%d",db_channel_updn[i].program_number); break;
							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;		
			case NO_PMT_CC_TABLE:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< MAX_PMT_AC3_TABLE_COUNT ; i++)
				{
					if(pmt_cc_table[i].program_number == 0) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 8;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"program_number";
				CDebugSQLSubWin_attributes[1].type = 1;
				CDebugSQLSubWin_attributes[2].name = (char *)"language";
				CDebugSQLSubWin_attributes[2].type = 0;
				CDebugSQLSubWin_attributes[3].name = (char *)"cc_type";
				CDebugSQLSubWin_attributes[3].type = 1;				
				CDebugSQLSubWin_attributes[4].name = (char *)"cc_id";
				CDebugSQLSubWin_attributes[4].type = 1;
				CDebugSQLSubWin_attributes[5].name = (char *)"easy_reader";
				CDebugSQLSubWin_attributes[5].type = 1;
				CDebugSQLSubWin_attributes[6].name = (char *)"wide_aspect_ratio";
				CDebugSQLSubWin_attributes[6].type = 1;
				CDebugSQLSubWin_attributes[7].name = (char *)"korean_code";
				CDebugSQLSubWin_attributes[7].type = 1;	

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",pmt_cc_table[i].rf);	break;
							case 1:	sprintf(tmp_str,"%d",pmt_cc_table[i].program_number);	break;
							case 2:	sprintf(tmp_str,"%s",pmt_cc_table[i].language); break;
							case 3:	sprintf(tmp_str,"%d",pmt_cc_table[i].cc_type); break;							
							case 4:	sprintf(tmp_str,"%d",pmt_cc_table[i].cc_id);	break;
							case 5:	sprintf(tmp_str,"%d",pmt_cc_table[i].easy_reader);	break;
							case 6:	sprintf(tmp_str,"%d",pmt_cc_table[i].wide_aspect_ratio); break;
							case 7:	sprintf(tmp_str,"%d",pmt_cc_table[i].korean_code); break;

							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;		
			case NO_PMT_AC3_TABLE:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< MAX_PMT_AC3_TABLE_COUNT ; i++)
				{
					if(pmt_ac3_table[i].program_number == 0) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 7;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"program_number";
				CDebugSQLSubWin_attributes[1].type = 1;
				CDebugSQLSubWin_attributes[2].name = (char *)"pid";
				CDebugSQLSubWin_attributes[2].type = 1;
				CDebugSQLSubWin_attributes[3].name = (char *)"bsmod";
				CDebugSQLSubWin_attributes[3].type = 1;				
				CDebugSQLSubWin_attributes[4].name = (char *)"full_syc";
				CDebugSQLSubWin_attributes[4].type = 1;
				CDebugSQLSubWin_attributes[5].name = (char *)"langcod";
				CDebugSQLSubWin_attributes[5].type = 1;
				CDebugSQLSubWin_attributes[6].name = (char *)"language";
				CDebugSQLSubWin_attributes[6].type = 0;

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",pmt_ac3_table[i].rf);	break;
							case 1:	sprintf(tmp_str,"%d",pmt_ac3_table[i].program_number);	break;
							case 2:	sprintf(tmp_str,"%d",pmt_ac3_table[i].pid); break;
							case 3:	sprintf(tmp_str,"%d",pmt_ac3_table[i].bsmod); break;							
							case 4:	sprintf(tmp_str,"%d",pmt_ac3_table[i].full_svc);	break;
							case 5:	sprintf(tmp_str,"%d",pmt_ac3_table[i].langcod);	break;
							case 6:	sprintf(tmp_str,"%s",pmt_ac3_table[i].language);	break;

							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;		
			case NO_PMT_ISO_TABLE:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< MAX_PMT_ISO_TABLE_COUNT ; i++)
				{
					if(pmt_iso_table[i].program_number == 0) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 5;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"program_number";
				CDebugSQLSubWin_attributes[1].type = 1;
				CDebugSQLSubWin_attributes[2].name = (char *)"pid";
				CDebugSQLSubWin_attributes[2].type = 1;
				CDebugSQLSubWin_attributes[3].name = (char *)"lang";
				CDebugSQLSubWin_attributes[3].type = 0;				
				CDebugSQLSubWin_attributes[4].name = (char *)"type";
				CDebugSQLSubWin_attributes[4].type = 1;

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",pmt_iso_table[i].rf);	break;
							case 1:	sprintf(tmp_str,"%d",pmt_iso_table[i].program_number);	break;
							case 2:	sprintf(tmp_str,"%d",pmt_iso_table[i].pid); break;
							case 3:	sprintf(tmp_str,"%s",pmt_iso_table[i].lang); break;							
							case 4:	sprintf(tmp_str,"%d",pmt_iso_table[i].type);	break;

							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;		
			case NO_PMT_AUDIO_TABLE:
				CDebugSQLSubWin_RowItemNum = 0;
				for(i = 0; i< MAX_PMT_AUDIO_TABLE_COUNT ; i++)
				{
					if(pmt_audio_table[i].program_number == 0) continue;
					CDebugSQLSubWin_RowItemNum++;
				}
				CDebugSQLSubWin_ColItemNum = 5;
				CDebugSQLSubWin_results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), CDebugSQLSubWin_RowItemNum*CDebugSQLSubWin_ColItemNum);
				CDebugSQLSubWin_attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), CDebugSQLSubWin_ColItemNum);			

				CDebugSQLSubWin_attributes[0].name = (char *)"rf";
				CDebugSQLSubWin_attributes[0].type = 1;
				CDebugSQLSubWin_attributes[1].name = (char *)"program_number";
				CDebugSQLSubWin_attributes[1].type = 1;
				CDebugSQLSubWin_attributes[2].name = (char *)"pid";
				CDebugSQLSubWin_attributes[2].type = 1;
				CDebugSQLSubWin_attributes[3].name = (char *)"type";
				CDebugSQLSubWin_attributes[3].type = 1;				
				CDebugSQLSubWin_attributes[4].name = (char *)"component_tag";
				CDebugSQLSubWin_attributes[4].type = 1;

				i = 0;
				for( i=0;i<CDebugSQLSubWin_RowItemNum;i++)
				{
					for( j=0;j<CDebugSQLSubWin_ColItemNum;j++)
					{
					
						memset(tmp_str, 0 ,4096*sizeof(char));
						switch(j)
						{
							case 0:	sprintf(tmp_str,"%d",pmt_audio_table[i].rf);	break;
							case 1:	sprintf(tmp_str,"%d",pmt_audio_table[i].program_number);	break;
							case 2:	sprintf(tmp_str,"%d",pmt_audio_table[i].pid); break;
							case 3:	sprintf(tmp_str,"%d",pmt_audio_table[i].type); break;							
							case 4:	sprintf(tmp_str,"%d",pmt_audio_table[i].component_tag);	break;

							default: break;
								
						}
						if(tmp_str != 0)
						{
							CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name = (char*)DST_OS_Calloc((strlen(tmp_str)+1)*sizeof(char),1);
							memcpy(CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name,tmp_str,strlen(tmp_str));
//							DST_Printf("results[%d]=%s\n",i*CDebugSQLSubWin_ColItemNum+j,CDebugSQLSubWin_results[i*CDebugSQLSubWin_ColItemNum+j].name);						
						}
					}
				}
				break;				
			default: break;
		}
		DBLock(false);
		if(CDebugSQLSubWin_RowItemNum == 0) return;
		if(CDebugSQLSubWin_ColItemNum == 0) return;
		
//			DST_Printf("RowItemNum = %d, ColItemNum = %d\n",RowItemNum,ColItemNum);
		


	}

	void CDebugSQLSubWin_InitValues()
	{					
		CDebugSQLSubWin_results = 0;
		CDebugSQLSubWin_attributes = 0;

		CDebugSQLSubWin_RowPos = 0;
		CDebugSQLSubWin_RowTop = 0;
		CDebugSQLSubWin_RowSelect = 0;
		CDebugSQLSubWin_RowListNum = 10;
		CDebugSQLSubWin_RowItemNum = 0;
		
		CDebugSQLSubWin_ColPos = 0;
		CDebugSQLSubWin_ColTop = 0;
		CDebugSQLSubWin_ColSelect = 0;
		CDebugSQLSubWin_ColListNum = 5;
		CDebugSQLSubWin_ColItemNum = 0;

		CDebugSQLSubWin_pre_ColItemNum = CDebugSQLSubWin_ColItemNum;
		CDebugSQLSubWin_pre_ColListNum = CDebugSQLSubWin_ColListNum;
		CDebugSQLSubWin_pre_ColTop = CDebugSQLSubWin_ColTop;
		CDebugSQLSubWin_pre_ColSelect = CDebugSQLSubWin_ColSelect;
		CDebugSQLSubWin_pre_ColPos = CDebugSQLSubWin_ColPos;				

		CDebugSQLSubWin_pre_RowItemNum = CDebugSQLSubWin_RowItemNum;
		CDebugSQLSubWin_pre_RowListNum = CDebugSQLSubWin_RowListNum;
		CDebugSQLSubWin_pre_RowTop = CDebugSQLSubWin_RowTop;
		CDebugSQLSubWin_pre_RowSelect = CDebugSQLSubWin_RowSelect;
		CDebugSQLSubWin_pre_RowPos = CDebugSQLSubWin_RowPos;

		CDebugSQLSubWin_GetDBResult();

		if (CDebugSQLSubWin_RowItemNum < CDebugSQLSubWin_RowListNum) CDebugSQLSubWin_RowListNum = CDebugSQLSubWin_RowItemNum;
		if (CDebugSQLSubWin_ColItemNum < CDebugSQLSubWin_ColListNum) CDebugSQLSubWin_ColListNum = CDebugSQLSubWin_ColItemNum;
	}


//	virtual void Show(WinID id)
	void CDebugSQLSubWin_ShowWindow(CWindow *this, WinID id)
	{
//		DST_Printf("id=%d\n",id);
		switch(id)
		{
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_CHANNEL_BANNER:
			case WIN_ERROR:
				break;
			default:
				this->Close(this);
				break;
		}
	}

	void CDebugSQLSubWin_DrawVerScrollBar(CWindow *this, int x, int y, int h, int total_count, int page_count, int page_start)
	{
		if (total_count <= page_count) return;
		//  ׸
		int nTop = 1;
		int nBot = 1;
		int nMinHeight = nTop + nBot + 1; // ּ 
		int nHeight = (h * page_count) / total_count; // 
		if (nHeight < nMinHeight) nHeight = nMinHeight; 
		int nStart = (h * page_start) / total_count;
		if (nStart + nHeight > h) nStart = h - nHeight; // Ʒ ° 
		if (total_count == page_start + page_count) nStart = h - nHeight; // Ʒ ȼ  
		int nMid = nHeight - nTop - nBot;	
		this->DrawBox32(this, x,y+nStart,10,1,CONV32_16(0xFFFFFFFF));
		int yy = 0;
		for ( yy = 0; yy < nMid; yy++)
		{
			this->DrawBox32(this, x,y+yy+nStart+nTop,10,1,CONV32_16(0xFFFFFFFF));
		}
		this->DrawBox32(this, x,y+nStart+nTop+nMid,10,1,CONV32_16(0xFFFFFFFF));
	}

	void CDebugSQLSubWin_DrawHorScrollBar(CWindow *this, int x, int y, int w, int total_count, int page_count, int page_start)
	{
		if (total_count <= page_count) return;
		//  ׸
		int nLeft = 1;
		int nRight = 1;
		int nMinWidth = nLeft + nRight + 1; // ּ 
		int nWidth = (w * page_count) / total_count; // 
		if (nWidth < nMinWidth) nWidth = nMinWidth; 
		int nStart = (w * page_start) / total_count;
		if (nStart + nWidth > w) nStart = w - nWidth; // Ʒ ° 
		if (total_count == page_start + page_count) nStart = w - nWidth; // Ʒ ȼ  
		int nMid = nWidth - nLeft - nRight;	
		this->DrawBox32(this, x+nStart,y,1,6,CONV32_16(0xFFFFFFFF));
		int xx = 0;
		for ( xx = 0; xx < nMid; xx++)
		{
			this->DrawBox32(this, x+xx+nStart+nLeft,y,1,6,CONV32_16(0xFFFFFFFF));
		}
		this->DrawBox32(this, x+nStart+nLeft+nMid,y,1,6,CONV32_16(0xFFFFFFFF));
	}	

	void CDebugSQLSubWin_DrawDetail(CWindow *this)
	{
		int i = 0;
		this->setFontStyle(this, 15, 0xFF262626, ALIGN_MIDDLE,ALIGN_LEFT);
		if(CDebugSQLSubWin_results == 0) return;
		 //column attribute data type int ,  hex  ش
		if(CDebugSQLSubWin_attributes[CDebugSQLSubWin_ColPos+CDebugSQLSubWin_ColTop].type == 1)
		{
			int nLen1 = strlen(CDebugSQLSubWin_results[(CDebugSQLSubWin_RowPos+CDebugSQLSubWin_RowTop)*CDebugSQLSubWin_ColItemNum+(CDebugSQLSubWin_ColPos+CDebugSQLSubWin_ColTop)].name);
			int number = dst_atoi(CDebugSQLSubWin_results[(CDebugSQLSubWin_RowPos+CDebugSQLSubWin_RowTop)*CDebugSQLSubWin_ColItemNum+(CDebugSQLSubWin_ColPos+CDebugSQLSubWin_ColTop)].name);
			char tmpStr[100] = {0,};
			sprintf(tmpStr," (0x%08X)",number);
			int count = 0;
			for( i=0;i<100;i++)
			{
				if(tmpStr[i] == 0) break;
				count++;
			}
			int nLen = nLen1 + count + 1;
			char * finalStr = (char*)DST_OS_Calloc((nLen)*sizeof(char),1);

			memcpy(finalStr,CDebugSQLSubWin_results[(CDebugSQLSubWin_RowPos+CDebugSQLSubWin_RowTop)*CDebugSQLSubWin_ColItemNum+(CDebugSQLSubWin_ColPos+CDebugSQLSubWin_ColTop)].name,nLen1);
			memcpy(&finalStr[nLen1],tmpStr,count);
			this->DrawText(this, 2, 2, this->rect.w-4, 54-4,finalStr,&(this->font));
			DST_OS_Free(&finalStr);
		}
		else
		{
			this->DrawText32(this, 2, 2, this->rect.w-4, 54-4, DST_UTF82Uni((DS_U8*)CDebugSQLSubWin_results[(CDebugSQLSubWin_RowPos+CDebugSQLSubWin_RowTop)*CDebugSQLSubWin_ColItemNum+(CDebugSQLSubWin_ColPos+CDebugSQLSubWin_ColTop)].name),&(this->font));
		}
	}

	void CDebugSQLSubWin_DrawDetailPre(CWindow *this)
	{
		int i = 0;
		this->setFontStyle(this, 15, 0xFF262626, ALIGN_MIDDLE,ALIGN_LEFT);
		if(CDebugSQLSubWin_results == 0)
		{
			this->DrawBox32(this, 2, 2, this->rect.w-4, 54-4, CONV32_16(0xFFFFFFFF));
			return;
		}
		 //column attribute data type int ,  hex  ش
		if(CDebugSQLSubWin_attributes[CDebugSQLSubWin_pre_ColPos+CDebugSQLSubWin_pre_ColTop].type == 1)
		{
			int nLen1 = strlen(CDebugSQLSubWin_results[(CDebugSQLSubWin_pre_RowPos+CDebugSQLSubWin_pre_RowTop)*CDebugSQLSubWin_ColItemNum+(CDebugSQLSubWin_pre_ColPos+CDebugSQLSubWin_pre_ColTop)].name);
			int number = dst_atoi(CDebugSQLSubWin_results[(CDebugSQLSubWin_pre_RowPos+CDebugSQLSubWin_pre_RowTop)*CDebugSQLSubWin_ColItemNum+(CDebugSQLSubWin_pre_ColPos+CDebugSQLSubWin_pre_ColTop)].name);
			char tmpStr[100] = {0,};
			sprintf(tmpStr," (0x%08X)",number);
			int count = 0;
			for( i=0;i<100;i++)
			{
				if(tmpStr[i] == 0) break;
				count++;
			}
			int nLen = nLen1 + count + 1;
			char * finalStr = (char*)DST_OS_Calloc((nLen)*sizeof(char),1);

			memcpy(finalStr,CDebugSQLSubWin_results[(CDebugSQLSubWin_pre_RowPos+CDebugSQLSubWin_pre_RowTop)*CDebugSQLSubWin_ColItemNum+(CDebugSQLSubWin_pre_ColPos+CDebugSQLSubWin_pre_ColTop)].name,nLen1);
			memcpy(&finalStr[nLen1],tmpStr,count);
			this->DrawBox32(this, 2, 2, DST_GetTextWidth(finalStr, this->FontGetSize(this)), 54-4, CONV32_16(0xFFFFFFFF));
			DST_OS_Free(&finalStr);
		}
		else
		{
			this->DrawBox32(this, 2, 2, DST_GetTextWidth32(DST_UTF82Uni((DS_U8*)CDebugSQLSubWin_results[(CDebugSQLSubWin_pre_RowPos+CDebugSQLSubWin_pre_RowTop)*CDebugSQLSubWin_ColItemNum+(CDebugSQLSubWin_pre_ColPos+CDebugSQLSubWin_pre_ColTop)].name), strlen32(DST_UTF82Uni((DS_U8*)CDebugSQLSubWin_results[(CDebugSQLSubWin_pre_RowPos+CDebugSQLSubWin_pre_RowTop)*CDebugSQLSubWin_ColItemNum+(CDebugSQLSubWin_pre_ColPos+CDebugSQLSubWin_pre_ColTop)].name)), this->FontGetSize(this)), 54-4, CONV32_16(0xFFFFFFFF));
		}
	}	

	void CDebugSQLSubWin_DrawAll(CWindow *this)
	{
		int i = 0;
		int j = 0;
		this->setFontStyle(this, 15, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);

		this->DrawBox32(this, 0, 0, this->rect.w, this->rect.h, CONV32_16(0xAA262626));

		
		this->DrawBox32(this, 2, 2, this->rect.w-4, 54-4, CONV32_16(0xFFFFFFFF));
		for( i=0;i<CDebugSQLSubWin_ColListNum;i++)
			this->DrawText(this, 2+i*108, 84+2-28, 108-4, 28-4, CDebugSQLSubWin_attributes[i+CDebugSQLSubWin_ColTop].name,&(this->font));
		char count_str[5] = {0,0,0,0,0};
		sprintf(count_str,"%d",CDebugSQLSubWin_RowItemNum);
		this->DrawText(this, 5*108 - 2, 84+2-28, 34, 28-4, count_str,&(this->font));

		
		this->setFontStyle(this, 15, 0xFF363636, ALIGN_MIDDLE,ALIGN_CENTER);
		i = 0;
		j = 0;
		for( i=0;i<CDebugSQLSubWin_RowListNum;i++)
		{
			for( j=0;j<CDebugSQLSubWin_ColListNum;j++)
			{
				if(CDebugSQLSubWin_RowSelect == i+CDebugSQLSubWin_RowTop && CDebugSQLSubWin_ColSelect == j+CDebugSQLSubWin_ColTop)
					this->DrawBox32(this, 2+j*108, 84+2+i*28, 108-4, 28-4, CONV32_16(0xAA2C86FF));
				else
					this->DrawBox32(this, 2+j*108, 84+2+i*28, 108-4, 28-4, CONV32_16(0xAAFFA52C));
				this->DrawText32(this, 2+j*108, 84+2+i*28, 108-4, 28-4,DST_UTF82Uni((DS_U8*)CDebugSQLSubWin_results[(i+CDebugSQLSubWin_RowTop)*CDebugSQLSubWin_ColItemNum+(j+CDebugSQLSubWin_ColTop)].name),&(this->font));
			}
		}
		CDebugSQLSubWin_DrawDetail(this);
		
		CDebugSQLSubWin_DrawVerScrollBar(this, 550, 86, 28*CDebugSQLSubWin_RowListNum-4, CDebugSQLSubWin_RowItemNum, CDebugSQLSubWin_RowListNum, CDebugSQLSubWin_RowTop);
		CDebugSQLSubWin_DrawHorScrollBar(this, 2, 370, 108*CDebugSQLSubWin_ColListNum-4, CDebugSQLSubWin_ColItemNum, CDebugSQLSubWin_ColListNum, CDebugSQLSubWin_ColTop);
	}	
	
	void CDebugSQLSubWin_Draw(CWindow *this)
	{
		int i = 0;
		int j = 0;
		bool bDone = false;
		this->setFontStyle(this, 15, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);

		CDebugSQLSubWin_DrawDetailPre(this);
		CDebugSQLSubWin_DrawDetail(this);

		
		if(CDebugSQLSubWin_ColTop != CDebugSQLSubWin_pre_ColTop)
		{
			for( i=0;i<CDebugSQLSubWin_ColListNum;i++)
				this->DrawText(this, 2+i*108, 84+2-28, 108-4, 28-4,CDebugSQLSubWin_attributes[i+CDebugSQLSubWin_ColTop].name,&(this->font));
		}
		
		this->setFontStyle(this, 15, 0xFF363636, ALIGN_MIDDLE,ALIGN_CENTER);
		i = 0;
		j = 0;
		for( i=0;i<CDebugSQLSubWin_RowListNum;i++)
		{
			for( j=0;j<CDebugSQLSubWin_ColListNum;j++)
			{
				if(CDebugSQLSubWin_RowSelect == i+CDebugSQLSubWin_RowTop && CDebugSQLSubWin_ColSelect == j+CDebugSQLSubWin_ColTop)
				{
					this->DrawBox32(this, 2+j*108, 84+2+i*28, 108-4, 28-4, CONV32_16(0xAA2C86FF));
					this->DrawText32(this, 2+j*108, 84+2+i*28, 108-4, 28-4,DST_UTF82Uni((DS_U8*)CDebugSQLSubWin_results[(i+CDebugSQLSubWin_RowTop)*CDebugSQLSubWin_ColItemNum+(j+CDebugSQLSubWin_ColTop)].name),&(this->font));
					bDone = true;
					break;
				}
			}
			if(bDone) break;
		}

		bDone = false;
		i = 0;
		j = 0;
		for( i=0;i<CDebugSQLSubWin_RowListNum;i++)
		{
			for( j=0;j<CDebugSQLSubWin_ColListNum;j++)
			{
				if(CDebugSQLSubWin_pre_RowSelect == i+CDebugSQLSubWin_pre_RowTop && CDebugSQLSubWin_pre_ColSelect == j+CDebugSQLSubWin_pre_ColTop)
				{
					this->DrawBox32(this, 2+j*108, 84+2+i*28, 108-4, 28-4, CONV32_16(0xAAFFA52C));
					this->DrawText32(this, 2+j*108, 84+2+i*28, 108-4, 28-4,DST_UTF82Uni((DS_U8*)CDebugSQLSubWin_results[(i+CDebugSQLSubWin_pre_RowTop)*CDebugSQLSubWin_ColItemNum+(j+CDebugSQLSubWin_pre_ColTop)].name),&(this->font));
					bDone = true;
					break;
				}
			}
			if(bDone) break;
		}	
		if(CDebugSQLSubWin_RowTop != CDebugSQLSubWin_pre_RowTop) CDebugSQLSubWin_DrawVerScrollBar(this, 550, 86, 28*CDebugSQLSubWin_RowListNum-4, CDebugSQLSubWin_RowItemNum, CDebugSQLSubWin_RowListNum, CDebugSQLSubWin_RowTop);
		if(CDebugSQLSubWin_ColTop != CDebugSQLSubWin_pre_ColTop) CDebugSQLSubWin_DrawHorScrollBar(this, 2, 370, 108*CDebugSQLSubWin_ColListNum-4, CDebugSQLSubWin_ColItemNum, CDebugSQLSubWin_ColListNum, CDebugSQLSubWin_ColTop);
	}

//	virtual void Show()
	void CDebugSQLSubWin_Show(CWindow *this)
	{
		CDebugSQLSubWin_DrawAll(this);
	}	

//	virtual void OnTimer(char nID)
	void CDebugSQLSubWin_OnTimer(CWindow *this, char nID)
	{
		switch(nID)
		{
			case 1:
				this->KillTimer(this,1);
				CDebugSQLSubWin_InitValues();
				this->Show(this);
				break;
		}
	}	

//	virtual void OnMessage(SWinEventMsg event)
	void CDebugSQLSubWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_CT_MSG: // Ʃ  ޽  
				if (event.data32[0] == CT_TUNE_START) 
				{
					this->SetTimer(this, 1, 1000);
				}
				break;		
		}
	}

//	virtual void KeyInput(DS_U8 key,bool)
	void CDebugSQLSubWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch(key)
		{
			case VK_PREV_CH:
			case VK_PREV:
			case VK_PREV_MENU:
			case VK_CANCEL: 
				{
					CWindow * sqlWin = DST_GetWin(WIN_DEBUG_SQL);
					if(sqlWin)
						sqlWin->SetVisible(sqlWin, true);
					else
						DST_CreateWin(WIN_DEBUG_SQL, 0, 0, 0, 0, 0);
				}
				this->Close(this);
				break;
			case VK_OK:
				
				break;
			case VK_LEFT:
			case VK_RIGHT:
				if(key == VK_RIGHT)
				{
					if(CDebugSQLSubWin_pre_ColPos == CDebugSQLSubWin_ColListNum-1 && CDebugSQLSubWin_pre_ColTop+CDebugSQLSubWin_ColListNum < CDebugSQLSubWin_ColItemNum - (CDebugSQLSubWin_ColItemNum%CDebugSQLSubWin_ColListNum))
					{
						ItemIncrease(CDebugSQLSubWin_ColItemNum, CDebugSQLSubWin_ColListNum, &CDebugSQLSubWin_ColTop, &CDebugSQLSubWin_ColSelect, &CDebugSQLSubWin_ColPos,CDebugSQLSubWin_ColListNum);
						CDebugSQLSubWin_ColSelect = 1 + CDebugSQLSubWin_ColSelect - CDebugSQLSubWin_ColListNum;
						CDebugSQLSubWin_ColPos = 0;
					}
					else
					{
						ItemIncrease(CDebugSQLSubWin_ColItemNum, CDebugSQLSubWin_ColListNum, &CDebugSQLSubWin_ColTop, &CDebugSQLSubWin_ColSelect, &CDebugSQLSubWin_ColPos, 1);
					}
				}
				else
				{
					if(CDebugSQLSubWin_pre_ColPos == 0 && CDebugSQLSubWin_pre_ColTop > CDebugSQLSubWin_ColListNum)
					{
					
						ItemDecrease(CDebugSQLSubWin_ColItemNum, CDebugSQLSubWin_ColListNum, &CDebugSQLSubWin_ColTop, &CDebugSQLSubWin_ColSelect, &CDebugSQLSubWin_ColPos,CDebugSQLSubWin_ColListNum);
						CDebugSQLSubWin_ColSelect = CDebugSQLSubWin_ColSelect + CDebugSQLSubWin_ColListNum - 1;
						CDebugSQLSubWin_ColPos = CDebugSQLSubWin_ColListNum -1;
					}
					else
					{
						ItemDecrease(CDebugSQLSubWin_ColItemNum, CDebugSQLSubWin_ColListNum, &CDebugSQLSubWin_ColTop, &CDebugSQLSubWin_ColSelect, &CDebugSQLSubWin_ColPos, 1);
					}
				}
				
				if(CDebugSQLSubWin_ColTop != CDebugSQLSubWin_pre_ColTop) CDebugSQLSubWin_DrawAll(this);
				else CDebugSQLSubWin_Draw(this);
				
				CDebugSQLSubWin_pre_ColItemNum = CDebugSQLSubWin_ColItemNum;
				CDebugSQLSubWin_pre_ColListNum = CDebugSQLSubWin_ColListNum;
				CDebugSQLSubWin_pre_ColTop = CDebugSQLSubWin_ColTop;
				CDebugSQLSubWin_pre_ColSelect = CDebugSQLSubWin_ColSelect;
				CDebugSQLSubWin_pre_ColPos = CDebugSQLSubWin_ColPos;				
				break;
			case VK_UP:
			case VK_DN:
				if(key == VK_DN)
				{
					if(CDebugSQLSubWin_pre_RowPos == CDebugSQLSubWin_RowListNum-1 && CDebugSQLSubWin_pre_RowTop+CDebugSQLSubWin_RowListNum < CDebugSQLSubWin_RowItemNum - (CDebugSQLSubWin_RowItemNum%CDebugSQLSubWin_RowListNum))
					{
						ItemIncrease(CDebugSQLSubWin_RowItemNum, CDebugSQLSubWin_RowListNum, &CDebugSQLSubWin_RowTop, &CDebugSQLSubWin_RowSelect, &CDebugSQLSubWin_RowPos,CDebugSQLSubWin_RowListNum);
						CDebugSQLSubWin_RowSelect = 1 + CDebugSQLSubWin_RowSelect - CDebugSQLSubWin_RowListNum ;
						CDebugSQLSubWin_RowPos = 0;
					}
					else
					{
						ItemIncrease(CDebugSQLSubWin_RowItemNum, CDebugSQLSubWin_RowListNum, &CDebugSQLSubWin_RowTop, &CDebugSQLSubWin_RowSelect, &CDebugSQLSubWin_RowPos, 1);
					}
				}
				else
				{
					if(CDebugSQLSubWin_pre_RowPos == 0 && CDebugSQLSubWin_pre_RowTop > CDebugSQLSubWin_RowListNum)
					{
					
						ItemDecrease(CDebugSQLSubWin_RowItemNum, CDebugSQLSubWin_RowListNum, &CDebugSQLSubWin_RowTop, &CDebugSQLSubWin_RowSelect, &CDebugSQLSubWin_RowPos,CDebugSQLSubWin_RowListNum);
						CDebugSQLSubWin_RowSelect = CDebugSQLSubWin_RowSelect + CDebugSQLSubWin_RowListNum - 1;
						CDebugSQLSubWin_RowPos = CDebugSQLSubWin_RowListNum -1;
					}
					else
					{
						ItemDecrease(CDebugSQLSubWin_RowItemNum, CDebugSQLSubWin_RowListNum, &CDebugSQLSubWin_RowTop, &CDebugSQLSubWin_RowSelect, &CDebugSQLSubWin_RowPos, 1);
					}
				}

				if(CDebugSQLSubWin_RowTop != CDebugSQLSubWin_pre_RowTop) CDebugSQLSubWin_DrawAll(this);
				else CDebugSQLSubWin_Draw(this);
			
			
				CDebugSQLSubWin_pre_RowItemNum = CDebugSQLSubWin_RowItemNum;
				CDebugSQLSubWin_pre_RowListNum = CDebugSQLSubWin_RowListNum;
				CDebugSQLSubWin_pre_RowTop = CDebugSQLSubWin_RowTop;
				CDebugSQLSubWin_pre_RowSelect = CDebugSQLSubWin_RowSelect;
				CDebugSQLSubWin_pre_RowPos = CDebugSQLSubWin_RowPos;				
				break;

		}
	}
//};


void DST_CreateDebugSQLSubWin(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor	= CDebugSQLSubWin_Destructor;
	pWin->KeyInput		= CDebugSQLSubWin_KeyInput;
	pWin->OnMessage		= CDebugSQLSubWin_OnMessage;
	pWin->OnTimer		= CDebugSQLSubWin_OnTimer;
	pWin->ShowWindow	= CDebugSQLSubWin_ShowWindow;
	pWin->Show			= CDebugSQLSubWin_Show;
	//  ȣ
	CDebugSQLSubWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}

