#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"

#if 0
____CMovingBannerWin___()
#endif


//class CErrorWin : public CWindow
//{
//private:
	static DS_U8 CErrorWin_nErrorNumber;
	static DS_U8 CErrorWin_nParameter;
	static int CErrorWin_nWidth;
//public:
void CErrorWin_GetPos(CWindow *this);

// 	CErrorWin(SWinEventMsg event):CWindow(event)
	void CErrorWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "Error");
		CErrorWin_nErrorNumber 	= event.data[2];
		CErrorWin_nParameter 	= event.data[3];
		CErrorWin_nWidth = 0;
		switch(CErrorWin_nErrorNumber)
		{
			case SM_AUDIO_ONLY:
				this->rect.w = DST_GetImageWidth(imgaudio);
				this->rect.h = DST_GetImageHeight(imgaudio);
				this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
				this->rect.y = (DST_GetScreenHeight() - this->rect.h) / 2;
				DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL ,0, 0, 0);
				break;

			case SM_NO_PROGRAM:
				{
					CErrorWin_nWidth = DST_GetTextWidthUni(pz_NoProgram[OSD_Lang],30); 
					this->rect.w = 9+DST_GetImageWidth(bracon_gui_caution)+10+CErrorWin_nWidth+10;
					this->rect.h = 92;
					CErrorWin_GetPos(this);
				}
				break;
			case SM_WEAK_SIGNAL:
				this->rect.w = DST_GetImageWidth(pin_change_back);
				this->rect.h = DST_GetImageHeight(pin_change_back);
				this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
				this->rect.y = (DST_GetScreenHeight() - this->rect.h) / 2;
				break;
				
			default: break;
		}

		this->SetTimeOut(this, 0);
	}

	void CErrorWin_Destructor(CWindow *this)
	{
	}
	
	void CErrorWin_GetPos(CWindow *this)
	{
		static DS_U8 nPos = 0;
		int x = 0, y = 0;
		int sw = DST_GetScreenWidth();
		int sh = DST_GetScreenHeight();
		int iw = this->rect.w;
		int ih = this->rect.h;
		int min_x = 0;
		int min_y = 0;
		int max_x = 0;
		int max_y = 0;
		switch (nPos)
		{
			case 0: x = sw*2/4; y = sh*2/4; break;
			case 1: x = sw*1/4; y = sh*1/4; break;
			case 2: x = sw*3/4; y = sh*1/4; break;
			case 3: x = sw*1/4; y = sh*3/4; break;
			case 4: x = sw*3/4; y = sh*3/4; break;
		}
		x-=(iw / 2);
		y-=(ih / 2);
		min_x = sw/10;
		min_y = sh/10;
		max_x = (sw*9/10) - iw;
		max_y = (sh*9/10) - ih;
		if (x < min_x) x = min_x;
		if (y < min_y) y = min_y;
		if (x > max_x) x = max_x;
		if (y > max_y) y = max_y;
		nPos = (nPos >= 4) ? 0 : nPos + 1;
		this->rect.x=x; this->rect.y=y;
	}


//	virtual void Show()
	void CErrorWin_Show(CWindow *this)
	{
	
		this->setFontStyle(this, 25,0xFF000000,ALIGN_MIDDLE,ALIGN_CENTER);
		// 
		switch (CErrorWin_nErrorNumber)
		{
			case SM_AUDIO_ONLY:
				this->DrawImage(this, 0, 0, imgaudio, false);
				break;
			case SM_NO_PROGRAM:
				this->DrawBox32(this, 0, 0, this->rect.w, this->rect.h, CONV32_16(0x00FFFFFF));
				this->DrawImage(this, 9, 9, bracon_gui_caution,true);
				this->DrawTextUni(this, 11+DST_GetImageWidth(bracon_gui_caution)+10, 2, CErrorWin_nWidth, this->rect.h-2, pz_NoProgram[OSD_Lang], &(this->font));
				this->setFontStyle(this, 25,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
				this->DrawTextUni(this, 9+DST_GetImageWidth(bracon_gui_caution)+10, 0, CErrorWin_nWidth, this->rect.h-2, pz_NoProgram[OSD_Lang], &(this->font));
				this->SetTimer(this, 1, 1000);				
				break;
			case SM_WEAK_SIGNAL:
				this->DrawImage(this, 0, 0, pin_change_back, false);
				this->setFontStyle(this, 21, 0xFFC8C8C8, ALIGN_MIDDLE, ALIGN_CENTER);
				this->RegisterKey(this, VK_OK, true, 0, 0);
				int	center_pos =  this->rect.h / 2; 
				int	line_spacing = DST_GetFontHeight(this->FontGetSize(this)) * 150 / 100;
				
				this->DrawTextUni(this, 0, center_pos-2*line_spacing, this->rect.w, line_spacing, pz_WeakSignal1[OSD_Lang], &(this->font)); 
				this->DrawTextUni(this, 0, center_pos-line_spacing, this->rect.w, line_spacing, pz_WeakSignal2[OSD_Lang], &(this->font)); 
				this->DrawTextUni(this, 0, center_pos, this->rect.w, line_spacing, pz_WeakSignal3[OSD_Lang], &(this->font)); 
				this->DrawTextUni(this, 0, center_pos+line_spacing, this->rect.w, line_spacing, pz_WeakSignal4[OSD_Lang], &(this->font)); 				
				break;
			default: break;

		}
		
		
		
	}

//	virtual void OnMessage(SWinEventMsg event)
	void CErrorWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				this->Close(this);
				break;
			default: break;
		}
	}

//	virtual void OnTimer(char /*nID*/)
	void CErrorWin_OnTimer(CWindow *this, char nID)
	{
		this->UpdateScreen(this);
		CErrorWin_GetPos(this);
		this->UpdateScreen(this);
	}	

//	virtual void Show(WinID id)
	void CErrorWin_ShowWindow(CWindow *this, WinID id)
	{
		if(CErrorWin_nErrorNumber == SM_AUDIO_ONLY) return;
		switch(id)
		{
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_ENGINEER_MODE:
			case WIN_FREQUENCY_SETTING:		
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
//			case WIN_VOLUME:
//			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
//			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
			case WIN_STATION_SEARCH:
			case WIN_PASSWD_CHANGE:
				if (CErrorWin_nErrorNumber == SM_WEAK_SIGNAL && id == WIN_CHANNEL_BANNER)
				{
					break;
				}
				else
				{
					this->Close(this);
					break;
				}
			case WIN_PASSWD_CHECK:
			case WIN_PASSWD_CONFIRM:
				this->SetVisible(this, false);
				break;
			default:
				break;
		}
	}

	void CErrorWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_OK:
				DST_CreateWin(WIN_AUTO_SEARCH, WIN_NULL, 1, 0, 0, 0); 
				this->Close(this);
				if(DST_UI_GetMute() && DST_GetWin(WIN_VOLUME_MUTE)==0) DST_CreateWin(WIN_VOLUME_MUTE, 0, 0, 0, 0, 0);
				break;

			default:
				break;

		}
	}

//};

void DST_CreateErrorWin(SWinEventMsg event)
{
	static DS_U8 nState = 0;
//	DST_Printf("DST_GetWin(WIN_ERROR)=%d nState=%d  event.data[2]=%d\n",DST_GetWin(WIN_ERROR),nState, event.data[2]);
	if (DST_GetWin(WIN_ERROR) != 0  && nState == event.data[2]) return; // ̹ ó̶ 
	
	if (DST_GetWin(WIN_EWS)) return;
	if (DST_GetWin(WIN_CHANNEL_BANNER)) 
	{
		if (event.data[2] != SM_AUDIO_ONLY)
		{
			if(nState != SM_AUDIO_ONLY) return;
			else 
			{
				if(event.data[2] == SM_WEAK_SIGNAL)
					DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL ,3, 0, 0);
				else
					DST_CloseWin(WIN_CHANNEL_BANNER);
			}
		}
	}

	if (DST_GetWin(WIN_DIRECT_TUNE)) return;
//	if (DST_GetWin(WIN_VOLUME)) return;
//	if (DST_GetWin(WIN_VOLUME_MUTE)) return;
	if (DST_GetWin(WIN_SIGNAL_METER)) return;
//	if (DST_GetWin(WIN_CLOSED_CAPTION_HOT)) return;
	if (DST_GetWin(WIN_AUDIO_HOT)) return;
	if (DST_GetWin(WIN_DISPLAY_MODE_HOT)) return;
	if (DST_GetWin(WIN_FACTORY_RESET)) return;
	if (DST_GetWin(WIN_FACTORY_RESET_ASK)) return;
//	if (DST_GetWin(WIN_INFOR_BANNER)) return;
	if (DST_GetWin(WIN_MAIN_MENU)) return;
	if (DST_GetWin(WIN_POWER_DOWN_CAUTION)) return;
	if (DST_GetWin(WIN_SUB_MENU_2DEPTH)) return;
	if (DST_GetWin(WIN_SUB_MENU_3DEPTH)) return;
	if (DST_GetWin(WIN_AUTO_SEARCH)) return;
	if (DST_GetWin(WIN_MANUAL_SEARCH)) return;
	if (DST_GetWin(WIN_CHANNEL_LIST)) return;
	if (DST_GetWin(WIN_PROGRAM_GUIDE)) return;
	if (DST_GetWin(WIN_PASSWD_CHANGE)) return;
	if (DST_GetWin(WIN_PASSWD_CHECK)) return;
	if (DST_GetWin(WIN_PASSWD_CONFIRM)) return;
	if (DST_GetWin(WIN_AGE_RATING)) return;
//	T();
	nState = event.data[2];

	CWindow*pWin = NewCWindow(event);
	pWin->Destructor	= CErrorWin_Destructor;
	pWin->OnMessage 	= CErrorWin_OnMessage;
	pWin->OnTimer		= CErrorWin_OnTimer;
	pWin->ShowWindow	= CErrorWin_ShowWindow;
	pWin->Show			= CErrorWin_Show;
	pWin->KeyInput		= CErrorWin_KeyInput;
	//  ȣ
	CErrorWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}

