#include "DST_WinManager.h"
#include "DST_CommonAPI.h"
#include "DST_ChannelTune.h"
#include "DST_DB_Engine.h"
#include "DST_DB.h"

static bool bCCEngineReady = false;

static bool bAutoDetectUnicode = false; // CC ͸ мϿ ڵ ϼ ڵ ˾Ƴ.

void DST_708_Callback(DS_U8 *bytearray,int size)
{
	if (size == 0) return;
	if (bCCEngineReady == false) return;
	// Sequence Header ùٸ Ȯغ.
	if (size < 0) // Sequence Header   
	{
		DST_Printf("Sequence Header Error\n");
		DST_SendWindowEventWithOnlyCmd(WM_SEQ_ERROR);
		return;
	}
	if (size > 31) return;
	int nCharTotal = 0;
	int i;
	for ( i=0; i < size; i++) if (bytearray[i] == 0x18) nCharTotal++;
	if (nCharTotal > 0) DST_g_CC_DataReceiveTick = DST_OS_GetTickCount();
	if (DST_EEPROM_GetCC() == 0) return; //  CC   Ʈ ϰ CC  
	SWinEventMsg msg;
	msg.cmd = WM_CS1;
	msg.data[0] = size;
	memcpy(&msg.data[1], bytearray, size);
	DST_SendWindowEvent(msg);
}

typedef void (*CC708_CallBack)(DS_U8 *bytearray,int size);
/*extern "C" */void SetCC708_CallBack(CC708_CallBack callback);


static bool DST_CCAvailable()
{
	if (DST_g_PowerOn == false) return false;
	if (DST_g_SignalState != SM_GOOD_SIGNAL) return false; // ȣ °  쿡 CC ֵ 
//	if (DST_g_SleepState != 0) return false; // normal ° ƴϸ CC ݴ´
	if (DST_EEPROM_GetCC() == 0) return false;
	if (DST_g_LastTuneTime == 0) return false;
	if (DST_IsVideoPlay() == false) return false;
	if (DST_g_LastTuneTryTime > DST_OS_GetTickCount()) DST_g_LastTuneTryTime = DST_OS_GetTickCount();
	if (DST_OS_GetTickCount() - DST_g_LastTuneTryTime < DST_OS_GetTicksPerSecond() * 3) return false;
	int id;
	for ( id = (int)WIN_NULL+1; id < (int)WIN_CAPTION; id++)
	{
		if (id == WIN_VOLUME) continue;
		if (id == WIN_VOLUME_MUTE) continue;
		if (DST_GetWin((WinID)id)) return false;
	}
	return true;
}
 
static void tCCManager()
{
	DST_OS_Delay(3000); // 3  
	bCCEngineReady = true;
	DST_CreateWin(WIN_CAPTION, WIN_NULL, 1, 0, 0, 0); 
	while (1)
	{
//		T();
		DST_OS_Delay(100);
		CWindow *pWin = DST_GetWin(WIN_CAPTION);
		if (DST_CCAvailable())
		{
			if (pWin) continue;
			DST_CreateWin(WIN_CAPTION, WIN_NULL, 1, 0,0,0);
			int i;
			for ( i = 0; i < 5; i++)
			{
				DST_OS_Delay(100);//  찡 ɶ  
				if (DST_GetWin(WIN_CAPTION)) break;
			}
		}
		else
		{
			if (pWin == 0) continue;
			DST_SendWindowEventWithOnlyCmd(WM_CC_CLOSE);
			int i;
			for ( i = 0; i < 5; i++)
			{
				DST_OS_Delay(100);//  찡 ɶ  
				if (DST_GetWin(WIN_CAPTION)==0) break;
			}
		}
	}
}

void DST_CCManagerInit()
{
	static int TaskID = 0;
	if (TaskID != 0) return;
	TaskID = DST_OS_SpawnTask((void(*)(void *))tCCManager, (char*)"CCManager", APP_TASK_PRIO_CC_MGR, WIN_MGR_TASK_STACKSIZE,  0);
}

void DST_CheckCCDescription(DS_U8 nServiceNumber, bool *bKorean, bool *bWideScreen, bool *bUnicode)
{
	*bKorean = DST_g_CC_bCCKorean;
	*bWideScreen = DST_g_CC_bWideScreen;
	*bUnicode = DST_g_CC_bUnicode; // CC ũ 
//	*bUnicode = bAutoDetectUnicode;  // ڵ 
}
