#ifndef __DST_FONT_ENGINE_H__
#define __DST_FONT_ENGINE_H__

#include "DST_Common.h"

// CC Ʈ  Լ

typedef struct 
{
	DS_U16 nCode;
	DS_U8 nSize;
	DS_U8 nStyle;
	DS_U8 nOffset; //  ʿ 0 normal  1 subscript 2 superscript
	bool bItalic;
	bool bUnderLine;
	DS_U8 nEdgeType;
	OSD_PIXEL_T Color;
	OSD_PIXEL_T EdgeColor;
	OSD_PIXEL_T BackColor;
} FONT_CC;

// ARGB    ȯ
OSD_PIXEL_T DST_SetColor(OSD_PIXEL_T a, OSD_PIXEL_T r, OSD_PIXEL_T g, OSD_PIXEL_T b);
//  ARGB 
void DST_GetColor(OSD_PIXEL_T color, OSD_PIXEL_T *a, OSD_PIXEL_T *r, OSD_PIXEL_T *g, OSD_PIXEL_T *b);
// Ʈ ̸ ȯѴ.
int DST_GetFontHeight(int nSize);

// ԵǴ ڿ  ū  ° Ʈ ̸ ȯѴ.
int DST_GetFontHeightCC(FONT_CC data[], int nCount);

// Ʈ ̸ Ѵ.
int DST_GetFontWidthCC(FONT_CC data[], int nCount);

// Ʈ ̹ Ѵ.
void DST_GetFontImageCC(FONT_CC data[], int nCount, OSD_PIXEL_T *buff);

// OSD  Ʈ  Լ

// ؽƮ ̸ Ѵ.
int DST_GetTextHeight(DS_U8 nSize);

//  ۿ Ʈ Ѵ.
bool DST_PrintText(
	OSD_PIXEL_T *buffDes, int buffer_width, int buffer_height,
	int x_pos, int y_pos, DS_U32 * strText, int nStrLen, DS_U8 nSize, OSD_PIXEL_T Color);

// ڵ ؽƮ  Ѵ.
int DST_GetTextWidthUniwithLen(DS_U16* strText, DS_U16 nStrLen, DS_U8 nSize);
int DST_GetTextWidthUni(DS_U16* strText, DS_U8 nSize);
int DST_GetTextWidth32(DS_U32* strText, DS_U16 nStrLen, DS_U8 nSize);

// ڵ ڿ   κ ؽƮ  Ѵ.
int DST_GetTextWidthExtUni(int start, int width, DS_U16* strText, DS_U16 nStrLen, DS_U8 nSize);

// ׷ ؽƮ  Ѵ. ѱ ޴ ȣҼ ִ.
int DST_GetTextWidth(char* strText, DS_U8 nSize);

// ARIB ڵ带 Unicode ȯ
DS_U32* DST_UTF82Uni(DS_U8 *utf);

#endif
