#ifndef __DST_MEMORY_DB_H__
#define __DST_MEMORY_DB_H__

#include "DST_CommonAPI.h"
#include "DST_Types.h"


typedef enum
{
	NO_PAT,
	NO_PMT,
#if EPG_SUPPORT
	NO_EIT,
	NO_EIT_SUB,
	NO_ETT,
#endif
#if CHANNEL_EDIT_SUPPORT
	NO_SKIP_LIST,
#endif
#if CVCT_SUPPORT
	NO_CVCT,
	NO_CVCT_SUB,
#endif
	NO_TVCT,
	NO_TVCT_SUB,
	NO_CONFIG,
	NO_CHANNEL_DB,
	NO_CHANNEL_UPDN,
	NO_PMT_CC_TABLE,
	NO_PMT_AC3_TABLE,
	NO_PMT_ISO_TABLE,
	NO_PMT_AUDIO_TABLE,
	NO_DB_MAX
}	DB_NO_LIST;

typedef struct 
{
	DB_NO_LIST list;
	char *name;
}DB_LIST;


extern DB_LIST db_list[NO_DB_MAX+1];

////////////////////////////////	 PAT		///////////////////////////////
#define DB_PAT_MAX RF_COUNT // RF 

typedef struct DB_PAT
{
	int rf;
	int program_number;
	int pid;
	DS_U32 crc;
} _DB_PAT_;

extern struct DB_PAT db_pat[DB_PAT_MAX];
///////////////////////////////////////////////////////////////////////////


////////////////////////////////	 PMT		 ///////////////////////////////
#define DB_PMT_MAX MAX_CHANNEL_NUMBER // ü ä 

typedef struct DB_PMT
{
	int rf;
	int program_number;
	int pcr_pid;
	int ca_pid;
	int video_pid;
	int video_type;
	int minor;
	DS_U32 crc;
}_DB_PMT_;

extern struct DB_PMT db_pmt[DB_PMT_MAX];
////////////////////////////////////////////////////////////////////////////

#if EPG_SUPPORT
////////////////////////////////	 EIT		 ///////////////////////////////
#define DB_EIT_MAX MAX_CHANNEL_NUMBER // ü ä 

typedef struct DB_EIT
{
	int rf;
	int id;
	int source_id;
	int version_number;
	DS_U32 crc;
}_DB_EIT_;

extern struct DB_EIT db_eit[DB_EIT_MAX];
////////////////////////////////////////////////////////////////////////////


//////////////////////////////	 EIT_SUB		 ////////////////////////////////
#define DB_EIT_SUB_MAX MAX_CHANNEL_NUMBER // ü ä  * 10

typedef struct DB_EIT_SUB
{
	int rf;
	int id;
	int source_id; // not zero
	int event_id;
	int start_time;
	int length_in_seconds;
	char* title;
	// there's no crc?
}_DB_EIT_SUB_;
	
extern struct DB_EIT_SUB db_eit_sub[DB_EIT_SUB_MAX];
////////////////////////////////////////////////////////////////////////////


////////////////////////////////	 ETT		 ///////////////////////////////
#define DB_ETT_MAX MAX_CHANNEL_NUMBER // ü ä  * 10

typedef struct DB_ETT
{
	int rf;
	int source_id;
	int event_id;
	char* title;
	DS_U32 crc;
}_DB_ETT_;
	
extern struct DB_ETT db_ett[DB_ETT_MAX];
////////////////////////////////////////////////////////////////////////////
#endif // EPG_SUPPORT

#if CHANNEL_EDIT_SUPPORT
//////////////////////////	 SKIP_LIST		 ///////////////////////////////
#define DB_SKIP_LIST_MAX MAX_CHANNEL_NUMBER // ü ä  

typedef struct DB_SKIP_LIST
{
	int rf;
	int program_number;
}_DB_SKIP_LIST_;
	
extern struct DB_SKIP_LIST db_skip_list[DB_SKIP_LIST_MAX];
////////////////////////////////////////////////////////////////////////////
#endif

#if CVCT_SUPPORT
//////////////////////////////	 CVCT		 ///////////////////////////////
#define DB_CVCT_MAX RF_COUNT // ü ä  

typedef struct DB_CVCT
{
	int rf;
	int transport_stream_id;
	int version_number;
	DS_U32 crc;
} _DB_CVCT_;
	
extern struct DB_CVCT db_cvct[DB_CVCT_MAX];
/////////////////////////////////////////////////////////////////////////////


//////////////////////////////	 CVCT_SUB		 /////////////////////////////
#define DB_CVCT_SUB_MAX MAX_CHANNEL_NUMBER // ü ä  

typedef struct DB_CVCT_SUB
{
	int rf;
	char short_name[TEXT_LENGTH_MAX/2];
	char long_name[TEXT_LENGTH_MAX];
	int major_channel_number;
	int minor_channel_number;
	int modulation_mode;
	int carrier_frequency;
	int channel_TSID;
	int program_number;
	int ETM_location;
	int access_controlled;
	int hidden;
	int show_guide;
	int service_type;
	int source_id;
	//no crc?
} _DB_CVCT_SUB_;
	
extern struct DB_CVCT_SUB db_cvct_sub[DB_CVCT_SUB_MAX];
///////////////////////////////////////////////////////////////////////////
#endif

//////////////////////////////	 TVTC		 ///////////////////////////////
#define DB_TVCT_MAX RF_COUNT // ü ä  

typedef struct DB_TVCT
{
	int rf;
	int transport_stream_id;
	int version_number;
	DS_U32 crc;
} _DB_TVCT_;
	
extern struct DB_TVCT db_tvct[DB_TVCT_MAX];
/////////////////////////////////////////////////////////////////////////////


//////////////////////////////	 TVTC_SUB		 /////////////////////////////
#define DB_TVCT_SUB_MAX MAX_CHANNEL_NUMBER // ü ä  

typedef struct DB_TVCT_SUB
{
	int rf;
	char short_name[TEXT_LENGTH_MAX/2];
	char long_name[TEXT_LENGTH_MAX];
	int major_channel_number;
	int minor_channel_number;
	int modulation_mode;
	int carrier_frequency;
	int channel_TSID;
	int program_number; // if valid data exist, this value is not zero.
	int ETM_location;
	int access_controlled;
	int hidden;
	int show_guide;
	int service_type;
	int source_id;
	//no crc?
} _DB_TVCT_SUB_;
	
extern struct DB_TVCT_SUB db_tvct_sub[DB_TVCT_SUB_MAX];
///////////////////////////////////////////////////////////////////////////////


////////////////////////////////	 CONFIG		 ///////////////////////////////
#define DB_CONFIG_MAX 15 

typedef struct DB_CONFIG
{
	char name[50];
	int value;
} _DB_CONFIG_;
	
extern struct DB_CONFIG db_config[DB_CONFIG_MAX];
////////////////////////////////////////////////////////////////////////////////

///////////////////////////////	 CHANNEL_DB		 ///////////////////////////////
#define DB_CHANNEL_DB_MAX MAX_CHANNEL_NUMBER // ü ä  

typedef struct DB_CHANNEL_DB
{
	int rf;
	char name[TEXT_LENGTH_MAX];
	int major;
	int minor;
	int program_number;
	int source_id;
	int pcr_pid;
	int video_pid;
	int video_type;
} _DB_CHANNEL_DB_;
	
extern struct DB_CHANNEL_DB db_channel_db[DB_CHANNEL_DB_MAX];
////////////////////////////////////////////////////////////////////////////////

///////////////////////////////	 CHANNEL_UPDN		 /////////////////////////////
#define DB_CHANNEL_UPDN_MAX MAX_CHANNEL_NUMBER // ü ä  

typedef struct DB_CHANNEL_UPDN
{
	int major;
	int rf;
	int minor;
	int program_number;
} _DB_CHANNEL_UPDN_;
	
extern struct DB_CHANNEL_UPDN db_channel_updn[DB_CHANNEL_UPDN_MAX];
////////////////////////////////////////////////////////////////////////////////

///////////////////////////////	 PMT_CC_TABLE		 /////////////////////////////
#define MAX_PMT_CC_TABLE_COUNT 500
typedef struct PMT_CC_TABLE
{
	int rf;
	int program_number;
	char language[4];
	int cc_type;
	int cc_id;
	int easy_reader;
	int wide_aspect_ratio;
	int korean_code;
} _PMT_CC_TABLE_;
extern struct PMT_CC_TABLE pmt_cc_table[MAX_PMT_CC_TABLE_COUNT];
////////////////////////////////////////////////////////////////////////////////

///////////////////////////////	 PMT_AC3_TABLE		 /////////////////////////////
#define MAX_PMT_AC3_TABLE_COUNT 500
typedef struct PMT_AC3_TABLE
{
	int rf;
	int program_number;
	int pid;
	int bsmod;
	int full_svc;
	int langcod;
	char language[4];
} _PMT_AC3_TABLE_;
extern struct PMT_AC3_TABLE pmt_ac3_table[MAX_PMT_AC3_TABLE_COUNT];
////////////////////////////////////////////////////////////////////////////////

///////////////////////////////	 PMT_ISO_TABLE		 /////////////////////////////
#define MAX_PMT_ISO_TABLE_COUNT 500
typedef struct PMT_ISO_TABLE
{
	int rf;
	int program_number;
	int pid;
	char lang[4];
	int type;
} _PMT_ISO_TABLE_;
extern struct PMT_ISO_TABLE pmt_iso_table[MAX_PMT_ISO_TABLE_COUNT];
////////////////////////////////////////////////////////////////////////////////

///////////////////////////////	 PMT_AUDIO_TABLE		 /////////////////////////////
#define MAX_PMT_AUDIO_TABLE_COUNT 500
typedef struct PMT_AUDIO_TABLE
{
	int rf;
	int program_number;
	int pid;
	int type;
	int component_tag;
} _PMT_AUDIO_TABLE_;
extern struct PMT_AUDIO_TABLE pmt_audio_table[MAX_PMT_AUDIO_TABLE_COUNT];

////////////////////////////////////////////////////////////////////////////////

void DBLock(bool bLock);

#endif //__DST_MEMORY_DB_H__
