#include "DST_UserInterface.h"
#include "DST_ChannelTune.h"
#include "DST_HostInterface.h"
#include "DST_WinManagerTask.h"
#include "DST_CommonAPI.h"
#include "DST_DataStrings.h"
#include "DST_FontEngine.h"
#include "DST_WinManager.h"
#include "DST_DB.h"

void DST_Tune(DS_U8 RF, DS_U16 program_number);
void DST_Scan(DS_U8 RF);
void CT_AudioVolume(DS_U8 nVal);

#if 0
____Channel_UI___()
#endif

// ä ٿ Լ
void DST_UI_ChannelUpDn(bool bUp)
{
	DST_DB_ChannelUpDn(bUp);
}

// ä Ʃ Ѵ.
void DST_UI_ChannelTune(DS_U8 RF, DS_U16 program_number)
{
	T();
	DST_Printf("RF = %d program_number=%d\n", RF, program_number);
	if(RF != DST_EEPROM_GetRF() || program_number != DST_EEPROM_GetProgramNumber())
	{
		DST_g_PrevRF = DST_EEPROM_GetRF();
		DST_g_PrevProgramNumber = DST_EEPROM_GetProgramNumber();
	}
	
	DST_EEPROM_SetRF(RF);
	DST_EEPROM_SetProgramNumber(program_number);
	DST_g_LastTuneTryTime = DST_OS_GetTickCount();
	DST_g_SignalState = SM_WAIT_SIGNAL;
	DST_Tune(RF, program_number);
//	DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL, 3, 0, 0);
}

#if 0
____Settings_UI___()
#endif

void DST_UI_InitMenuCursor()
{
	 // ޴ Ŀ ʱȭ
	MenuTop[0] = 0;
	MenuTop[1] = 0;
	MenuPos[0] = 0;
	MenuPos[1] = 0;
	MenuSelect[0] = 0;
	MenuSelect[1] = 0;
}

// MTS Setting (0) ѱ (1) ܱ
DS_U8 DST_UI_GetMTS()
{
	return DST_EEPROM_GetAudioPref();
}

void DST_UI_SetMTS( DS_U8 nVal)
{
	DST_EEPROM_SetAudioPref(nVal);
	DST_g_AudioSettingChanged = true;
}

// VI Setting (0) Off (1) On
DS_U8 DST_UI_GetVI()
{
	return DST_EEPROM_GetVI();
}

void DST_UI_SetVI( DS_U8 nVal)
{
	DST_EEPROM_SetVI(nVal);
	DST_g_AudioSettingChanged = true;
}

// CC 
void DST_UI_SetCloseCaption(DS_U8 value)
{
	DST_EEPROM_SetCC(value ? 1 : 0);
}

// 0̸ RF3 1̸ RF4
DS_U8 DST_UI_GetCh34(void)
{
	return DST_EEPROM_GetPreferredConn();
}

void DST_UI_SetCh34(DS_U8 nVal)
{
	DST_EEPROM_SetPreferredConn(nVal);
	DHL_SetCh34(nVal);
}

#if 0
____Volum_UI___()
#endif

//  
DS_U8 DST_UI_GetVolume(void)
{
	return DST_EEPROM_GetVolume();
}
//  
void DST_UI_SetVolume(DS_U8 value)
{
	if (value > 0) DST_UI_SetMute(false);
	DST_EEPROM_SetVolume(value);
	CT_AudioVolume(DST_UI_GetMute() ? 0 : DST_UI_GetVolume()*2);
}

// Ʈ 
static bool g_Mute = false;
bool DST_UI_GetMute(void)
{
	return g_Mute;
}

// Ʈ 
void DST_UI_SetMute(bool bVal)
{
	g_Mute = bVal;
	CT_AudioVolume(g_Mute ? 0 : DST_UI_GetVolume()*2);
}

#if 0
____Info_Banner_UI___()
#endif

//  ð ´.
//bool DST_UI_GetLocalTime(STime_t *time)
//{
//	return DST_GetTime(time);
//}

//    HD ΰ?
bool DST_UI_GetHDInfo(void)
{
	return DST_GetHDInfo();
}

//  CC ֱⰡ Ѱ?
bool DST_UI_GetCCInfo(void)
{
	return DST_GetCCInfo();
}

#if 0
____EPG_UI___()
#endif

// äιȣ ä̸
// Է 迭  40
int DST_UI_GetCurrentChannelInfo(DS_U32 *chInfo)
{
	if (chInfo == 0) return 0;
	chInfo[0] = 0;
	char chNum[50];
	DS_U32 chName[TEXT_LENGTH_MAX];
	int num = 0;
	if (DST_DB_GetCurrentChannelInfo(chNum, chName, &num) == false) sprintf(chNum, "%d ", num); // RF ȣ
	str232(chInfo, chNum);
	strcpy32(&chInfo[strlen32(chInfo)], chName);
	return strlen32(chInfo);
}

// ð ڿ ȯѴ.
int DST_UI_GetTimeString(int hour, int min, DS_U16* timeInfo)
{
	char strText[16];
	sprintf(strText, "%02dh%02d", hour, min);
	str2uni(timeInfo, strText); 
	return strlen16(timeInfo);
}

// ļ ̺  Լ
static DS_U16 FREQ_TABLE[] =
{
	  2,   57,   3,  63,    4,  69,    5,   79,  6,  85,  
	  7, 177,    8, 183,    9, 189,  10,  195, 11,  201,
	  12, 207, 13, 213, 
	 14, 123,  15, 129,  16, 135,   17, 141, 18, 147,
	 19, 153,  20, 159,  21, 165,   22, 171, 23, 219,
	 24, 225,  25, 231,  26, 237,  27, 243, 28, 249,
	 29, 255, 30, 261,  31, 267, 32, 273, 33, 279,
	 34, 285, 35, 291, 36, 297, 37, 303, 38, 309,
	 39, 315, 40, 321, 41, 327, 42,333, 43,339,
	 44, 345, 45, 351, 46,357, 47,363,48,369,
	 49,375, 50, 381, 51, 387, 52, 393, 53,399,
	 54, 405, 55, 411, 56, 417, 57, 423, 58, 429,
	 59, 435, 60, 441, 61, 447, 62, 453, 63, 459,
	 64, 465, 65, 471, 66, 477, 67, 483, 68, 489,
	 69, 495, 70, 501, 71, 507, 72, 513, 73, 519,
	 74, 525, 75,531, 76,537, 77,543, 78,549,
	 79, 555,  80, 561,  81, 567,  82, 573,  83, 579, 
	 84, 585,  85, 591,  86, 597,  87, 603,  88, 609,
	 89, 615,  90, 621,  91, 627,  92, 633,  93, 639,
	 94, 645,   95, 93,   96, 99,   97, 105,
	 100, 651, 101, 657, 102, 663, 103, 669, 
	104, 675, 105, 681, 106, 687, 107, 693, 108, 699, 
	109, 705, 110, 711, 111, 717, 112, 723, 113, 729,
	114, 735, 115, 741, 116, 747, 117, 753, 118, 759,
	119, 765, 120, 771, 121, 777, 122, 783, 123, 789,
	124, 795, 125, 801, 126, 807, 127, 813, 128, 819,
	129, 825, 130, 831, 131, 837, 132, 843, 133, 849,
	134, 855, 135, 861, 136, 867, 137, 873, 138, 879,
	139, 885, 140, 891, 141, 897, 142, 903, 143, 909,
	144, 915, 145, 921, 146, 927, 147, 933, 148, 939,
	149, 945, 150, 951, 151, 957, 152, 963, 153, 969,
	154, 975, 155, 981, 156, 987, 157, 993, 158, 999
};
// Aspect Ratio (0) wide (1) normal (2) zoom
// DS_U8 DST_EEPROM_GetAspect(bool bOutput4x3, bool bSource4x3);
DS_U8 DST_UI_GetAspect()
{
	if (DST_g_LastTuneTime == 0) return ASPECT_RATIO_NORMAL;
	if (DST_IsVideoPlay() == false) return ASPECT_RATIO_NORMAL;
	DS_U16 w = 0, h = 0, fps = 0;
	bool bWide = false, bInterlace = false;
	DST_GetVideoSize(&w, &h, &fps, &bInterlace, &bWide);
	if (h == 0) return ASPECT_RATIO_NORMAL;
	return DST_EEPROM_GetAspect((!bWide));
}

// void DST_EEPROM_SetAspect(bool bOutput4x3, bool bSource4x3,  DS_U8 nVal); 
void DST_UI_SetAspect(DS_U8 nVal)
{
	if (DST_g_LastTuneTime == 0) return;
	if (DST_IsVideoPlay() == false) return;
	DS_U16 w = 0, h = 0, fps = 0;
	bool bWide = false, bInterlace = false;
	DST_GetVideoSize(&w, &h, &fps, &bInterlace, &bWide);
	if (h == 0) return;
	DST_EEPROM_SetAspect((!bWide), nVal);
}

// ļ ̺ 
int DST_GetFreqCount()
{
	return DST_MaxRF() -DST_MinRF() + 1;
}

// ε Էϰ ļ ȣ ޴´.
DS_U16 DST_GetFrequencyNumberbyIndex(int index)
{
	return FREQ_TABLE[2*index];
}

// ε Էϰ MHz  ļ ޴´.
DS_U16 DST_GetMHzFrequencybyIndex(int index)
{
	return FREQ_TABLE[1+2*index];
}

// ļ ȣ Էϰ ε  ޴´.
int DST_GetIndexByRFNumber(int rf_number)
{
	int i;
	for ( i = 0; i < sizeof(FREQ_TABLE)/4; i++)
	{
		if (rf_number == DST_GetFrequencyNumberbyIndex(i)) return i;
	}
	return -1;
}

// MHz ļ Էϰ ε  ޴´.
int DST_GetIndexByMHzFrequency(int MHz)
{
	int i;
	for ( i = 0; i < sizeof(FREQ_TABLE)/4; i++)
	{
		if (MHz == DST_GetMHzFrequencybyIndex(i)) return i;
	}
	return -1;
}
