#include "DST_WinManager.h"

//   Լ 
static CWindow *window[WIN_ID_MAX];
// 츦 ߰Ѵ.
void DST_AddWin(WinID nID, CWindow *pData)
{
	if (!pData) return;
	if (window[nID]) DeleteCWindow(window[nID]);
	window[nID] = pData;
}
// 츦 Ѵ.
void DST_RemoveWin(WinID nID)
{
	if (window[nID]) DeleteCWindow(window[nID]);
	window[nID] = 0;
}
//  츦 Ѵ.
void DST_RemoveAllWindows()
{
	int i;
	for ( i=WIN_NULL; i < WIN_ID_MAX; i++)
	{
	 	DST_RemoveWin((WinID)i);
	}
}

void DST_RemoveAllWindowExceptBasicWin()
{
	int i;
	for ( i=WIN_NULL; i < WIN_BASIC; i++)
	{
		DST_RemoveWin((WinID)i);
	}
}

//  ̵  Ŭ ͸ ´.
CWindow *DST_GetWin(WinID nID)
{
	if (nID < WIN_ID_MAX) return window[nID];
	return 0;
}

// Ʈ  Լ 
static DST_RECT rectUpdate;
// Ʈ  ʱȭ
void DST_ResetUpdateRegion()
{
	memset(&rectUpdate, 0, sizeof(DST_RECT));
}
// Ʈ  ߰
#define max(x,y) ((x)>(y)?(x):(y))
#define min(x,y) ((x)<(y)?(x):(y))	
void DST_AddUpdateRegion(DST_RECT rectNew)
{
	if (rectNew.w == 0 || rectNew.h == 0) return;
	if (rectUpdate.w == 0 || rectUpdate.h == 0) // ڽ ũⰡ 0̸ ڽ ũ üѴ.
	{
		rectUpdate = rectNew;
		return;
	}
	DST_RECT rectTemp = rectUpdate;
	rectUpdate.x = min(rectTemp.x, rectNew.x );
	rectUpdate.y = min(rectTemp.y, rectNew.y );
	rectUpdate.w = max(rectTemp.x + rectTemp.w, rectNew.x + rectNew.w) - rectUpdate.x;
	rectUpdate.h = max(rectTemp.y + rectTemp.h, rectNew.y + rectNew.h) - rectUpdate.y;

	if (rectUpdate.x < 0) rectUpdate.x = 0;
	if (rectUpdate.y < 0) rectUpdate.y = 0;
	if (rectUpdate.w > DST_GetScreenWidth() - rectUpdate.x) rectUpdate.w = DST_GetScreenWidth() - rectUpdate.x;
	if (rectUpdate.h > DST_GetScreenHeight() - rectUpdate.y) rectUpdate.h = DST_GetScreenHeight() - rectUpdate.y;
}
// Ʈ  ȯ
DST_RECT DST_GetUpdateRegion()
{
	return rectUpdate;
}
