#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"

#if 0
____CPowerDownCautionWin___()
#endif

#define MAX_SECONDS 60
//class CPowerDownCautionWin : public CWindow
//{
//private:
	static bool CPowerDownCautionWin_needShutDown;
	static int CPowerDownCautionWin_nMaxWidth;
	static int CPowerDownCautionWin_nCoundDown;
//public:
DS_U16* CPowerDownCautionWin_GetTextNWidth(int *textWidth, int countDown, int fontSize);
//	CPowerDownCautionWin(SWinEventMsg event):CWindow(event)
	void CPowerDownCautionWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "PowerDownCaution");
		this->setFontStyle(this, 20, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_LEFT);
		CPowerDownCautionWin_needShutDown = false;
		CPowerDownCautionWin_nMaxWidth = 0;
		CPowerDownCautionWin_nCoundDown = MAX_SECONDS;
		CPowerDownCautionWin_GetTextNWidth(&CPowerDownCautionWin_nMaxWidth,CPowerDownCautionWin_nCoundDown,this->FontGetSize(this));

		this->rect.w = 9+DST_GetImageWidth(bracon_gui_caution)+10+CPowerDownCautionWin_nMaxWidth+10;
		this->rect.h = 92;
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = DST_GetScreenHeight()*9/10 - this->rect.h;

		this->SetTimeOut(this, 0);
	}

	void CPowerDownCautionWin_Destructor(CWindow *this)
	{
		if(CPowerDownCautionWin_needShutDown) DST_SendWindowEventWithOnlyCmd(WM_POWER_OFF);
	}
	
	DS_U16* CPowerDownCautionWin_GetTextNWidth(int *textWidth, int countDown, int fontSize)
	{
		static DS_U16 final[100];
		char  tmpStr[10];
		int nStrLen = 0;
		int i = 0;
		DS_U16* fianlStr;
		
		memset(final,0,sizeof(final));
		memset(tmpStr,0,sizeof(tmpStr));
		sprintf(tmpStr," %d", countDown);
		str2uni(&final[strlen16(final)], (char *)tmpStr);
		strcpy16(&final[strlen16(final)], pz_PowerDownCountDown_P2[OSD_Lang]);
		memset(tmpStr,0,sizeof(tmpStr));
		sprintf(tmpStr," ");
		str2uni(&final[strlen16(final)], (char *)tmpStr);
		strcpy16(&final[strlen16(final)], pz_PowerDownCountDown_P1[OSD_Lang]);

		*textWidth = DST_GetTextWidthUni(final,fontSize);

		for( i=0;i<100;i++)
		{
			if(final[i]==0) break;
			nStrLen++;
		}
		fianlStr = (DS_U16*)DST_OS_Malloc((nStrLen+1) * sizeof(DS_U16));
		memset(fianlStr, 0, (nStrLen+1) * sizeof(DS_U16));
		memcpy(fianlStr,final,(nStrLen+1) * sizeof(DS_U16));
		return fianlStr;
	}
	
//	virtual void Show(WinID id)
	void CPowerDownCautionWin_ShowWindow(CWindow *this, WinID id)
	{
		DST_Printf("id=%d\n",id);
		switch(id)
		{
			case WIN_ERROR:
			case WIN_POWER_DOWN_CAUTION:
				break;
			default:
				this->KillTimer(this, 1);
				this->Close(this);
				break;
		}
	}

//	virtual void Show()
	void CPowerDownCautionWin_Show(CWindow *this)
	{
		int nWidth = 0;
		DS_U16* str;
		
		this->DrawBox32(this, 0, 0, this->rect.w, this->rect.h, CONV32_16(0xFF262626));
		this->DrawImage(this, 9, 9, bracon_gui_caution,true);
		
		str = CPowerDownCautionWin_GetTextNWidth(&nWidth, CPowerDownCautionWin_nCoundDown, this->FontGetSize(this));		
		this->DrawTextUni(this, 9+DST_GetImageWidth(bracon_gui_caution)+10, 0, CPowerDownCautionWin_nMaxWidth, this->rect.h, str, &(this->font)); 
		DST_OS_Free(&str);
		this->SetTimer(this, 1, 1000);
	}	

//	virtual void OnMessage(SWinEventMsg event)
	void CPowerDownCautionWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				this->Close(this);
				break;
			default: break;
		}
	}

//	virtual void OnTimer(char nID)
	void CPowerDownCautionWin_OnTimer(CWindow *this, char nID)
	{
		switch(nID)
		{
			case 1:
				this->KillTimer(this, 1);
				this->UpdateScreen(this);
				CPowerDownCautionWin_nCoundDown--;
				if(CPowerDownCautionWin_nCoundDown == 0)
				{
					DST_g_bSleepTimerOut = true;
					CPowerDownCautionWin_needShutDown = true;
					this->Close(this);
					return;
				}
				this->Show(this);
				this->UpdateScreen(this);
				break;
		}
	}	

//};


void DST_CreatePowerDownCautionWin(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor	= CPowerDownCautionWin_Destructor;
	pWin->OnMessage 	= CPowerDownCautionWin_OnMessage;
	pWin->OnTimer		= CPowerDownCautionWin_OnTimer;
	pWin->ShowWindow	= CPowerDownCautionWin_ShowWindow;
	pWin->Show			= CPowerDownCautionWin_Show;
	//  ȣ
	CPowerDownCautionWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}

