#if EPG_SUPPORT
#include "DST_WinManager.h"
#include "DST_ChannelTune.h"
#include "DST_SignalMonitor.h"
#include "DST_DataStrings.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_DB.h"

DS_U32* DST_UTF82Uni(DS_U8 *utf);

static DS_U32 g_StartTime = 0; //  EPG  Detail â ٰ   Ŀ Ű 
static int    g_Pos = 0; // EPG  Detail â ٰ   Ŀ ġ Ű 
static EPG_DB g_Event; // EPG â  â ѱ 

#define MAX_LINES (100) // ִ 100 

//class CProgramGuideDetailWin : public CWindow
//{
//private:
	static int CProgramGuideDetailWin_cursor;
	static int CProgramGuideDetailWin_nLines;
	static bool CProgramGuideDetailWin_bTitle[MAX_LINES]; //  
	static DS_U32* CProgramGuideDetailWin_MultiLine[MAX_LINES]; // 
//public:
int CProgramGuideDetailWin_SetMultiLineText(DS_U32 *strBuff, DS_U16 nStrLen, int width, DS_U8 nSize, bool bBold);

//	CProgramGuideDetailWin(SWinEventMsg event):CWindow(event)
	void CProgramGuideDetailWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		int i = 0;
		this->SetWinName(this,  "ProgramGuideDetail");
		this->rect.w = DST_GetImageWidth(newcon2_gui_detailedinfo_back);
		this->rect.h = DST_GetImageHeight(newcon2_gui_detailedinfo_back);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight()- this->rect.h) / 2;
		CProgramGuideDetailWin_cursor = 0;
		CProgramGuideDetailWin_nLines = 0;
		for ( i = 0; i < MAX_LINES; i++) CProgramGuideDetailWin_MultiLine[i] = 0;
		if (g_Event.text > 0) // ֳ normal
		{
			DS_U32* strTemp = DST_UTF82Uni((DS_U8*)g_Event.text);
			if(strlen32(strTemp) > 0)
			{
				CProgramGuideDetailWin_SetMultiLineText(strTemp, strlen32(strTemp), 528, fontItemSize, false);
			}
			else
			{
				DS_U32 strTemp1[200] = {0,};
				uni232(strTemp1,pz_ProgramGuide_No[OSD_Lang]);
				CProgramGuideDetailWin_SetMultiLineText(strTemp1, strlen32(strTemp1), 528, fontItemSize, false);
			}
		}
	}

	//   Ͽ پ ߶ ͸ Ѵ.
	void CProgramGuideDetailWin_InsertMultiLineText(DS_U32 *strBuff, DS_U16 nStrLen, bool bBold)
	{
		if (CProgramGuideDetailWin_nLines >= MAX_LINES-1) return;
		if (nStrLen > 0)
		{
			CProgramGuideDetailWin_MultiLine[CProgramGuideDetailWin_nLines] = (DS_U32*)DST_OS_Malloc((nStrLen+1) * sizeof(DS_U32));
			memcpy(CProgramGuideDetailWin_MultiLine[CProgramGuideDetailWin_nLines], strBuff, nStrLen * sizeof(DS_U32));
			CProgramGuideDetailWin_MultiLine[CProgramGuideDetailWin_nLines][nStrLen] = 0;
		}
		CProgramGuideDetailWin_bTitle[CProgramGuideDetailWin_nLines] = bBold;
		CProgramGuideDetailWin_nLines++;
	}
	
	//  ڿ  ߶󳽴.
	int CProgramGuideDetailWin_SetMultiLineText(DS_U32 *strBuff, DS_U16 nStrLen, int width, DS_U8 nSize, bool bBold)
	{
		if (nStrLen < 1) return 0;
		int nSpacePos = -1;
		int i = 0;
		
		for ( i = 0; i < nStrLen; i++)
		{
			if (strBuff[i] == 0x0D)
			{
				if (((i+1) < nStrLen) && strBuff[i+1] == 0x0A)
				{
					CProgramGuideDetailWin_InsertMultiLineText(strBuff,i, bBold);
					return CProgramGuideDetailWin_SetMultiLineText(strBuff+(i+2), nStrLen-(i+2), width, nSize, bBold) + 1;
				}
				CProgramGuideDetailWin_InsertMultiLineText(strBuff,i, bBold); 
				return CProgramGuideDetailWin_SetMultiLineText(strBuff+(i+1), nStrLen-(i+1), width, nSize, bBold) + 1;
			}
			if ((strBuff[i] == 0x0A))
			{
				CProgramGuideDetailWin_InsertMultiLineText(strBuff,i, bBold); 
				return CProgramGuideDetailWin_SetMultiLineText(strBuff+(i+1), nStrLen-(i+1), width, nSize, bBold) + 1;
			}
		
			if (DST_GetTextWidth32(strBuff, i + 1, nSize) > width)
			{
				if (strBuff[i-1] == 0x20 ||nSpacePos == -1)
				{
					CProgramGuideDetailWin_InsertMultiLineText(strBuff,i, bBold);
					return CProgramGuideDetailWin_SetMultiLineText(strBuff+(i), nStrLen-(i), width, nSize, bBold) + 1;
				}
				CProgramGuideDetailWin_InsertMultiLineText(strBuff, nSpacePos + 1, bBold);
				return CProgramGuideDetailWin_SetMultiLineText(strBuff+(nSpacePos + 1), nStrLen-(nSpacePos + 1), width, nSize, bBold) + 1;
			}
			if (strBuff[i] == 0x20) nSpacePos = i;
		}
		CProgramGuideDetailWin_InsertMultiLineText(strBuff, nStrLen, bBold);
		return 1;
	}
	
	void CProgramGuideDetailWin_Destructor(CWindow *this)
	{
		int i = 0;
		for ( i = 0; i < MAX_LINES; i++) if (CProgramGuideDetailWin_MultiLine[i]) DST_OS_Free(&CProgramGuideDetailWin_MultiLine[i]);
	}

//	virtual void Show(WinID id)
	void CProgramGuideDetailWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_ENGINEER_MODE:
			case WIN_FREQUENCY_SETTING:		
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:	
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_OTC_DOWNLOAD:
			case WIN_OTC_DOWNLOAD_FAIL:
			case WIN_UPDATE:
			case WIN_UPDATE_RESET:				
				this->Close(this);
				break;
			default:
				break;
		}
	}

	void CProgramGuideDetailWin_DrawScrollBar3(CWindow *this, int x, int y, int h, int total_count, int page_count, int page_start)
	{
		if (total_count <= page_count) return;
		int nScrollPosition = total_count - page_count;
//		DST_Printf("nScrollPosition : %d h/nScrollPosition : %d/%d == %d y+page_start*ScrollHeight = %d\n",nScrollPosition,h,nScrollPosition ,ScrollHeight,y+page_start*ScrollHeight);
		this->DrawImage(this, x,y+(page_start*h)/nScrollPosition,newcon2_gui_scroll_button,true);
	}

//	virtual void Show()
	void CProgramGuideDetailWin_Show(CWindow *this)
	{
		int rf = DST_EEPROM_GetRF();
		DS_U32 ChInfo[100]={0};
		DS_U32 curTime = DST_GetCurrentUTCTime();
		DS_U16 CurrTime[50] = {0,};		
		DS_U32 endTime = g_Event.start_time +g_Event.duration;
		DS_U16 time[110] = {0,};
		int i = 0;
		DS_U16	final[20];
		
		// 
		this->DrawImage(this, 0, 0, newcon2_gui_detailedinfo_back, false);
		// window title
		// program title
		this->setFontStyle(this, 20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);
		if (g_Event.title != 0)
		{
			if (g_Event.title) this->DrawTextUTF8(this, 15, 43, 528, 29, (DS_U8*)g_Event.title, &(this->font));

		}
		
		// ð ǥ
		this->setFontStyle(this, 20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_RIGHT);
		strcpy16(CurrTime, DST_GetTimeString(curTime,DATE_NO_YEAR_TIME_NO_SEC_DETAIL,true,DST_g_TimeOffset[rf]));
		this->DrawTextUni(this, 0, 11, 536, 29,  CurrTime, &(this->font));		

		// ä ̸ ǥ			
		DST_UI_GetCurrentChannelInfo(ChInfo);
		this->setFontStyle(this, 20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);
		this->DrawText32(this, 15, 11, 536-DST_GetTextWidthUni(CurrTime,this->FontGetSize(this)), 29, ChInfo,  &(this->font));
		
		//program time
		strcpy16(time, DST_GetTimeString(g_Event.start_time,DATE_NO_YEAR_TIME_NO_SEC_DETAIL,true,DST_g_TimeOffset[rf]));
		strcat16_8(time, (char *)" - ");
		strcat16(time, DST_GetTimeString(endTime,TIME_NO_SEC,true,DST_g_TimeOffset[rf]));
		this->DrawTextUni(this, 15, 80, 482, 29, time, &(this->font)); 

		// program text
		for ( i=0; i < 6; i++)
		{
			if (CProgramGuideDetailWin_MultiLine[CProgramGuideDetailWin_cursor+i] == 0) continue;
			this->DrawText32(this, 15, 117+36*i, 528, 29, CProgramGuideDetailWin_MultiLine[CProgramGuideDetailWin_cursor+i], &(this->font));
		}
		// ũѹ
		if (CProgramGuideDetailWin_nLines > 6) CProgramGuideDetailWin_DrawScrollBar3(this, 560, 76, 250, CProgramGuideDetailWin_nLines, 6, CProgramGuideDetailWin_cursor);
		// Ű ̵
		this->setFontStyle(this, 20,0xFF8C8C8C,ALIGN_MIDDLE,ALIGN_CENTER);
		memset(final,0,sizeof(final));
		strcpy16(final, pz_Edit_Menu[OSD_Lang]);
		str2uni(&final[strlen16(final)], (char *)" : ");
		strcpy16(&final[strlen16(final)], pz_Edit_Exit[OSD_Lang]);
		this->DrawTextUni(this, 17, 340, 142, 29, final, &(this->font));

		this->UpdateScreen(this);
		
		this->RegisterKey(this, VK_MENU, true, 0, 0);
		this->RegisterKey(this, VK_UP, true, 0, 0);
		this->RegisterKey(this, VK_DN, true, 0, 0);
		this->RegisterKey(this, VK_LEFT, true, 0, 0);
		this->RegisterKey(this, VK_RIGHT, true, 0, 0);
		this->RegisterKey(this, VK_OK, true, 0, 0);
		this->RegisterKey(this, VK_EPG, true, 0, 0);
		this->RegisterKey(this, VK_CANCEL, true, 0, 0);
		this->RegisterKey(this, VK_PREV, true, 0, 0);
		this->RegisterKey(this, VK_PREV_CH, true, 0, 0);
		this->RegisterKey(this, VK_PREV_MENU, true, 0, 0);
	}

//	virtual void OnMessage(SWinEventMsg event)
	void CProgramGuideDetailWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				this->Close(this);
				break;
			default: break;
		}
	}

//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CProgramGuideDetailWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_UP:
				if (CProgramGuideDetailWin_nLines <= 6) break;
				if (CProgramGuideDetailWin_cursor == 0) break;
				CProgramGuideDetailWin_cursor--;
				this->Show(this);
				break;
				
			case VK_DN:
				if (CProgramGuideDetailWin_nLines <= 6) break;
				if (CProgramGuideDetailWin_cursor == CProgramGuideDetailWin_nLines-6) break;
				CProgramGuideDetailWin_cursor++;
				this->Show(this);
				break;

			case VK_RIGHT:
			case VK_OK:
				// ڰ 2̸  ġ ϸ鼭 EPG ׸  
				DST_CreateWin(WIN_PROGRAM_GUIDE, this->GetParentWinID(this), 2, 0, 0, 0); 
				this->Close(this);
				break;
				
			default:
				DST_CreateWin(WIN_PROGRAM_GUIDE, this->GetParentWinID(this), 2, 0, 0, 0); 
				this->Close(this);
				break;
		}    
	}
//};

//class CProgramGuideWin : public CWindow
//{
//private:
	static int CProgramGuideWin_start;
	static int CProgramGuideWin_cursor;
	static int CProgramGuideWin_EventNum;
	static EPG_DB *CProgramGuideWin_Events;
	static DS_U8 CProgramGuideWin_event_parameter2;
//public:
void CProgramGuideWin_InitEPG();

//	CProgramGuideWin(SWinEventMsg event):CWindow(event)
	void CProgramGuideWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "ProgramGuide");
		this->rect.w = DST_GetImageWidth(newcon2_gui_epg_back);
		this->rect.h = DST_GetImageHeight(newcon2_gui_epg_back);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = (DST_GetScreenHeight()- this->rect.h) / 2;
		
		CProgramGuideWin_start  = 0;
		CProgramGuideWin_cursor = 0;
		CProgramGuideWin_event_parameter2 = event.data[2];
		CProgramGuideWin_EventNum = 0;
		CProgramGuideWin_Events = 0;
		CProgramGuideWin_InitEPG();
	}

	void CProgramGuideWin_Destructor(CWindow *this)
	{
		if (CProgramGuideWin_Events)		
		{
			DST_EPG_DB_Free(CProgramGuideWin_Events, CProgramGuideWin_EventNum);
			CProgramGuideWin_Events = 0;
		}
	}

	void CProgramGuideWin_InitEPG()
	{
		int tmpEventNum = 0;
		int i = 0;
		int nPos = 0;
		if (CProgramGuideWin_Events) 
		{
			DST_EPG_DB_Free(CProgramGuideWin_Events, CProgramGuideWin_EventNum);
			CProgramGuideWin_Events = 0;
		}
		CProgramGuideWin_Events = DST_EPG_DB_Get(&CProgramGuideWin_EventNum, 0);
		for ( i = 0; i < CProgramGuideWin_EventNum; i++) if (strlen((char *)CProgramGuideWin_Events[i].title) == 0 && strlen((char *)CProgramGuideWin_Events[i].text) == 0) tmpEventNum--;

		if(CProgramGuideWin_EventNum != tmpEventNum)
		{
			tmpEventNum = CProgramGuideWin_EventNum;
			EPG_DB *tmpEvents = (EPG_DB*)DST_OS_Calloc(tmpEventNum, sizeof(EPG_DB));
			nPos = 0;
			i = 0;
			for ( i = 0; i < CProgramGuideWin_EventNum; i++)
			{
				if (strlen((char *)CProgramGuideWin_Events[i].title) == 0 && strlen((char *)CProgramGuideWin_Events[i].text) == 0) continue;
//				memcpy(&tmpEvents[nPos], &Events[i],sizeof(EPG_DB));
				tmpEvents[nPos].source_id= CProgramGuideWin_Events[i].source_id;
				tmpEvents[nPos].event_id= CProgramGuideWin_Events[i].event_id;
				tmpEvents[nPos].start_time= CProgramGuideWin_Events[i].start_time;
				tmpEvents[nPos].duration= CProgramGuideWin_Events[i].duration;
				strcpy((char*)tmpEvents[nPos].title, (char*)CProgramGuideWin_Events[i].title);
				tmpEvents[nPos].text = (char*)DST_OS_Calloc(strlen(CProgramGuideWin_Events[i].text)+1, 1);
				strcpy((char*)tmpEvents[nPos].text, (char*)CProgramGuideWin_Events[i].text);
				nPos++;
			}		
			if (CProgramGuideWin_EventNum > 0)
			{
				DST_EPG_DB_Free(CProgramGuideWin_Events, CProgramGuideWin_EventNum);
				CProgramGuideWin_Events = 0;
			}
			CProgramGuideWin_Events = (EPG_DB*)DST_OS_Calloc(tmpEventNum, sizeof(EPG_DB));
			memcpy(CProgramGuideWin_Events, tmpEvents,tmpEventNum*sizeof(EPG_DB));
			CProgramGuideWin_EventNum = tmpEventNum;

		}

//		DST_Printf("CProgramGuideWin EventNum = %d\n", CProgramGuideWin_EventNum);
		if (CProgramGuideWin_event_parameter2 == 2) //  ġ 
		{
			i = 0;
			for ( i = 0; i < CProgramGuideWin_EventNum; i++)
			{
				if (CProgramGuideWin_Events[i].start_time != g_StartTime) continue;
				CProgramGuideWin_cursor = i;
				CProgramGuideWin_start = CProgramGuideWin_cursor - g_Pos;
				if (CProgramGuideWin_start < 0) CProgramGuideWin_start = 0;
				CProgramGuideWin_event_parameter2 = 0;
				break;
			}
		}
	}
	
//	virtual void OnMessage(SWinEventMsg event)
	void CProgramGuideWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				this->Close(this);
				break;
			default: break;
		}
	}
	
//	virtual void Show(WinID id)
	void CProgramGuideWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_ENGINEER_MODE:
			case WIN_FREQUENCY_SETTING:		
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_OTC_DOWNLOAD:
			case WIN_OTC_DOWNLOAD_FAIL:
			case WIN_UPDATE:
			case WIN_UPDATE_RESET:
				this->Close(this);
				break;
			default:
				break;
		}
	}

	void CProgramGuideWin_DrawScrollBar3(CWindow *this, int x, int y, int h, int total_count, int page_count, int page_start)
	{
		if (total_count <= page_count) return;
		int nScrollPosition = total_count - page_count;
//		DST_Printf("nScrollPosition : %d h/nScrollPosition : %d/%d == %d y+page_start*ScrollHeight = %d\n",nScrollPosition,h,nScrollPosition ,ScrollHeight,y+page_start*ScrollHeight);
		this->DrawImage(this, x,y+(page_start*h)/nScrollPosition,newcon2_gui_scroll_button,true);
	}
	
//	virtual void Show()
	void CProgramGuideWin_Show(CWindow *this)
	{
		DS_U8  RF= 0;
		DS_U16 sID = 0;
		DS_U32 ChInfo[100]={0};
		int nTextWidth = 0;
		DS_U32 curTime = 0;
		DS_U16 time_str[50] = {0,};		
		int listNum = 0;
		int listPos = 0;
		int i = 0;
		DS_U16 time[110] = {0,};
		DS_U16	final[20];
		// 
		this->DrawImage(this, 0, 0, newcon2_gui_epg_back, false);

		DST_GetAVState(&RF, 0, &sID);
		// ä ̸ ǥ			
		DST_UI_GetCurrentChannelInfo(ChInfo);
		this->setFontStyle(this, 20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);
		nTextWidth = DST_GetTextWidth32(ChInfo, strlen32(ChInfo), fontTitleSize);
		this->DrawText32(this, 15, 43, 536, 29, ChInfo,  &(this->font));
		// ð ǥ
		this->setFontStyle(this, 20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_RIGHT);
		curTime = DST_GetCurrentUTCTime();
		strcpy16(time_str, DST_GetTimeString(curTime,DATE_NO_YEAR_TIME_NO_SEC_DETAIL,true,DST_g_TimeOffset[RF]));
		this->DrawTextUni(this, 0, 11, 536, 29, time_str, &(this->font));		
		// EPG ̺Ʈ ǥ
		
		if (CProgramGuideWin_EventNum > 0)
		{
			listNum = CProgramGuideWin_EventNum > 7 ? 7 : CProgramGuideWin_EventNum;
			listPos = CProgramGuideWin_cursor - CProgramGuideWin_start;
			this->DrawBox32(this, 12, 79+36*listPos, 217, 33, CONV32_16(0xFF234B9C));
			this->DrawBox32(this, 232, 79+36*listPos, 319, 33, CONV32_16(0xFF234B9C));

			for ( i=0; i < listNum; i++)
			{
				this->setFontStyle(this, 20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
				DS_U32 endTime = CProgramGuideWin_Events[CProgramGuideWin_start+i].start_time + CProgramGuideWin_Events[CProgramGuideWin_start+i].duration;
				strcpy16(time, DST_GetTimeString(endTime,AMPM,true,DST_g_TimeOffset[RF]));
				strcat16_8(time, (char *)" ");
				strcat16(time, DST_GetTimeString(CProgramGuideWin_Events[CProgramGuideWin_start+i].start_time,TIME_NO_SEC_NO_AMPM,true,DST_g_TimeOffset[RF]));
				strcat16_8(time, (char *)" - ");
				strcat16(time, DST_GetTimeString(endTime,TIME_NO_SEC_NO_AMPM,true,DST_g_TimeOffset[RF]));
				this->DrawTextUni(this, 15, 81+36*i, 205, 29, time, &(this->font)); 

				this->setFontStyle(this, 20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);
				if (CProgramGuideWin_Events[CProgramGuideWin_start+i].title) this->DrawTextUTF8(this, 238, 81+36*i, 315, 29, (DS_U8*)CProgramGuideWin_Events[CProgramGuideWin_start+i].title, &(this->font));
			}
		}
		// ũѹ
		if (CProgramGuideWin_EventNum > 7) CProgramGuideWin_DrawScrollBar3(this, 560, 76, 250, CProgramGuideWin_EventNum, 7, CProgramGuideWin_start);
		// Ű ̵
		this->setFontStyle(this, 20,0xFF8C8C8C,ALIGN_MIDDLE,ALIGN_CENTER);
		memset(final,0,sizeof(final));
		strcpy16(final, pz_Edit_Menu[OSD_Lang]);
		str2uni(&final[strlen16(final)], (char *)" : ");
		strcpy16(&final[strlen16(final)], pz_Edit_Exit[OSD_Lang]);
		this->DrawTextUni(this, 17, 340, 142, 29, final, &(this->font));

		memset(final,0,sizeof(final));
		strcpy16(final, pz_Edit_OK[OSD_Lang]);
		str2uni(&final[strlen16(final)], (char *)" : ");
		strcpy16(&final[strlen16(final)], pz_EPG_Detail[OSD_Lang]);
		this->DrawTextUni(this, 170, 340, 200, 29, final, &(this->font));
		
		this->UpdateScreen(this);
		
		this->RegisterKey(this, VK_MENU, true, 0, 0);
		this->RegisterKey(this, VK_UP, true, 0, 0);
		this->RegisterKey(this, VK_DN, true, 0, 0);
		this->RegisterKey(this, VK_LEFT, true, 0, 0);
		this->RegisterKey(this, VK_RIGHT, true, 0, 0);
		this->RegisterKey(this, VK_OK, true, 0, 0);
		this->RegisterKey(this, VK_EPG, true, 0, 0);
		this->RegisterKey(this, VK_CANCEL, true, 0, 0);
		this->RegisterKey(this, VK_PREV, true, 0, 0);
		this->RegisterKey(this, VK_PREV_CH, true, 0, 0);
		this->RegisterKey(this, VK_PREV_MENU, true, 0, 0);
		this->SetTimer(this, 1,1000); // ð  Ȯϴٰ д Ǹ ð踦 ٽ ׸
	}

//	virtual void OnTimer(char /*nID*/)
	void CProgramGuideWin_OnTimer(CWindow *this, char nID)
	{
		// úд ǥ ð ŵǸ ȭ Ѵ.
		CProgramGuideWin_InitEPG();
		this->Show(this);
	}

	//  â ѱ Ŀ ͸  Ѵ.
	void CProgramGuideWin_SetEPGDetail()
	{
		g_Event.source_id= CProgramGuideWin_Events[CProgramGuideWin_cursor].source_id;
		g_Event.event_id= CProgramGuideWin_Events[CProgramGuideWin_cursor].event_id;
		g_Event.start_time = CProgramGuideWin_Events[CProgramGuideWin_cursor].start_time;
		g_Event.duration = CProgramGuideWin_Events[CProgramGuideWin_cursor].duration;
		
		strcpy((char*)g_Event.title, (char*)CProgramGuideWin_Events[CProgramGuideWin_cursor].title);
		if (g_Event.text) DST_OS_Free(&g_Event.text);
		g_Event.text = (char*)DST_OS_Calloc(strlen(CProgramGuideWin_Events[CProgramGuideWin_cursor].text)+1,1);
		strcpy(g_Event.text, CProgramGuideWin_Events[CProgramGuideWin_cursor].text);

		g_StartTime = CProgramGuideWin_Events[CProgramGuideWin_cursor].start_time; // ƿö  ġ Ѵ.
		g_Pos = CProgramGuideWin_cursor - CProgramGuideWin_start; // ƿö  ġ Ѵ.
	}
	
//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CProgramGuideWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_UP:
				if (CProgramGuideWin_cursor == 0) break;
				CProgramGuideWin_cursor--;
				if (CProgramGuideWin_start > CProgramGuideWin_cursor) CProgramGuideWin_start = CProgramGuideWin_cursor;
				this->Show(this);
				break;
				
			case VK_DN:
				if (CProgramGuideWin_cursor >= CProgramGuideWin_EventNum - 1) break;
				CProgramGuideWin_cursor++;
				if (CProgramGuideWin_start < CProgramGuideWin_cursor - 6) CProgramGuideWin_start = CProgramGuideWin_cursor - 6;
				this->Show(this);
				break;
				
			case VK_OK:
			case VK_RIGHT:
				if (CProgramGuideWin_EventNum < 1) break;
				//  â ѱ Ŀ ͸  Ѵ.
				CProgramGuideWin_SetEPGDetail();
				DST_CreateWin(WIN_PROGRAM_GUIDE, this->GetParentWinID(this), 1, 0, 0, 0); 
				this->Close(this);
				break;
				
			default:
				if (this->GetParentWinID(this)) DST_CreateWin(this->GetParentWinID(this), 0, 0, 0, 0, 0);
				this->Close(this);
				break;
		}    
	}
//};

void DST_CreateProgramGuideWin(SWinEventMsg event)
{
	if (DST_DB_PresentChMap() == false) return; 
	
	CWindow*pWin = NewCWindow(event);

	if (event.data[2] == 1)
	{
		pWin->Destructor	= CProgramGuideDetailWin_Destructor;
		pWin->KeyInput		= CProgramGuideDetailWin_KeyInput;
		pWin->OnMessage 	= CProgramGuideDetailWin_OnMessage;
		pWin->ShowWindow	= CProgramGuideDetailWin_ShowWindow;
		pWin->Show			= CProgramGuideDetailWin_Show;
		//  ȣ
		CProgramGuideDetailWin_Constructor(pWin, event);
		//  ޴ 
		DST_AddWin((WinID)(event.data[0]), pWin);
	}
	else
	{
		pWin->Destructor	= CProgramGuideWin_Destructor;
		pWin->KeyInput		= CProgramGuideWin_KeyInput;
		pWin->OnMessage 	= CProgramGuideWin_OnMessage;
		pWin->OnTimer		= CProgramGuideWin_OnTimer;
		pWin->ShowWindow	= CProgramGuideWin_ShowWindow;
		pWin->Show			= CProgramGuideWin_Show;
		//  ȣ
		CProgramGuideWin_Constructor(pWin, event);
		//  ޴ 
		DST_AddWin((WinID)(event.data[0]), pWin);
	}
}
#endif
