#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_CommonAPI.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"
#include "DST_Updates.h"

void JST_RFUpdate(DS_U8 RF);

#if 0
____CRFUpdateWin___()
#endif

//class CRFUpdateWin : public CWindow
//{
	static int CRFUpdateWin_nReceivePos;
	static int CRFUpdateWin_nWritePos;
	static int CRFUpdateWin_nCategory;
	static char CRFUpdateWin_strVersion[8];
//public:
//	CRFUpdateWin(SWinEventMsg event):CWindow(event)
	void CRFUpdateWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "RFUpdate");
		DST_g_RFUpdateState = 0;
		this->RegisterAllKey(this);
		this->rect.w = DST_GetScreenWidth();
		this->rect.h = DST_GetScreenHeight();
		this->rect.x = 0;
		this->rect.y = 0;
		this->SetTimeOut(this, 0);
//		JST_RFUpdate(10);
		CRFUpdateWin_nReceivePos = 0;
		CRFUpdateWin_nWritePos = 0;
		CRFUpdateWin_nCategory = 0;
		CRFUpdateWin_strVersion[0] = 0;
	}

	void CRFUpdateWin_Destructor(CWindow *this)
	{
		JST_Stop();	
	}
	
//	virtual void OnMessage(SWinEventMsg event)
	void CRFUpdateWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_RF_UPDATE:
				switch(event.data32[0])
				{
					case DATA_RECEIVING: // DATA RECEIVING
						memcpy(CRFUpdateWin_strVersion, &event.data32[2], 8);
						CRFUpdateWin_nReceivePos = event.data32[1];
						CRFUpdateWin_nWritePos = 0;
						DST_g_RFUpdateState = 0;
						break;
					case DATA_RECEIVING_COMPLETE: // DATA RECEIVING COMPLETE
						CRFUpdateWin_nReceivePos = 100;
						CRFUpdateWin_nWritePos = 0;
						DST_g_RFUpdateState = 0;
						break;
					case FLASH_WRITING: // FLASH WRITING
						CRFUpdateWin_nReceivePos = 100;
						CRFUpdateWin_nWritePos = event.data32[1];
						CRFUpdateWin_nCategory = event.data32[2];
						DST_g_RFUpdateState = 0;
						break;
					case FLASH_WRITING_COMPLETE: // FLASH WRITING COMPLETE
						CRFUpdateWin_nReceivePos = 100;
						CRFUpdateWin_nWritePos = 100;
						DST_g_RFUpdateState = 1;
						break;
					case FLASH_WRITING_FAIL: // FLASH WRITING FAIL
						CRFUpdateWin_nReceivePos = 100;
						CRFUpdateWin_nWritePos = 100;
						DST_g_RFUpdateState = 2;
						break;						
					case 100: // Different model
						DST_g_RFUpdateState = 2;
						break;
					case 101: // Same Version
						memcpy(CRFUpdateWin_strVersion, &event.data32[2], 8);
						DST_Printf("strVersion = %s\n", CRFUpdateWin_strVersion);
						CRFUpdateWin_nReceivePos = 100;
						CRFUpdateWin_nWritePos = 100;
						DST_g_RFUpdateState = 1;
						break;
					default: break;
				}
				this->Show(this);
				break;
			default: break;
		}
	}

//	virtual void Show()
	void CRFUpdateWin_Show(CWindow *this)
	{
		char strText[64];
		this->DrawBox32(this, 0,0,this->rect.w, this->rect.h, CONV32_16(0xFF808080));
		
		this->setFontStyle(this, 30, 0xFFFFFFF, ALIGN_MIDDLE,ALIGN_CENTER);
		this->DrawText(this, 0,   60, this->rect.w, 60, "RF Update", &(this->font));
		
		sprintf(strText, "Data Receiving : %s", CRFUpdateWin_strVersion);
		this->setFontStyle(this, 25, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);
		this->DrawText(this, 0, 150, this->rect.w, 40, strText, &(this->font));
		
		this->DrawBox32(this, 60-1, 200    ,    600+2, 50, CONV32_16(0xFFFFFFFF));
		this->DrawBox32(this, 60, 200 + 1, CRFUpdateWin_nReceivePos * 6, 48, CONV32_16(0xFF00FF00));
		 
		sprintf(strText, "%d%%", CRFUpdateWin_nReceivePos);
		this->setFontStyle(this, 25, 0xFF000000, ALIGN_MIDDLE,ALIGN_CENTER);
		this->DrawText(this, 0, 200, this->rect.w, 50, strText, &(this->font));
		
		this->setFontStyle(this, 25, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);
		this->DrawText(this, 0, 300, this->rect.w, 40, "Flash Writing:", &(this->font));
		
		this->DrawBox32(this, 60-1, 350    ,    600+2, 50, CONV32_16(0xFFFFFFFF));
		this->DrawBox32(this, 60, 350 + 1, CRFUpdateWin_nWritePos * 6, 48, CONV32_16(0xFF00FF00));
		
//		strText[5];
		sprintf(strText, "%d%%", CRFUpdateWin_nWritePos);
		this->setFontStyle(this, 25, 0xFF000000, ALIGN_MIDDLE,ALIGN_CENTER);
		this->DrawText(this, 0, 350, this->rect.w, 50, strText, &(this->font));

		this->setFontStyle(this, 25, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);
		switch(CRFUpdateWin_nCategory)
		{
			case UPDATE_BOOTLOADER: this->DrawText(this, 0, 400, this->rect.w, 40, "Bootloader", &(this->font));break;
			case UPDATE_APPLICATION0: this->DrawText(this, 0, 400, this->rect.w, 40, "Application 0", &(this->font));break;
			case UPDATE_APPLICATION1: this->DrawText(this, 0, 400, this->rect.w, 40, "Application 1", &(this->font));break;
			default: break;
		}
	}
//};

void DST_CreateRFUpdateWindow(SWinEventMsg event)
{
	if (DST_GetWin(WIN_RF_UPDATE)) return;
	
	DST_RemoveAllWindowExceptBasicWin();

	CWindow*pWin = NewCWindow(event);
	pWin->Destructor	= CRFUpdateWin_Destructor;
	pWin->OnMessage 	= CRFUpdateWin_OnMessage;
	pWin->Show			= CRFUpdateWin_Show;
	//  ȣ
	CRFUpdateWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);	
}
