#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"

#if 0
____CVolumeWin___()
#endif


//class CVolumeWin : public CWindow
//{
	static int CVolumeWin_prev_vol;
//public:
//	CVolumeWin(SWinEventMsg event):CWindow(event)
	void CVolumeWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "Volume");
		this->rect.w = DST_GetImageWidth(volume_back_left) + 194 + DST_GetImageWidth(volume_back_right);
		this->rect.h = DST_GetImageHeight(volume_back_left);
		this->rect.x = (DST_GetScreenWidth() - this->rect.w) / 2;
		this->rect.y = DST_GetScreenHeight()/20; 
		
		DST_UI_SetMute(false);
		this->SetTimeOut(this, 3);
		CVolumeWin_prev_vol = DST_UI_GetVolume();
	}

	void CVolumeWin_Destructor(CWindow *this)
	{		
		if(DST_g_SignalState == SM_AUDIO_ONLY) DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL ,0, 0, 0);
	}

//	virtual void OnMessage(SWinEventMsg event)
	void CVolumeWin_OnMessage(CWindow *this, SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				this->Close(this);
				break;
		}
	}

//	virtual void Show(WinID id)
	void CVolumeWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_VOLUME_MUTE:
				this->Close(this);
				break;
			default:
				break;
		}
	}

	void DrawProgressBar(CWindow *this, int x, int y, int w, int range, int pos, int pre_pos)
	{
		int position	= (w*pos)/(range);
		int pre_position = (w*pre_pos)/(range);
		int i = 0;
		if (pre_position > position)
		{
			for(i = x; i < x+(pre_position-position);i++)
				this->DrawImage(this, i+position, 0, volume_back_mid, false);
		}
		if (DST_UI_GetVolume() > 0)
		{
			for (i = x; i < x+position; i++)
			{
				this->DrawImage(this, i, y, volume_seg, false);
			}
		}
	}


	void CVolumeWin_Draw(CWindow *this)
	{
		char vol[4];
		sprintf(vol, "%d", DST_UI_GetVolume());	
		this->DrawBox32(this, 56, 6, 40, 20, CONV32_16(0xFF000000));
		this->DrawText(this, 56, 8, 40, 15, vol, &(this->font));
//		DrawBox32(106, 11, 280, DST_GetImageHeight(imgvolume_seg), CONV32_16(0x00000000));
		DrawProgressBar(this, 106, 11, 204, 50, DST_UI_GetVolume(),CVolumeWin_prev_vol);
		CVolumeWin_prev_vol = DST_UI_GetVolume();
			
	}

//	virtual void Show()
	void CVolumeWin_Show(CWindow *this)
	{
		
		this->DrawImage(this, 0, 0, volume_back_left, false);
		this->DrawImage(this, DST_GetImageWidth(volume_back_left) + 194, 0, volume_back_right, false);

		int i = 0;
		for(i=DST_GetImageWidth(volume_back_left);i<DST_GetImageWidth(volume_back_left)+194;i++) 
			this->DrawImage(this, i, 0, volume_back_mid, false);
		this->setFontStyle(this, 20,0xFFE1E1E1,ALIGN_MIDDLE,ALIGN_RIGHT);
		char vol[4];
		sprintf(vol, "%d", DST_UI_GetVolume());	
		this->DrawText(this, 56, 8, 40, 15, vol, &(this->font));
		DrawProgressBar(this, 106, 11, 204, 50, DST_UI_GetVolume(),CVolumeWin_prev_vol);

		this->RegisterKey(this, VK_VOL_DN, true, 0, 0);
		this->RegisterKey(this, VK_VOL_UP, true, 0, 0);
	}

//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CVolumeWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_VOL_DN:
				if (DST_UI_GetVolume() == 0) break;
				DST_UI_SetVolume(DST_UI_GetVolume()-1);
				CVolumeWin_Draw(this);
				break;
			case VK_VOL_UP:
				if (DST_UI_GetVolume() == 50) break;
				DST_UI_SetVolume(DST_UI_GetVolume()+1);
				CVolumeWin_Draw(this);
				break;
			default:
				this->Close(this);
				if(DST_g_SignalState == SM_AUDIO_ONLY) DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL ,0, 0, 0);
				break;

		}
	}

//};
void DST_CreateVolumeWindow(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor = CVolumeWin_Destructor;
	pWin->OnMessage = CVolumeWin_OnMessage;	
	pWin->KeyInput = CVolumeWin_KeyInput;
	pWin->ShowWindow = CVolumeWin_ShowWindow;
	pWin->Show = CVolumeWin_Show;
	//  ȣ
	CVolumeWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}



//class CVolumeMuteWin : public CWindow
//{
//private:
//public:
//	CVolumeMuteWin(SWinEventMsg event):CWindow(event)
	void CVolumeMuteWin_Constructor(CWindow *this, SWinEventMsg event)
	{
		this->SetWinName(this,  "Mute");
		this->rect.w = DST_GetImageWidth(mute);
		this->rect.h = DST_GetImageHeight(mute);
		this->rect.x = 9 + (DST_GetScreenWidth()) / 20;
		this->rect.y = DST_GetScreenHeight()/20;
		this->SetTimeOut(this, 0);
	}

	void CVolumeMuteWin_Destructor(CWindow *this)
	{
		if(DST_g_SignalState == SM_AUDIO_ONLY) DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL ,0, 0, 0);
	}

//	virtual void Show(WinID id)
	void CVolumeMuteWin_ShowWindow(CWindow *this, WinID id)
	{
		switch(id)
		{
			case WIN_VOLUME:
				this->Close(this);
				break;
			default:
				break;
		}
	}

	
//	virtual void Show()
	void CVolumeMuteWin_Show(CWindow *this)
	{

		this->DrawImage(this, 0, 0, mute, false);
		this->RegisterKey(this, VK_VOL_DN, true, 0, 0);
		this->RegisterKey(this, VK_VOL_UP, true, 0, 0);

	}

//	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	void CVolumeMuteWin_KeyInput(CWindow *this, DS_U8 key, bool bRepeat)
	{
		switch (key)
		{
			case VK_VOL_UP:
			case VK_VOL_DN:
				DST_CreateWin(WIN_VOLUME, WIN_NULL, 0, 0, 0, 0);
				break;
			default:
				this->Close(this);
				if(DST_g_SignalState == SM_AUDIO_ONLY) DST_CreateWin(WIN_CHANNEL_BANNER, WIN_NULL, BANNER_NORMAL ,0, 0, 0);
				break;

		}
	}


//};


void DST_CreateVolumeMuteWindow(SWinEventMsg event)
{
	CWindow*pWin = NewCWindow(event);
	pWin->Destructor 	= CVolumeMuteWin_Destructor;
	pWin->KeyInput 		= CVolumeMuteWin_KeyInput;
	pWin->ShowWindow 	= CVolumeMuteWin_ShowWindow;
	pWin->Show 			= CVolumeMuteWin_Show;
	//  ȣ
	CVolumeMuteWin_Constructor(pWin, event);
	//  ޴ 
	DST_AddWin((WinID)(event.data[0]), pWin);
}

