//-----------------------------------------------------------------------------//
//   dst_eroum_interface.h
//   V2.23 â POWER   
//   V2.22 â ܺ Է  
//   V2.20 â 2012.02.20 Audio Info ߰
//                           Open Լ TV/CVBS и
//                           Power Manager Լ ߰
//                           Rear View Detect Լ ߰
//   V1.01 â 2012.01.19 Dual Decoding ߰
//   V1.00 â 2012.01.13 First Draft 
//-----------------------------------------------------------------------------//

#ifndef __DST_EROUM_INTERFACE_H__
#define __DST_EROUM_INTERFACE_H__

#ifdef DSTAR
#include <stdlib.h>
#include <stdio.h>
#else
#include <ministd.h>
#include "DHL_OSAL.h"
#endif

#include <string.h>

#include "DST_Types.h"

#ifdef DSTAR
#define DST_Printf printf
#else
#define DST_Printf printf
#endif
#define T() DST_Printf("[INFO][%d]%s %d\n",__LINE__,__func__, (int)DST_OS_GetTickCount())


typedef unsigned int   DHL_HANDLE;
//  ڵ 
typedef enum 
{
	DHL_OK_,
	DHL_FAIL_
} DHL_ERROR;

// ԷµǴ  ҽ ASPECT
//  16:9 Է ƴ϶  4:3 ó
typedef enum 
{
	DHL_SOURCE_UNKNOWN,
	DHL_SOURCE_4x3,
	DHL_SOURCE_16x9
} DHL_SOURCE_ASEPCT;


// singal info ݹ Լ prototype
// TV  ڵ ۵  ȭػ  ݹ
// CVBS  Է ۵  ȭػ  ݹ
// CVBS  Է   ȭ nWidth nHeight  0 ݹ
typedef void (*DHL_SignalInfoCallBack)(
	int nWidth, //  
	int nHeight,  //  
	int RefreshRate, // Refresh 
	bool bInterlaced, // ͷ̽  true = interlace
	DHL_SOURCE_ASEPCT); //  Է ҽ ̵忩

// B-CAS ī尡 ų ŵ  ߻
// TV ǰ CAS ʱȭ ϷǸ ȣ
// ī尡 ԶǴ Žø ȣ
typedef enum 
{
	DHL_CAS_UNKNOWN,
	DHL_CAS_ERROR,
	DHL_CAS_INSERTED,
	DHL_CAS_ACTIVATED,
	DHL_CAS_REMOVED
} DHL_CAS_STATE;

// Caption ݹ prototype
typedef void (*DHL_CCCallBack) (DS_U8 *buffer, int Context);	

// video start ݹ Լ prototype
// TV Videoڵ ۵Ǿ ȭ  ϸ ߻ϴ Callback
// Mute  
typedef void (*DHL_VideoStartCallBack)();

// SI ݹ Լ prototype
typedef void (*DHL_SiCallBack)(DS_U32 RF, DS_U32 nRequestID, DS_U8** buff, DS_U32 nBuffLength);

// IR ݹ Ÿ
typedef void (*DHL_IrCallBack) (DS_U32 key, DS_U32 repeat, DS_U32 tick);

//  ڵ ڵ
typedef enum 
{
	DHL_VIDEO_NONE,
	DHL_VIDEO_MPEG1,
	DHL_VIDEO_MPEG2,
	DHL_VIDEO_MPEG4
} DHL_VIDEO_TYPE;

//  ڵ ڵ
typedef enum 
{
	DHL_AUDIO_NONE,
	DHL_AUDIO_MPEG1,
	DHL_AUDIO_MPEG2,
	DHL_AUDIO_AAC_ADTS,
	DHL_AUDIO_AAC_LATM,
	DHL_AUDIO_AC3,
}DHL_AUDIO_TYPE;

//  LR 
// Dual Mono ƴ  ׻ DHL_AUDIO_BOTH ȣ
typedef enum 
{
	DHL_AUDIO_BOTH,
	DHL_AUDIO_LEFT,
	DHL_AUDIO_RIGHT
}DHL_AUDIO_LR;

// Play   带 ȯѴ.
typedef enum 
{
	DHL_AUDIO_UNKNOWN, //  带   ų    
	DHL_AUDIO_DUAL_MONO, 
	DHL_AUDIO_MONO,
	DHL_AUDIO_STEREO,
	DHL_AUDIO_5_1
} DHL_AUDIO_MODE;

typedef enum 
{
	DHL_ASPECT_4x3_4x3,               //  4:3 Է¼ҽ  4:3 
	DHL_ASPECT_16x9_4x3_WIDE,      // 16:9 Է¼ҽ  4:3  wide
	DHL_ASPECT_16x9_4x3_NORMAL,  // 16:9 Է¼ҽ 4:3  normal
	DHL_ASPECT_16x9_4x3_ZOOM,     // 16:9 Է¼ҽ 4:3  zoom 
} DHL_ASPECT_RATIO;



// audio start ݹ Լ prototype
// TV Audioڵ ۵Ǿ ȭ  ϸ ߻ϴ Callback
// Mute  
typedef void (*DHL_AudioStartCallBack)(DS_U32);

#if 0
____System___()
#endif


// SYSTEM ʱȭ
DHL_ERROR DHL_SYS_Initialize();

// TV 
DHL_ERROR DHL_SYS_TV_Open(
		DHL_SignalInfoCallBack, 
		DHL_VideoStartCallBack, 
		DHL_AudioStartCallBack, 
		DHL_SiCallBack,
		DHL_CCCallBack,
		DHL_IrCallBack);

// TV 
DHL_ERROR DHL_SYS_TV_Close();

#if 0
____Video___()
#endif

// Video 
DHL_ERROR DHL_VID_Start(DS_U16 VideoPID, DS_U16 PcrPID, DHL_VIDEO_TYPE);

// Dual Decoding Video 
// Ǯ׿  ÿ  ڵ ϴ Լ
// bDisplayFullSeg = true  Ǯ  ȭ鿡 ǥ
// bDisplayFullSeg = false    ȭ鿡 ǥ
// Ʒ     Ǵ 쿡 Video Stop  ȣ ϸ
// ̶    
// 1. Ǯ׿ ׷ Ǵ  ȣ
// DHL_VID_DualStart(10, 11, DHL_VIDEO_MPEG2, 20,21, DHL_VIDEO_MPEG4, true);
// DHL_VID_DualStart(10, 11, DHL_VIDEO_MPEG2, 20,21, DHL_VIDEO_MPEG4, false);
// 2.  RF Ǯ׸ ٸ äη  
// DHL_VID_DualStart(10, 11, DHL_VIDEO_MPEG2, 20,21, DHL_VIDEO_MPEG4, true);
// DHL_VID_DualStart(12, 11, DHL_VIDEO_MPEG2, 20,21, DHL_VIDEO_MPEG4, true);
// 3.  ä ٰ Ÿ 
// DHL_VID_DualStart(10, 11, DHL_VIDEO_MPEG2,  0,  0, DHL_VIDEO_NONE, true);
// DHL_VID_DualStart(12, 11, DHL_VIDEO_MPEG2, 20, 21, DHL_VIDEO_MPEG4, true);
DHL_ERROR DHL_VID_DualStart(
	DS_U16 FullSegVideoPID, DS_U16 FullSegPcrPID, DHL_VIDEO_TYPE typeFullSeg,
	DS_U16 OneSegVideoPID,  DS_U16 OneSegPcrPID,  DHL_VIDEO_TYPE typeOneSeg,
	bool bDisplayFullSeg);

// Video 
DHL_ERROR DHL_VID_Stop();

// Video Mute  ȭ   ʵ . CVBS 
// bMute = false --> Video Unmute
// bMute = true  --> Video Mute
DHL_ERROR DHL_VID_Mute(bool bMute);

// Video Alive ڵ  ִ θ ˷ִ Լ
bool DHL_VID_Alive();

// Video Aspect 
// Է ASPECT(4:3 16:9)     尡 
//DHL_ERROR DHL_VID_Aspect(DHL_ASPECT_RATIO);
DHL_ERROR DHL_VID_Aspect(DHL_ASPECT_RATIO ar, DS_U16 w, DS_U16 h);

#if 0
____Audio___()
#endif

// Audio 
// PcrPID == 0 ΰ Audio Only ä
DHL_ERROR DHL_AUD_Start(DS_U16 AudioPid, DS_U16 PcrPID, DHL_AUDIO_TYPE);

// Audio 
DHL_ERROR DHL_AUD_Stop();

// Audio Volume 0 is mute
DHL_ERROR DHL_AUD_Volume(DS_U8 nVal);

// Audio Alive ڵ  ִ θ ˷ִ Լ
bool DHL_AUD_Alive();

DHL_AUDIO_MODE DHL_AUD_GetMode();

#if 0
____SI___()
#endif

// PAT Monitoring
// PAT ͸ Ѵ.
// CRC   ݹ
// PID = 0x00
DHL_HANDLE DHL_SI_MonitorPAT(DS_U32 RF, DS_U32 nRequestID);

// PMT Monitoring
// PMT ͸ Ѵ.
// RF ִ 16 ͸ Ѵ.
// CRC   ݹ
// PID = depend on PAT
// 
DHL_HANDLE DHL_SI_MonitorPMT(DS_U32 RF, DS_U32 nRequestID, DS_U16 Pid, DS_U16 source_id);

// SDT Monitoring
// SDT ͸Ѵ.
// CRC   ݹ
// PID = 0x11
DHL_HANDLE DHL_SI_MonitorSDT(DS_U32 RF, DS_U32 nRequestID);

// NIT Monitoring
// NIT ͸Ѵ.
// CRC   ݹ
// PID = 0x10
DHL_HANDLE DHL_SI_MonitorNIT(DS_U32 RF, DS_U32 nRequestID);

// CDT Monitoring
// CDT ͸Ѵ.
// ۱ ΰ ޴  Ƽǿ   ʿ
// CRC   ݹ
// PID = 0x29
DHL_HANDLE DHL_SI_MonitorCDT(DS_U32 RF, DS_U32 nRequestID);

// ECM Monitoring
// CRC   ݹ
// PID = depend on PMT
DHL_HANDLE DHL_SI_MonitorECM(DS_U32 RF, DS_U32 nRequestID, DS_U16 Pid);

// BIT Monitoring
// CRC   ݹ
// PID = 0x24
DHL_HANDLE DHL_SI_MonitorBIT(DS_U32 RF, DS_U32 nRequestID);

// TOT Monitoring
// CRC   ݹ
// PID = 0x14 TableID = 0x73
DHL_HANDLE DHL_SI_MonitorTOT(DS_U32 RF, DS_U32 nRequestID);

// TOT Monitoring
// CRC   ݹ
// PID = 0x14 TableID = 0x70
DHL_HANDLE DHL_SI_MonitorTDT(DS_U32 RF, DS_U32 nRequestID);

// EIT Monitoring
// HEIT = 0x12 TableID = 0x4E~0x5F SourceID = depend on PMT
// MEIT = 0x26 
// LEIT - 0x27
DHL_HANDLE DHL_SI_MonitorEIT(DS_U32 RF, DS_U32 nRequestID, DS_U16 pid, DS_U16 source_id);
DHL_HANDLE DHL_SI_MonitorETT(DS_U32 RF, DS_U32 nRequestID, DS_U16 pid, DS_U16 source_id);
DHL_HANDLE DHL_SI_MonitorTVCT(DS_U32 RF, DS_U32 nRequestID);
DHL_HANDLE DHL_SI_MonitorCVCT(DS_U32 RF, DS_U32 nRequestID);
DHL_HANDLE DHL_SI_MonitorMGT(DS_U32 RF, DS_U32 nRequestID);
DHL_HANDLE DHL_SI_MonitorSTT(DS_U32 RF, DS_U32 nRequestID);

DHL_HANDLE DHL_SI_MonitorRFUpdate(DS_U32 RF, DS_U32 nRequestID);

DHL_HANDLE DHL_SI_MonitorSCTE_CVT(DS_U32 RF, DS_U32 nRequestID);
DHL_HANDLE DHL_SI_MonitorSCTE_DII(DS_U32 RF, DS_U32 nRequestID, DS_U16 pid);
DHL_HANDLE DHL_SI_MonitorSCTE_DDB(DS_U32 RF, DS_U32 nRequestID, DS_U16 pid);


// Monitoring Stop
DHL_ERROR DHL_SI_MonitorStop(DHL_HANDLE* handle);

#if 0
____Tuner___()
#endif

typedef enum  // A65 Table 6.5 Modulation Modes
{
	DHL_MODULATION_NULL,
	DHL_MODULATION_64QAM = 2,
	DHL_MODULATION_256QAM = 3,
	DHL_MODULATION_8VSB = 4,
	DHL_MODULATION_16VSB =5
} DHL_MODULATION_MODE;

// Ʃ 
// DHL_ERROR DHL_TUN_Start(int rf, DHL_MODULATION_MODE nMode = DHL_MODULATION_8VSB);
DHL_ERROR DHL_TUN_Start(int rf, DHL_MODULATION_MODE nMode);
// Ʃ 
DHL_ERROR DHL_TUN_Stop();

// ȣ
//    0-10000
// SignalStrength ȣ
// BERA  Bit Error Rate
// BERB  Ǯ Bir Error Rate
DHL_ERROR DHL_TUNE_Info(DS_U8 RF, int *SignalStrength, bool *bLock, int *power, int *nSNR);

#if 0
____CAS___()
#endif

// ī 
DHL_ERROR DHL_CAS_Transaction(DS_U8 Cmd[188], DS_U8 nCmdLen, DS_U8 Ret[188]);

// Multi2 PID 
// Video Audio CC PID Ѵ.
DHL_ERROR DHL_CAS_SetPid(DS_U16 Pid);

// Multi2 PID ʱȭ
// DHL_CAS_SetPid     ʱȭѴ.
DHL_ERROR DHL_CAS_ResetPid();


void DHL_GFX_Open();
void DHL_GFX_Draw(OSD_PIXEL_T *src, int x, int y, int w, int h);


#if 0
____IR___()
#endif

// Űе  ´.
// 1 : POWER 2:UP 3:DN
DS_U8 DHL_GetKeyPadGPIO();

void DHL_SetLED(bool bRed, bool bGreen);

void DHL_SetCh34(DS_U8 nVal);
#if 0
____OS___()
#endif

DS_U32 DST_OS_GetTickCount();
void DST_OS_Delay(DS_U32 Ticks);
DS_U32 DST_OS_GetTicksPerSecond();
void DST_OS_GetRunTime(DS_U32 *hour, DS_U32 *min, DS_U32 *sec);
DS_U32 DST_OS_SpawnTask (void (*func)(void* ), char *name, DS_U16 prio, DS_U16 stacksize, DS_U32 arg);
void DST_OS_SelfDeleteTask();

DS_U32 DST_OS_CreateMessageQueue (const char *name, DS_U32 option, DS_U32 maxMessage, DS_U32 messageLength);
DS_U32 DST_OS_DeleteMessageQueue(DS_U32 qId);
DS_U32 DST_OS_ReceiveMessage_Wait(DS_U32 qId, DS_U32 *msgBuf, DS_U32 maxLen, DS_U32 *retLen, DS_U32 timeOut);
DS_U32 DST_OS_ReceiveMessage_NoWait(DS_U32 qId, DS_U32 *msgBuf, DS_U32 maxLen, DS_U32 *retLen);
DS_U32 DST_OS_SendMessage (DS_U32 qId, DS_U32 *pBuffer, DS_U32 nBytes);

DS_U32 DST_OS_CreateLock(char *name);
void DST_OS_Lock(DS_U32 id);
void DST_OS_Unlock(DS_U32 id);

void *_DST_OS_Malloc(unsigned int size, const char* func, int nLine);
void *_DST_OS_Calloc(unsigned int count, unsigned int size, const char* func, int nLine);
void _DST_OS_Free(void *where, const char* func, int nLine);

void DST_OS_PrintMemUnit(void);
#define DST_OS_Malloc(a)    _DST_OS_Malloc(a, __func__, __LINE__)
#define DST_OS_Calloc(a, b) _DST_OS_Calloc(a, b, __func__, __LINE__)
#define DST_OS_Free(block)  {		\
                                _DST_OS_Free(*(void **)block, __func__, __LINE__);		\
                                *(void **)block =NULL;		\
														}
///*extern "C" */void *DST_OS_MallocDirect(int size); // malloc
///*extern "C" */void *DST_OS_CallocDirect(int num, int size); // calloc
///*extern "C" */void *DST_OS_ReallocDirect(void *ptr, int size); // realloc
///*extern "C" */void DST_OS_FreeDirect( void *ptr); // free
///*extern "C" */int DST_OS_MemSize(void *ptr);

#if 0
____POWER___()
#endif

void DHL_SYS_Off();
void DHL_SYS_Reboot();
void DHL_POWER_Display(bool bOn);

// Return  0̸ Bank0 1̸ Bank1
bool DHL_INFO_GetBankNumber();
void DHL_INFO_SetBankNumber(DS_U8 data);

bool DHL_INFO_GetLastPowerState();
void DHL_INFO_SetLastPowerState(bool bOn);
#if 0
____Flash_Memory___()
#endif


extern DS_U32 FLASH_TOTAL_SIZE;
//#define FLASH_TOTAL_SIZE    (8*1024*1024)

#define FLASH_BOOT_POS      (0)
#define FLASH_BOOT_SIZE     (192 * 1024)

#define FLASH_BANK0_POS   (0x0030000)

extern DS_U32 FLASH_BANK1_POS;
//#define FLASH_BANK1_POS   (0x400000)
#define FLASH_BANK_SIZE     (3768*1024)

#define FLASH_BANK_SELECT_POS (0x3DE000)
#define FLASH_BANK_SELECT_SIZE (4*1024)

#define FLASH_LAST_POWER_POS (0x3DF000)
#define FLASH_LAST_POWER_SIZE  (4*1024)

#define FLASH_CH_MAP_POS (0x3E0000)
#define FLASH_CH_MAP_SIZE (128*1024)

void DHL_Flash_Write(DS_U32 address, DS_U32 nSize, DS_U8 *data);
// ȣ ʿ ޸  ʿ
DS_U8* DHL_Flash_Read(DS_U32 address, DS_U32 nSize);

// ministd  ʴ stdc Լ
int dst_atoi(char *st);

#endif // __DST_EROUM_INTERFACE_H__
