#include "DST_WinManager.h"
#include "DST_CommonAPI.h"
#include "DST_ChannelTune.h"
#include "DST_DB_Engine.h"
#include "DST_DB.h"

static bool bCCEngineReady = false;

static bool bAutoDetectUnicode = false; // CC ͸ мϿ ڵ ϼ ڵ ˾Ƴ.

void DST_708_Callback(DS_U8 *bytearray,int size)
{
	if (size == 0) return;
	if (bCCEngineReady == false) return;
	// Sequence Header ùٸ Ȯغ.
	if (size == -1) // Sequence Header   
	{
		DST_Printf("Sequence Header Error\n");
		DST_SendWindowEventWithOnlyCmd(WM_SEQ_ERROR);
		return;
	}

	if (size > 31) return;

	int nCharTotal = 0;
	int nCharLatin = 0;
	int nCharWanSung = 0;
	
	for (int i=0; i < size-2; i++)
	{
		if (bytearray[i] != 0x18) continue;
		nCharTotal++;
		if (bytearray[i+1] == 0)
		{
			nCharLatin++;
		}
		if (bytearray[i+1] >= 0xA1 && bytearray[i+1]  <= 0xFE && bytearray[i+2] >= 0xA1 && bytearray[i+2] <= 0xFE) 
		{
			nCharWanSung++;
		}
		i+=2;
	}
	bool isWanSung = true;
	//DST_Printf("nCharTotal = %d\n", nCharTotal);
	//DST_Printf("nCharLatin = %d\n", nCharLatin);
	//DST_Printf("nCharWanSung = %d\n", nCharWanSung);
	//  CC ڰ ִٸ    е δ.
	if (nCharTotal > 0)
	{
		//T();
		DST_g_CC_DataReceiveTick = DST_OS_GetTickCount();
	}
	if (DST_EEPROM_GetCC() == 0) return; //  CC   Ʈ ϰ CC  
			
	int nCount = nCharTotal - nCharLatin;
	if (nCount < 0) nCount = 0;
	if (nCount > 0)
	{
		if ((nCharWanSung * 100 /  nCount) < 50) isWanSung = false;
	}
	//DST_Printf("isWanSung = %d\n", isWanSung);	
	
	bAutoDetectUnicode = !isWanSung; // ڵ  ڵ

	SWinEventMsg msg;
	msg.cmd = WM_CS1;
	msg.data[0] = size;
	memcpy(&msg.data[1], bytearray, size);
	DST_SendWindowEvent(msg);
}

typedef void (*CC708_CallBack)(DS_U8 *bytearray,int size);
extern "C" void SetCC708_CallBack(CC708_CallBack callback);


static bool DST_CCAvailable()
{
	if (DST_g_SignalState != SM_GOOD_SIGNAL) return false; // ȣ °  쿡 CC ֵ 
//	if (DST_g_SleepState != 0) return false; // normal ° ƴϸ CC ݴ´
	if (DST_EEPROM_GetCC() == 0) return false;
	if (DST_g_LastTuneTime == 0) return false;
	if (DST_IsVideoPlay() == false) return false;
	if (DST_g_LastTuneTryTime > DST_OS_GetTickCount()) DST_g_LastTuneTryTime = DST_OS_GetTickCount();
	if (DST_OS_GetTickCount() - DST_g_LastTuneTryTime < DST_OS_GetTicksPerSecond() * 3) return false;
	for (int id = (int)WIN_NULL+1; id < (int)WIN_CAPTION; id++)
	{
		if (id == WIN_VOLUME) continue;
		if (id == WIN_VOLUME_MUTE) continue;
		if (DST_GetWin((DST_WinID)id)) return false;
	}
	return true;
}
 
static void tCCManager()
{
	DST_OS_Delay(DST_OS_GetTicksPerSecond()*3); // 3  
	bCCEngineReady = true;
	DST_CreateWin(WIN_CAPTION, WIN_NULL, 1); 
	while (1)
	{
		DST_OS_Delay(DST_OS_GetTicksPerSecond()/10);
		CWindow *pWin = DST_GetWin(WIN_CAPTION);
		if (DST_CCAvailable())
		{
			if (pWin) continue;
			DST_CreateWin(WIN_CAPTION, WIN_NULL, 1);
			for (int i = 0; i < 5; i++)
			{
				DST_OS_Delay(DST_OS_GetTicksPerSecond()/10);//  찡 ɶ  
				if (DST_GetWin(WIN_CAPTION)) break;
			}
		}
		else
		{
			if (pWin == 0) continue;
			DST_SendWindowEventWithOnlyCmd(WM_CC_CLOSE);
			for (int i = 0; i < 5; i++)
			{
				DST_OS_Delay(DST_OS_GetTicksPerSecond()/10);//  찡 ɶ  
				if (DST_GetWin(WIN_CAPTION)==0) break;
			}
		}
	}
}

void DST_CCManagerInit()
{
	static int TaskID = 0;
	if (TaskID != 0) return;
	TaskID = DST_OS_SpawnTask((void(*)(void *))tCCManager, (char*)"CCManager", APP_TASK_PRIO_CC_MGR, WIN_MGR_TASK_STACKSIZE,  0);
}

void DST_CheckCCDescription(DS_U8 /*nServiceNumber*/, bool *bKorean, bool *bWideScreen, bool *bUnicode)
{
	*bKorean = DST_g_CC_bCCKorean;
	*bWideScreen = DST_g_CC_bWideScreen;
	//*bUnicode = DST_g_CC_bUnicode; // CC ũ 
	*bUnicode = bAutoDetectUnicode;  // ڵ 
}
