#ifndef __DST_TYPES_H__
#define __DST_TYPES_H__

#ifndef DS_U32
typedef unsigned long     DS_U32;
#endif

#ifndef DS_S32
typedef long              DS_S32;
#endif

#ifndef DS_U16
typedef unsigned short    DS_U16;
#endif

#ifndef DS_S16
typedef short             DS_S16;
#endif

#ifndef DS_U8
typedef unsigned char     DS_U8;
#endif

#ifndef DS_S8
typedef char              DS_S8;
#endif

#define OSD_PIXEL_BPP   32
#if (OSD_PIXEL_BPP==16)
#define OSD_PIXEL_T DS_U16
#else
#define OSD_PIXEL_T DS_U32
#endif

#if (OSD_PIXEL_BPP==16)
#define CONV32_16(x)    ((((x)&0x000000F0)>>4)|(((x)&0x0000F000)>>8)|(((x)&0x00F00000)>>12)|(((x)&0xF0000000)>>16))
#else
#define CONV32_16(x)    (x)
#endif

#endif /* __DST_TYPES_H__ */
