#include "DST_WinManager.h"
#include "DST_ChannelTune.h"
#include "DST_SignalMonitor.h"

#include "DST_DataStrings.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"

#include "DST_ISDBT_ChannelTask.h"
#include "DST_ChannelTune.h"
#include "DST_DB.h"
#include "DST_DB_Engine.h"

#define AS_RF_W			77
#define AS_CH_NO_W		111
#define AS_CH_NAME_W	364

#define PROGRESS_BAR_X	33
#define PROGRESS_BAR_Y	266
#define PROGRESS_BAR_W	333


class CAutoSearchWin : public CWindow
{
private:
	int m_nState;
	int m_nRF; // ĵ ġ
	CHANNEL_DISPLAY ch[4];
	DS_U8 nAutoSearchMode;
	int nChCount[255];
	bool bTimeOut;
	bool bReceivePSIP; 
	bool bReceivePMT;
	bool bCanceled; 
	DS_U16 g_nPos;
	DS_U16 g_nTop;
	DS_U16 mainSelect;
	DS_U16 mainListNum;
	DS_U16 mainItemNum;
public:
	CAutoSearchWin(SWinEventMsg event):CWindow(event)
	{
		bCanceled = false;
		bTimeOut = false; 
		bReceivePSIP = false;
		bReceivePMT = false;
		
		nAutoSearchMode = 1; // 0 Ʈ 1 ĵ
		InitValues();
		
//		DST_Printf("nAutoSearchMode = %d\n", nAutoSearchMode);
		rect.w = DST_GetImageWidth(newcon2_gui_autoscan_back);
		rect.h = DST_GetImageHeight(newcon2_gui_autoscan_back);
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = (DST_GetScreenHeight()- rect.h) / 2;
		
		RegisterAllKey();
		RegisterKey(VK_PWR, false);
		
		memset(DST_g_SignalStrength, 0, sizeof(DST_g_SignalStrength));// ĵ ʱȭ
		SetTimeOut(0);
		m_nState = 0; // ĵ 
		m_nRF = DST_MinRF();
		memset(ch, 0, sizeof(ch));
		memset(nChCount, 0, sizeof(nChCount));

		/*if(DST_DB_GetChannelCount() == 0)*/ KeyInput(VK_OK, false);
	}

	virtual ~CAutoSearchWin()
	{
		T();
		T();
		T();
		T();
		T();
	}
	
	void InitValues(void)
	{
		mainItemNum = 2;
		g_nTop = 0;
		g_nPos = 0;
		mainSelect = nAutoSearchMode;
		
		mainListNum = 2;
		if (mainItemNum < mainListNum) mainListNum = mainItemNum;
		
		InitItemValues(mainListNum, mainSelect, &g_nTop, &g_nPos);
	}
	
	void AddChList(int rf, int major, int minor, char* name)
	{
		int nPos = 4;
		for (int i = 0; i < 4; i++)
		{
			if (strlen(ch[i].num) != 0) continue;
			nPos = i;
			break;
		}
		if (nPos > 3) 
		{
			nPos = 3;
			memcpy(&ch[0], &ch[1], sizeof(CHANNEL_DISPLAY)* 3);
		}
		if (minor == 0)
		{
			sprintf(ch[nPos].num, "%d(%d)", major, DST_GetFrequencyNumberbyIndex(rf));
		}
		else
		{
			sprintf(ch[nPos].num, "%d-%d(%d)", major, minor, DST_GetFrequencyNumberbyIndex(rf));
		}
		strcpy((char*)ch[nPos].name, (char*)name);
	}
	void AddChList(int RF)
	{
		CDB db;
		db.GetTable("select major, minor, name from channel_db where rf =%d order by major,minor", RF);
		if (db.GetRow() < 1) return;
		nChCount[RF] = db.GetRow();
		for (int i = 0; i < db.GetRow(); i++)
		{
			AddChList(RF, 
				atoi(db.GetResult((i+1)*db.GetCol()+0)), 
				atoi(db.GetResult((i+1)*db.GetCol()+1)), 
				db.GetResult((i+1)*db.GetCol()+2));
		}
	}
	
	void Scan(int nRF)
	{
		if (bCanceled) return;
		JST_Scan(nRF);
		m_nState = 1; //ĵ
		m_nRF = nRF;
		T();
	}

	void ScanComplete()
	{
		DST_DB_TuneFirstChannel();
		m_nState = 2;	// ĵ 
		Draw(m_nState, m_nRF);
		SetTimeOut(5);
	}	

	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
				
			case WM_CT_MSG:
				switch (event.data32[0])
				{
					case CT_STOPPED:
						m_nState = 2;
						Draw(m_nState, m_nRF);
						ScanComplete();
						break;
						
					case CT_SCAN_START:
						T();
						Draw(m_nState, event.data32[1]);
						bTimeOut = false; // LOCK ȵǰų PSIP ޾Ƽ ŸӾƿ  
						bReceivePSIP = false; // PSIP ޾Ҵ.
						bReceivePMT = false; //PMT ޾Ҵ. VCT  ä  ִ
						break;
					
					case CT_SCAN_PSIP_WAIT:
						DST_Printf("CT_SCAN_PSIP_WAIT %d %d %d\n", (int)event.data32[1], (int)event.data32[2], (int)event.data32[3]);
						if (bReceivePSIP == true) break;
						if (bTimeOut == true) break;
						if ((int)event.data32[1] != m_nRF) break;
						if (event.data32[2] < 7000) break;
						DST_Printf("CT_SCAN_PSIP_WAIT timeout\n");
						bTimeOut = true;
						
						//  ä .
						if (bReceivePMT == false && nAutoSearchMode == 1) // 0 Ʈ 1 ĵ
						{
							JST_DB_Del(m_nRF);
						}
						 if (bReceivePMT == true) // PSIP äϼ ִ.
						 {
						 	AddChList(event.data32[1]);
						}
						if (event.data32[1] >= DST_MaxRF())
						{
							ScanComplete();
						}
						else
						{
							Scan(event.data32[1]+1);
						} 
						break;
							
					case CT_SCAN_LOCK_WAIT:
						DST_Printf("CT_SCAN_LOCK_WAIT %d %d %d\n", (int)event.data32[1], (int)event.data32[2], (int)event.data32[3]);
						if (bReceivePSIP == true) break;
						if (bTimeOut == true) break;
						if ((int)event.data32[1] != m_nRF) break;
						if (event.data32[2] < 700) break; // 700ms ̳ 
						if (event.data32[3] > 0) break; // lock Ǿ ִٸ 
						DST_Printf("CT_SCAN_LOCK_WAIT timeout\n");
						bTimeOut = true;
						
						//  ä .
						if (bReceivePMT == false && nAutoSearchMode == 1) // 0 Ʈ 1 ĵ 2: ġ
						{
							JST_DB_Del(m_nRF);
						}
						  if (bReceivePMT == true) // PSIP äϼ ִ.
						 {
						 	AddChList(event.data32[1]);
						}
						if (event.data32[1] >= DST_MaxRF())
						{
							ScanComplete();
						}
						else
						{
							Scan(event.data32[1]+1);
						} 
						break;
					
					case CT_SCAN_RECEIVE_TVCT:
					case CT_SCAN_RECEIVE_CVCT:
						DST_Printf("CT_SCAN_RECEIVE_TVCT\n");
						if (bReceivePSIP == true) break;
						if (bTimeOut == true) break;
						bReceivePSIP = true;
						AddChList(event.data32[1]);
						if (event.data32[1] >= DST_MaxRF())
						{
							ScanComplete();
						}
						else
						{
							Scan(event.data32[1]+1);
						} 
						break;
						
					case CT_SCAN_RECEIVE_PMT:
						DST_Printf("CT_SCAN_RECEIVE_PMT %d %d %d\n", (int)event.data32[1], (int)event.data32[2], (int)event.data32[3]);
						bReceivePMT = true;
						break;
					case CT_SCAN_RECEIVE_PAT:
						DST_Printf("CT_SCAN_RECEIVE_PAT\n");
						break;
				}
				break;
		}
	}
	
	virtual void Show(void)
	{
		Draw(m_nState, m_nRF);
	}
	
	DS_U16* GetString(int index)
	{
		switch(index)
		{
			case 0: return pz_Scan_Update[OSD_Lang];
			case 1: return pz_Scan_Rescan[OSD_Lang];
			default: break;
		}
		return 0;
	}	
	
	// nState == 0; //   ư 
	// nState == 1; //    ư
	// nState == 2; //     ư
	void Draw(int nState, int nRF)
	{
		// 
		DrawImage(0, 0, newcon2_gui_autoscan_back);
		// ŸƲ
		setFontStyle(20,0xC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
		// ׸ ̸  äιȣ RF ä̸ 
#if DESIGN_TYPE == 1
		DrawTextUni( 27, 10,  118, 29, pz_Scan_NoRF[OSD_Lang], &font);
		DrawTextUni(174, 10, 176, 29, pz_chName[OSD_Lang], &font);
#else
		DrawTextUni( 10, 10,  171, 29, pz_Scan_NoRF[OSD_Lang], &font);
		DrawTextUni(184, 10, 169, 29, pz_chName[OSD_Lang], &font);
#endif


		// ư ׸
		
		setFontStyle(19,0xC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
		DrawImage(390, 12, newcon2_gui_depth3_button_small_selected,true);
		//DrawImage(390, 61, newcon2_gui_depth3_button_small_selected,true);
		DrawTextUni(390, 12, DST_GetImageWidth(newcon2_gui_depth3_button_small_selected), 38, pz_Scan_Update[OSD_Lang], &font);
		//DrawTextUni(390, 61, DST_GetImageWidth(newcon2_gui_depth3_button_small_selected), 38, pz_Scan_Rescan[OSD_Lang], &font);
#if DESIGN_TYPE == 1
#else
				setFontStyle(19,0x000000,ALIGN_MIDDLE,ALIGN_CENTER);
#endif

		//if(mainSelect == 0)
		//{
			DrawImage(390, 12, newcon2_gui_depth3_button_small_cursor,true);
			DrawTextUni(390, 12, DST_GetImageWidth(newcon2_gui_depth3_button_small_selected),  DST_GetImageHeight(newcon2_gui_depth3_button_small_selected), (nState==1)?pz_Stop[OSD_Lang]:GetString(mainSelect), &font);
		//}
		//else
		//{
			//DrawImage(390, 61, newcon2_gui_depth3_button_small_cursor,true);
			//DrawTextUni(390, 61, DST_GetImageWidth(newcon2_gui_depth3_button_small_selected),  DST_GetImageHeight(newcon2_gui_depth3_button_small_selected), (nState==1)?pz_Stop[OSD_Lang]:GetString(mainSelect), &font);
		//}
		
		setFontStyle(20,0xC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
		// ׸ ǥ
		for (int i=0; i < 4; i++)
		{
			if (strlen(ch[i].num) == 0) continue;
			DS_U32* strText32 = DST_UTF82Uni((DS_U8*)ch[i].name); // ȣ ʿ ޸ 
			// ä ȣ , RF
#if DESIGN_TYPE == 1
			// RF
			//sprintf(strText, "(%d) %02d", ch[i].rf, ch[i].num);
			DrawText( 27, 10+(i+1)*36,	118, 29,  ch[i].num, &font);
			// ä ̸
			DrawText32(174, 10+(i+1)*36, 174, 29, strText32, &font);
#else
			// RF
			//sprintf(strText, "(%d) %02d", ch[i].rf, ch[i].num);
			DrawText( 10, 10+(i+1)*36,	171, 29,  ch[i].num, &font);
			// ä ̸
			DrawText32(184, 10+(i+1)*36, 169, 29, strText32, &font);
#endif
//			DST_OS_Free(&strText32);

		}
		// 
		int nProg = 0;
		switch (nState)
		{
			case 0: nProg = 0; break;
			case 1: nProg = nRF - DST_MinRF() + 1; break;
			case 2: nProg = DST_MaxRF() - DST_MinRF()+1; break;
		}
		DST_Printf("nProg = %d\n", nProg);
		
#if DESIGN_TYPE == 1
		DrawProgressBar(36, 211, 291,  DST_MaxRF() - DST_MinRF() +1, nProg);
#else
		DrawProgressBar(13, 210, 338,  DST_MaxRF() - DST_MinRF() +1, nProg);
#endif
		

				
		// Ȳ 
		// 5 channels found. searching...
		
		int nTotalCount = 0;
		for (int i = 0; i <= nRF; i++) nTotalCount+=nChCount[i];

		if( m_nState == 0 ) 
		{
			UpdateScreen();
			return;
		}
		
		if(nTotalCount == 0 && m_nState == 1)
		{
			//DrawTextUni(366, 166, 148, 29, pz_Searching[OSD_Lang], &font);
		}
		else
		{
			if (nTotalCount)
			{
				char strTextNum[20];
				sprintf(strTextNum, " %d", nTotalCount);
				DS_U16 strText16[64];
				str2uni(strText16, strTextNum);
				strcat16(strText16, pz_Scan_ChannelFound[OSD_Lang]);
				DrawTextUni(366-15, 166, 148+30, 29, strText16, &font);
			}
		}

			
		
		UpdateScreen();
		
	}

	void DrawProgressBar(int x, int y, int w, int range, int pos)
	{
		DST_Printf("range = %d pos = %d\n", range, pos);
		int position = (w*pos)/(range);

		for (int i = x; i < x+position; i++)
		{
			DrawImage(i, y, newcon2_gui_progress_yellow,true);
		}
	}

	virtual void KeyInput(unsigned char key, bool /*bRepeat*/)
	{
		switch(key)
		{
//			case VK_UP:
//			case VK_DN:
//				if(m_nState==1) break;
//				if(key == VK_UP)
//					ItemIncrease(mainItemNum, 2, &g_nTop, &mainSelect, &g_nPos);
//				else
//					ItemDecrease(mainItemNum, 2, &g_nTop, &mainSelect, &g_nPos);
//				Draw(m_nState, m_nRF);
//				break;
			case VK_OK: 
				if(nAutoSearchMode == mainSelect && m_nState == 1)
				{
					bCanceled = true;
					JST_Stop();
					ScanComplete();			
				}
				else
				{
					SetTimeOut(0);
					bCanceled = false;
					m_nRF = DST_MinRF();
					memset(ch, 0, sizeof(ch));
					memset(nChCount, 0, sizeof(nChCount));
					// nAutoSearchMode=mainSelect; ׻ ʱ ĵ̴.
					Scan(m_nRF);
					Draw(m_nState, m_nRF);
				}
				break;
			case VK_CANCEL:
			case VK_MENU:
				m_nState = 0;
				bCanceled = true;
				JST_Stop();
				ScanComplete();
				Close();
				break;
		}
	}
};

void DST_CreateAutoSearchWin(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CAutoSearchWin(event));
}
