#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"
#include "DST_DB_Engine.h"

#if 0
____CPowerDownCautionWin___()
#endif

struct DBNAMES
{
	char* name;
};

struct ATTRIBUTES
{
	DS_U8 type;
	char* name;
};

char * g_name;

class CDebugSQLWin : public CWindow
{
private:
	DS_U16 Pos;
	DS_U16 Top;
	DS_U16 Select;
	DS_U16 ListNum;
	DS_U16 ItemNum;

	DS_U16 pre_Pos;
	DS_U16 pre_Top;
	DS_U16 pre_Select;
	DS_U16 pre_ListNum;
	DS_U16 pre_ItemNum;

	DBNAMES* names;
public:
	CDebugSQLWin(SWinEventMsg event):CWindow(event)
	{
		InitValues();
		rect.w = 576;
		rect.h = 384;
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = (DST_GetScreenHeight() - rect.h) / 2;

		SetTimeOut(0);

		RegisterKey(VK_CANCEL, true);
		RegisterKey(VK_PREV, true);
		RegisterKey(VK_PREV_MENU, true);
		RegisterKey(VK_OK, true);
		RegisterKey(VK_RIGHT, true);
		RegisterKey(VK_LEFT, true);
		RegisterKey(VK_UP, true);
		RegisterKey(VK_DN, true);
	}

	virtual ~CDebugSQLWin()
	{
		if (names) 
		{
			for (int i = 0; i < ItemNum; i++) if (names[i].name) DST_OS_Free(&names[i].name);
			DST_OS_Free(&names);
		}

	}
	
	void InitValues(void)
	{		
		names = 0;
		Pos = 0;
		Top = 0;
		Select = 0;
		ListNum = 30;
		ItemNum = 0;

		pre_Pos = Pos;
		pre_Top = Top;
		pre_Select = Select;
		pre_ListNum = ListNum;
		pre_ItemNum = ItemNum;
		
		UpdateList();
		if (ItemNum < ListNum) ListNum = ItemNum;
	}
	void UpdateList(void)
	{
		if (names) 
		{
			for (int i = 0; i < ItemNum; i++) if (names[i].name) DST_OS_Free(&names[i].name);
			DST_OS_Free(&names);
		}
		names = GetDBTableName(&ItemNum);	
	}
	

	DBNAMES* GetDBTableName(DS_U16 *size)
	{

		CDB db;
		db.GetTable("SELECT name FROM sqlite_master where type='table' order by name");
		*size = db.GetRow();
		if (*size < 1) return 0;
		DBNAMES* n = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), *size);
//		DST_Printf("size = %d\n\n\n",*size);
		for (int i = 0; i < *size; i++)
		{
			int nLen = strlen(db.GetResult((i+1)*db.GetCol()+0));
			n[i].name = 0;
			n[i].name = (char*)DST_OS_Calloc((nLen+1)*sizeof(char),1);
			memcpy(n[i].name,db.GetResult((i+1)*db.GetCol()+0),nLen);
			
//			DST_Printf("nLen=%d  ",nLen);
//			DST_Printf("n[%d].name=%s\n",i,n[i].name);
		}
		return n;
	}

	virtual void Show(WinID id)
	{
//		DST_Printf("id=%d\n",id);
//		switch(id)
//		{
//			case WIN_ERROR:
//			case WIN_POWER_DOWN_CAUTION:
//				break;
//			default:
//				KillTimer(1);
//				Close();
//				break;
//		}
	}

	virtual void Show()
	{
		DrawAll();

	}	

	void DrawAll()
	{
		setFontStyle(15, 0xAAC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);

		DrawBox32(0, 0, rect.w, rect.h, CONV32_16(0xAA262626));

		for(int x=0;x<3;x++)
		{
			for(int y=0;y<10;y++)
			{
				if(ItemNum > y+x*10)
				{
					if(Select+Top == y+x*10)
						DrawBox32(2+x*192, 84+2+y*30, 192-4, 30-4, CONV32_16(0xAA1C3923));
					else
						DrawBox32(2+x*192, 84+2+y*30, 192-4, 30-4, CONV32_16(0xAAFFA52C));
					DrawText(2+x*192, 84+2+y*30, 192-4, 30-4,names[y+x*10].name,&font);
//					DST_Printf("n[%d].name=%s\n",y+x*10,names[y+x*10].name);
					
				}
			}
		}
		
	}

	void Draw()
	{
		setFontStyle(15, 0xAAC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);


		for(int x=0;x<3;x++)
		{
			for(int y=0;y<10;y++)
			{
				if(ItemNum > y+x*10)
				{
					if(Select+Top == y+x*10)
						DrawBox32(2+x*192, 84+2+y*30, 192-4, 30-4, CONV32_16(0xAA1C3923));
					else
						DrawBox32(2+x*192, 84+2+y*30, 192-4, 30-4, CONV32_16(0xAAFFA52C));
					DrawText(2+x*192, 84+2+y*30, 192-4, 30-4,names[y+x*10].name,&font);
				}
			}
		}
		
	}
		
	virtual void OnTimer(char nID)
	{
		switch(nID)
		{
			case 1:
				break;
		}
	}	

	virtual void KeyInput(DS_U8 key,bool)
	{
		switch(key)
		{
			case VK_PREV:
			case VK_PREV_MENU:
			case VK_CANCEL: 
				if (DST_GetWin(WIN_ENGINEER_MODE)==0) DST_CreateWin(WIN_ENGINEER_MODE);
				Close();
				break;
			case VK_OK: 
//				if(g_name) DST_OS_Free(&g_name);
				g_name = names[Select+Top].name;
				DST_CreateWin(WIN_DEBUG_SQL_SUB);
				SetVisible(false);
				break;
			case VK_RIGHT: break;
			case VK_LEFT: break;
			case VK_UP:
			case VK_DN:
				if(key == VK_DN)
					ItemIncrease(ItemNum, ListNum, &Top, &Select, &Pos);
				else
					ItemDecrease(ItemNum, ListNum, &Top, &Select, &Pos);
				Draw();
				break;

		}
	}
};


void DST_CreateDebugSQLWin(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CDebugSQLWin(event));
}

class CDebugSQLSubWin : public CWindow
{
private:
	DS_U16 RowPos;
	DS_U16 RowTop;
	DS_U16 RowSelect;
	DS_U16 RowListNum;
	DS_U16 RowItemNum;

	DS_U16 ColPos;
	DS_U16 ColTop;
	DS_U16 ColSelect;
	DS_U16 ColListNum;
	DS_U16 ColItemNum;

	DS_U16 pre_RowPos;
	DS_U16 pre_RowTop;
	DS_U16 pre_RowSelect;
	DS_U16 pre_RowListNum;
	int pre_RowItemNum;

	DS_U16 pre_ColPos;
	DS_U16 pre_ColTop;
	DS_U16 pre_ColSelect;
	DS_U16 pre_ColListNum;
	DS_U16 pre_ColItemNum;

	DBNAMES * results;
	ATTRIBUTES * attributes;
public:
	CDebugSQLSubWin(SWinEventMsg event):CWindow(event)
	{
		InitValues();
		rect.w = 576;
		rect.h = 384;
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = (DST_GetScreenHeight() - rect.h) / 2;

		SetTimeOut(0);

		RegisterKey(VK_CANCEL, true);
		RegisterKey(VK_PREV, true);
		RegisterKey(VK_PREV_MENU, true);
		RegisterKey(VK_OK, true);
		RegisterKey(VK_RIGHT, true);
		RegisterKey(VK_LEFT, true);
		RegisterKey(VK_UP, true);
		RegisterKey(VK_DN, true);

	}

	virtual ~CDebugSQLSubWin()
	{
		if (results)
		{
			for(int i=0;i<RowItemNum;i++)
			{
				for(int j=0;j<ColItemNum;j++)
				{
					if(results[i*ColItemNum+j].name)
					DST_OS_Free(&results[i*ColItemNum+j].name);
				}
			}
			T();
			DST_OS_Free(&results);			
		}
		if(attributes)
		{
			for(int j=0;j<ColItemNum;j++)
			{
				if(attributes[j].name)	DST_OS_Free(&attributes[j].name);
			}
			DST_OS_Free(&attributes);
		}
	}
	
	void InitValues(void)
	{					
		results = 0;
		attributes = 0;

		RowPos = 0;
		RowTop = 0;
		RowSelect = 0;
		RowListNum = 10;
		RowItemNum = 0;
		
		ColPos = 0;
		ColTop = 0;
		ColSelect = 0;
		ColListNum = 5;
		ColItemNum = 0;

		pre_ColItemNum = ColItemNum;
		pre_ColListNum = ColListNum;
		pre_ColTop = ColTop;
		pre_ColSelect = ColSelect;
		pre_ColPos = ColPos;				
	
		pre_RowItemNum = RowItemNum;
		pre_RowListNum = RowListNum;
		pre_RowTop = RowTop;
		pre_RowSelect = RowSelect;
		pre_RowPos = RowPos;

		GetDBResult();

		if (RowItemNum < RowListNum) RowListNum = RowItemNum;
		if (ColItemNum < ColListNum) ColListNum = ColItemNum;

	}

	void GetDBResult()
	{
		if(g_name == 0) return;
		
		CDB db;
		if(db.GetTable("SELECT * FROM %s ", g_name)) return;
		
		RowItemNum = db.GetRow();
		ColItemNum = db.GetCol();

		if(RowItemNum == 0) return;
		if(ColItemNum == 0) return;
		
//			DST_Printf("RowItemNum = %d, ColItemNum = %d\n",RowItemNum,ColItemNum);
		
		results = (DBNAMES *)DST_OS_Calloc(sizeof(DBNAMES), RowItemNum*ColItemNum);
		attributes = (ATTRIBUTES *)DST_OS_Calloc(sizeof(ATTRIBUTES), ColItemNum);

		for(int i=0;i<ColItemNum;i++)
		{
			int nLen = strlen(db.GetResult(i));
			attributes[i].type = 0;
			attributes[i].name = 0;
			attributes[i].name = (char*)DST_OS_Calloc((nLen+1)*sizeof(char),1);
			memcpy(attributes[i].name,db.GetResult(i),nLen);			
		}
		
		for(int i=0;i<RowItemNum;i++)
		{
			for(int j=0;j<ColItemNum;j++)
			{
				int nLen = strlen(db.GetResult((i+1)*ColItemNum+j));
				results[i*ColItemNum+j].name = 0;
				results[i*ColItemNum+j].name = (char*)DST_OS_Calloc((nLen+1)*sizeof(char),1);
				memcpy(results[i*ColItemNum+j].name,db.GetResult((i+1)*ColItemNum+j),nLen);
//					DST_Printf("results[%d]=%s\n",i*ColItemNum+j,results[i*ColItemNum+j].name);
			}
		}

		//  迭  ؼ Ȯ
//			for(int i=0;i<RowItemNum;i++)
//			{
//				for(int j=0;j<ColItemNum;j++)
//				{
//					DST_Printf("%s ",results[i*ColItemNum+j].name);
//				}
//				DST_Printf("\n");
//			}

		
		db.GetTable("pragma table_info(%Q)",g_name);
		if(db.GetRow() < 1 || db.GetRow() != ColItemNum) return;
		for(int i=0;i<db.GetRow();i++)
		{
			int rc = strcmp((char *)"int",db.GetResult((i+1)*db.GetCol()+2));
			attributes[i].type = (rc == 0)?1:0;
		}



	}

	virtual void Show(WinID id)
	{
//		DST_Printf("id=%d\n",id);
//		switch(id)
//		{
//			case WIN_ERROR:
//			case WIN_POWER_DOWN_CAUTION:
//				break;
//			default:
//				KillTimer(1);
//				Close();
//				break;
//		}
	}

	virtual void Show()
	{
		DrawAll();
	}	

	void DrawVerScrollBar(int x, int y, int h, int total_count, int page_count, int page_start)
	{
		if (total_count <= page_count) return;
		//  ׸
		int nTop = 1;
		int nBot = 1;
		int nMinHeight = nTop + nBot + 1; // ּ 
		int nHeight = (h * page_count) / total_count; // 
		if (nHeight < nMinHeight) nHeight = nMinHeight; 
		int nStart = (h * page_start) / total_count;
		if (nStart + nHeight > h) nStart = h - nHeight; // Ʒ ° 
		if (total_count == page_start + page_count) nStart = h - nHeight; // Ʒ ȼ  
		int nMid = nHeight - nTop - nBot;	
		DrawBox32(x,y+nStart,10,1,CONV32_16(0xFFFFFFFF));
		for (int yy = 0; yy < nMid; yy++)
		{
			DrawBox32(x,y+yy+nStart+nTop,10,1,CONV32_16(0xFFFFFFFF));
		}
		DrawBox32(x,y+nStart+nTop+nMid,10,1,CONV32_16(0xFFFFFFFF));
	}

	void DrawHorScrollBar(int x, int y, int w, int total_count, int page_count, int page_start)
	{
		if (total_count <= page_count) return;
		//  ׸
		int nLeft = 1;
		int nRight = 1;
		int nMinWidth = nLeft + nRight + 1; // ּ 
		int nWidth = (w * page_count) / total_count; // 
		if (nWidth < nMinWidth) nWidth = nMinWidth; 
		int nStart = (w * page_start) / total_count;
		if (nStart + nWidth > w) nStart = w - nWidth; // Ʒ ° 
		if (total_count == page_start + page_count) nStart = w - nWidth; // Ʒ ȼ  
		int nMid = nWidth - nLeft - nRight;	
		DrawBox32(x+nStart,y,1,6,CONV32_16(0xFFFFFFFF));
		for (int xx = 0; xx < nMid; xx++)
		{
			DrawBox32(x+xx+nStart+nLeft,y,1,6,CONV32_16(0xFFFFFFFF));
		}
		DrawBox32(x+nStart+nLeft+nMid,y,1,6,CONV32_16(0xFFFFFFFF));
	}	

	void DrawAll()
	{
		setFontStyle(15, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);

		DrawBox32(0, 0, rect.w, rect.h, CONV32_16(0xAA262626));

		
		DrawBox32(2, 2, rect.w-4, 54-4, CONV32_16(0xFFFFFFFF));
		for(int i=0;i<ColListNum;i++)
			DrawText(2+i*108, 84+2-28, 108-4, 28-4, attributes[i+ColTop].name,&font);

		
		setFontStyle(15, 0xFF363636, ALIGN_MIDDLE,ALIGN_CENTER);
		for(int i=0;i<RowListNum;i++)
		{
			for(int j=0;j<ColListNum;j++)
			{
				if(RowSelect == i+RowTop && ColSelect == j+ColTop)
					DrawBox32(2+j*108, 84+2+i*28, 108-4, 28-4, CONV32_16(0xAA2C86FF));
				else
					DrawBox32(2+j*108, 84+2+i*28, 108-4, 28-4, CONV32_16(0xAAFFA52C));

				
				DrawText32(2+j*108, 84+2+i*28, 108-4, 28-4,DST_UTF82Uni((DS_U8*)results[(i+RowTop)*ColItemNum+(j+ColTop)].name),&font);
			}
		}
		DrawDetail();
		
		DrawVerScrollBar(550, 86, 28*RowListNum-4, RowItemNum, RowListNum, RowTop);
		DrawHorScrollBar(2, 370, 108*ColListNum-4, ColItemNum, ColListNum, ColTop);
	}	
	void Draw()
	{
		setFontStyle(15, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_CENTER);

		DrawDetailPre();
		DrawDetail();

		
		if(ColTop != pre_ColTop)
		{
			for(int i=0;i<ColListNum;i++)
				DrawText(2+i*108, 84+2-28, 108-4, 28-4,attributes[i+ColTop].name,&font);
		}
		
		setFontStyle(15, 0xFF363636, ALIGN_MIDDLE,ALIGN_CENTER);
		bool bDone = false;
		for(int i=0;i<RowListNum;i++)
		{
			for(int j=0;j<ColListNum;j++)
			{
				if(RowSelect == i+RowTop && ColSelect == j+ColTop)
				{
					DrawBox32(2+j*108, 84+2+i*28, 108-4, 28-4, CONV32_16(0xAA2C86FF));
					DrawText32(2+j*108, 84+2+i*28, 108-4, 28-4,DST_UTF82Uni((DS_U8*)results[(i+RowTop)*ColItemNum+(j+ColTop)].name),&font);
					bDone = true;
					break;
				}
			}
			if(bDone) break;
		}

		bDone = false;
		for(int i=0;i<RowListNum;i++)
		{
			for(int j=0;j<ColListNum;j++)
			{
				if(pre_RowSelect == i+pre_RowTop && pre_ColSelect == j+pre_ColTop)
				{
					DrawBox32(2+j*108, 84+2+i*28, 108-4, 28-4, CONV32_16(0xAAFFA52C));
					DrawText32(2+j*108, 84+2+i*28, 108-4, 28-4,DST_UTF82Uni((DS_U8*)results[(i+pre_RowTop)*ColItemNum+(j+pre_ColTop)].name),&font);
					bDone = true;
					break;
				}
			}
			if(bDone) break;
		}	
		if(RowTop != pre_RowTop) DrawVerScrollBar(550, 86, 28*RowListNum-4, RowItemNum, RowListNum, RowTop);
		if(ColTop != pre_ColTop) DrawHorScrollBar(2, 370, 108*ColListNum-4, ColItemNum, ColListNum, ColTop);
	}

	void DrawDetail()
	{
		setFontStyle(15, 0xFF262626, ALIGN_MIDDLE,ALIGN_LEFT);
		if(results == 0) return;
		 //column attribute data type int ,  hex  ش
		if(attributes[ColPos+ColTop].type == 1)
		{
			int nLen1 = strlen(results[(RowPos+RowTop)*ColItemNum+(ColPos+ColTop)].name);
			int number = atoi(results[(RowPos+RowTop)*ColItemNum+(ColPos+ColTop)].name);
			char tmpStr[100] = {0,};
			sprintf(tmpStr," (0x%08X)",number);
			int count = 0;
			for(int i=0;i<100;i++)
			{
				if(tmpStr[i] == 0) break;
				count++;
			}
			int nLen = nLen1 + count + 1;
			char * finalStr = (char*)DST_OS_Calloc((nLen)*sizeof(char),1);

			memcpy(finalStr,results[(RowPos+RowTop)*ColItemNum+(ColPos+ColTop)].name,nLen1);
			memcpy(&finalStr[nLen1],tmpStr,count);
			DrawText(2, 2, rect.w-4, 54-4,finalStr,&font);
			DST_OS_Free(&finalStr);
		}
		else
		{
			DrawText32(2, 2, rect.w-4, 54-4, DST_UTF82Uni((DS_U8*)results[(RowPos+RowTop)*ColItemNum+(ColPos+ColTop)].name),&font);
		}
	}

	void DrawDetailPre()
	{
		setFontStyle(15, 0xFF262626, ALIGN_MIDDLE,ALIGN_LEFT);
		if(results == 0)
		{
			DrawBox32(2, 2, rect.w-4, 54-4, CONV32_16(0xFFFFFFFF));
			return;
		}
		 //column attribute data type int ,  hex  ش
		if(attributes[pre_ColPos+pre_ColTop].type == 1)
		{
			int nLen1 = strlen(results[(pre_RowPos+pre_RowTop)*ColItemNum+(pre_ColPos+pre_ColTop)].name);
			int number = atoi(results[(pre_RowPos+pre_RowTop)*ColItemNum+(pre_ColPos+pre_ColTop)].name);
			char tmpStr[100] = {0,};
			sprintf(tmpStr," (0x%08X)",number);
			int count = 0;
			for(int i=0;i<100;i++)
			{
				if(tmpStr[i] == 0) break;
				count++;
			}
			int nLen = nLen1 + count + 1;
			char * finalStr = (char*)DST_OS_Calloc((nLen)*sizeof(char),1);

			memcpy(finalStr,results[(pre_RowPos+pre_RowTop)*ColItemNum+(pre_ColPos+pre_ColTop)].name,nLen1);
			memcpy(&finalStr[nLen1],tmpStr,count);
			DrawBox32(2, 2, DST_GetTextWidth(finalStr, font.GetSize()), 54-4, CONV32_16(0xFFFFFFFF));
			DST_OS_Free(&finalStr);
		}
		else
		{
			DrawBox32(2, 2, DST_GetTextWidth32(DST_UTF82Uni((DS_U8*)results[(pre_RowPos+pre_RowTop)*ColItemNum+(pre_ColPos+pre_ColTop)].name), strlen32(DST_UTF82Uni((DS_U8*)results[(pre_RowPos+pre_RowTop)*ColItemNum+(pre_ColPos+pre_ColTop)].name)), font.GetSize()), 54-4, CONV32_16(0xFFFFFFFF));
		}
	}	
	virtual void OnTimer(char nID)
	{
		switch(nID)
		{
			case 1:
				break;
		}
	}	

	virtual void KeyInput(DS_U8 key,bool)
	{
		switch(key)
		{
			case VK_PREV:
			case VK_PREV_MENU:
			case VK_CANCEL: 
				{
					CWindow * sqlWin = DST_GetWin(WIN_DEBUG_SQL);
					if(sqlWin)
						sqlWin->SetVisible(true);
					else
						DST_CreateWin(WIN_DEBUG_SQL);
				}
				Close();
				break;
			case VK_OK:
				
				break;
			case VK_LEFT:
			case VK_RIGHT:
				if(key == VK_RIGHT)
				{
					if(pre_ColPos == ColListNum-1 && pre_ColTop+ColListNum < ColItemNum - (ColItemNum%ColListNum))
					{
						ItemIncrease(ColItemNum, ColListNum, &ColTop, &ColSelect, &ColPos,ColListNum);
						ColSelect = 1 + ColSelect - ColListNum;
						ColPos = 0;
					}
					else
					{
						ItemIncrease(ColItemNum, ColListNum, &ColTop, &ColSelect, &ColPos);
					}
				}
				else
				{
					if(pre_ColPos == 0 && pre_ColTop > ColListNum)
					{
					
						ItemDecrease(ColItemNum, ColListNum, &ColTop, &ColSelect, &ColPos,ColListNum);
						ColSelect = ColSelect + ColListNum - 1;
						ColPos = ColListNum -1;
					}
					else
					{
						ItemDecrease(ColItemNum, ColListNum, &ColTop, &ColSelect, &ColPos);
					}
				}
				
				if(ColTop != pre_ColTop) DrawAll();
				else Draw();
				
				pre_ColItemNum = ColItemNum;
				pre_ColListNum = ColListNum;
				pre_ColTop = ColTop;
				pre_ColSelect = ColSelect;
				pre_ColPos = ColPos;				
				break;
			case VK_UP:
			case VK_DN:
				if(key == VK_DN)
				{
					if(pre_RowPos == RowListNum-1 && pre_RowTop+RowListNum < RowItemNum - (RowItemNum%RowListNum))
					{
						ItemIncrease(RowItemNum, RowListNum, &RowTop, &RowSelect, &RowPos,RowListNum);
						RowSelect = 1 + RowSelect - RowListNum ;
						RowPos = 0;
					}
					else
					{
						ItemIncrease(RowItemNum, RowListNum, &RowTop, &RowSelect, &RowPos);
					}
				}
				else
				{
					if(pre_RowPos == 0 && pre_RowTop > RowListNum)
					{
					
						ItemDecrease(RowItemNum, RowListNum, &RowTop, &RowSelect, &RowPos,RowListNum);
						RowSelect = RowSelect + RowListNum - 1;
						RowPos = RowListNum -1;
					}
					else
					{
						ItemDecrease(RowItemNum, RowListNum, &RowTop, &RowSelect, &RowPos);
					}
				}

				if(RowTop != pre_RowTop) DrawAll();
				else Draw();
			
			
				pre_RowItemNum = RowItemNum;
				pre_RowListNum = RowListNum;
				pre_RowTop = RowTop;
				pre_RowSelect = RowSelect;
				pre_RowPos = RowPos;				
				break;

		}
	}
};


void DST_CreateDebugSQLSubWin(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CDebugSQLSubWin(event));
}

