#include "DST_Window.h"
#include "DST_WinManager.h"
#include "DST_CommonAPI.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"
#include "DST_ISDBT_ChannelTask.h"
#include "DST_DB.h"
#include "DST_ChannelTune.h"
#include "DST_SignalMonitor.h"

#ifndef DSTAR
#include "DHL_OSAL.h"
#include "DHL_OSAL_Priv.h"
#endif


#if 0
____CEngineerMenuWin___()
#endif

char* DST_GetAppShortVersion();
const char *DST_GetVendorInfo(void);
const char *DST_GetModelName(void);

class CEngineerMenuWin : public CWindow
{
private:
	
public:
	CEngineerMenuWin(SWinEventMsg event):CWindow(event)
	{
		setFontStyle(22, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_LEFT);
		rect.w = 576;
		rect.h = 384;
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = (DST_GetScreenHeight() - rect.h) / 2;

		SetTimeOut(0);

		SetTimer(1, 1000);
	}

	virtual void OnTimer(char nID)
	{
		Show();
	}

	DS_U16* GetString(int nPos)
	{
		switch (nPos)
		{
			case 1: return pz_Age_Rating_None[OSD_Lang];
			case 2: return pz_Age_Rating_12[OSD_Lang];
			case 3: return pz_Age_Rating_15[OSD_Lang];
			case 4:  return pz_Age_Rating_19[OSD_Lang];
			default: break;
		}
		return 0;
	}	
	
	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			//case WIN_CHANNEL_BANNER:
			case WIN_DEBUG_SQL:
			case WIN_DEBUG_SQL_SUB:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
			case WIN_INFOR_BANNER:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_MAIN_MENU:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
			case WIN_PASSWD_CHANGE:
			case WIN_PASSWD_CHECK:
			case WIN_PASSWD_CONFIRM:
			case WIN_AGE_RATING:
				Close();
				break;
			default:
				break;
		}
	}

	virtual void Show()
	{
		RegisterKey(VK_CANCEL, true);
		RegisterKey(VK_PREV, true);
		RegisterKey(VK_PREV_MENU, true);
		RegisterKey(VK_1, true);
		RegisterKey(VK_2, true);
		RegisterKey(VK_3, true);
		RegisterKey(VK_4, true);
		RegisterKey(VK_5, true);
		RegisterKey(VK_6, true);
		RegisterKey(VK_7, true);
		RegisterKey(VK_8, true);
		RegisterKey(VK_9, true);
		RegisterKey(VK_0, true);
		
		DrawBox32(0, 0, rect.w, rect.h, CONV32_16(0xAA262626));
		setFontStyle(15, 0xFFC8C8C8, ALIGN_MIDDLE,ALIGN_LEFT);
		//((CT_AV_START)
		DS_U8 RF = 0;
		DS_U16 SourceID = 0;
//		DS_U8 tuneMode = 0;
//		DS_U8 state = 0;

		//(CT_AV_INFO)
		DS_U32 PCR = 0;
		DS_U32 vPid = 0;
		DS_U32 aPid = 0;
		DS_U32 vType = 0;
		DS_U32 aType = 0;

		//(CT_SIGNAL_INFO)
		bool bLock = 0;
		int ss = 0;
		DS_U32 ber_a = 0;
		DS_U32 ber_b = 0;

		//(CT_VIDEO_RESOLUTION)
		DS_U16 vWidth = 0;
		DS_U16 vHeight = 0;
		DS_U16 fps = 0;
		bool bInterlace = false;
		bool bWide = false;

		//(CT_SIGNAL)
		bool vAlive = false;
		bool aAlive = false;

		//MEMORY
		DS_U32 total_size = 0;
		DS_U32 free_size = 0;
		DS_U32 largest_free_size = 0;

#ifndef DSTAR

		//DHL_OS_HEAP_STATUS status;
		//DHL_OS_GetHeapStatus(&status);
		//total_size = status.total_size;
		//free_size = status.free_size;
		//largest_free_size = status.largest_free_size;
#endif
		
		DST_GetAVState(&RF, 0, &SourceID);
		DST_GetAVInfo(&PCR, &vPid, &aPid, &vType, &aType);
		DST_GetSignalInfo(&bLock, &ss, &ber_a, &ber_b);
		DST_GetVideoSize(&vWidth, &vHeight, &fps, &bInterlace, &bWide);
		DST_GetAVAliveInfo(&vAlive, &aAlive);


		char strText[9][256];
		for(int i=0;i<9;i++)
		{
			memset(strText[i], 0, 256);
		}

		DrawText(2, 2, rect.w, 20, (char*)"**** STATUS ****", &font);	

		sprintf(strText[0], "S/W Version: %s %s, Compile Time : %s %s ",DST_GetModelName(), DST_GetAppShortVersion(),  __DATE__, __TIME__);
		DrawText(2, 22, rect.w, 20, strText[0], &font);

		sprintf(strText[1], "FrontEnd: %s, strength [%d]", bLock?(char*)"lock":(char*)"unlock", ss);
		DrawText(2, 42, rect.w, 20, strText[1], &font);

		char chNum[20];
		DS_U32 chName[21];
		int num = 0;
		if (DST_DB_GetCurrentChannelInfo(chNum, chName, &num) == false) sprintf(chNum, "%d ", num); // RF ȣ		

		DS_U32 tmpStr[256] = {0,};
		sprintf(strText[2], "Tuning: %s, [", chNum);
		str232(tmpStr,strText[2]);
		strcpy32(&tmpStr[strlen32(tmpStr)],chName);
		sprintf(strText[2], "], pva [0x%2X/0x%2X/0x%2X]", (unsigned int)PCR, (unsigned int)vPid, (unsigned int)aPid);
		str232(&tmpStr[strlen32(tmpStr)],strText[2]);
		DrawText32(2, 62, rect.w, 20, tmpStr, &font);

		sprintf(strText[3], "               video alive [%s], audio alive [%s]", vAlive?(char *)"true":(char *)"false", aAlive?(char *)"true":(char *)"false");
		DrawText(2, 82, rect.w, 20, strText[3], &font);
		

		DS_U16 avStr[256] = {0,};
		
		char strFPS[10] = "N/A";
		switch (fps)
		{
			case 1:	strcpy(strFPS, "23.976"); break;
			case 2: strcpy(strFPS, "24"); break;
			case 3: strcpy(strFPS, "25"); break;
			case 4: strcpy(strFPS, "29.97"); break;
			case 5: strcpy(strFPS, "30"); break;
			case 6: strcpy(strFPS, "50"); break;
			case 7: strcpy(strFPS, "59.94"); break;
			case 8: strcpy(strFPS, "60"); break;
		}
		
		if(vWidth==0)
			sprintf(strText[4], "AV: source( %dx%d %s %sHz %s ), output 480i, audio: ", (int)vWidth, (int)vHeight, (char *)"(null)", strFPS, (char *)"(null)");
		else
			sprintf(strText[4], "AV: source( %dx%d %s %sHz %s ), output 480i, audio: ", (int)vWidth, (int)vHeight, bInterlace?(char*)"i":(char*)"p", strFPS, bWide?(char*)"wide":(char*)"normal");
		str2uni(avStr,strText[4]);
		strcpy16(&avStr[strlen16(avStr)], DST_UI_GetMTS()==0?pz_MTS_Main[OSD_Lang]:pz_MTS_Sub[OSD_Lang]);
		DrawTextUni(2, 102, rect.w, 20, avStr, &font);

		char vTypeStr[20] = {0,};
		char aTypeStr[20] = {0,};
		switch (vType) // ABNT NBR 15602-3:2007 Table 5 ? Strem_type
		{
			case 0x01: sprintf(vTypeStr,(char *)"MPEG1"); break;
			case 0x02: sprintf(vTypeStr,(char *)"MPEG2"); break;
			case 0x1B: sprintf(vTypeStr,(char *)"AVC(H.264)"); break;
		};
		switch (aType) // ABNT NBR 15602-3:2007 Table 5 ? Strem_type
		{
			case 0x03: sprintf(aTypeStr,(char *)"MPEG1"); break;
			case 0x04: sprintf(aTypeStr,(char *)"MPEG2"); break;
			case 0x0F: sprintf(aTypeStr,(char *)"AAC(ADTS)"); break;
			case 0x11: sprintf(aTypeStr,(char *)"AAC(LATM)"); break;
		};

		sprintf(strText[5], "AV format: video %s[0x%2X], audio %s[0x%2X]", vTypeStr, (unsigned int)vType, aTypeStr, (unsigned int)aType);
		DrawText(2, 122, rect.w, 20, strText[5], &font);	


		sprintf(strText[6], "Memory: Heap Total: %dBytes, Free: %dBytes, LFree: %dBytes",(int)total_size,(int)free_size,(int)largest_free_size);
		DrawText(2, 142, rect.w, 20, strText[6], &font);	
		DS_U32 sec = DST_OS_GetTickCount()/DST_OS_GetTicksPerSecond();
		DS_U32 min = sec / 60;
		DS_U32 hour = min / 60;
		sec = sec % 60;
		min = min % 60;
		sprintf(strText[7], "Running time: %02d:%02d:%02d",(int)hour, (int)min, (int)sec);
		DrawText(2, 162, rect.w, 20, strText[7], &font);	

		
		DrawText(2, 222, rect.w, 20, (char*)"**** commands ****", &font);	
		DrawText(2, 242, rect.w, 20, (char*)"1. show SQL database", &font);	
		
		DrawText(2, 362, rect.w, 20, (char*)"[0..9] Select ", &font);	


	}


	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch(key)
		{
			case VK_1:
				DST_Printf("Enter DB SQL Menu\n");
				DST_CreateWin(WIN_DEBUG_SQL); // Ͼ  
				break;
			case VK_2:
			case VK_3:
			case VK_4:
			case VK_5:
			case VK_6:
			case VK_7:
			case VK_8:
			case VK_9:
			case VK_0:
				break;
			case VK_CANCEL:
			case VK_PREV:
			case VK_PREV_MENU:
			default:
				Close();
				break;
		}
	}

};

void DST_CreateEngineerMenuWin(SWinEventMsg event)
{
	DST_RemoveAllWindowExceptBasicWin();
	DST_AddWin((WinID)(event.data[0]), new CEngineerMenuWin(event));
}


