#include "DST_Window.h"
#include "DST_WinManager.h"
#include "DST_CommonAPI.h"
#include "DST_UserInterface.h"
#include "DST_DataStrings.h"
#include "DST_ISDBT_ChannelTask.h"
#include "DST_DB.h"
#include "DST_ChannelTune.h"
#include "DST_SignalMonitor.h"



#if 0
____CFactoryWin___()
#endif
void DST_Tune(DS_U8 RF, DS_U16 program_number);

char *DST_GetBoardVersion(void);
char* DST_GetAppShortVersion();
void JST_RFUpdate(DS_U8 RF);



class CFactoryWin : public CWindow
{
private:
	DS_U16 Pos;
	DS_U16 Top;
	DS_U16 Select;
	DS_U16 ListNum;
	DS_U16 ItemNum;
	int signal;
	bool nPWR_pressed;
	bool nCHUP_pressed;
	bool nCHDN_Pressed;
	int nRF[2];
	int chUp;
	
public:
	CFactoryWin(SWinEventMsg event):CWindow(event)
	{
		DST_g_bFactoryMode = true;
		InitValues();

		setFontStyle(22, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_LEFT);
		rect.w = 576;
		rect.h = 384;
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = (DST_GetScreenHeight() - rect.h) / 2;

		SetTimeOut(0);


		// ִ 
		DST_UI_SetMute(false);
		DST_UI_SetVolume(50);
		SetTimeOut(0);
		// ʱȭ
		DST_EEPROM_SetNeedReset(1);
		DST_DB_Sync();
		// ä Ʃ
		
		DST_Tune(nRF[chUp], 0); // ä4
		SetTimer(1, 500);
	}

	void InitValues(void)
	{		
		nPWR_pressed = false;
		nCHUP_pressed = false;
		nCHDN_Pressed = false;
		signal	= DST_GetSignalStrength();
		Pos = 0;
		Top = 0;
		Select = 0;
		ListNum = 3;
		ItemNum = 3;
		if (ItemNum < ListNum) ListNum = ItemNum;

		nRF[0] = DST_GetIndexByRFNumber(4);
		nRF[1] = DST_GetIndexByRFNumber(48);
		chUp = 0;
	}

	virtual void OnTimer(char nID)
	{
		Show();
//		DST_Tune(Select+14, 1, 1);
	}

	void Draw(int x, int y, int w, int h, char * str)
	{
		
	}
	
	virtual void Show()
	{
		DS_U8 RF = 0;
		DST_GetAVState(&RF);
		
		RegisterAllKey(); //  Ű 
		DrawBox32(0, 0, rect.w, rect.h, CONV32_16(0x00000000));
		
		setFontStyle(22, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_LEFT);
		char strText[10][256];
		for(int i=0;i<10;i++)
		{
			memset(strText[i], 0, 256);
		}
		sprintf(strText[0], " S/W version : %s", DST_GetAppShortVersion() );
		DrawText(2, 2, rect.w, 30, strText[0], &font);

		sprintf(strText[1], " H/W version : %s", DST_GetBoardVersion());
		DrawText(2, 32, rect.w, 30, strText[1], &font);

		sprintf(strText[2], " FrontEnd : Broadcom" );
		DrawText(2, 62, rect.w, 30, strText[2], &font);

		signal	= DST_GetSignalStrength();
		sprintf(strText[3], " Signal Strength : %d ", signal);
		font.SetColor(CONV32_16((signal > 28 && DST_g_Lock == 1) ? 0xFF00FF00 : 0xFFFF0000));
		DrawText(2, 92, rect.w, 30, strText[3], &font);
		
		setFontStyle(22, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_LEFT);

		sprintf(strText[4], " RF : %d", DST_GetFrequencyNumberbyIndex(RF));
		DrawText(2, 122, rect.w, 30, strText[4], &font);
		
		sprintf(strText[5], " Front Key Test :  ");
		DrawText(2, 152, rect.w, 30, strText[5], &font);
		
		setFontStyle(22, 0xFF000000, ALIGN_MIDDLE, ALIGN_CENTER);
		
		sprintf(strText[6], "UP");
		DrawBox32(69, 192, 100, 40, CONV32_16(nCHUP_pressed ? 0xFFFF0000 : 0xFFFFFFFF));
		DrawText(69, 192, 100, 40, strText[6], &font);
		

		sprintf(strText[7], "DOWN");
		DrawBox32(238, 192, 100, 40, CONV32_16(nCHDN_Pressed ? 0xFFFF0000 : 0xFFFFFFFF));
		DrawText(238, 192, 100, 40, strText[7], &font);

		sprintf(strText[8], "POWER");
		DrawBox32(407, 192, 100, 40, CONV32_16(nPWR_pressed ? 0xFFFF0000 : 0xFFFFFFFF));
		DrawText(407, 192, 100, 40, strText[8], &font);
		

		
		setFontStyle(22, 0xFFFFFFFF, ALIGN_MIDDLE, ALIGN_LEFT);
		sprintf(strText[9], " 1.CH_UP  7.RF UPDATE  " );
		DrawText(2, 344, rect.w, 30, strText[9], &font);

		

	}

	
	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch(key)
		{
			case VK_FAC_CANCEL:
			case VK_1:
				DST_g_bUseAirFreq = true;

				chUp = (chUp+1)%2;
				DST_UI_ChannelTune(nRF[chUp], 0);
				break;
			case VK_7:
				DST_g_bUseAirFreq = true;
				JST_RFUpdate(DST_GetIndexByRFNumber(18)); // RF 18 RF Ʈ ļ
				DST_Printf("Enter RF Update Mode\n");
				DST_CreateWin(WIN_RF_UPDATE); // RF Ʈ  
				break;
			case VK_KEY_UP:
				nCHUP_pressed = true;
				nCHDN_Pressed = false;
				nPWR_pressed = false;
				break;
			case VK_KEY_DN:
				nCHUP_pressed = false;
				nCHDN_Pressed = true;
				nPWR_pressed = false;
				break;
			case VK_KEY_PWR:
				nCHUP_pressed = false;
				nCHDN_Pressed = false;
				nPWR_pressed = true;
				break;
		}
//		Close(); 忡 OSD   
	}
};

void DST_CreateFactoryWin(SWinEventMsg event)
{
	DST_RemoveAllWindowExceptBasicWin();
	DST_AddWin((WinID)(event.data[0]), new CFactoryWin(event));
}

