#include "DST_WinManager.h"
#include "DST_DataStrings.h"
#include "DST_OSDImage.h"
#include "DST_EEPROM.h"
#include "DST_ChannelTune.h"
#include "DST_UserInterface.h"
#include "DST_DB.h"


#if 0
____CMessageWin___()
#endif


class CFactoryResetWin : public CWindow
{
private:
	DS_U8 winParentID;
	DS_U8 msg;
public:
	CFactoryResetWin(SWinEventMsg event):CWindow(event)
	{
		rect.w = DST_GetImageWidth(newcon2_gui_banner_yesno_back);
		rect.h = DST_GetImageHeight(newcon2_gui_banner_yesno_back);
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = (DST_GetScreenHeight()- rect.h) / 2;
		RegisterAllKey();
		SetTimeOut(0);

		winParentID = event.data[1];
		msg = event.data[2];
		DST_Printf("winParentID : %d , msg : %d\n",winParentID,msg);
		DST_EEPROM_SetNeedReset(1);
		DST_DB_Sync();

	}
	~CFactoryResetWin()
	{
		DST_Reset(__func__); // â 鼭 
	}
	virtual void OnTimer(char)
	{
		Show();
	}

	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
		}
	}
	
	virtual void Show(void)
	{
		DrawImage(0, 0, newcon2_gui_banner_yesno_back);
		setFontStyle(24,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);

		if (DST_DB_IsSync())
		{
			KillTimer(1);
			SetTimeOut(1); // ũ  ŸӾƿ 1ʷ 
			DrawTextUni(0, 0, rect.w, rect.h, pz_sysreset[OSD_Lang], &font);
		}
		else
		{
			DrawTextUni(0, 0, rect.w, rect.h, pz_plz_wait[OSD_Lang], &font);
			SetTimer(1, 1000);
		}
		UpdateScreen();
	}
};


class CFactoryResetAskWin : public CWindow
{
private:

	DS_U16 g_nPos;
	DS_U16 g_nTop;
	DS_U16 select;
	DS_U16 itemNum;
	bool bExitKeyPressed;
	bool bVolumeKeyPressed;
	DS_U8 winParentID;
	DS_U8 msg;
public:
	CFactoryResetAskWin(SWinEventMsg event):CWindow(event)
	{
		setSize();
		bExitKeyPressed = false;
		bVolumeKeyPressed = false;
		g_nTop = 0;
		g_nPos = 0;
		select = 1;
		itemNum = 2;

		winParentID = event.data[1];
		msg = event.data[2];
		SetTimeOut(30);
	}

	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
		}
	}
	
	void setSize(void)
	{
		rect.w = DST_GetImageWidth(newcon2_gui_banner_yesno_back);
		rect.h = DST_GetImageHeight(newcon2_gui_banner_yesno_back);
		rect.x = (DST_GetScreenWidth() - rect.w)/2;
		rect.y = (DST_GetScreenHeight() - rect.h)/2;
	}

	virtual void Focus(bool bVal)
	{
		RegisterKey(VK_CANCEL, bVal);
		RegisterKey(VK_MENU, bVal);
		RegisterKey(VK_OK, bVal);
		RegisterKey(VK_RIGHT, bVal);
		RegisterKey(VK_LEFT, bVal);
		RegisterKey(VK_UP, bVal);
		RegisterKey(VK_DN, bVal);
		RegisterKey(VK_PREV, bVal);
		RegisterKey(VK_PREV_MENU, true);
	}
	

	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
				bVolumeKeyPressed = true;
				Close();
				break;
			default:
				break;
		}
	}
		

	virtual void Show(void)
	{
		Draw();
		DoFocus(true);
	}

	DS_U16* GetString(int index)
	{
		switch(index)
		{
			case 0: return pz_Yes[OSD_Lang];
			case 1: return pz_No[OSD_Lang];
			default: break;
		}
		return 0;
	}
	
	void Draw(void)
	{
		DrawImage(0,0,newcon2_gui_banner_yesno_back,true);
		setFontStyle(24,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
		int center_pos =  DST_GetImageHeight(newcon2_gui_banner_yesno_back) / 2; 
		int line_spacing = DST_GetFontHeight(font.GetSize()) * 125 / 100;

		DrawTextUni(0,	center_pos-line_spacing/2-line_spacing, rect.w, line_spacing, pz_Sub_FactoryResetAsk_E1[OSD_Lang],  &font);
		DrawTextUni(0,	center_pos-line_spacing/2, rect.w, line_spacing, pz_Sub_FactoryResetAsk_E2[OSD_Lang],  &font);
		
		DrawImage(65, 141, newcon2_gui_depth3_button_small_selected, true);
		DrawImage(185, 141, newcon2_gui_depth3_button_small_selected, true);
		if(select == 0)
			DrawImage(65, 141, newcon2_gui_depth3_button_small_cursor, true);
		else
			DrawImage(185, 141, newcon2_gui_depth3_button_small_cursor, true);
		
		for(int i=0;i<itemNum;i++)
		{
#if DESIGN_TYPE == 1
#else
			if(select==i)
				setFontStyle(24,0xFF000000,ALIGN_MIDDLE,ALIGN_CENTER);
			else
				setFontStyle(24,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_CENTER);
#endif
			DrawTextUni(65+i*120, 141, DST_GetImageWidth(newcon2_gui_depth3_button_small_selected),  DST_GetImageHeight(newcon2_gui_depth3_button_small_selected), GetString(i),	&font);
		}
	}
	
	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_RIGHT:
			case VK_LEFT:
				if(key == VK_RIGHT)
					ItemIncrease(itemNum, 2, &g_nTop, &select, &g_nPos);
				else
					ItemDecrease(itemNum, 2, &g_nTop, &select, &g_nPos);
				Draw();
				break;
			case VK_OK: 
				if(select == 0)
				{
//					DST_RemoveAllWindowExceptBasicWin();
					DST_CreateWin(WIN_FACTORY_RESET, (WinID)winParentID, msg);
				}
				else
				{
					DST_CreateWin((WinID)winParentID);
				}
				Close();
				break;
			case VK_MENU:
			case VK_CANCEL:
			case VK_PREV:
			case VK_PREV_MENU:
				DST_CreateWin((WinID)winParentID);
				Close();
				break;
			default:
				break;
		}
	}

};

void DST_CreateFactoryResetWin(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CFactoryResetWin(event));
}

void DST_CreateFactoryResetAskWin(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CFactoryResetAskWin(event));
}
