#include "DST_WinManager.h"
#include "DST_OSDImage.h"
#include "DST_UserInterface.h"
#include "DST_SignalMonitor.h"
#include "DST_ChannelTune.h"
#include "DST_GlobalVariables.h"
#include "DST_DataStrings.h"
#include "DST_DB.h"
#include "DST_ISDBT_ChannelTask.h"
#include "DST_DB_Engine.h"

OSD_PIXEL_T DST_GetAribColor(DS_U8 n);
DS_U32* DST_UTF82Uni(DS_U8 *utf);

#if 0
____CInfobannerWin___()
#endif

class CInfobannerWin : public CWindow
{
 public:
	CInfobannerWin(SWinEventMsg event):CWindow(event)
	{
		rect.w = DST_GetImageWidth(newcon2_gui_infobanner_back);
		rect.h = DST_GetImageHeight(newcon2_gui_infobanner_back);
		rect.x = (DST_GetScreenWidth() - rect.w) / 2;
		rect.y = DST_GetScreenHeight() / 20;
		SetTimeOut(60);
	}
	
	virtual void OnMessage(SWinEventMsg event)
	{
		switch (event.cmd)
		{
			case WM_POWER_OFF:
				Close();
				break;
			case WM_CT_MSG: // Ʃ  ޽  
				if (event.data32[0] == CT_TUNE_START) Show();
				SetTimeOut(60);
				break;
		}
	}
	
	virtual void OnTimer(char /*nID*/)
	{
		Show();
	}

	virtual void Show(WinID id)
	{
		switch(id)
		{
			case WIN_EWS:
			case WIN_CHANNEL_BANNER:
			case WIN_DIRECT_TUNE:
			case WIN_VOLUME:
			case WIN_VOLUME_MUTE:
			case WIN_SIGNAL_METER:
			case WIN_CLOSED_CAPTION_HOT:
			case WIN_AUDIO_HOT:
			case WIN_DISPLAY_MODE_HOT:
			case WIN_FACTORY_RESET:
			case WIN_FACTORY_RESET_ASK:
//			case WIN_INFOR_BANNER:
			case WIN_MAIN_MENU:
			case WIN_POWER_DOWN_CAUTION:
			case WIN_SUB_MENU_2DEPTH:
			case WIN_SUB_MENU_3DEPTH:
			case WIN_SUB_MENU_4DEPTH:
			case WIN_AUTO_SEARCH:
			case WIN_MANUAL_SEARCH:
			case WIN_CHANNEL_LIST:
			case WIN_PROGRAM_GUIDE:
				Close();
				break;
			default:
				break;
		}
	}

  virtual void Show(void)
	{
		DrawImage(0, 0, newcon2_gui_infobanner_back);
		
		DS_U8 RF = 0;
		DS_U16 source_id = 0;
		DST_GetAVState(&RF, 0, &source_id);
		
		DrawChannel();
		DrawTime(RF);
		DrawProgram(RF, source_id);
		DrawSignalBar();
		DrawIcon(RF, source_id);
		
		SetTimer(1, 500); // 500ms  
		RegisterKey(VK_OK, true);
		RegisterKey(VK_CANCEL, true);
	}

	void DrawProgram(int RF, DS_U16 source_id)
	{
		if (source_id == 0) return;
		CDB db;
		//   α׷ ã´. ̹   ϰ  ۽ð ɷ ϳ 
		db.GetTable("select start_time, length_in_seconds, title from eit_sub "
				"where rf = %d and source_id = %d "
				"and start_time+length_in_seconds >  %d "
				"order by start_time limit 1", RF, source_id, DST_GetCurrentUTCTime());
		if(db.GetRow() < 1) return;
			
		setFontStyle(20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);
		DrawTextUTF8(12, 35, 540, 20, (DS_U8*)db.GetResult(5), &font);

		DS_U16 time[110] = {0,};
		strcpy16(time, DST_GetTimeString(atoi(db.GetResult(3)),DATE_NO_YEAR_TIME_NO_SEC_DETAIL,true,DST_g_TimeOffset[RF]));
		strcat16(time, (char *)" - ");
		strcat16(time, DST_GetTimeString(atoi(db.GetResult(3)) + atoi(db.GetResult(4)),TIME_NO_SEC,true,DST_g_TimeOffset[RF]));
		DrawTextUni(12, 65, 540, 20 , time, &font); 	
  	}

	void DrawTime(int RF)
	{
		// ð ǥ
		setFontStyle(20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_RIGHT);
		DS_U32 curTime = DST_GetCurrentUTCTime();
		// DST_Printf("curTime = %d\n", curTime);
		if (curTime > 0)
		{
			DS_U16 time[50] = {0,};
			strcpy16(time, DST_GetTimeString(curTime,DATE_NO_YEAR_TIME_NO_SEC_DETAIL,true,DST_g_TimeOffset[RF]));
			DrawTextUni(12, 5, 540, 20, time, &font);
		}
	}
	
	void DrawChannel(void)
	{
		// ä ̸ ǥ			
		DS_U32 ChInfo[40]={0};
		DST_UI_GetCurrentChannelInfo(ChInfo);
		setFontStyle(20,0xFFC8C8C8,ALIGN_MIDDLE,ALIGN_LEFT);
		DrawText32(12, 5, 298, 20, ChInfo,  &font);
	}
	void DrawIcon(DS_U8 RF, DS_U16 program_number)
	{
		DrawResolution();
		DrawImage(163, 128, DST_UI_GetCCInfo() ? newcon2_gui_infobanner_cc_enable:newcon2_gui_infobanner_cc_disable);

		DrawImage(118, 128, (CT_GetAudioCount(RF, program_number) > 1) ? newcon2_gui_infobanner_multi_enable : newcon2_gui_infobanner_multi_disable);
		DS_U8* image  = newcon2_gui_infobanner_stereo_disable;
		switch (DST_AUD_GetMode())
		{
			case DHL_AUDIO_MONO: image = newcon2_gui_infobanner_stereo_disable; break;// Mono
			case DHL_AUDIO_DUAL_MONO: image = newcon2_gui_infobanner_stereo_enable; break; // Dual Mono
			case DHL_AUDIO_STEREO:	image = newcon2_gui_infobanner_stereo_enable; break;// Stereo
			case DHL_AUDIO_5_1: image = newcon2_gui_infobanner_stereo_disable; break;// 5.1
			default: break;
		}
		DrawImage(73, 128, image);
	}

	void DrawResolution(void)
	{
		DS_U8 *image = newcon2_gui_infobanner_hdtv_disable;
		switch (DST_GetResolutionInfo())
		{
			case  1: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_disable : newcon2_gui_infobanner_hdtv_disable; break;
			case  2: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_disable : newcon2_gui_infobanner_hdtv_disable; break;
			case  3: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_disable : newcon2_gui_infobanner_hdtv_disable; break;
			case  4: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_disable : newcon2_gui_infobanner_hdtv_disable; break;
			case  5: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_disable : newcon2_gui_infobanner_hdtv_disable; break;
			case  6: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_disable : newcon2_gui_infobanner_hdtv_disable; break;
			case  7: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_disable : newcon2_gui_infobanner_hdtv_disable; break;
			case  8: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_enable : newcon2_gui_infobanner_hdtv_disable; break;
			case  9: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_enable : newcon2_gui_infobanner_hdtv_disable; break;
			case 10: image = DST_IsVideoPlay() ? newcon2_gui_infobanner_hdtv_enable : newcon2_gui_infobanner_hdtv_disable; break;
		}
		DrawImage(12, 128, image);
	}

	void DrawSignalBar(void)
	{
		int xPos 	= 358;
		int yPos 	= 133;
		int width   = 183;
		int range	= 100;
		int signal	= DST_GetSignalStrength();

		int division =	width/3;
		int position = (width*signal)/(range);

		//signal meter
		for (int i=xPos; i < xPos+position; i++)
		{
			if ((i-xPos) <= division)
				DrawImage(i, yPos, newcon2_gui_progress_red);
			else if ((i-xPos) <= (division*2))
				DrawImage(i, yPos, newcon2_gui_progress_yellow);
			else
				DrawImage(i, yPos, newcon2_gui_progress_green);
		}
	}

	virtual void KeyInput(DS_U8 key, bool /*bRepeat*/)
	{
		switch (key)
		{
			case VK_OK:
			case VK_CANCEL:
			  Close();
			  break;
		}
	}
};

void DST_CreateInforbannerWindow(SWinEventMsg event)
{
	DST_AddWin((WinID)(event.data[0]), new CInfobannerWin (event));
}
